/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.io.channel;

import com.siemens.ct.exi.core.io.channel.DecoderChannel;
import com.siemens.ct.exi.core.types.DateTimeType;
import com.siemens.ct.exi.core.values.BooleanValue;
import com.siemens.ct.exi.core.values.DateTimeValue;
import com.siemens.ct.exi.core.values.DecimalValue;
import com.siemens.ct.exi.core.values.FloatValue;
import com.siemens.ct.exi.core.values.IntegerValue;
import java.io.IOException;
import java.math.BigInteger;

public abstract class AbstractDecoderChannel
implements DecoderChannel {
    private final int[] maskedOctets = new int[9];
    private static final int MAX_OCTETS_FOR_LONG = 9;
    protected StringBuilder sbHelper;

    public BooleanValue decodeBooleanValue() throws IOException {
        return this.decodeBoolean() ? BooleanValue.BOOLEAN_VALUE_TRUE : BooleanValue.BOOLEAN_VALUE_FALSE;
    }

    public char[] decodeString() throws IOException {
        return this.decodeStringOnly(this.decodeUnsignedInteger());
    }

    public char[] decodeStringOnly(int length) throws IOException {
        char[] ca = new char[length];
        for (int i = 0; i < length; ++i) {
            int codePoint = this.decodeUnsignedInteger();
            if (Character.isSupplementaryCodePoint(codePoint)) {
                return this.decodeStringOnlySupplementaryCodePoints(ca, length, i, codePoint);
            }
            ca[i] = (char)codePoint;
        }
        return ca;
    }

    private char[] decodeStringOnlySupplementaryCodePoints(char[] ca, int length, int i, int codePoint) throws IOException {
        assert (Character.isSupplementaryCodePoint(codePoint));
        if (this.sbHelper == null) {
            this.sbHelper = new StringBuilder(length + 10);
        } else {
            this.sbHelper.setLength(0);
        }
        this.sbHelper.append(ca, 0, i);
        this.sbHelper.appendCodePoint(codePoint);
        for (int k = i + 1; k < length; ++k) {
            this.sbHelper.appendCodePoint(this.decodeUnsignedInteger());
        }
        int len = this.sbHelper.length();
        char[] dst = new char[len];
        this.sbHelper.getChars(0, len, dst, 0);
        return dst;
    }

    public final int decodeUnsignedInteger() throws IOException {
        int result = this.decode();
        if (result >= 128) {
            int b;
            result &= 0x7F;
            int mShift = 7;
            do {
                b = this.decode();
                result += (b & 0x7F) << mShift;
                mShift += 7;
            } while (b >= 128);
        }
        return result;
    }

    protected long decodeUnsignedLong() throws IOException {
        int b;
        long lResult = 0L;
        int mShift = 0;
        do {
            b = this.decode();
            lResult += (long)(b & 0x7F) << mShift;
            mShift += 7;
        } while (b >>> 7 == 1);
        return lResult;
    }

    protected int decodeInteger() throws IOException {
        if (this.decodeBoolean()) {
            return -(this.decodeUnsignedInteger() + 1);
        }
        return this.decodeUnsignedInteger();
    }

    protected long decodeLong() throws IOException {
        if (this.decodeBoolean()) {
            return -(this.decodeUnsignedLong() + 1L);
        }
        return this.decodeUnsignedLong();
    }

    public IntegerValue decodeIntegerValue() throws IOException {
        return this.decodeUnsignedIntegerValue(this.decodeBoolean());
    }

    public IntegerValue decodeUnsignedIntegerValue() throws IOException {
        return this.decodeUnsignedIntegerValue(false);
    }

    protected final IntegerValue decodeUnsignedIntegerValue(boolean negative) throws IOException {
        int b;
        for (int i = 0; i < 9; ++i) {
            b = this.decode();
            if (b < 128) {
                switch (i) {
                    case 0: {
                        return IntegerValue.valueOf(negative ? -(b + 1) : b);
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.maskedOctets[i] = b;
                        int iResult = 0;
                        for (int k = i; k >= 0; --k) {
                            iResult = iResult << 7 | this.maskedOctets[k];
                        }
                        return IntegerValue.valueOf(negative ? -(iResult + 1) : iResult);
                    }
                }
                this.maskedOctets[i] = b;
                long lResult = 0L;
                for (int k = i; k >= 0; --k) {
                    lResult = lResult << 7 | (long)this.maskedOctets[k];
                }
                return IntegerValue.valueOf(negative ? -(lResult + 1L) : lResult);
            }
            this.maskedOctets[i] = b & 0x7F;
        }
        BigInteger bResult = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        for (int i = 0; i < 9; ++i) {
            bResult = bResult.add(multiplier.multiply(BigInteger.valueOf(this.maskedOctets[i])));
            multiplier = multiplier.shiftLeft(7);
        }
        do {
            b = this.decode();
            bResult = bResult.add(multiplier.multiply(BigInteger.valueOf(b & 0x7F)));
            multiplier = multiplier.shiftLeft(7);
        } while (b > 127);
        if (negative) {
            bResult = bResult.add(BigInteger.ONE).negate();
        }
        return IntegerValue.valueOf(bResult);
    }

    public IntegerValue decodeNBitUnsignedIntegerValue(int n) throws IOException {
        return IntegerValue.valueOf(this.decodeNBitUnsignedInteger(n));
    }

    public DecimalValue decodeDecimalValue() throws IOException {
        boolean negative = this.decodeBoolean();
        IntegerValue integral = this.decodeUnsignedIntegerValue(false);
        IntegerValue revFractional = this.decodeUnsignedIntegerValue(false);
        return new DecimalValue(negative, integral, revFractional);
    }

    public FloatValue decodeFloatValue() throws IOException {
        return new FloatValue(this.decodeIntegerValue(), this.decodeIntegerValue());
    }

    public DateTimeValue decodeDateTimeValue(DateTimeType type) throws IOException {
        int year = 0;
        int monthDay = 0;
        int time = 0;
        int fractionalSecs = 0;
        switch (type) {
            case gYear: {
                year = this.decodeInteger() + 2000;
                break;
            }
            case gYearMonth: 
            case date: {
                year = this.decodeInteger() + 2000;
                monthDay = this.decodeNBitUnsignedInteger(9);
                break;
            }
            case dateTime: {
                year = this.decodeInteger() + 2000;
                monthDay = this.decodeNBitUnsignedInteger(9);
            }
            case time: {
                time = this.decodeNBitUnsignedInteger(17);
                boolean presenceFractionalSecs = this.decodeBoolean();
                fractionalSecs = presenceFractionalSecs ? this.decodeUnsignedInteger() : 0;
                break;
            }
            case gMonth: 
            case gMonthDay: 
            case gDay: {
                monthDay = this.decodeNBitUnsignedInteger(9);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        boolean presenceTimezone = this.decodeBoolean();
        int timeZone = presenceTimezone ? this.decodeNBitUnsignedInteger(11) - 896 : 0;
        return new DateTimeValue(type, year, monthDay, time, fractionalSecs, presenceTimezone, timeZone);
    }
}

