/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.datatype;

import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.AbstractDatatype;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.DatatypeID;
import com.siemens.ct.exi.core.datatype.EnumDatatype;
import com.siemens.ct.exi.core.types.BuiltInType;
import com.siemens.ct.exi.core.util.MethodsBag;
import com.siemens.ct.exi.core.values.Value;

public class EnumerationDatatype
extends AbstractDatatype
implements EnumDatatype {
    protected Datatype dtEnumValues;
    protected int codingLength;
    protected Value[] enumValues;

    public EnumerationDatatype(Value[] enumValues, Datatype dtEnumValues, QNameContext schemaType) {
        super(BuiltInType.ENUMERATION, schemaType);
        if (dtEnumValues.getBuiltInType() == BuiltInType.QNAME || dtEnumValues.getBuiltInType() == BuiltInType.ENUMERATION) {
            throw new RuntimeException("Enumeration type values can't be of type Enumeration or QName");
        }
        this.dtEnumValues = dtEnumValues;
        this.enumValues = enumValues;
        this.codingLength = MethodsBag.getCodingLength(enumValues.length);
    }

    public Datatype getEnumValueDatatype() {
        return this.dtEnumValues;
    }

    public DatatypeID getDatatypeID() {
        return this.dtEnumValues.getDatatypeID();
    }

    public int getEnumerationSize() {
        return this.enumValues.length;
    }

    public int getCodingLength() {
        return this.codingLength;
    }

    public Value getEnumValue(int i) {
        assert (i >= 0 && i < this.enumValues.length);
        return this.enumValues[i];
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof EnumerationDatatype) {
            EnumerationDatatype e = (EnumerationDatatype)o;
            if (this.dtEnumValues.equals(e.dtEnumValues) && this.enumValues.length == e.enumValues.length) {
                for (int i = 0; i < this.enumValues.length; ++i) {
                    if (this.enumValues[i].equals(e.enumValues[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

