/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.validation.schematron;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.daffodil.api.ValidationFailure;
import org.apache.daffodil.api.ValidationResult;
import org.apache.daffodil.api.ValidationWarning;
import org.apache.daffodil.api.Validator;
import org.apache.daffodil.validation.schematron.Schematron;
import org.apache.daffodil.validation.schematron.SchematronResult$;
import org.apache.daffodil.validation.schematron.SchematronValidationError;
import org.apache.daffodil.validation.schematron.SchematronValidator$;
import org.apache.daffodil.validation.schematron.SvrlOutputException$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.Elem$;
import scala.xml.Node;
import scala.xml.NodeSeq$;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0005\n\u0003;!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015\u0011\u0005\u0001\"\u0001D\u000f\u0015y%\u0003#\u0001Q\r\u0015\t\"\u0003#\u0001R\u0011\u0015id\u0001\"\u0001S\u0011\u001d\u0019fA1A\u0005\u0002QCaa\u0017\u0004!\u0002\u0013)v!\u0002/\u0007\u0011\u0003if!B0\u0007\u0011\u0003\u0001\u0007\"B\u001f\f\t\u0003\t\u0007b\u00022\f\u0005\u0004%\ta\u0019\u0005\u0007].\u0001\u000b\u0011\u00023\t\u000f=\\!\u0019!C\u0001G\"1\u0001o\u0003Q\u0001\n\u0011\u00141cU2iK6\fGO]8o-\u0006d\u0017\u000eZ1u_JT!a\u0005\u000b\u0002\u0015M\u001c\u0007.Z7biJ|gN\u0003\u0002\u0016-\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005]A\u0012\u0001\u00033bM\u001a|G-\u001b7\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d2\u0012aA1qS&\u0011\u0011F\n\u0002\n-\u0006d\u0017\u000eZ1u_J\fa!\u001a8hS:,\u0007C\u0001\u0017.\u001b\u0005\u0011\u0012B\u0001\u0018\u0013\u0005)\u00196\r[3nCR\u0014xN\\\u0001\tgZ\u0014H\u000eU1uQB\u0019q$M\u001a\n\u0005I\u0002#AB(qi&|g\u000e\u0005\u00025w5\tQG\u0003\u00027o\u0005!a-\u001b7f\u0015\tA\u0014(A\u0002oS>T\u0011AO\u0001\u0005U\u00064\u0018-\u0003\u0002=k\t!\u0001+\u0019;i\u0003\u0019a\u0014N\\5u}Q\u0019q\bQ!\u0011\u00051\u0002\u0001\"\u0002\u0016\u0004\u0001\u0004Y\u0003\"B\u0018\u0004\u0001\u0004\u0001\u0014a\u0003<bY&$\u0017\r^3Y\u001b2#\"\u0001R$\u0011\u0005\u0015*\u0015B\u0001$'\u0005A1\u0016\r\\5eCRLwN\u001c*fgVdG\u000fC\u0003I\t\u0001\u0007\u0011*\u0001\u0005e_\u000e,X.\u001a8u!\tQU*D\u0001L\u0015\ta\u0015(\u0001\u0002j_&\u0011aj\u0013\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\nTG\",W.\u0019;s_:4\u0016\r\\5eCR|'\u000f\u0005\u0002-\rM\u0011aA\b\u000b\u0002!\u0006!a.Y7f+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-:\u0003\u0011a\u0017M\\4\n\u0005i;&AB*ue&tw-A\u0003oC6,\u0007%\u0001\u0006D_:4\u0017nZ&fsN\u0004\"AX\u0006\u000e\u0003\u0019\u0011!bQ8oM&<7*Z=t'\tYa\u0004F\u0001^\u0003\u001d\u00198\r\u001b)bi\",\u0012\u0001\u001a\t\u0003K2t!A\u001a6\u0011\u0005\u001d\u0004S\"\u00015\u000b\u0005%d\u0012A\u0002\u001fs_>$h(\u0003\u0002lA\u00051\u0001K]3eK\u001aL!AW7\u000b\u0005-\u0004\u0013\u0001C:dQB\u000bG\u000f\u001b\u0011\u0002\u001dM4(\u000f\\(viB,HOR5mK\u0006y1O\u001e:m\u001fV$\b/\u001e;GS2,\u0007\u0005")
public final class SchematronValidator
implements Validator {
    private final Schematron engine;
    private final Option<Path> svrlPath;

    public static String name() {
        return SchematronValidator$.MODULE$.name();
    }

    public ValidationResult validateXML(InputStream document) {
        Elem svrl = (Elem)XML$.MODULE$.loadString(this.engine.validate(document));
        Seq valErr = (Seq)svrl.child().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SchematronValidator.$anonfun$validateXML$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Node node = x$1;
            Option option = Elem$.MODULE$.unapplySeq(node);
            if (!option.isEmpty()) {
                String string = (String)((Tuple5)option.get())._1();
                String string2 = (String)((Tuple5)option.get())._2();
                Seq msg = (Seq)((Tuple5)option.get())._5();
                if ("svrl".equals(string) && "failed-assert".equals(string2)) {
                    return new SchematronValidationError(NodeSeq$.MODULE$.seqToNodeSeq(msg).text().trim(), node.$bslash$bslash("@location").text());
                }
            }
            throw new MatchError((Object)node);
        }, Seq$.MODULE$.canBuildFrom());
        String svrlString = svrl.mkString();
        Option svrlOutputFailure = this.svrlPath.flatMap((Function1 & Serializable & scala.Serializable)path -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FileOutputStream os = new FileOutputStream(path.toFile());
            os.write(svrlString.getBytes());
            os.close();
        }).failed().map((Function1)SvrlOutputException$.MODULE$).toOption());
        Seq err = (Seq)svrlOutputFailure.fold((Function0 & Serializable & scala.Serializable)() -> valErr, (Function1 & Serializable & scala.Serializable)f -> (Seq)valErr.$colon$plus(f, Seq$.MODULE$.canBuildFrom()));
        return SchematronResult$.MODULE$.apply((Seq<ValidationWarning>)((Seq)Nil$.MODULE$), (Seq<ValidationFailure>)err, svrlString);
    }

    public static final /* synthetic */ boolean $anonfun$validateXML$1(Node check$ifrefutable$1) {
        Node node = check$ifrefutable$1;
        Option option = Elem$.MODULE$.unapplySeq(node);
        if (!option.isEmpty()) {
            String string = (String)((Tuple5)option.get())._1();
            String string2 = (String)((Tuple5)option.get())._2();
            if ("svrl".equals(string) && "failed-assert".equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public SchematronValidator(Schematron engine, Option<Path> svrlPath) {
        this.engine = engine;
        this.svrlPath = svrlPath;
    }
}

