/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.io.ByteArrayOutputStreamWithGetBuf;
import org.apache.daffodil.io.FileIOException;
import org.apache.daffodil.util.Maybe$;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc!B\u000e\u001d\u0001q!\u0003\u0002\u0004\u0017\u0001\t\u0003\u0005)Q!A!\u0002\u0013q\u0003\u0002\u0004\u001b\u0001\t\u0003\u0005)Q!A!\u0002\u0013)\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000b\u001d\u0003A\u0011\u0001%\t\u000fA\u0003\u0001\u0019!C\u0001#\"9Q\u000b\u0001a\u0001\n\u00031\u0006B\u0002/\u0001A\u0003&!\u000bC\u0004^\u0001\u0001\u0007I\u0011\u00010\t\u000f\u0001\u0004\u0001\u0019!C\u0001C\"11\r\u0001Q!\n}C\u0001\u0002\u001a\u0001\t\u0006\u0004%\t!\u0015\u0005\bK\u0002\u0001\r\u0011\"\u0001g\u0011\u001d9\u0007\u00011A\u0005\u0002!DaA\u001b\u0001!B\u0013q\u0003bB6\u0001\u0001\u0004%\t\u0001\u001c\u0005\b[\u0002\u0001\r\u0011\"\u0001o\u0011\u0019\u0001\b\u0001)Q\u0005K!)\u0011\u000f\u0001C\u0005e\")\u0011\u0010\u0001C!u\"1\u0011\u0010\u0001C!\u0003\u000fAa!\u001f\u0001\u0005B\u0005e\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002D\u0001!\t%!\u0012\u00037\tKH/Z!se\u0006LxJ\u001d$jY\u0016|U\u000f\u001e9viN#(/Z1n\u0015\tib$\u0001\u0002j_*\u0011q\u0004I\u0001\tI\u00064gm\u001c3jY*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h'\t\u0001Q\u0005\u0005\u0002'U5\tqE\u0003\u0002\u001eQ)\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016(\u00051yU\u000f\u001e9viN#(/Z1n\u0003!{'o\u001a\u0013ba\u0006\u001c\u0007.\u001a\u0013eC\u001a4w\u000eZ5mI%|GEQ=uK\u0006\u0013(/Y=Pe\u001aKG.Z(viB,Ho\u0015;sK\u0006lG\u0005J7bq\n+hMZ3s'&TX-\u00138CsR,7o\u0001\u0001\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\t1{gnZ\u0001@_J<G%\u00199bG\",G\u0005Z1gM>$\u0017\u000e\u001c\u0013j_\u0012\u0012\u0015\u0010^3BeJ\f\u0017p\u0014:GS2,w*\u001e;qkR\u001cFO]3b[\u0012\"C/Z7q\t&\u0014\b+\u0019;i!\t1c'\u0003\u00028O\t!a)\u001b7f\u0003Ei\u0017-\u001f2f\u000bbL7\u000f^5oO\u001aKG.\u001a\t\u0004uuzT\"A\u001e\u000b\u0005qr\u0012\u0001B;uS2L!AP\u001e\u0003\u000b5\u000b\u0017PY3\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00024jY\u0016T!\u0001\u0012\u0015\u0002\u00079Lw.\u0003\u0002G\u0003\n!\u0001+\u0019;i\u0003\u0019a\u0014N\\5u}Q!\u0011jS'P!\tQ\u0005!D\u0001\u001d\u0011\u0015aE\u00011\u0001/\u0003Qi\u0017\r\u001f\"vM\u001a,'oU5{K&s')\u001f;fg\")a\n\u0002a\u0001k\u0005YA/Z7q\t&\u0014\b+\u0019;i\u0011\u0015AD\u00011\u0001:\u0003\u0019I7OR5mKV\t!\u000b\u0005\u00020'&\u0011A\u000b\r\u0002\b\u0005>|G.Z1o\u0003)I7OR5mK~#S-\u001d\u000b\u0003/j\u0003\"a\f-\n\u0005e\u0003$\u0001B+oSRDqa\u0017\u0004\u0002\u0002\u0003\u0007!+A\u0002yIE\nq![:GS2,\u0007%A\u0005nCf\u0014WMR5mKV\tq\fE\u0002;{U\nQ\"\\1zE\u00164\u0015\u000e\\3`I\u0015\fHCA,c\u0011\u001dY\u0016\"!AA\u0002}\u000b!\"\\1zE\u00164\u0015\u000e\\3!\u0003)I7\u000fV3na\u001aKG.Z\u0001\u0007]\nKH/Z:\u0016\u00039\n!B\u001c\"zi\u0016\u001cx\fJ3r)\t9\u0016\u000eC\u0004\\\u001b\u0005\u0005\t\u0019\u0001\u0018\u0002\u000f9\u0014\u0015\u0010^3tA\u000511\u000f\u001e:fC6,\u0012!J\u0001\u000bgR\u0014X-Y7`I\u0015\fHCA,p\u0011\u001dY\u0006#!AA\u0002\u0015\nqa\u001d;sK\u0006l\u0007%A\u0006dQ\u0016\u001c7NQ;gM\u0016\u0014HCA,t\u0011\u0015!(\u00031\u0001/\u00035aWM\\4uQ&s')\u001f;fg\"\u0012!C\u001e\t\u0003_]L!\u0001\u001f\u0019\u0003\r%tG.\u001b8f\u0003\u00159(/\u001b;f)\t96\u0010C\u0003}'\u0001\u0007Q0A\u0001c!\u0011yc0!\u0001\n\u0005}\u0004$!B!se\u0006L\bcA\u0018\u0002\u0004%\u0019\u0011Q\u0001\u0019\u0003\t\tKH/\u001a\u000b\b/\u0006%\u00111BA\u000b\u0011\u0015aH\u00031\u0001~\u0011\u001d\ti\u0001\u0006a\u0001\u0003\u001f\t1a\u001c4g!\ry\u0013\u0011C\u0005\u0004\u0003'\u0001$aA%oi\"9\u0011q\u0003\u000bA\u0002\u0005=\u0011a\u00017f]R\u0019q+a\u0007\t\rq,\u0002\u0019AA\b\u0003\u0015\u0019Gn\\:f)\u00059\u0016AB4fi\n+h\rF\u0001~\u0003\u001d9W\r\u001e$jY\u0016,\u0012!N\u0001\bQ\u0016DH)^7q+\t\ti\u0003\u0005\u0003\u00020\u0005ub\u0002BA\u0019\u0003s\u00012!a\r1\u001b\t\t)DC\u0002\u000285\na\u0001\u0010:p_Rt\u0014bAA\u001ea\u00051\u0001K]3eK\u001aLA!a\u0010\u0002B\t11\u000b\u001e:j]\u001eT1!a\u000f1\u0003!!xn\u0015;sS:<GCAA\u0017\u0001")
public class ByteArrayOrFileOutputStream
extends OutputStream {
    private boolean isTempFile;
    public final long org$apache$daffodil$io$ByteArrayOrFileOutputStream$$maxBufferSizeInBytes;
    public final File org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath;
    private Object maybeExistingFile;
    private boolean isFile;
    private Object maybeFile;
    private long nBytes;
    private OutputStream stream;
    private volatile boolean bitmap$0;

    public boolean isFile() {
        return this.isFile;
    }

    public void isFile_$eq(boolean x$1) {
        this.isFile = x$1;
    }

    public Object maybeFile() {
        return this.maybeFile;
    }

    public void maybeFile_$eq(Object x$1) {
        this.maybeFile = x$1;
    }

    private boolean isTempFile$lzycompute() {
        ByteArrayOrFileOutputStream byteArrayOrFileOutputStream = this;
        synchronized (byteArrayOrFileOutputStream) {
            if (!this.bitmap$0) {
                this.isTempFile = !Maybe$.MODULE$.isDefined$extension(this.maybeExistingFile) && this.isFile();
                this.bitmap$0 = true;
            }
        }
        this.maybeExistingFile = null;
        return this.isTempFile;
    }

    public boolean isTempFile() {
        return !this.bitmap$0 ? this.isTempFile$lzycompute() : this.isTempFile;
    }

    public long nBytes() {
        return this.nBytes;
    }

    public void nBytes_$eq(long x$1) {
        this.nBytes = x$1;
    }

    public OutputStream stream() {
        return this.stream;
    }

    public void stream_$eq(OutputStream x$1) {
        this.stream = x$1;
    }

    private void checkBuffer(long lengthInBytes) {
        if (!this.isFile() && this.nBytes() + lengthInBytes > this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$maxBufferSizeInBytes) {
            BoxedUnit boxedUnit;
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)"Switching to file based output stream. If this is performance critical, you may want to consider re-organizing your schema to avoid this if possible.", null);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.maybeFile_$eq(this.liftedTree1$1());
            FileOutputStream newStream = new FileOutputStream((File)Maybe$.MODULE$.get$extension(this.maybeFile()));
            this.stream().flush();
            ((ByteArrayOutputStreamWithGetBuf)this.stream()).writeTo(newStream);
            this.stream_$eq(newStream);
            this.isFile_$eq(true);
        } else {
            this.nBytes_$eq(this.nBytes() + lengthInBytes);
        }
    }

    @Override
    public void write(byte[] b) {
        this.checkBuffer(b.length);
        this.stream().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.checkBuffer(len);
        this.stream().write(b, off, len);
    }

    @Override
    public void write(int b) {
        this.checkBuffer(1L);
        this.stream().write(b);
    }

    @Override
    public void close() {
        this.stream().close();
    }

    public byte[] getBuf() {
        if (this.isFile()) {
            throw Assert$.MODULE$.abort2("Usage error: Attempted to call getBuf on FileOutputStream", "ByteArrayOrFileOutputStream.this.isFile.unary_!");
        }
        return ((ByteArrayOutputStreamWithGetBuf)this.stream()).getBuf();
    }

    public File getFile() {
        return (File)Maybe$.MODULE$.get$extension(this.maybeFile());
    }

    public String hexDump() {
        return this.isFile() ? ((File)Maybe$.MODULE$.get$extension(this.maybeFile())).toString() : ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), (int)this.nBytes() - 1).map((Function1 & Serializable & scala.Serializable)i -> ByteArrayOrFileOutputStream.$anonfun$hexDump$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public String toString() {
        return this.hexDump();
    }

    private final /* synthetic */ Object liftedTree1$1() {
        Object object;
        try {
            File file = File.createTempFile("daffodil-", ".tmp", this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath);
            file.deleteOnExit();
            object = Maybe$.MODULE$.apply((Object)file);
        }
        catch (Exception e) {
            throw new FileIOException(new StringOps(Predef$.MODULE$.augmentString("Unable to create temporary file in %s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath.getPath(), e.getMessage()})));
        }
        return object;
    }

    public static final /* synthetic */ String $anonfun$hexDump$1(ByteArrayOrFileOutputStream $this, int i) {
        return new StringOps(Predef$.MODULE$.augmentString("%2x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)($this.getBuf()[i] & 0xFF))}));
    }

    public ByteArrayOrFileOutputStream(long maxBufferSizeInBytes, File tempDirPath, Object maybeExistingFile) {
        this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$maxBufferSizeInBytes = maxBufferSizeInBytes;
        this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath = tempDirPath;
        this.maybeExistingFile = maybeExistingFile;
        this.isFile = Maybe$.MODULE$.isDefined$extension(maybeExistingFile);
        this.maybeFile = Maybe$.MODULE$.isDefined$extension(maybeExistingFile) ? Maybe$.MODULE$.apply((Object)((Path)Maybe$.MODULE$.get$extension(maybeExistingFile)).toFile()) : Maybe$.MODULE$.Nope();
        this.nBytes = 0L;
        this.stream = new ByteArrayOutputStreamWithGetBuf();
    }
}

