/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.daffodil.CLIConf;
import org.apache.daffodil.CLIConf$parse$;
import org.apache.daffodil.CLIConf$performance$;
import org.apache.daffodil.CLIConf$test$;
import org.apache.daffodil.CLIConf$unparse$;
import org.apache.daffodil.InfosetType$;
import org.apache.daffodil.Main$ExitCode$;
import org.apache.daffodil.api.DFDL;
import org.apache.daffodil.api.DaffodilConfig;
import org.apache.daffodil.api.DaffodilConfig$;
import org.apache.daffodil.api.DaffodilSchemaSource;
import org.apache.daffodil.api.DaffodilTunables$;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.URISchemaSource;
import org.apache.daffodil.api.URISchemaSource$;
import org.apache.daffodil.api.ValidationMode;
import org.apache.daffodil.api.WithDiagnostics;
import org.apache.daffodil.compiler.Compiler;
import org.apache.daffodil.compiler.Compiler$;
import org.apache.daffodil.compiler.InvalidParserException;
import org.apache.daffodil.compiler.ProcessorFactory;
import org.apache.daffodil.debugger.CLIDebuggerRunner;
import org.apache.daffodil.debugger.DebuggerExitException;
import org.apache.daffodil.debugger.InteractiveDebugger;
import org.apache.daffodil.debugger.InteractiveDebuggerRunner;
import org.apache.daffodil.debugger.TraceDebuggerRunner;
import org.apache.daffodil.dsom.ExpressionCompilerClass;
import org.apache.daffodil.dsom.ExpressionCompilers$;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.exceptions.NotYetImplementedException;
import org.apache.daffodil.exceptions.UnsuppressableException;
import org.apache.daffodil.externalvars.Binding;
import org.apache.daffodil.externalvars.BindingException;
import org.apache.daffodil.externalvars.ExternalVariablesLoader$;
import org.apache.daffodil.infoset.InfosetInputter;
import org.apache.daffodil.infoset.InfosetOutputter;
import org.apache.daffodil.infoset.JDOMInfosetInputter;
import org.apache.daffodil.infoset.JDOMInfosetOutputter;
import org.apache.daffodil.infoset.JsonInfosetInputter;
import org.apache.daffodil.infoset.JsonInfosetOutputter;
import org.apache.daffodil.infoset.NullInfosetInputter;
import org.apache.daffodil.infoset.NullInfosetInputter$;
import org.apache.daffodil.infoset.NullInfosetOutputter;
import org.apache.daffodil.infoset.ScalaXMLInfosetInputter;
import org.apache.daffodil.infoset.ScalaXMLInfosetOutputter;
import org.apache.daffodil.infoset.ScalaXMLInfosetOutputter$;
import org.apache.daffodil.infoset.W3CDOMInfosetInputter;
import org.apache.daffodil.infoset.W3CDOMInfosetOutputter;
import org.apache.daffodil.infoset.XMLTextInfosetInputter;
import org.apache.daffodil.infoset.XMLTextInfosetOutputter;
import org.apache.daffodil.io.DataDumper;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.processors.DaffodilParseOutputStreamContentHandler;
import org.apache.daffodil.processors.DataLoc;
import org.apache.daffodil.processors.DataProcessor;
import org.apache.daffodil.processors.ExternalVariableException;
import org.apache.daffodil.processors.HasSetDebugger;
import org.apache.daffodil.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.tdml.Runner;
import org.apache.daffodil.tdml.TDMLException;
import org.apache.daffodil.tdml.TDMLTestNotCompatibleException;
import org.apache.daffodil.tdml.TestCase;
import org.apache.daffodil.udf.UserDefinedFunctionFatalErrorException;
import org.apache.daffodil.util.Logger$;
import org.apache.daffodil.util.MaybeULong$;
import org.apache.daffodil.util.Misc$;
import org.apache.daffodil.util.Timer$;
import org.apache.daffodil.xml.DaffodilSAXParserFactory$;
import org.apache.daffodil.xml.NS;
import org.apache.daffodil.xml.RefQName;
import org.apache.daffodil.xml.XMLUtils$;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.rogach.scallop.ScallopConfBase;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.ControlThrowable;
import scala.util.matching.Regex;
import scala.xml.Node;
import scala.xml.XML$;

public final class Main$ {
    public static Main$ MODULE$;
    private final Seq<String> traceCommands;
    private final Path blobDir;
    private final String blobSuffix;

    static {
        new Main$();
    }

    public Seq<String> traceCommands() {
        return this.traceCommands;
    }

    public String indent(String str, int pad) {
        String[] lines = str.split("\n");
        String prefix = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(pad);
        String[] indented = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(0).append(prefix).append((String)x$1).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indented)).mkString("\n");
    }

    public Seq<Binding> overrideBindings(Seq<Binding> bindings, Seq<Binding> bindingsToOverride) {
        Seq inBoth = (Seq)((SeqLike)bindings.intersect(bindingsToOverride)).distinct();
        Seq bindingsMinusBoth = (Seq)bindings.diff((GenSeq)inBoth);
        Seq bindingsToOverrideMinusBoth = (Seq)bindingsToOverride.diff((GenSeq)inBoth);
        Seq bindingsWithCorrectValues = (Seq)bindings.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)inBoth.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$overrideBindings$2(b, p)))));
        Seq bindingsMinusUpdates = (Seq)bindingsMinusBoth.union((GenSeq)bindingsToOverrideMinusBoth, Seq$.MODULE$.canBuildFrom());
        Seq bindingsWithUpdates = (Seq)bindingsMinusUpdates.union((GenSeq)bindingsWithCorrectValues, Seq$.MODULE$.canBuildFrom());
        return bindingsWithUpdates;
    }

    public void displayDiagnostics(WithDiagnostics pr) {
        pr.getDiagnostics().foreach((Function1 & Serializable & scala.Serializable)d -> {
            Main$.$anonfun$displayDiagnostics$1(d);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Binding> combineExternalVariables(Map<String, String> vars, Option<DaffodilConfig> optDafConfig) {
        Seq configFileVars = (Seq)optDafConfig.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.externalVariableBindings()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Queue individualVars = ExternalVariablesLoader$.MODULE$.mapToBindings(vars);
        Seq<Binding> bindings = this.overrideBindings((Seq<Binding>)individualVars, (Seq<Binding>)configFileVars);
        return bindings;
    }

    public Option<DFDL.DataProcessor> createProcessorFromParser(File savedParser, Option<String> path, ValidationMode.Type mode) {
        None$ none$;
        block5: {
            try {
                Compiler compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
                DFDL.DataProcessor processor = (DFDL.DataProcessor)Timer$.MODULE$.getResult("reloading", (Function0 & Serializable & scala.Serializable)() -> compiler.reload(savedParser));
                if (!processor.isError()) {
                    none$ = new Some((Object)processor.withValidationMode(mode));
                    break block5;
                }
                none$ = None$.MODULE$;
            }
            catch (InvalidParserException e) {
                BoxedUnit boxedUnit;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)e.getMessage(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public void setupDebugOrTrace(HasSetDebugger proc, CLIConf conf) {
        block10: {
            Object object;
            if (!BoxesRunTime.unboxToBoolean((Object)conf.trace().apply()) && !conf.debug().isDefined()) break block10;
            if (BoxesRunTime.unboxToBoolean((Object)conf.trace().apply())) {
                object = new TraceDebuggerRunner();
            } else {
                CLIDebuggerRunner cLIDebuggerRunner;
                BoxedUnit boxedUnit;
                if (System.console() == null) {
                    if (Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                        org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)"Using --debug on a non-interactive console may result in display issues", null);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option option = (Option)conf.debug().apply();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String f = (String)some.value();
                    cLIDebuggerRunner = new CLIDebuggerRunner(new File(f));
                } else if (None$.MODULE$.equals(option)) {
                    cLIDebuggerRunner = new CLIDebuggerRunner();
                } else {
                    throw new MatchError((Object)option);
                }
                object = cLIDebuggerRunner;
            }
            TraceDebuggerRunner runner = object;
            InteractiveDebugger id = new InteractiveDebugger((InteractiveDebuggerRunner)runner, (ExpressionCompilerClass)ExpressionCompilers$.MODULE$);
            proc.setDebugging(true);
            proc.setDebugger((Object)id);
        }
    }

    public Option<DFDL.DataProcessor> createProcessorFromSchema(URI schema, Option<RefQName> rootNS, Option<String> path, Map<String, String> tunablesMap, ValidationMode.Type mode) {
        Some some;
        RefQName refQName;
        Compiler compiler;
        Compiler c = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1()).withTunables(tunablesMap);
        Option<RefQName> option = rootNS;
        if (None$.MODULE$.equals(option)) {
            compiler = c;
        } else if (option instanceof Some && (refQName = (RefQName)(some = (Some)option).value()) != null) {
            String root = refQName.local();
            NS ns = refQName.namespace();
            compiler = c.withDistinguishedRootNode(root, ns.toStringOrNullIfNoNS());
        } else {
            throw new MatchError(option);
        }
        Compiler compiler2 = compiler;
        URISchemaSource schemaSource = URISchemaSource$.MODULE$.apply(schema);
        Option res = (Option)Timer$.MODULE$.getResult("compiling", (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            ProcessorFactory processorFactory = compiler2.compileSource((DaffodilSchemaSource)schemaSource, compiler2.compileSource$default$2(), compiler2.compileSource$default$3());
            if (!processorFactory.isError()) {
                DFDL.DataProcessor processor = processorFactory.onPath((String)path.getOrElse((Function0 & Serializable & scala.Serializable)() -> "/")).withValidationMode(mode);
                MODULE$.displayDiagnostics((WithDiagnostics)processor);
                object = processor.isError() ? None$.MODULE$ : new Some((Object)processor);
            } else {
                MODULE$.displayDiagnostics((WithDiagnostics)processorFactory);
                object = None$.MODULE$;
            }
            return object;
        });
        return res;
    }

    public Option<DFDL.CodeGenerator> createGeneratorFromSchema(URI schema, Option<RefQName> rootNS, Map<String, String> tunables, String language) {
        Some some;
        RefQName refQName;
        Compiler compiler;
        Compiler c = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1()).withTunables(tunables);
        Option<RefQName> option = rootNS;
        if (None$.MODULE$.equals(option)) {
            compiler = c;
        } else if (option instanceof Some && (refQName = (RefQName)(some = (Some)option).value()) != null) {
            String root = refQName.local();
            NS ns = refQName.namespace();
            compiler = c.withDistinguishedRootNode(root, ns.toStringOrNullIfNoNS());
        } else {
            throw new MatchError(option);
        }
        Compiler compiler2 = compiler;
        URISchemaSource schemaSource = URISchemaSource$.MODULE$.apply(schema);
        Option cg = (Option)Timer$.MODULE$.getResult("compiling", (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            ProcessorFactory processorFactory = compiler2.compileSource((DaffodilSchemaSource)schemaSource, compiler2.compileSource$default$2(), compiler2.compileSource$default$3());
            if (!processorFactory.isError()) {
                DFDL.CodeGenerator generator = processorFactory.forLanguage(language);
                MODULE$.displayDiagnostics((WithDiagnostics)generator);
                none$ = new Some((Object)generator);
            } else {
                MODULE$.displayDiagnostics((WithDiagnostics)processorFactory);
                none$ = None$.MODULE$;
            }
            return none$;
        });
        return cg;
    }

    public Path blobDir() {
        return this.blobDir;
    }

    public String blobSuffix() {
        return this.blobSuffix;
    }

    public Either<InfosetOutputter, DaffodilParseOutputStreamContentHandler> getInfosetOutputter(Enumeration.Value infosetType, OutputStream os) {
        Left left;
        Enumeration.Value value = infosetType;
        Enumeration.Value value2 = InfosetType$.MODULE$.XML();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            left = scala.package$.MODULE$.Left().apply((Object)new XMLTextInfosetOutputter(os, true));
        } else {
            Enumeration.Value value4 = InfosetType$.MODULE$.SCALA_XML();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                left = scala.package$.MODULE$.Left().apply((Object)new ScalaXMLInfosetOutputter(ScalaXMLInfosetOutputter$.MODULE$.$lessinit$greater$default$1(), ScalaXMLInfosetOutputter$.MODULE$.$lessinit$greater$default$2()));
            } else {
                Enumeration.Value value6 = InfosetType$.MODULE$.JSON();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    left = scala.package$.MODULE$.Left().apply((Object)new JsonInfosetOutputter(os, true));
                } else {
                    Enumeration.Value value8 = InfosetType$.MODULE$.JDOM();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        left = scala.package$.MODULE$.Left().apply((Object)new JDOMInfosetOutputter());
                    } else {
                        Enumeration.Value value10 = InfosetType$.MODULE$.W3CDOM();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            left = scala.package$.MODULE$.Left().apply((Object)new W3CDOMInfosetOutputter());
                        } else {
                            Enumeration.Value value12 = InfosetType$.MODULE$.SAX();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                left = scala.package$.MODULE$.Right().apply((Object)new DaffodilParseOutputStreamContentHandler(os, true));
                            } else {
                                Enumeration.Value value14 = InfosetType$.MODULE$.NULL();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    left = scala.package$.MODULE$.Left().apply((Object)new NullInfosetOutputter());
                                } else {
                                    throw new MatchError((Object)value);
                                }
                            }
                        }
                    }
                }
            }
        }
        Left outputter = left;
        Object object = outputter.isLeft() ? outputter.left().map((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.setBlobAttributes(Main$.MODULE$.blobDir(), null, Main$.MODULE$.blobSuffix());
            return BoxedUnit.UNIT;
        }) : BoxedUnit.UNIT;
        return outputter;
    }

    public Object infosetDataToInputterData(Enumeration.Value infosetType, Either<byte[], InputStream> data) {
        Object object;
        boolean bl;
        Enumeration.Value value = infosetType;
        Enumeration.Value value2 = InfosetType$.MODULE$.XML();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = InfosetType$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = InfosetType$.MODULE$.SAX();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
        }
        if (bl) {
            Object object2;
            Either<byte[], InputStream> either = data;
            if (either instanceof Left) {
                byte[] bytes;
                Left left = (Left)either;
                object2 = bytes = (byte[])left.value();
            } else if (either instanceof Right) {
                Right right = (Right)either;
                InputStream is = (InputStream)right.value();
                object2 = is;
            } else {
                throw new MatchError(either);
            }
            object = object2;
        } else {
            Enumeration.Value value8 = InfosetType$.MODULE$.SCALA_XML();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                SAXParser p;
                InputStream inputStream;
                Either<byte[], InputStream> either = data;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    byte[] bytes = (byte[])left.value();
                    inputStream = new ByteArrayInputStream(bytes);
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    InputStream is = (InputStream)right.value();
                    inputStream = is;
                } else {
                    throw new MatchError(either);
                }
                InputStream is = inputStream;
                SAXParserFactory f = DaffodilSAXParserFactory$.MODULE$.apply();
                f.setNamespaceAware(false);
                SAXParser parser = p = f.newSAXParser();
                object = XML$.MODULE$.withSAXParser(parser).load(is);
            } else {
                Enumeration.Value value10 = InfosetType$.MODULE$.JDOM();
                Enumeration.Value value11 = value;
                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                    InputStream inputStream;
                    Either<byte[], InputStream> either = data;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        byte[] bytes = (byte[])left.value();
                        inputStream = new ByteArrayInputStream(bytes);
                    } else if (either instanceof Right) {
                        Right right = (Right)either;
                        InputStream is = (InputStream)right.value();
                        inputStream = is;
                    } else {
                        throw new MatchError(either);
                    }
                    InputStream is = inputStream;
                    SAXBuilder builder = new SAXBuilder(){

                        /*
                         * WARNING - void declaration
                         */
                        public XMLReader createParser() {
                            void var1_1;
                            XMLReader rdr = super.createParser();
                            XMLUtils$.MODULE$.setSecureDefaults(rdr);
                            return var1_1;
                        }
                    };
                    object = builder.build(is);
                } else {
                    Enumeration.Value value12 = InfosetType$.MODULE$.W3CDOM();
                    Enumeration.Value value13 = value;
                    if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                        byte[] byArray;
                        Either<byte[], InputStream> either = data;
                        if (either instanceof Left) {
                            byte[] bytes;
                            Left left = (Left)either;
                            byArray = bytes = (byte[])left.value();
                        } else if (either instanceof Right) {
                            Right right = (Right)either;
                            InputStream is = (InputStream)right.value();
                            byArray = IOUtils.toByteArray((InputStream)is);
                        } else {
                            throw new MatchError(either);
                        }
                        byte[] byteArr = byArray;
                        object = new ThreadLocal<org.w3c.dom.Document>(byteArr){
                            private final byte[] byteArr$1;

                            public org.w3c.dom.Document initialValue() {
                                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                                dbf.setNamespaceAware(true);
                                dbf.setFeature(XMLUtils$.MODULE$.XML_DISALLOW_DOCTYPE_FEATURE(), true);
                                DocumentBuilder db = dbf.newDocumentBuilder();
                                return db.parse(new ByteArrayInputStream(this.byteArr$1));
                            }
                            {
                                this.byteArr$1 = byteArr$1;
                            }
                        };
                    } else {
                        Enumeration.Value value14 = InfosetType$.MODULE$.NULL();
                        Enumeration.Value value15 = value;
                        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                            InputStream inputStream;
                            Either<byte[], InputStream> either = data;
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                byte[] bytes = (byte[])left.value();
                                inputStream = new ByteArrayInputStream(bytes);
                            } else if (either instanceof Right) {
                                Right right = (Right)either;
                                InputStream is = (InputStream)right.value();
                                inputStream = is;
                            } else {
                                throw new MatchError(either);
                            }
                            InputStream is = inputStream;
                            NullInfosetInputter.Event[] events = NullInfosetInputter$.MODULE$.toEvents(is);
                            object = events;
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
        }
        return object;
    }

    public Either<InfosetInputter, DFDL.DaffodilUnparseContentHandler> getInfosetInputter(Enumeration.Value infosetType, Object anyRef, DFDL.DataProcessor processor, WritableByteChannel outChannel) {
        Left left;
        Enumeration.Value value = infosetType;
        Enumeration.Value value2 = InfosetType$.MODULE$.XML();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            InputStream inputStream;
            Object object = anyRef;
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                inputStream = new ByteArrayInputStream(byArray);
            } else if (object instanceof InputStream) {
                InputStream inputStream2 = (InputStream)object;
                inputStream = inputStream2;
            } else {
                throw new MatchError(object);
            }
            InputStream is = inputStream;
            left = scala.package$.MODULE$.Left().apply((Object)new XMLTextInfosetInputter(is));
        } else {
            Enumeration.Value value4 = InfosetType$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                InputStream inputStream;
                Object object = anyRef;
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    inputStream = new ByteArrayInputStream(byArray);
                } else if (object instanceof InputStream) {
                    InputStream inputStream3 = (InputStream)object;
                    inputStream = inputStream3;
                } else {
                    throw new MatchError(object);
                }
                InputStream is = inputStream;
                left = scala.package$.MODULE$.Left().apply((Object)new JsonInfosetInputter(is));
            } else {
                Enumeration.Value value6 = InfosetType$.MODULE$.SCALA_XML();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    left = scala.package$.MODULE$.Left().apply((Object)new ScalaXMLInfosetInputter((Node)anyRef));
                } else {
                    Enumeration.Value value8 = InfosetType$.MODULE$.JDOM();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        left = scala.package$.MODULE$.Left().apply((Object)new JDOMInfosetInputter((Document)anyRef));
                    } else {
                        Enumeration.Value value10 = InfosetType$.MODULE$.W3CDOM();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            ThreadLocal tl = (ThreadLocal)anyRef;
                            left = scala.package$.MODULE$.Left().apply((Object)new W3CDOMInfosetInputter((org.w3c.dom.Document)tl.get()));
                        } else {
                            Enumeration.Value value12 = InfosetType$.MODULE$.NULL();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                NullInfosetInputter.Event[] events = (NullInfosetInputter.Event[])anyRef;
                                left = scala.package$.MODULE$.Left().apply((Object)new NullInfosetInputter(events));
                            } else {
                                Enumeration.Value value14 = InfosetType$.MODULE$.SAX();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    DFDL.DataProcessor dp = processor;
                                    left = scala.package$.MODULE$.Right().apply((Object)dp.newContentHandlerInstance(outChannel));
                                } else {
                                    throw new MatchError((Object)value);
                                }
                            }
                        }
                    }
                }
            }
        }
        return left;
    }

    public void setLogLevel(int verbose) {
        Level level;
        int n = verbose;
        switch (n) {
            case 0: {
                level = Level.WARN;
                break;
            }
            case 1: {
                level = Level.INFO;
                break;
            }
            case 2: {
                level = Level.DEBUG;
                break;
            }
            default: {
                level = Level.TRACE;
                break;
            }
        }
        Level verboseLevel = level;
        Configurator.setLevel((String)"org.apache.daffodil", (Level)verboseLevel);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Enumeration.Value run(String[] arguments) {
        block97: {
            block102: {
                block101: {
                    block100: {
                        block99: {
                            block98: {
                                block93: {
                                    block95: {
                                        block96: {
                                            block94: {
                                                conf = new CLIConf(arguments);
                                                this.setLogLevel(BoxesRunTime.unboxToInt((Object)conf.verbose().apply()));
                                                var27_3 = false;
                                                var28_4 = null;
                                                var29_5 = conf.subcommand();
                                                if (!(var29_5 instanceof Some)) break block93;
                                                var27_3 = true;
                                                var28_4 = (Some)var29_5;
                                                var30_6 = (ScallopConfBase)var28_4.value();
                                                if (!conf.parse().equals(var30_6)) break block93;
                                                parseOpts = conf.parse();
                                                validate = (ValidationMode.Type)parseOpts.validate().toOption().get();
                                                optDafConfig = parseOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$1(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                                                if (parseOpts.parser().isDefined()) {
                                                    v0 = this.createProcessorFromParser((File)parseOpts.parser().apply(), (Option<String>)parseOpts.path().toOption(), validate);
                                                } else {
                                                    tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(parseOpts.tunables(), optDafConfig);
                                                    v0 = this.createProcessorFromSchema((URI)parseOpts.schema().apply(), (Option<RefQName>)parseOpts.rootNS().toOption(), (Option<String>)parseOpts.path().toOption(), (Map<String, String>)tunables, validate);
                                                }
                                                var37_12 = processor = v0.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$2(org.apache.daffodil.CLIConf$parse$ scala.Option org.apache.daffodil.api.DFDL$DataProcessor ), (Lorg/apache/daffodil/api/DFDL$DataProcessor;)Lorg/apache/daffodil/api/DFDL$DataProcessor;)((CLIConf$parse$)parseOpts, (Option)optDafConfig));
                                                if (!None$.MODULE$.equals(var37_12)) break block94;
                                                var18_13 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                                                break block95;
                                            }
                                            if (!(var37_12 instanceof Some)) break block96;
                                            var38_14 = (Some)var37_12;
                                            proc = (DFDL.DataProcessor)var38_14.value();
                                            if (proc.isError()) {
                                                throw Assert$.MODULE$.abort("Invariant broken: proc.isError.unary_!");
                                            }
                                            processor = ObjectRef.create((Object)proc);
                                            var42_17 = parseOpts.infile().toOption();
                                            var24_20 = var42_17 instanceof Some != false && "-".equals(var44_19 = (String)(var43_18 = (Some)var42_17).value()) != false ? true : None$.MODULE$.equals(var42_17) != false;
                                            if (var24_20) {
                                                var23_21 = System.in;
                                            } else if (var42_17 instanceof Some) {
                                                var45_22 = (Some)var42_17;
                                                file = (String)var45_22.value();
                                                f = new File(file);
                                                var23_21 = new FileInputStream(f);
                                            } else {
                                                throw new MatchError((Object)var42_17);
                                            }
                                            input = var23_21;
                                            inStream = InputSourceDataInputStream$.MODULE$.apply(input);
                                            processor.elem = ((DFDL.DataProcessor)processor.elem).withValidationMode(validate);
                                            this.setupDebugOrTrace((HasSetDebugger)((DataProcessor)((DFDL.DataProcessor)processor.elem)), conf);
                                            var50_27 = parseOpts.output().toOption();
                                            var22_30 = var50_27 instanceof Some != false && "-".equals(var52_29 = (String)(var51_28 = (Some)var50_27).value()) != false ? true : None$.MODULE$.equals(var50_27) != false;
                                            if (var22_30) {
                                                var21_31 /* !! */  = System.out;
                                            } else if (var50_27 instanceof Some) {
                                                var53_32 = (Some)var50_27;
                                                file = (String)var53_32.value();
                                                var21_31 /* !! */  = new FileOutputStream(file);
                                            } else {
                                                throw new MatchError((Object)var50_27);
                                            }
                                            output = var21_31 /* !! */ ;
                                            infosetType = (Enumeration.Value)parseOpts.infosetType().toOption().get();
                                            eitherOutputterOrHandler = this.getInfosetOutputter(infosetType, output);
                                            lastParseBitPosition = 0L;
                                            keepParsing = true;
                                            exitCode = Main$ExitCode$.MODULE$.Success();
                                            while (keepParsing) {
                                                var62_43 = eitherOutputterOrHandler;
                                                if (var62_43 instanceof Right) {
                                                    var63_44 = (Right)var62_43;
                                                    saxContentHandler = (DaffodilParseOutputStreamContentHandler)var63_44.value();
                                                    saxContentHandler.reset();
                                                    var20_41 = (DFDL.ParseResult)Timer$.MODULE$.getResult("parsing", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$3(scala.runtime.ObjectRef org.apache.daffodil.io.InputSourceDataInputStream org.apache.daffodil.processors.DaffodilParseOutputStreamContentHandler ), ()Lorg/apache/daffodil/api/DFDL$ParseResult;)((ObjectRef)processor, (InputSourceDataInputStream)inStream, (DaffodilParseOutputStreamContentHandler)saxContentHandler));
                                                } else if (var62_43 instanceof Left) {
                                                    var65_46 = (Left)var62_43;
                                                    outputter = (InfosetOutputter)var65_46.value();
                                                    outputter.reset();
                                                    var20_41 = (DFDL.ParseResult)Timer$.MODULE$.getResult("parsing", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$4(scala.runtime.ObjectRef org.apache.daffodil.io.InputSourceDataInputStream org.apache.daffodil.infoset.InfosetOutputter ), ()Lorg/apache/daffodil/api/DFDL$ParseResult;)((ObjectRef)processor, (InputSourceDataInputStream)inStream, (InfosetOutputter)outputter));
                                                } else {
                                                    throw new MatchError(var62_43);
                                                }
                                                parseResult = var20_41;
                                                finfo = (FormatInfo)parseResult.resultState();
                                                loc = (DataLoc)parseResult.resultState().currentLocation();
                                                this.displayDiagnostics((WithDiagnostics)parseResult);
                                                if (((DFDL.Result)parseResult).isProcessingError() || ((DFDL.Result)parseResult).isValidationError()) {
                                                    keepParsing = false;
                                                    exitCode = Main$ExitCode$.MODULE$.ParseError();
                                                    continue;
                                                }
                                                var69_50 = false;
                                                var70_51 = null;
                                                var71_52 = eitherOutputterOrHandler;
                                                if (!(var71_52 instanceof Left)) ** GOTO lbl-1000
                                                var69_50 = true;
                                                var70_51 = (Left)var71_52;
                                                sxml = (InfosetOutputter)var70_51.value();
                                                if (sxml instanceof ScalaXMLInfosetOutputter) {
                                                    var73_54 = (ScalaXMLInfosetOutputter)sxml;
                                                    writer = new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8);
                                                    XML$.MODULE$.write((Writer)writer, var73_54.getResult(), "UTF-8", true, null, XML$.MODULE$.write$default$6());
                                                    writer.flush();
                                                    var19_40 = BoxedUnit.UNIT;
                                                } else if (var69_50 && (jdom = (InfosetOutputter)var70_51.value()) instanceof JDOMInfosetOutputter) {
                                                    var76_57 = (JDOMInfosetOutputter)jdom;
                                                    new XMLOutputter().output(var76_57.getResult(), (OutputStream)output);
                                                    var19_40 = BoxedUnit.UNIT;
                                                } else if (var69_50 && (w3cdom = (InfosetOutputter)var70_51.value()) instanceof W3CDOMInfosetOutputter) {
                                                    var78_59 = (W3CDOMInfosetOutputter)w3cdom;
                                                    tf = TransformerFactory.newInstance();
                                                    transformer = tf.newTransformer();
                                                    result = new StreamResult(output);
                                                    source = new DOMSource(var78_59.getResult());
                                                    transformer.transform(source, result);
                                                    var19_40 = BoxedUnit.UNIT;
                                                } else {
                                                    var19_40 = BoxedUnit.UNIT;
                                                }
                                                output.flush();
                                                if (!inStream.hasData()) {
                                                    keepParsing = false;
                                                    continue;
                                                }
                                                if (BoxesRunTime.unboxToBoolean((Object)parseOpts.stream().toOption().get())) {
                                                    if (lastParseBitPosition == (long)loc.bitPos0b()) {
                                                        v1 = remainingBits = MaybeULong$.MODULE$.isDefined$extension(loc.bitLimit0b()) != false ? Long.toString(MaybeULong$.MODULE$.get$extension(loc.bitLimit0b()) - (long)loc.bitPos0b()) : new StringBuilder(9).append("at least ").append(inStream.inputSource().bytesAvailable() * 8L).toString();
                                                        if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                                                            org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)new StringBuilder(110).append("Left over data after consuming 0 bits while streaming. Stopped after consuming ").append(loc.bitPos0b()).append(" bit(s) with ").append(remainingBits).append(" bit(s) remaining.").toString(), null);
                                                            v2 = BoxedUnit.UNIT;
                                                        } else {
                                                            v2 = BoxedUnit.UNIT;
                                                        }
                                                        keepParsing = false;
                                                        exitCode = Main$ExitCode$.MODULE$.LeftOverData();
                                                        continue;
                                                    }
                                                    lastParseBitPosition = loc.bitPos0b();
                                                    keepParsing = true;
                                                    output.write(0);
                                                    continue;
                                                }
                                                Dump = new DataDumper();
                                                bitsAlreadyConsumed = loc.bitPos0b() % 8;
                                                if (bitsAlreadyConsumed != 0) {
                                                    bitsToDisplay = 8 - bitsAlreadyConsumed;
                                                    pbp = inStream.inputSource().position() + 1L;
                                                    firstByteBitArray = inStream.getByteArray(bitsToDisplay, finfo);
                                                    fbs = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper((int)firstByteBitArray[0])))).takeRight(8))).reverse())).padTo(8, (Object)BoxesRunTime.boxToCharacter((char)'0'), Predef$.MODULE$.StringCanBuildFrom()))).reverse();
                                                    v3 = finfo.bitOrder();
                                                    var93_73 = BitOrder.MostSignificantBitFirst$.MODULE$;
                                                    bits = !(v3 != null ? v3.equals(var93_73) == false : var93_73 != null) ? new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("x")).$times(bitsAlreadyConsumed)).append(new StringOps(Predef$.MODULE$.augmentString(fbs)).dropRight(bitsAlreadyConsumed)).toString() : new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(fbs)).takeRight(bitsToDisplay)).append(new StringOps(Predef$.MODULE$.augmentString("x")).$times(bitsAlreadyConsumed)).toString();
                                                    arg$macro$1 = BoxesRunTime.boxToLong((long)pbp);
                                                    arg$macro$2 = bits;
                                                    v4 = dumpString = new StringOps("\nLeft over data starts with partial byte. Left over data (Binary) at byte %s is: (0b%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2}));
                                                } else {
                                                    v4 = "";
                                                }
                                                firstByteString = v4;
                                                curBytePosition1b = inStream.inputSource().position() + 1L;
                                                bytesAvailable = inStream.inputSource().bytesAvailable();
                                                bytesLimit = (int)package$.MODULE$.min(8L, bytesAvailable);
                                                destArray = new byte[bytesLimit];
                                                destArrayFilled = inStream.inputSource().get(destArray, 0, bytesLimit);
                                                if (destArrayFilled) {
                                                    x$1 = new DataDumper.TextOnly(Dump, (Option)new Some((Object)"utf-8"));
                                                    x$2 = 0L;
                                                    x$3 = destArray.length * 8;
                                                    x$4 = ByteBuffer.wrap(destArray);
                                                    x$5 = false;
                                                    x$6 = Dump.dump$default$5();
                                                    x$7 = Dump.dump$default$7();
                                                    v5 = Dump.dump((DataDumper.Kind)x$1, x$2, x$3, x$4, x$6, x$5, x$7).mkString("\n");
                                                } else {
                                                    v5 = "";
                                                }
                                                dumpString = v5;
                                                dataText = destArrayFilled != false ? new StringBuilder(51).append("\nLeft over data (UTF-8) starting at byte ").append(curBytePosition1b).append(" is: (").append(dumpString).append("...)").toString() : "";
                                                dataHex = destArrayFilled != false ? new StringBuilder(51).append("\nLeft over data (Hex) starting at byte ").append(curBytePosition1b).append(" is: (0x").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(destArray)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$5$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString()).append("...)").toString() : "";
                                                remainingBits = MaybeULong$.MODULE$.isDefined$extension(loc.bitLimit0b()) != false ? Long.toString(MaybeULong$.MODULE$.get$extension(loc.bitLimit0b()) - (long)loc.bitPos0b()) : new StringBuilder(9).append("at least ").append(bytesAvailable * 8L).toString();
                                                leftOverDataMessage = new StringBuilder(56).append("Left over data. Consumed ").append(loc.bitPos0b()).append(" bit(s) with ").append(remainingBits).append(" bit(s) remaining.").append(firstByteString).append(dataHex).append(dataText).toString();
                                                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                                                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)leftOverDataMessage, null);
                                                    v6 = BoxedUnit.UNIT;
                                                } else {
                                                    v6 = BoxedUnit.UNIT;
                                                }
                                                keepParsing = false;
                                                exitCode = Main$ExitCode$.MODULE$.LeftOverData();
                                            }
                                            var18_13 = exitCode;
                                            break block95;
                                        }
                                        throw new MatchError((Object)var37_12);
                                    }
                                    var2_95 = rc = var18_13;
                                    break block97;
                                }
                                if (!var27_3) break block98;
                                var117_96 = (ScallopConfBase)var28_4.value();
                                if (!conf.performance().equals(var117_96)) break block98;
                                performanceOpts = conf.performance();
                                validate = (ValidationMode.Type)performanceOpts.validate().toOption().get();
                                optDafConfig = performanceOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$6(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                                if (performanceOpts.parser().isDefined()) {
                                    v7 = this.createProcessorFromParser((File)performanceOpts.parser().apply(), (Option<String>)performanceOpts.path().toOption(), validate);
                                } else {
                                    tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(performanceOpts.tunables(), optDafConfig);
                                    v7 = this.createProcessorFromSchema((URI)performanceOpts.schema().apply(), (Option<RefQName>)performanceOpts.rootNS().toOption(), (Option<String>)performanceOpts.path().toOption(), (Map<String, String>)tunables, validate);
                                }
                                var124_102 = processor = v7.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$7(org.apache.daffodil.CLIConf$performance$ scala.Option org.apache.daffodil.api.DFDL$DataProcessor ), (Lorg/apache/daffodil/api/DFDL$DataProcessor;)Lorg/apache/daffodil/api/DFDL$DataProcessor;)((CLIConf$performance$)performanceOpts, (Option)optDafConfig)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$8(org.apache.daffodil.api.ValidationMode$Type org.apache.daffodil.api.DFDL$DataProcessor ), (Lorg/apache/daffodil/api/DFDL$DataProcessor;)Lorg/apache/daffodil/api/DFDL$DataProcessor;)((ValidationMode.Type)validate));
                                if (None$.MODULE$.equals(var124_102)) {
                                    var15_103 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                                } else if (var124_102 instanceof Some) {
                                    var125_104 = (Some)var124_102;
                                    processor = (DFDL.DataProcessor)var125_104.value();
                                    infile = new File((String)performanceOpts.infile().apply());
                                    files = infile.isDirectory() != false ? (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])infile.listFiles())).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$9$adapted(java.io.File ), (Ljava/io/File;)Ljava/lang/Object;)()) : (File[])((Object[])new File[]{infile});
                                    infosetType = (Enumeration.Value)performanceOpts.infosetType().toOption().get();
                                    dataSeq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$10(org.apache.daffodil.CLIConf$performance$ scala.Enumeration$Value java.io.File ), (Ljava/io/File;)Lscala/util/Either;)((CLIConf$performance$)performanceOpts, (Enumeration.Value)infosetType), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                                    inputs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)performanceOpts.number().apply())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$11$adapted(scala.collection.Seq java.lang.Object ), (Ljava/lang/Object;)Lscala/util/Either;)((Seq)dataSeq), IndexedSeq$.MODULE$.canBuildFrom());
                                    inputsWithIndex = (IndexedSeq)inputs.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom());
                                    executionContext = new ExecutionContext(performanceOpts){
                                        private final ExecutorService threadPool;

                                        public ExecutionContext prepare() {
                                            return ExecutionContext.prepare$((ExecutionContext)this);
                                        }

                                        public ExecutorService threadPool() {
                                            return this.threadPool;
                                        }

                                        public void execute(Runnable runnable) {
                                            this.threadPool().submit(runnable);
                                        }

                                        public void reportFailure(Throwable t) {
                                        }
                                        {
                                            ExecutionContext.$init$((ExecutionContext)this);
                                            this.threadPool = Executors.newFixedThreadPool(BoxesRunTime.unboxToInt((Object)performanceOpts$1.threads().apply()));
                                        }
                                    };
                                    nullChannelForUnparse = Channels.newChannel((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                                    nullOutputStreamForParse = NullOutputStream.NULL_OUTPUT_STREAM;
                                    NSConvert = 1.0E9;
                                    var139_116 = Timer$.MODULE$.getTimeResult((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$12(scala.collection.immutable.IndexedSeq scala.Enumeration$Value org.apache.daffodil.api.DFDL$DataProcessor java.nio.channels.WritableByteChannel org.apache.commons.io.output.NullOutputStream scala.concurrent.ExecutionContext ), ()Lscala/collection/immutable/IndexedSeq;)((IndexedSeq)inputsWithIndex, (Enumeration.Value)infosetType, (DFDL.DataProcessor)processor, (WritableByteChannel)nullChannelForUnparse, (NullOutputStream)nullOutputStreamForParse, (ExecutionContext)executionContext));
                                    if (var139_116 == null) {
                                        throw new MatchError((Object)var139_116);
                                    }
                                    totalTime = var139_116._1$mcJ$sp();
                                    results = (IndexedSeq)var139_116._2();
                                    var17_119 = new Tuple2((Object)BoxesRunTime.boxToLong((long)totalTime), (Object)results);
                                    var138_120 = var17_119;
                                    totalTime = var138_120._1$mcJ$sp();
                                    results = (IndexedSeq)var138_120._2();
                                    rates = (IndexedSeq)results.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$18$adapted(double scala.Tuple3 ), (Lscala/Tuple3;)Ljava/lang/Object;)((double)NSConvert), IndexedSeq$.MODULE$.canBuildFrom());
                                    numFailures = ((SeqLike)((TraversableLike)results.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$19$adapted(scala.Tuple3 ), (Lscala/Tuple3;)Ljava/lang/Object;)(), IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$20$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)())).length();
                                    if (numFailures > 0) {
                                        if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                                            org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)new StringBuilder(16).append(numFailures).append(" failures found\n").toString(), null);
                                            v8 = BoxedUnit.UNIT;
                                        } else {
                                            v8 = BoxedUnit.UNIT;
                                        }
                                    } else {
                                        v8 = BoxedUnit.UNIT;
                                    }
                                    sec = (double)totalTime / NSConvert;
                                    var151_126 = BoxesRunTime.unboxToBoolean((Object)performanceOpts.unparse().apply());
                                    if (var151_126) {
                                        var16_127 = "unparse";
                                    } else if (!var151_126) {
                                        var16_127 = "parse";
                                    } else {
                                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)var151_126));
                                    }
                                    action = var16_127;
                                    Predef$.MODULE$.printf("total %s time (sec): %f\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, BoxesRunTime.boxToDouble((double)sec)}));
                                    Predef$.MODULE$.printf("min rate (files/sec): %f\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rates.min((Ordering)Ordering.Double$.MODULE$)}));
                                    Predef$.MODULE$.printf("max rate (files/sec): %f\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rates.max((Ordering)Ordering.Double$.MODULE$)}));
                                    Predef$.MODULE$.printf("avg rate (files/sec): %f\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)BoxesRunTime.unboxToInt((Object)performanceOpts.number().apply()) / sec))}));
                                    var15_103 = numFailures == 0 ? Main$ExitCode$.MODULE$.Success() : Main$ExitCode$.MODULE$.PerformanceTestError();
                                } else {
                                    throw new MatchError((Object)var124_102);
                                }
                                var2_95 = rc = var15_103;
                                break block97;
                            }
                            if (!var27_3) break block99;
                            var152_130 = (ScallopConfBase)var28_4.value();
                            if (!conf.unparse().equals(var152_130)) break block99;
                            unparseOpts = conf.unparse();
                            validate = (ValidationMode.Type)unparseOpts.validate().toOption().get();
                            optDafConfig = unparseOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$21(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                            if (unparseOpts.parser().isDefined()) {
                                v9 = this.createProcessorFromParser((File)unparseOpts.parser().apply(), (Option<String>)unparseOpts.path().toOption(), validate);
                            } else {
                                tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(unparseOpts.tunables(), optDafConfig);
                                v9 = this.createProcessorFromSchema((URI)unparseOpts.schema().apply(), (Option<RefQName>)unparseOpts.rootNS().toOption(), (Option<String>)unparseOpts.path().toOption(), (Map<String, String>)tunables, validate);
                            }
                            processor = v9.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$22(org.apache.daffodil.CLIConf$unparse$ scala.Option org.apache.daffodil.api.DFDL$DataProcessor ), (Lorg/apache/daffodil/api/DFDL$DataProcessor;)Lorg/apache/daffodil/api/DFDL$DataProcessor;)((CLIConf$unparse$)unparseOpts, (Option)optDafConfig));
                            var159_136 = unparseOpts.output().toOption();
                            var14_139 = var159_136 instanceof Some != false && "-".equals(var161_138 = (String)(var160_137 = (Some)var159_136).value()) != false ? true : None$.MODULE$.equals(var159_136) != false;
                            if (var14_139) {
                                var13_140 /* !! */  = System.out;
                            } else if (var159_136 instanceof Some) {
                                var162_141 = (Some)var159_136;
                                file = (String)var162_141.value();
                                var13_140 /* !! */  = new FileOutputStream(file);
                            } else {
                                throw new MatchError((Object)var159_136);
                            }
                            output = var13_140 /* !! */ ;
                            outChannel = Channels.newChannel(output);
                            var166_145 = unparseOpts.infile().toOption();
                            var12_148 = var166_145 instanceof Some != false && "-".equals(var168_147 = (String)(var167_146 = (Some)var166_145).value()) != false ? true : None$.MODULE$.equals(var166_145) != false;
                            if (var12_148) {
                                var11_149 = System.in;
                            } else if (var166_145 instanceof Some) {
                                var169_150 = (Some)var166_145;
                                fileName = (String)var169_150.value();
                                var11_149 = new FileInputStream(fileName);
                            } else {
                                throw new MatchError((Object)var166_145);
                            }
                            is = var11_149;
                            var172_153 = processor;
                            if (None$.MODULE$.equals(var172_153)) {
                                var8_154 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                            } else if (var172_153 instanceof Some) {
                                var173_155 = (Some)var172_153;
                                processor = (DFDL.DataProcessor)var173_155.value();
                                if (processor.isError()) {
                                    throw Assert$.MODULE$.abort("Invariant broken: processor.isError.==(false)");
                                }
                                this.setupDebugOrTrace((HasSetDebugger)((DataProcessor)processor), conf);
                                if (BoxesRunTime.unboxToBoolean((Object)unparseOpts.stream().toOption().get())) {
                                    scnr = new Scanner(is);
                                    scnr.useDelimiter("\u0000");
                                    v10 = new Some((Object)scnr);
                                } else {
                                    v10 = None$.MODULE$;
                                }
                                maybeScanner = v10;
                                keepUnparsing = maybeScanner.isEmpty() != false || ((Scanner)maybeScanner.get()).hasNext() != false;
                                exitCode = Main$ExitCode$.MODULE$.Success();
                                while (keepUnparsing) {
                                    eitherBytesOrStream = maybeScanner.isDefined() != false ? scala.package$.MODULE$.Left().apply((Object)((Scanner)maybeScanner.get()).next().getBytes()) : scala.package$.MODULE$.Right().apply((Object)is);
                                    inputterData = this.infosetDataToInputterData((Enumeration.Value)unparseOpts.infosetType().toOption().get(), (Either<byte[], InputStream>)eitherBytesOrStream);
                                    inputterOrContentHandler = this.getInfosetInputter((Enumeration.Value)unparseOpts.infosetType().toOption().get(), inputterData, processor, outChannel);
                                    var183_167 = inputterOrContentHandler;
                                    if (var183_167 instanceof Left) {
                                        var184_168 = (Left)var183_167;
                                        inputter = (InfosetInputter)var184_168.value();
                                        var9_161 = (DFDL.UnparseResult)Timer$.MODULE$.getResult("unparsing", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$23(org.apache.daffodil.api.DFDL$DataProcessor org.apache.daffodil.infoset.InfosetInputter java.nio.channels.WritableByteChannel ), ()Lorg/apache/daffodil/api/DFDL$UnparseResult;)((DFDL.DataProcessor)processor, (InfosetInputter)inputter, (WritableByteChannel)outChannel));
                                    } else if (var183_167 instanceof Right) {
                                        var186_170 = (Right)var183_167;
                                        contentHandler = (DFDL.DaffodilUnparseContentHandler)var186_170.value();
                                        var189_173 = inputterData;
                                        if (var189_173 instanceof byte[]) {
                                            var190_174 = (byte[])var189_173;
                                            var10_162 /* !! */  = new ByteArrayInputStream(var190_174);
                                        } else if (var189_173 instanceof InputStream) {
                                            var191_175 = (InputStream)var189_173;
                                            var10_162 /* !! */  = var191_175;
                                        } else {
                                            throw new MatchError(var189_173);
                                        }
                                        is /* !! */  = var10_162 /* !! */ ;
                                        var9_161 = (DFDL.UnparseResult)Timer$.MODULE$.getResult("unparsing", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$24(java.io.InputStream org.apache.daffodil.api.DFDL$DaffodilUnparseContentHandler ), ()Lorg/apache/daffodil/api/DFDL$UnparseResult;)((InputStream)is /* !! */ , (DFDL.DaffodilUnparseContentHandler)contentHandler));
                                    } else {
                                        throw new MatchError(var183_167);
                                    }
                                    unparseResult = var9_161;
                                    this.displayDiagnostics((WithDiagnostics)unparseResult);
                                    if (((DFDL.Result)unparseResult).isError()) {
                                        keepUnparsing = false;
                                        exitCode = Main$ExitCode$.MODULE$.UnparseError();
                                        continue;
                                    }
                                    keepUnparsing = maybeScanner.isDefined() != false && ((Scanner)maybeScanner.get()).hasNext() != false;
                                }
                                var8_154 = exitCode;
                            } else {
                                throw new MatchError((Object)var172_153);
                            }
                            rc = var8_154;
                            is.close();
                            outChannel.close();
                            var2_95 = rc;
                            break block97;
                        }
                        if (!var27_3) break block100;
                        var192_177 = (ScallopConfBase)var28_4.value();
                        if (!conf.save().equals(var192_177)) break block100;
                        saveOpts = conf.save();
                        validate = ValidationMode.Off$.MODULE$;
                        optDafConfig = saveOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$25(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                        tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(saveOpts.tunables(), optDafConfig);
                        tunablesObj = DaffodilTunables$.MODULE$.apply(tunables);
                        processor = this.createProcessorFromSchema((URI)saveOpts.schema().apply(), (Option<RefQName>)saveOpts.rootNS().toOption(), (Option<String>)saveOpts.path().toOption(), (Map<String, String>)tunables, (ValidationMode.Type)validate);
                        var200_184 = saveOpts.outfile().toOption();
                        var7_187 = var200_184 instanceof Some != false && "-".equals(var202_186 = (String)(var201_185 = (Some)var200_184).value()) != false ? true : None$.MODULE$.equals(var200_184) != false;
                        if (var7_187) {
                            var6_188 = Channels.newChannel(System.out);
                        } else if (var200_184 instanceof Some) {
                            var203_189 = (Some)var200_184;
                            file = (String)var203_189.value();
                            var6_188 = new FileOutputStream(file).getChannel();
                        } else {
                            throw new MatchError((Object)var200_184);
                        }
                        output = var6_188;
                        var206_192 = processor;
                        if (var206_192 instanceof Some) {
                            var207_193 = (Some)var206_192;
                            processor = (DFDL.DataProcessor)var207_193.value();
                            if (processor.isError()) {
                                throw Assert$.MODULE$.abort("Invariant broken: processor.isError.==(false)");
                            }
                            Timer$.MODULE$.getResult("saving", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$run$26(org.apache.daffodil.api.DFDL$DataProcessor java.nio.channels.WritableByteChannel ), ()V)((DFDL.DataProcessor)processor, (WritableByteChannel)output));
                            var5_195 = Main$ExitCode$.MODULE$.Success();
                        } else if (None$.MODULE$.equals(var206_192)) {
                            var5_195 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                        } else {
                            throw new MatchError(var206_192);
                        }
                        var2_95 = rc = var5_195;
                        break block97;
                    }
                    if (!var27_3) break block101;
                    var209_197 = (ScallopConfBase)var28_4.value();
                    if (!conf.test().equals(var209_197)) break block101;
                    testOpts = conf.test();
                    tdmlFile = (String)testOpts.tdmlfile().apply();
                    tdmlRunner = new Runner(new File(tdmlFile));
                    tests = (Seq)((SeqLike)((SeqLike)(testOpts.testnames().isDefined() != false ? ((List)testOpts.testnames().apply()).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$27(org.apache.daffodil.CLIConf$test$ org.apache.daffodil.tdml.Runner java.lang.String ), (Ljava/lang/String;)Lscala/collection/Seq;)((CLIConf$test$)testOpts, (Runner)tdmlRunner), List$.MODULE$.canBuildFrom()) : tdmlRunner.testCases().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$31(org.apache.daffodil.tdml.TestCase ), (Lorg/apache/daffodil/tdml/TestCase;)Lscala/Tuple2;)(), Seq$.MODULE$.canBuildFrom()))).distinct()).sortBy((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$32(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/String;)(), (Ordering)Ordering.String$.MODULE$);
                    tdmlRunner.reset();
                    if (BoxesRunTime.unboxToBoolean((Object)testOpts.list().apply())) {
                        if (BoxesRunTime.unboxToInt((Object)testOpts.info().apply()) > 0) {
                            headers = new .colon.colon((Object)"Name", (List)new .colon.colon((Object)"Model", (List)new .colon.colon((Object)"Root", (List)new .colon.colon((Object)"Description", (List)Nil$.MODULE$))));
                            maxCols = (List)tests.foldLeft(headers.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$33$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)(), List$.MODULE$.canBuildFrom()), (Function2)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$34(scala.collection.immutable.List scala.Tuple2 ), (Lscala/collection/immutable/List;Lscala/Tuple2;)Lscala/collection/immutable/List;)());
                            formatStr = ((TraversableOnce)maxCols.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$35$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom())).mkString("  ");
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(formatStr)).format((Seq)headers));
                            tests.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$36$adapted(java.lang.String scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((String)formatStr));
                        } else {
                            tests.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$37$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)());
                        }
                        v11 = Main$ExitCode$.MODULE$.Success();
                    } else {
                        pass = IntRef.create((int)0);
                        fail = IntRef.create((int)0);
                        notfound = IntRef.create((int)0);
                        tests.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$38$adapted(scala.runtime.IntRef scala.runtime.IntRef org.apache.daffodil.CLIConf$test$ scala.runtime.IntRef scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((IntRef)pass, (IntRef)fail, (CLIConf$test$)testOpts, (IntRef)notfound));
                        Predef$.MODULE$.println((Object)"");
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Total: %d, Pass: %d, Fail: %d, Not Found: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(pass.elem + fail.elem + notfound.elem)), BoxesRunTime.boxToInteger((int)pass.elem), BoxesRunTime.boxToInteger((int)fail.elem), BoxesRunTime.boxToInteger((int)notfound.elem)})));
                        v11 = fail.elem == 0 ? Main$ExitCode$.MODULE$.Success() : Main$ExitCode$.MODULE$.TestError();
                    }
                    var2_95 = v11;
                    break block97;
                }
                if (!var27_3) break block102;
                var220_208 = (ScallopConfBase)var28_4.value();
                if (!conf.generate().equals(var220_208)) break block102;
                var221_209 = conf.subcommands();
                var222_210 = List$.MODULE$.unapplySeq((Seq)var221_209);
                if (var222_210.isEmpty() || var222_210.get() == null || ((LinearSeqOptimized)var222_210.get()).lengthCompare(2) != 0) ** GOTO lbl449
                var223_211 = (ScallopConfBase)((LinearSeqOptimized)var222_210.get()).apply(0);
                var224_212 = (ScallopConfBase)((LinearSeqOptimized)var222_210.get()).apply(1);
                if (!conf.generate().equals(var223_211) || !conf.generate().c().equals(var224_212)) ** GOTO lbl449
                generateOpts = conf.generate().c();
                optDafConfig = generateOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$40(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(generateOpts.tunables(), optDafConfig);
                generator = this.createGeneratorFromSchema((URI)generateOpts.schema().apply(), (Option<RefQName>)generateOpts.rootNS().toOption(), (Map<String, String>)tunables, generateOpts.language());
                outputDir = (String)generateOpts.outdir().toOption().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$41(), ()Ljava/lang/String;)());
                var231_218 = generator;
                if (var231_218 instanceof Some) {
                    var232_219 = (Some)var231_218;
                    generator = (DFDL.CodeGenerator)var232_219.value();
                    Timer$.MODULE$.getResult("generating", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$42(org.apache.daffodil.api.DFDL$CodeGenerator java.lang.String ), ()Los/Path;)((DFDL.CodeGenerator)generator, (String)outputDir));
                    this.displayDiagnostics((WithDiagnostics)generator);
                    var4_221 = generator.isError() != false ? Main$ExitCode$.MODULE$.GenerateCodeError() : Main$ExitCode$.MODULE$.Success();
                } else if (None$.MODULE$.equals(var231_218)) {
                    var4_221 = Main$ExitCode$.MODULE$.GenerateCodeError();
                } else {
                    throw new MatchError(var231_218);
lbl449:
                    // 2 sources

                    throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                }
                var3_223 = rc = var4_221;
                var2_95 = var3_223;
                break block97;
            }
            throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
        }
        ret = var2_95;
        return ret;
    }

    private DFDL.UnparseResult unparseWithSAX(InputStream is, DFDL.DaffodilUnparseContentHandler contentHandler) {
        XMLReader xmlReader = DaffodilSAXParserFactory$.MODULE$.apply().newSAXParser().getXMLReader();
        xmlReader.setContentHandler((ContentHandler)contentHandler);
        xmlReader.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACES_FEATURE(), true);
        xmlReader.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE(), true);
        try {
            xmlReader.parse(new InputSource(is));
        }
        catch (DFDL.DaffodilUnparseErrorSAXException daffodilUnparseErrorSAXException) {}
        DFDL.UnparseResult ur = contentHandler.getUnparseResult();
        return ur;
    }

    private DFDL.ParseResult parseWithSAX(DFDL.DataProcessor processor, InputSourceDataInputStream data, DaffodilParseOutputStreamContentHandler saxContentHandler) {
        DFDL.DaffodilParseXMLReader saxXmlRdr = processor.newXMLReaderInstance();
        saxXmlRdr.setContentHandler((ContentHandler)saxContentHandler);
        saxXmlRdr.setProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBDIRECTORY(), (Object)this.blobDir());
        saxXmlRdr.setProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBSUFFIX(), (Object)this.blobSuffix());
        saxXmlRdr.parse(data);
        DFDL.ParseResult pr = (DFDL.ParseResult)saxXmlRdr.getProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_PARSERESULT());
        return pr;
    }

    public int bugFound(Exception e) {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("|\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |!!   An unexpected exception occurred. This is a bug!   !!\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |\n                          | Please report this bug and help us fix it:\n                          |\n                          |  https://daffodil.apache.org/community/#issue-tracker\n                          |\n                          | Please include the following exception, the command you\n                          | ran, and any input, schema, or tdml files used that led\n                          | to this bug.\n                          |\n                          |")).stripMargin());
        e.printStackTrace();
        return 1;
    }

    public int nyiFound(NotYetImplementedException e) {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("|\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |!!                 Not Yet Implemented                  !!\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |\n                          | You are using a feature that is not yet implemented:\n                          |\n                          | %s\n                          |\n                          | You can create a bug and track the progress of this\n                          | feature at:\n                          |\n                          |  https://issues.apache.org/jira/projects/DAFFODIL\n                          |\n                          |")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Misc$.MODULE$.getSomeMessage((Throwable)e)})))).stripMargin());
        return 1;
    }

    public int oomError(OutOfMemoryError e) {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("|\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |!!             Daffodil ran out of memory!              !!\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |\n                          | Try increasing the amount of memory by changing or\n                          | setting the DAFFODIL_JAVA_OPTS environment variable.\n                          | \"DAFFODIL_JAVA_OPTS=-Xmx5G\" for 5GB.\n                          |\n                          |")).stripMargin());
        return 1;
    }

    public void main(String[] arguments) {
        Enumeration.Value value;
        try {
            value = this.run(arguments);
        }
        catch (Throwable throwable) {
            Enumeration.Value value2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 instanceof FileNotFoundException) {
                BoxedUnit boxedUnit;
                FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage((Throwable)fileNotFoundException).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                value2 = Main$ExitCode$.MODULE$.FileNotFound();
            } else if (throwable2 instanceof ExternalVariableException) {
                BoxedUnit boxedUnit;
                ExternalVariableException externalVariableException = (ExternalVariableException)throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage((Throwable)externalVariableException).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                value2 = Main$ExitCode$.MODULE$.BadExternalVariable();
            } else if (throwable2 instanceof BindingException) {
                BoxedUnit boxedUnit;
                BindingException bindingException = (BindingException)throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage((Throwable)bindingException).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                value2 = Main$ExitCode$.MODULE$.BadExternalVariable();
            } else if (throwable2 instanceof NotYetImplementedException) {
                NotYetImplementedException notYetImplementedException = (NotYetImplementedException)throwable2;
                this.nyiFound(notYetImplementedException);
                value2 = Main$ExitCode$.MODULE$.NotYetImplemented();
            } else if (throwable2 instanceof TDMLException) {
                BoxedUnit boxedUnit;
                Throwable throwable3 = throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage(throwable3).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                value2 = Main$ExitCode$.MODULE$.TestError();
            } else if (throwable2 instanceof OutOfMemoryError) {
                OutOfMemoryError outOfMemoryError = (OutOfMemoryError)throwable2;
                this.oomError(outOfMemoryError);
                value2 = Main$ExitCode$.MODULE$.OutOfMemory();
            } else if (throwable2 instanceof UserDefinedFunctionFatalErrorException) {
                BoxedUnit boxedUnit;
                UserDefinedFunctionFatalErrorException userDefinedFunctionFatalErrorException = (UserDefinedFunctionFatalErrorException)throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage((Throwable)userDefinedFunctionFatalErrorException).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])userDefinedFunctionFatalErrorException.cause().getStackTrace())).take(10))).foreach((Function1 & Serializable & scala.Serializable)ste -> {
                    Main$.$anonfun$main$1(ste);
                    return BoxedUnit.UNIT;
                });
                value2 = Main$ExitCode$.MODULE$.UserDefinedFunctionError();
            } else if (throwable2 instanceof DebuggerExitException) {
                value2 = Main$ExitCode$.MODULE$.Failure();
            } else if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                this.bugFound(exception);
                value2 = Main$ExitCode$.MODULE$.BugFound();
            } else {
                throw throwable;
            }
            value = value2;
        }
        Enumeration.Value ret = value;
        System.exit(ret.id());
    }

    public static final /* synthetic */ boolean $anonfun$overrideBindings$2(Binding b$1, Binding p) {
        return b$1.hashCode() == p.hashCode();
    }

    public static final /* synthetic */ void $anonfun$displayDiagnostics$1(Diagnostic d) {
        BoxedUnit boxedUnit;
        if (d.isError()) {
            BoxedUnit boxedUnit2;
            if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)d.getMessage(), null);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (Logger$.MODULE$.log().isEnabled(Level.WARN)) {
            org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)d.getMessage(), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$1(File x$4) {
        return DaffodilConfig$.MODULE$.fromFile(x$4);
    }

    public static final /* synthetic */ DFDL.DataProcessor $anonfun$run$2(CLIConf$parse$ parseOpts$1, Option optDafConfig$1, DFDL.DataProcessor x$5) {
        return x$5.withExternalVariables(MODULE$.combineExternalVariables((Map<String, String>)parseOpts$1.vars(), (Option<DaffodilConfig>)optDafConfig$1));
    }

    public static final /* synthetic */ DFDL.ParseResult $anonfun$run$3(ObjectRef processor$1, InputSourceDataInputStream inStream$1, DaffodilParseOutputStreamContentHandler saxContentHandler$1) {
        return MODULE$.parseWithSAX((DFDL.DataProcessor)processor$1.elem, inStream$1, saxContentHandler$1);
    }

    public static final /* synthetic */ DFDL.ParseResult $anonfun$run$4(ObjectRef processor$1, InputSourceDataInputStream inStream$1, InfosetOutputter outputter$1) {
        return ((DFDL.DataProcessor)processor$1.elem).parse(inStream$1, outputter$1);
    }

    public static final /* synthetic */ String $anonfun$run$5(byte a) {
        byte arg$macro$3 = a;
        return new StringOps("%02x").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)arg$macro$3)}));
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$6(File x$6) {
        return DaffodilConfig$.MODULE$.fromFile(x$6);
    }

    public static final /* synthetic */ DFDL.DataProcessor $anonfun$run$7(CLIConf$performance$ performanceOpts$1, Option optDafConfig$2, DFDL.DataProcessor x$7) {
        return x$7.withExternalVariables(MODULE$.combineExternalVariables((Map<String, String>)performanceOpts$1.vars(), (Option<DaffodilConfig>)optDafConfig$2));
    }

    public static final /* synthetic */ DFDL.DataProcessor $anonfun$run$8(ValidationMode.Type validate$1, DFDL.DataProcessor x$8) {
        return x$8.withValidationMode(validate$1);
    }

    public static final /* synthetic */ boolean $anonfun$run$9(File x$9) {
        return !x$9.isDirectory();
    }

    public static final /* synthetic */ Either $anonfun$run$10(CLIConf$performance$ performanceOpts$1, Enumeration.Value infosetType$1, File filePath) {
        Right right;
        FileInputStream input = new FileInputStream(filePath);
        long dataSize = filePath.length();
        byte[] bytes = new byte[(int)dataSize];
        input.read(bytes);
        boolean bl = BoxesRunTime.unboxToBoolean((Object)performanceOpts$1.unparse().apply());
        if (bl) {
            right = scala.package$.MODULE$.Left().apply(MODULE$.infosetDataToInputterData(infosetType$1, (Either<byte[], InputStream>)scala.package$.MODULE$.Left().apply((Object)bytes)));
        } else if (!bl) {
            right = scala.package$.MODULE$.Right().apply((Object)bytes);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        Right data = right;
        return data;
    }

    public static final /* synthetic */ Either $anonfun$run$11(Seq dataSeq$1, int n) {
        int index = n % dataSeq$1.length();
        return (Either)dataSeq$1.apply(index);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$run$12(IndexedSeq inputsWithIndex$1, Enumeration.Value infosetType$1, DFDL.DataProcessor processor$2, WritableByteChannel nullChannelForUnparse$1, NullOutputStream nullOutputStreamForParse$1, ExecutionContext executionContext$1) {
        IndexedSeq tasks = (IndexedSeq)inputsWithIndex$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future task;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either inData = (Either)tuple2._1();
            int n = tuple2._2$mcI$sp();
            Future future = task = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Tuple2 tuple2;
                Either either = inData;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Object anyRef = left.value();
                    tuple2 = Timer$.MODULE$.getTimeResult((Function0 & Serializable & scala.Serializable)() -> {
                        DFDL.UnparseResult unparseResult;
                        Either<InfosetInputter, DFDL.DaffodilUnparseContentHandler> inputterForUnparse = MODULE$.getInfosetInputter(infosetType$1, anyRef, processor$2, nullChannelForUnparse$1);
                        Either<InfosetInputter, DFDL.DaffodilUnparseContentHandler> either = inputterForUnparse;
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            InfosetInputter inputter = (InfosetInputter)left.value();
                            unparseResult = processor$2.unparse(inputter, nullChannelForUnparse$1);
                        } else if (either instanceof Right) {
                            InputStream inputStream;
                            Right right = (Right)either;
                            DFDL.DaffodilUnparseContentHandler contentHandler = (DFDL.DaffodilUnparseContentHandler)right.value();
                            Object object = anyRef;
                            if (object instanceof byte[]) {
                                byte[] byArray = (byte[])object;
                                inputStream = new ByteArrayInputStream(byArray);
                            } else if (object instanceof InputStream) {
                                InputStream inputStream2 = (InputStream)object;
                                inputStream = inputStream2;
                            } else {
                                throw new MatchError(object);
                            }
                            InputStream is = inputStream;
                            unparseResult = MODULE$.unparseWithSAX(is, contentHandler);
                        } else {
                            throw new MatchError(either);
                        }
                        return unparseResult;
                    });
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    byte[] data = (byte[])right.value();
                    tuple2 = Timer$.MODULE$.getTimeResult((Function0 & Serializable & scala.Serializable)() -> {
                        DFDL.ParseResult parseResult;
                        InputSourceDataInputStream input = InputSourceDataInputStream$.MODULE$.apply(data);
                        Either<InfosetOutputter, DaffodilParseOutputStreamContentHandler> eitherOutputterOrHandlerForParse = MODULE$.getInfosetOutputter(infosetType$1, (OutputStream)nullOutputStreamForParse$1);
                        Either<InfosetOutputter, DaffodilParseOutputStreamContentHandler> either = eitherOutputterOrHandlerForParse;
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            InfosetOutputter outputter = (InfosetOutputter)left.value();
                            parseResult = processor$2.parse(input, outputter);
                        } else if (either instanceof Right) {
                            DFDL.ParseResult parseResult2;
                            Right right = (Right)either;
                            DaffodilParseOutputStreamContentHandler saxContentHandler = (DaffodilParseOutputStreamContentHandler)right.value();
                            parseResult = parseResult2 = MODULE$.parseWithSAX(processor$2, input, saxContentHandler);
                        } else {
                            throw new MatchError(either);
                        }
                        return parseResult;
                    });
                } else {
                    throw new MatchError((Object)either);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                long time = tuple22._1$mcJ$sp();
                DFDL.Result result = (DFDL.Result)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToLong((long)time), (Object)result);
                Tuple2 tuple24 = tuple23;
                long time2 = tuple24._1$mcJ$sp();
                DFDL.Result result2 = (DFDL.Result)tuple24._2();
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToLong((long)time2), (Object)BoxesRunTime.boxToBoolean((boolean)result2.isError()));
            }, executionContext$1);
            return future;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq results = (IndexedSeq)tasks.map((Function1 & Serializable & scala.Serializable)x$11 -> (Tuple3)Await$.MODULE$.result((Awaitable)x$11, (Duration)Duration$.MODULE$.Inf()), IndexedSeq$.MODULE$.canBuildFrom());
        return results;
    }

    public static final /* synthetic */ double $anonfun$run$18(double NSConvert$1, Tuple3 results) {
        BoxedUnit boxedUnit;
        String status;
        Tuple3 tuple3 = results;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int runNum = BoxesRunTime.unboxToInt((Object)tuple3._1());
        long nsTime = BoxesRunTime.unboxToLong((Object)tuple3._2());
        boolean error = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        int n = runNum;
        long l = nsTime;
        boolean bl = error;
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToBoolean((boolean)bl));
        Tuple3 tuple33 = tuple32;
        int runNum2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
        long nsTime2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        boolean error2 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
        double rate = 1.0 / ((double)nsTime2 / NSConvert$1);
        String string = status = error2 ? "fail" : "pass";
        if (Logger$.MODULE$.log().isEnabled(Level.INFO)) {
            org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.INFO, null, (CharSequence)new StringBuilder(34).append("run: ").append(runNum2).append(", seconds: ").append((double)nsTime2 / NSConvert$1).append(", rate: ").append(rate).append(", status: ").append(status).toString(), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return rate;
    }

    public static final /* synthetic */ boolean $anonfun$run$19(Tuple3 x$14) {
        return BoxesRunTime.unboxToBoolean((Object)x$14._3());
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$21(File x$15) {
        return DaffodilConfig$.MODULE$.fromFile(x$15);
    }

    public static final /* synthetic */ DFDL.DataProcessor $anonfun$run$22(CLIConf$unparse$ unparseOpts$1, Option optDafConfig$3, DFDL.DataProcessor x$16) {
        return x$16.withExternalVariables(MODULE$.combineExternalVariables((Map<String, String>)unparseOpts$1.vars(), (Option<DaffodilConfig>)optDafConfig$3));
    }

    public static final /* synthetic */ DFDL.UnparseResult $anonfun$run$23(DFDL.DataProcessor processor$3, InfosetInputter inputter$1, WritableByteChannel outChannel$1) {
        return processor$3.unparse(inputter$1, outChannel$1);
    }

    public static final /* synthetic */ DFDL.UnparseResult $anonfun$run$24(InputStream is$1, DFDL.DaffodilUnparseContentHandler contentHandler$1) {
        return MODULE$.unparseWithSAX(is$1, contentHandler$1);
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$25(File x$17) {
        return DaffodilConfig$.MODULE$.fromFile(x$17);
    }

    public static final /* synthetic */ void $anonfun$run$26(DFDL.DataProcessor processor$4, WritableByteChannel output$1) {
        processor$4.save(output$1);
    }

    public static final /* synthetic */ boolean $anonfun$run$28(Regex regex$1, TestCase testCase) {
        return regex$1.pattern().matcher(testCase.tcName()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$run$30(String testName$1, TestCase x$18) {
        String string = x$18.tcName();
        String string2 = testName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Seq $anonfun$run$27(CLIConf$test$ testOpts$1, Runner tdmlRunner$1, String testName) {
        .colon.colon colon2;
        if (BoxesRunTime.unboxToBoolean((Object)testOpts$1.regex().apply())) {
            Regex regex = new StringOps(Predef$.MODULE$.augmentString(testName)).r();
            Seq matches = (Seq)tdmlRunner$1.testCases().filter((Function1 & Serializable & scala.Serializable)testCase -> BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$run$28(regex, testCase)));
            colon2 = (Seq)matches.map((Function1 & Serializable & scala.Serializable)testCase -> new Tuple2((Object)testCase.tcName(), (Object)new Some(testCase)), Seq$.MODULE$.canBuildFrom());
        } else {
            colon2 = new .colon.colon((Object)new Tuple2((Object)testName, (Object)tdmlRunner$1.testCases().find((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$run$30(testName, x$18)))), (List)Nil$.MODULE$);
        }
        return colon2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$run$31(TestCase test) {
        return new Tuple2((Object)test.tcName(), (Object)new Some((Object)test));
    }

    public static final /* synthetic */ String $anonfun$run$32(Tuple2 x$19) {
        return (String)x$19._1();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ List $anonfun$run$34(List maxVals, Tuple2 testPair) {
        Tuple2 tuple2 = testPair;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(0))), name.length()), BoxesRunTime.unboxToInt((Object)maxVals.apply(1)), BoxesRunTime.unboxToInt((Object)maxVals.apply(2)), BoxesRunTime.unboxToInt((Object)maxVals.apply(3))}));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String name = (String)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
        Some some = (Some)option;
        TestCase test = (TestCase)some.value();
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(0))), name.length()), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(1))), test.model().length()), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(2))), test.rootName().length()), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(3))), test.description().length())}));
    }

    public static final /* synthetic */ String $anonfun$run$35(int max) {
        return new StringBuilder(2).append("%").append(-max).append("s").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$run$36(String formatStr$1, Tuple2 testPair) {
        Tuple2 tuple2 = testPair;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                TestCase test = (TestCase)some.value();
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(formatStr$1)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, test.model(), test.rootName(), test.description()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String name = (String)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(formatStr$1)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, "[Not Found]", "", ""})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$run$37(Tuple2 testPair) {
        Tuple2 tuple2 = testPair;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Predef$.MODULE$.println((Object)name);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String name = (String)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s  [Not Found]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$run$38(IntRef pass$1, IntRef fail$1, CLIConf$test$ testOpts$1, IntRef notfound$1, Tuple2 testPair) {
        Tuple2 tuple2 = testPair;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                TestCase test = (TestCase)some.value();
                try {
                    test.run();
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("[Pass] %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                    ++pass$1.elem;
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof ControlThrowable) {
                        ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                        throw (Throwable)controlThrowable;
                    }
                    if (throwable2 instanceof UnsuppressableException) {
                        UnsuppressableException unsuppressableException = (UnsuppressableException)throwable2;
                        throw unsuppressableException;
                    }
                    if (throwable2 instanceof TDMLTestNotCompatibleException) {
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("[Skipped] %s (Not compatible implementation.)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit3;
                        if (throwable2 == null) throw throwable;
                        Throwable throwable3 = throwable2;
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("[Fail] %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                        ++fail$1.elem;
                        if (BoxesRunTime.unboxToInt((Object)testOpts$1.info().apply()) > 0) {
                            Predef$.MODULE$.println((Object)"  Failure Information:");
                            Predef$.MODULE$.println((Object)MODULE$.indent(throwable3.getMessage(), 4));
                        }
                        if (BoxesRunTime.unboxToInt((Object)testOpts$1.info().apply()) > 1) {
                            Predef$.MODULE$.println((Object)"  Backtrace:");
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])throwable3.getStackTrace())).foreach((Function1 & Serializable & scala.Serializable)st -> {
                                Predef$.MODULE$.println((Object)Main$.MODULE$.indent(st.toString(), 4));
                                return BoxedUnit.UNIT;
                            });
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit4 = boxedUnit3;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit5 = boxedUnit;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String name = (String)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("[Not Found] %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        ++notfound$1.elem;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$40(File x$21) {
        return DaffodilConfig$.MODULE$.fromFile(x$21);
    }

    public static final /* synthetic */ String $anonfun$run$41() {
        return ".";
    }

    public static final /* synthetic */ os.Path $anonfun$run$42(DFDL.CodeGenerator generator$1, String outputDir$1) {
        return generator$1.generateCode(outputDir$1);
    }

    public static final /* synthetic */ void $anonfun$main$1(StackTraceElement ste) {
        BoxedUnit boxedUnit;
        if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
            org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)new StringBuilder(7).append("    at ").append(ste).toString(), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Main$() {
        MODULE$ = this;
        this.traceCommands = (Seq)new .colon.colon((Object)"display info parser", (List)new .colon.colon((Object)"display info data", (List)new .colon.colon((Object)"display info infoset", (List)new .colon.colon((Object)"display info diff", (List)new .colon.colon((Object)"trace", (List)Nil$.MODULE$)))));
        this.blobDir = Paths.get(System.getProperty("user.dir"), "daffodil-blobs");
        this.blobSuffix = ".bin";
    }

    public static final /* synthetic */ String $anonfun$run$5$adapted(Object a) {
        return Main$.$anonfun$run$5(BoxesRunTime.unboxToByte((Object)a));
    }

    public static final /* synthetic */ Object $anonfun$run$9$adapted(File x$9) {
        return BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$run$9(x$9));
    }

    public static final /* synthetic */ Either $anonfun$run$11$adapted(Seq dataSeq$1, Object n) {
        return Main$.$anonfun$run$11(dataSeq$1, BoxesRunTime.unboxToInt((Object)n));
    }

    public static final /* synthetic */ Object $anonfun$run$18$adapted(double NSConvert$1, Tuple3 results) {
        return BoxesRunTime.boxToDouble((double)Main$.$anonfun$run$18(NSConvert$1, results));
    }

    public static final /* synthetic */ Object $anonfun$run$19$adapted(Tuple3 x$14) {
        return BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$run$19(x$14));
    }

    public static final /* synthetic */ Object $anonfun$run$20$adapted(Object e) {
        return BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)e));
    }

    public static final /* synthetic */ Object $anonfun$run$33$adapted(String x$20) {
        return BoxesRunTime.boxToInteger((int)x$20.length());
    }

    public static final /* synthetic */ String $anonfun$run$35$adapted(Object max) {
        return Main$.$anonfun$run$35(BoxesRunTime.unboxToInt((Object)max));
    }

    public static final /* synthetic */ Object $anonfun$run$36$adapted(String formatStr$1, Tuple2 testPair) {
        Main$.$anonfun$run$36(formatStr$1, testPair);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$run$37$adapted(Tuple2 testPair) {
        Main$.$anonfun$run$37(testPair);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$run$38$adapted(IntRef pass$1, IntRef fail$1, CLIConf$test$ testOpts$1, IntRef notfound$1, Tuple2 testPair) {
        Main$.$anonfun$run$38(pass$1, fail$1, testOpts$1, notfound$1, testPair);
        return BoxedUnit.UNIT;
    }
}

