/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime2;

import org.apache.daffodil.dsom.ElementBase;
import org.apache.daffodil.grammar.Gram;
import org.apache.daffodil.grammar.Prod;
import org.apache.daffodil.grammar.RootGrammarMixin;
import org.apache.daffodil.grammar.SeqComp;
import org.apache.daffodil.grammar.primitives.BinaryBoolean;
import org.apache.daffodil.grammar.primitives.BinaryDouble;
import org.apache.daffodil.grammar.primitives.BinaryFloat;
import org.apache.daffodil.grammar.primitives.BinaryIntegerKnownLength;
import org.apache.daffodil.grammar.primitives.CaptureContentLengthEnd;
import org.apache.daffodil.grammar.primitives.CaptureContentLengthStart;
import org.apache.daffodil.grammar.primitives.CaptureValueLengthEnd;
import org.apache.daffodil.grammar.primitives.CaptureValueLengthStart;
import org.apache.daffodil.grammar.primitives.ElementCombinator;
import org.apache.daffodil.grammar.primitives.ElementParseAndUnspecifiedLength;
import org.apache.daffodil.grammar.primitives.HexBinaryLengthPrefixed;
import org.apache.daffodil.grammar.primitives.HexBinarySpecifiedLength;
import org.apache.daffodil.grammar.primitives.OrderedSequence;
import org.apache.daffodil.grammar.primitives.RightFill;
import org.apache.daffodil.grammar.primitives.ScalarOrderedSequenceChild;
import org.apache.daffodil.grammar.primitives.SpecifiedLengthImplicit;
import org.apache.daffodil.runtime2.generators.BinaryBooleanCodeGenerator;
import org.apache.daffodil.runtime2.generators.BinaryFloatCodeGenerator;
import org.apache.daffodil.runtime2.generators.BinaryIntegerKnownLengthCodeGenerator;
import org.apache.daffodil.runtime2.generators.BinaryValueCodeGenerator;
import org.apache.daffodil.runtime2.generators.CodeGeneratorState;
import org.apache.daffodil.runtime2.generators.ElementParseAndUnspecifiedLengthCodeGenerator;
import org.apache.daffodil.runtime2.generators.HexBinaryCodeGenerator;
import org.apache.daffodil.runtime2.generators.OrderedSequenceCodeGenerator;
import org.apache.daffodil.runtime2.generators.SeqCompCodeGenerator;
import org.apache.daffodil.util.Misc$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class Runtime2CodeGenerator$
implements BinaryBooleanCodeGenerator,
BinaryIntegerKnownLengthCodeGenerator,
BinaryFloatCodeGenerator,
ElementParseAndUnspecifiedLengthCodeGenerator,
HexBinaryCodeGenerator,
OrderedSequenceCodeGenerator,
SeqCompCodeGenerator {
    public static Runtime2CodeGenerator$ MODULE$;

    static {
        new Runtime2CodeGenerator$();
    }

    @Override
    public void seqCompGenerateCode(SeqComp g, CodeGeneratorState state) {
        SeqCompCodeGenerator.seqCompGenerateCode$(this, g, state);
    }

    @Override
    public void orderedSequenceGenerateCode(OrderedSequence g, CodeGeneratorState cgState) {
        OrderedSequenceCodeGenerator.orderedSequenceGenerateCode$(this, g, cgState);
    }

    @Override
    public void hexBinaryLengthPrefixedGenerateCode(ElementBase e, CodeGeneratorState cgState) {
        HexBinaryCodeGenerator.hexBinaryLengthPrefixedGenerateCode$(this, e, cgState);
    }

    @Override
    public void hexBinarySpecifiedLengthGenerateCode(ElementBase e, CodeGeneratorState cgState) {
        HexBinaryCodeGenerator.hexBinarySpecifiedLengthGenerateCode$(this, e, cgState);
    }

    @Override
    public void elementParseAndUnspecifiedLengthGenerateCode(ElementParseAndUnspecifiedLength g, CodeGeneratorState cgState) {
        ElementParseAndUnspecifiedLengthCodeGenerator.elementParseAndUnspecifiedLengthGenerateCode$(this, g, cgState);
    }

    @Override
    public void binaryFloatGenerateCode(ElementBase e, int lengthInBits, CodeGeneratorState cgState) {
        BinaryFloatCodeGenerator.binaryFloatGenerateCode$(this, e, lengthInBits, cgState);
    }

    @Override
    public void binaryIntegerKnownLengthGenerateCode(ElementBase e, long lengthInBits, boolean signed, CodeGeneratorState cgState) {
        BinaryIntegerKnownLengthCodeGenerator.binaryIntegerKnownLengthGenerateCode$(this, e, lengthInBits, signed, cgState);
    }

    @Override
    public void binaryBooleanGenerateCode(ElementBase e, CodeGeneratorState cgState) {
        BinaryBooleanCodeGenerator.binaryBooleanGenerateCode$(this, e, cgState);
    }

    @Override
    public void binaryValueGenerateCode(ElementBase e, Function1<String, BoxedUnit> addField, Function1<String, BoxedUnit> validateFixed) {
        BinaryValueCodeGenerator.binaryValueGenerateCode$(this, e, addField, validateFixed);
    }

    @Override
    public void valueAddField(ElementBase e, String initialValue, String primType, String deref, CodeGeneratorState cgState) {
        BinaryValueCodeGenerator.valueAddField$(this, e, initialValue, primType, deref, cgState);
    }

    @Override
    public void valueValidateFixed(ElementBase e, String deref, CodeGeneratorState cgState) {
        BinaryValueCodeGenerator.valueValidateFixed$(this, e, deref, cgState);
    }

    public void generateCode(Gram gram, CodeGeneratorState state) {
        Gram gram2;
        while (true) {
            Prod prod;
            if ((gram2 = gram) instanceof RootGrammarMixin) {
                Gram gram3 = gram2;
                gram = ((RootGrammarMixin)gram3).documentElement();
                continue;
            }
            if (gram2 instanceof Prod && (prod = (Prod)gram2).guard()) {
                gram = prod.gram();
                continue;
            }
            if (gram2 instanceof ElementCombinator) {
                ElementCombinator elementCombinator = (ElementCombinator)gram2;
                gram = elementCombinator.subComb();
                continue;
            }
            if (gram2 instanceof SpecifiedLengthImplicit) {
                SpecifiedLengthImplicit specifiedLengthImplicit = (SpecifiedLengthImplicit)gram2;
                gram = specifiedLengthImplicit.eGram();
                continue;
            }
            if (!(gram2 instanceof ScalarOrderedSequenceChild)) break;
            ScalarOrderedSequenceChild scalarOrderedSequenceChild = (ScalarOrderedSequenceChild)gram2;
            gram = scalarOrderedSequenceChild.term().termContentBody();
        }
        if (gram2 instanceof BinaryBoolean) {
            BinaryBoolean binaryBoolean = (BinaryBoolean)gram2;
            this.binaryBooleanGenerateCode(binaryBoolean.e(), state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof BinaryDouble) {
            BinaryDouble binaryDouble = (BinaryDouble)gram2;
            this.binaryFloatGenerateCode(binaryDouble.e(), 64, state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof BinaryFloat) {
            BinaryFloat binaryFloat = (BinaryFloat)gram2;
            this.binaryFloatGenerateCode(binaryFloat.e(), 32, state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof BinaryIntegerKnownLength) {
            BinaryIntegerKnownLength binaryIntegerKnownLength = (BinaryIntegerKnownLength)gram2;
            this.binaryIntegerKnownLengthGenerateCode(binaryIntegerKnownLength.e(), binaryIntegerKnownLength.lengthInBits(), binaryIntegerKnownLength.signed(), state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof ElementParseAndUnspecifiedLength) {
            ElementParseAndUnspecifiedLength elementParseAndUnspecifiedLength = (ElementParseAndUnspecifiedLength)gram2;
            this.elementParseAndUnspecifiedLengthGenerateCode(elementParseAndUnspecifiedLength, state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof HexBinaryLengthPrefixed) {
            HexBinaryLengthPrefixed hexBinaryLengthPrefixed = (HexBinaryLengthPrefixed)gram2;
            this.hexBinaryLengthPrefixedGenerateCode(hexBinaryLengthPrefixed.e(), state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof HexBinarySpecifiedLength) {
            HexBinarySpecifiedLength hexBinarySpecifiedLength = (HexBinarySpecifiedLength)gram2;
            this.hexBinarySpecifiedLengthGenerateCode(hexBinarySpecifiedLength.e(), state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof OrderedSequence) {
            OrderedSequence orderedSequence = (OrderedSequence)gram2;
            this.orderedSequenceGenerateCode(orderedSequence, state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof SeqComp) {
            SeqComp seqComp = (SeqComp)gram2;
            this.seqCompGenerateCode(seqComp, state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof CaptureContentLengthStart) {
            this.noop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof CaptureContentLengthEnd) {
            this.noop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof CaptureValueLengthStart) {
            this.noop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof CaptureValueLengthEnd) {
            this.noop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (gram2 instanceof RightFill) {
            this.noop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw gram.SDE("Code generation not supported for: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Misc$.MODULE$.getNameFromClass((Object)gram)}));
        }
    }

    private void noop() {
    }

    private Runtime2CodeGenerator$() {
        MODULE$ = this;
        BinaryValueCodeGenerator.$init$(this);
        BinaryBooleanCodeGenerator.$init$(this);
        BinaryIntegerKnownLengthCodeGenerator.$init$(this);
        BinaryFloatCodeGenerator.$init$(this);
        ElementParseAndUnspecifiedLengthCodeGenerator.$init$(this);
        HexBinaryCodeGenerator.$init$(this);
        OrderedSequenceCodeGenerator.$init$(this);
        SeqCompCodeGenerator.$init$(this);
    }
}

