/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.parsers;

import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.infoset.DIComplex;
import org.apache.daffodil.infoset.DIElement;
import org.apache.daffodil.infoset.DISimple;
import org.apache.daffodil.infoset.DataValue$;
import org.apache.daffodil.infoset.Infoset$;
import org.apache.daffodil.processors.ElementRuntimeData;
import org.apache.daffodil.processors.Success$;
import org.apache.daffodil.processors.parsers.PState;
import org.apache.daffodil.processors.parsers.Parser;
import org.apache.daffodil.schema.annotation.props.gen.LengthUnits;
import org.apache.daffodil.util.MaybeInt$;
import org.apache.daffodil.util.MaybeULong$;
import org.apache.daffodil.util.Numbers$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%3q\u0001C\u0005\u0011\u0002\u0007\u0005A\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003!\u0001\u0019\u0005\u0011\u0005C\u0003'\u0001\u0019\u0005q\u0005C\u0003-\u0001\u0019\u0005Q\u0006C\u0003;\u0001\u0019\u00051\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003G\u0001\u0011\u0005qIA\rQe\u00164\u0017\u000e_3e\u0019\u0016tw\r\u001e5QCJ\u001cXM]'jq&t'B\u0001\u0006\f\u0003\u001d\u0001\u0018M]:feNT!\u0001D\u0007\u0002\u0015A\u0014xnY3tg>\u00148O\u0003\u0002\u000f\u001f\u0005AA-\u00194g_\u0012LGN\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001\u001e!\t1b$\u0003\u0002 /\t!QK\\5u\u0003Q\u0001(/\u001a4jq\u0016$G*\u001a8hi\"\u0004\u0016M]:feV\t!\u0005\u0005\u0002$I5\t\u0011\"\u0003\u0002&\u0013\t1\u0001+\u0019:tKJ\f\u0011\u0003\u001d:fM&DX\r\u001a'f]\u001e$\b.\u0012*E+\u0005A\u0003CA\u0015+\u001b\u0005Y\u0011BA\u0016\f\u0005I)E.Z7f]R\u0014VO\u001c;j[\u0016$\u0015\r^1\u0002\u00171,gn\u001a;i+:LGo]\u000b\u0002]A\u0011q\u0006O\u0007\u0002a)\u0011\u0011GM\u0001\u0004O\u0016t'BA\u001a5\u0003\u0015\u0001(o\u001c9t\u0015\t)d'\u0001\u0006b]:|G/\u0019;j_:T!aN\u0007\u0002\rM\u001c\u0007.Z7b\u0013\tI\u0004GA\u0006MK:<G\u000f[+oSR\u001c\u0018a\b9sK\u001aL\u00070\u001a3MK:<G\u000f[!eUV\u001cH/\\3oi&sWK\\5ugV\tA\b\u0005\u0002\u0017{%\u0011ah\u0006\u0002\u0005\u0019>tw-\u0001\rhKR\u0004&/\u001a4jq\u0016$G*\u001a8hi\"Le.\u00168jiN$\"\u0001P!\t\u000b\t3\u0001\u0019A\"\u0002\u000bM$\u0018\r^3\u0011\u0005\r\"\u0015BA#\n\u0005\u0019\u00016\u000b^1uK\u00069r-\u001a;Qe\u00164\u0017\u000e_3e\u0019\u0016tw\r\u001e5J]\nKGo\u001d\u000b\u0003y!CQAQ\u0004A\u0002\r\u0003")
public interface PrefixedLengthParserMixin {
    public Parser prefixedLengthParser();

    public ElementRuntimeData prefixedLengthERD();

    public LengthUnits lengthUnits();

    public long prefixedLengthAdjustmentInUnits();

    public static /* synthetic */ long getPrefixedLengthInUnits$(PrefixedLengthParserMixin $this, PState state) {
        return $this.getPrefixedLengthInUnits(state);
    }

    default public long getPrefixedLengthInUnits(PState state) {
        Long l;
        DIElement savedInfoset = state.infoset();
        DISimple plElement = (DISimple)Infoset$.MODULE$.newDetachedElement(state, this.prefixedLengthERD());
        state.infoset_$eq(plElement);
        try {
            this.prefixedLengthParser().parse1(state);
            l = state.processorStatus() != Success$.MODULE$ ? Predef$.MODULE$.long2Long(0L) : Numbers$.MODULE$.asLong(DataValue$.MODULE$.getAnyRef$extension(plElement.dataValue()));
        }
        finally {
            state.infoset_$eq(savedInfoset);
        }
        Long parsedLen = l;
        if (Predef$.MODULE$.Long2long(parsedLen) < 0L) {
            throw state.SDE("Prefixed length result must be non-negative, but was: %d", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parsedLen}));
        }
        long adjustedLen = Predef$.MODULE$.Long2long(parsedLen) - this.prefixedLengthAdjustmentInUnits();
        if (adjustedLen < 0L) {
            throw state.SDE("Prefixed length result must be non-negative after dfdl:prefixIncludesPrefixLength adjustment , but was: %d", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)adjustedLen)}));
        }
        return adjustedLen;
    }

    public static /* synthetic */ long getPrefixedLengthInBits$(PrefixedLengthParserMixin $this, PState state) {
        return $this.getPrefixedLengthInBits(state);
    }

    default public long getPrefixedLengthInBits(PState state) {
        long l;
        long lenInUnits = this.getPrefixedLengthInUnits(state);
        LengthUnits lengthUnits = this.lengthUnits();
        if (LengthUnits.Bits$.MODULE$.equals(lengthUnits)) {
            l = lenInUnits;
        } else if (LengthUnits.Bytes$.MODULE$.equals(lengthUnits)) {
            l = lenInUnits * 8L;
        } else if (LengthUnits.Characters$.MODULE$.equals(lengthUnits)) {
            long mfw = state.encoder().bitsCharset().maybeFixedWidth();
            if (!MaybeInt$.MODULE$.isDefined$extension(mfw)) {
                throw Assert$.MODULE$.abort("Invariant broken. Prefixed length for text data in non-fixed width encoding.");
            }
            l = lenInUnits * (long)MaybeInt$.MODULE$.get$extension(mfw);
        } else {
            throw new MatchError((Object)lengthUnits);
        }
        long lenInBits = l;
        long mLenInBits = MaybeULong$.MODULE$.apply(lenInBits);
        DIElement dIElement = state.infoset();
        if (dIElement instanceof DIComplex) {
            DIComplex dIComplex = (DIComplex)dIElement;
            dIComplex.contentLength().maybeComputedLengthInBits_$eq(mLenInBits);
            dIComplex.valueLength().maybeComputedLengthInBits_$eq(mLenInBits);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dIElement instanceof DISimple) {
            DISimple dISimple = (DISimple)dIElement;
            dISimple.contentLength().maybeComputedLengthInBits_$eq(mLenInBits);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)dIElement);
        }
        return lenInBits;
    }

    public static void $init$(PrefixedLengthParserMixin $this) {
    }
}

