/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.calendar.DFDLDate;
import org.apache.daffodil.calendar.DFDLDateConversion$;
import org.apache.daffodil.calendar.DFDLDateTime;
import org.apache.daffodil.calendar.DFDLDateTimeConversion$;
import org.apache.daffodil.calendar.DFDLTime;
import org.apache.daffodil.calendar.DFDLTimeConversion$;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.util.Maybe$;
import org.apache.daffodil.util.Maybe$One$;
import org.apache.daffodil.util.Misc$;
import org.apache.daffodil.xml.NS;
import org.apache.daffodil.xml.NS$;
import org.apache.daffodil.xml.PrettyPrinter;
import org.apache.daffodil.xml.XMLUtils;
import org.xml.sax.XMLReader;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;
import scala.xml.Atom;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.Elem$;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.PrefixedAttribute$;
import scala.xml.ProcInstr;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.Unparsed;
import scala.xml.Utility$;

public final class XMLUtils$ {
    public static XMLUtils$ MODULE$;
    private URI schemaForDFDLSchemas;
    private URI dafextURI;
    private URI tdmlURI;
    private final PrefixedAttribute xmlNilAttribute;
    private final String PositiveInfinityString;
    private final String NegativeInfinityString;
    private final String NaNString;
    private final NS XSD_NAMESPACE;
    private final NS XSI_NAMESPACE;
    private final NS XPATH_FUNCTION_NAMESPACE;
    private final NS XPATH_MATH_NAMESPACE;
    private final NS DFDL_NAMESPACE;
    private final NS DFDLX_NAMESPACE;
    private final NS TDML_NAMESPACE;
    private final NS EXAMPLE_NAMESPACE;
    private final NS XHTML_NAMESPACE;
    private final String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA;
    private final NS DAFFODIL_EXTENSION_NAMESPACE_NCSA;
    private final String EXT_PREFIX_NCSA;
    private final NS EXT_NS_NCSA;
    private final String DAFFODIL_NAMESPACE_ROOT_APACHE;
    private final NS DAFFODIL_EXTENSION_NAMESPACE_APACHE;
    private final String EXT_PREFIX_APACHE;
    private final NS EXT_NS_APACHE;
    private final NS DAFFODIL_INTERNAL_NAMESPACE;
    private final String INT_PREFIX;
    private final NS INT_NS;
    private final String DAFFODIL_SAX_URN_ROOT;
    private final String DAFFODIL_SAX_URN_PARSERESULT;
    private final String DAFFODIL_SAX_URN_BLOBDIRECTORY;
    private final String DAFFODIL_SAX_URN_BLOBPREFIX;
    private final String DAFFODIL_SAX_URN_BLOBSUFFIX;
    private final String SAX_NAMESPACES_FEATURE;
    private final String SAX_NAMESPACE_PREFIXES_FEATURE;
    private final String XML_DISALLOW_DOCTYPE_FEATURE;
    private final String XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE;
    private final String XML_EXTERNAL_GENERAL_ENTITIES_FEATURE;
    private final String XML_LOAD_EXTERNAL_DTD_FEATURE;
    private final String FILE_ATTRIBUTE_NAME;
    private final String LINE_ATTRIBUTE_NAME;
    private final String COLUMN_ATTRIBUTE_NAME;
    private final NS xsdURI;
    private final NS dfdlURI;
    private final NS dfdlxURI;
    private final NS dfdlAppinfoSource;
    private final NS targetNS;
    private final NS xsiURI;
    private final NS fnURI;
    private final NS mathURI;
    private final NS dafintURI;
    private final List<String> DFDL_SIMPLE_BUILT_IN_TYPES;
    private final Function1<Object, Object> escapeMapper;
    private final Regex xmlEntityPattern;
    private volatile byte bitmap$0;

    static {
        new XMLUtils$();
    }

    private URI schemaForDFDLSchemas$lzycompute() {
        XMLUtils$ xMLUtils$ = this;
        synchronized (xMLUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.schemaForDFDLSchemas = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/XMLSchema_for_DFDL.xsd");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.schemaForDFDLSchemas;
    }

    public URI schemaForDFDLSchemas() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.schemaForDFDLSchemas$lzycompute() : this.schemaForDFDLSchemas;
    }

    private URI dafextURI$lzycompute() {
        XMLUtils$ xMLUtils$ = this;
        synchronized (xMLUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dafextURI = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/dafext.xsd");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dafextURI;
    }

    public URI dafextURI() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dafextURI$lzycompute() : this.dafextURI;
    }

    private URI tdmlURI$lzycompute() {
        XMLUtils$ xMLUtils$ = this;
        synchronized (xMLUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.tdmlURI = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/tdml.xsd");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.tdmlURI;
    }

    public URI tdmlURI() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.tdmlURI$lzycompute() : this.tdmlURI;
    }

    public PrefixedAttribute xmlNilAttribute() {
        return this.xmlNilAttribute;
    }

    public String PositiveInfinityString() {
        return this.PositiveInfinityString;
    }

    public String NegativeInfinityString() {
        return this.NegativeInfinityString;
    }

    public String NaNString() {
        return this.NaNString;
    }

    public char remapXMLIllegalCharToPUA(boolean checkForExistingPUA, boolean replaceCRWithLF, char c) {
        char c2;
        char cInt = c;
        char c3 = cInt;
        if ('\t' == c3) {
            c2 = c;
        } else if ('\n' == c3) {
            c2 = c;
        } else if ('\r' == c3) {
            c2 = replaceCRWithLF ? (char)10 : (char)57357;
        } else if (cInt < ' ') {
            c2 = (char)(cInt + 57344);
        } else if (cInt > '\ud7ff' && cInt < '\ue000') {
            c2 = (char)(cInt + 4096);
        } else if (cInt >= '\ue000' && cInt <= '\uf8ff') {
            if (checkForExistingPUA) {
                throw Assert$.MODULE$.usageError(new StringOps(Predef$.MODULE$.augmentString("Pre-existing Private Use Area (PUA) character found in data: '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)})));
            }
            c2 = c;
        } else if ('\ufffe' == c3) {
            c2 = (char)61694;
        } else if ('\uffff' == c3) {
            c2 = (char)61695;
        } else {
            if (cInt > '\u10ffff') {
                throw Assert$.MODULE$.invariantFailed(new StringOps(Predef$.MODULE$.augmentString("Character code beyond U+10FFFF found in data. Codepoint: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cInt)})));
            }
            c2 = c;
        }
        char res = c2;
        return res;
    }

    public boolean remapXMLIllegalCharToPUA$default$1() {
        return true;
    }

    public boolean remapXMLIllegalCharToPUA$default$2() {
        return true;
    }

    public boolean needsXMLToPUARemapping(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            if (!(v < ' ' && v != '\n' && v != '\t' || v > '\ud7ff' && v < '\ue000' || v >= '\ue000' && v <= '\uf8ff' || v == '\ufffe' || v == '\uffff') && v <= '\u10ffff') continue;
            return true;
        }
        return false;
    }

    public char remapPUAToXMLIllegalChar(char c) {
        char c2;
        char cInt;
        char c3 = cInt = c;
        if (c >= '\ue000' && c <= '\ue01f') {
            c2 = (char)(c - 57344);
        } else if (c >= '\ue800' && c <= '\uefff') {
            c2 = (char)(c - 4096);
        } else if ('\uf0fe' == c3) {
            c2 = (char)65534;
        } else if ('\uf0ff' == c3) {
            c2 = (char)65535;
        } else {
            if (c > '\u10ffff') {
                throw Assert$.MODULE$.invariantFailed(new StringOps(Predef$.MODULE$.augmentString("Character code beyond U+10FFFF found in data. Codepoint: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
            }
            c2 = c;
        }
        char res = c2;
        return res;
    }

    public boolean needsPUAToXMLRemapping(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            if (!(v == '\r' || v >= '\ue000' && v <= '\ue01f' || v >= '\ue800' && v <= '\uefff' || v == '\uf0fe' || v == '\uf0ff') && v <= '\u10ffff') continue;
            return true;
        }
        return false;
    }

    public boolean isLeadingSurrogate(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public boolean isTrailingSurrogate(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    /*
     * WARNING - void declaration
     */
    public int uncodeLength(String s) {
        void var2_2;
        int res = s.getBytes("UTF-32BE").length / 4;
        return (int)var2_2;
    }

    public <T> Seq<T> walkUnicodeString(String str, Function3<Object, Object, Object, T> bodyFunc) {
        int len = str.length();
        if (len == 0) {
            return Nil$.MODULE$;
        }
        ListBuffer list = new ListBuffer();
        char prev = (char)0;
        char curr = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), 0);
        char next = (char)0;
        for (int pos = 0; pos < len; ++pos) {
            next = pos + 1 < len ? StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), pos + 1) : (char)0;
            list.$plus$eq(bodyFunc.apply((Object)BoxesRunTime.boxToCharacter((char)prev), (Object)BoxesRunTime.boxToCharacter((char)curr), (Object)BoxesRunTime.boxToCharacter((char)next)));
            prev = curr;
            curr = next;
        }
        return list;
    }

    public String remapXMLCharacters(String dfdlString, Function1<Object, Object> remapFunc) {
        int len = dfdlString.length();
        if (len == 0) {
            return dfdlString;
        }
        StringBuilder sb = new StringBuilder();
        char prev = (char)0;
        char curr = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dfdlString), 0);
        char next = (char)0;
        for (int pos = 0; pos < len; ++pos) {
            char c = next = pos + 1 < len ? StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dfdlString), pos + 1) : (char)0;
            Object object = curr == '\r' ? (next != '\n' ? sb.append((char)10) : BoxedUnit.UNIT) : sb.append(this.remapOneChar$1(prev, curr, next, remapFunc));
            prev = curr;
            curr = next;
        }
        return sb.toString();
    }

    public String remapXMLIllegalCharactersToPUA(String dfdlString) {
        String string;
        if (this.needsXMLToPUARemapping(dfdlString)) {
            boolean bl = this.remapXMLIllegalCharToPUA$default$2();
            string = this.remapXMLCharacters(dfdlString, (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)XMLUtils$.MODULE$.remapXMLIllegalCharToPUA(false, bl, BoxesRunTime.unboxToChar((Object)c))));
        } else {
            string = dfdlString;
        }
        return string;
    }

    public String remapPUAToXMLIllegalCharacters(String dfdlString) {
        return this.needsPUAToXMLRemapping(dfdlString) ? this.remapXMLCharacters(dfdlString, (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)XMLUtils$.MODULE$.remapPUAToXMLIllegalChar(BoxesRunTime.unboxToChar((Object)c)))) : dfdlString;
    }

    public Node coalesceAllAdjacentTextNodes(Node node) {
        Node node2;
        Node node3 = node;
        Option option = Elem$.MODULE$.unapplySeq(node3);
        if (!option.isEmpty()) {
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attribs = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq child = (Seq)((Tuple5)option.get())._5();
            Seq coalescedChildren = (Seq)child.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.coalesceAllAdjacentTextNodes((Node)x$1), Seq$.MODULE$.canBuildFrom());
            Seq<Node> newChildren = this.coalesceAdjacentTextNodes((Seq<Node>)coalescedChildren);
            node2 = Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
        } else {
            node2 = node3;
        }
        return node2;
    }

    public Seq<Node> coalesceAdjacentTextNodes(Seq<Node> seq) {
        if (seq.length() == 0) {
            return seq;
        }
        if (seq.length() == 1) {
            Node node = (Node)seq.apply(0);
            if (node instanceof Atom) {
                return seq;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ArrayBuilder ab = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Node.class));
        boolean i = false;
        ObjectRef tn = ObjectRef.create(null);
        ObjectRef sb = ObjectRef.create(null);
        seq.foreach((Function1 & Serializable & scala.Serializable)current -> {
            Builder builder;
            if (current instanceof Text || current instanceof Unparsed) {
                if ((Node)tn$1.elem == null) {
                    if ((StringBuilder)sb$1.elem == null || ((StringBuilder)sb$1.elem).length() == 0) {
                        tn$1.elem = current;
                        builder = BoxedUnit.UNIT;
                    } else {
                        builder = ((StringBuilder)sb$1.elem).append(current.text());
                    }
                } else {
                    if ((StringBuilder)sb$1.elem == null) {
                        sb$1.elem = new StringBuilder();
                    }
                    ((StringBuilder)sb$1.elem).append(((Node)tn$1.elem).text());
                    ((StringBuilder)sb$1.elem).append(current.text());
                    tn$1.elem = null;
                    builder = BoxedUnit.UNIT;
                }
            } else {
                XMLUtils$.processText$1(tn, sb, ab);
                builder = ab.$plus$eq(current);
            }
            return builder;
        });
        XMLUtils$.processText$1(tn, sb, ab);
        return Predef$.MODULE$.wrapRefArray((Object[])ab.result());
    }

    public NS XSD_NAMESPACE() {
        return this.XSD_NAMESPACE;
    }

    public NS XSI_NAMESPACE() {
        return this.XSI_NAMESPACE;
    }

    public NS XPATH_FUNCTION_NAMESPACE() {
        return this.XPATH_FUNCTION_NAMESPACE;
    }

    public NS XPATH_MATH_NAMESPACE() {
        return this.XPATH_MATH_NAMESPACE;
    }

    public NS DFDL_NAMESPACE() {
        return this.DFDL_NAMESPACE;
    }

    public NS DFDLX_NAMESPACE() {
        return this.DFDLX_NAMESPACE;
    }

    public NS TDML_NAMESPACE() {
        return this.TDML_NAMESPACE;
    }

    public NS EXAMPLE_NAMESPACE() {
        return this.EXAMPLE_NAMESPACE;
    }

    public NS XHTML_NAMESPACE() {
        return this.XHTML_NAMESPACE;
    }

    public Elem getXSDElement(NamespaceBinding scope) {
        String string;
        boolean isXSDTheDefaultNS;
        String xsdPre = scope.getPrefix(this.XSD_NAMESPACE().toString());
        String string2 = this.XSD_NAMESPACE().toString();
        String string3 = scope.getURI(null);
        boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? true : (isXSDTheDefaultNS = false);
        if (xsdPre != null) {
            string = xsdPre;
        } else if (isXSDTheDefaultNS) {
            string = null;
        } else {
            throw Assert$.MODULE$.usageError("Scope argument must have a binding for the XSD namespace.");
        }
        String xsdPrefix = string;
        Elem res = Elem$.MODULE$.apply(xsdPrefix, "element", (MetaData)Null$.MODULE$, scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        return res;
    }

    private String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA() {
        return this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA;
    }

    private NS DAFFODIL_EXTENSION_NAMESPACE_NCSA() {
        return this.DAFFODIL_EXTENSION_NAMESPACE_NCSA;
    }

    public String EXT_PREFIX_NCSA() {
        return this.EXT_PREFIX_NCSA;
    }

    public NS EXT_NS_NCSA() {
        return this.EXT_NS_NCSA;
    }

    private String DAFFODIL_NAMESPACE_ROOT_APACHE() {
        return this.DAFFODIL_NAMESPACE_ROOT_APACHE;
    }

    private NS DAFFODIL_EXTENSION_NAMESPACE_APACHE() {
        return this.DAFFODIL_EXTENSION_NAMESPACE_APACHE;
    }

    public String EXT_PREFIX_APACHE() {
        return this.EXT_PREFIX_APACHE;
    }

    public NS EXT_NS_APACHE() {
        return this.EXT_NS_APACHE;
    }

    private NS DAFFODIL_INTERNAL_NAMESPACE() {
        return this.DAFFODIL_INTERNAL_NAMESPACE;
    }

    public String INT_PREFIX() {
        return this.INT_PREFIX;
    }

    public NS INT_NS() {
        return this.INT_NS;
    }

    public String DAFFODIL_SAX_URN_ROOT() {
        return this.DAFFODIL_SAX_URN_ROOT;
    }

    public String DAFFODIL_SAX_URN_PARSERESULT() {
        return this.DAFFODIL_SAX_URN_PARSERESULT;
    }

    public String DAFFODIL_SAX_URN_BLOBDIRECTORY() {
        return this.DAFFODIL_SAX_URN_BLOBDIRECTORY;
    }

    public String DAFFODIL_SAX_URN_BLOBPREFIX() {
        return this.DAFFODIL_SAX_URN_BLOBPREFIX;
    }

    public String DAFFODIL_SAX_URN_BLOBSUFFIX() {
        return this.DAFFODIL_SAX_URN_BLOBSUFFIX;
    }

    public String SAX_NAMESPACES_FEATURE() {
        return this.SAX_NAMESPACES_FEATURE;
    }

    public String SAX_NAMESPACE_PREFIXES_FEATURE() {
        return this.SAX_NAMESPACE_PREFIXES_FEATURE;
    }

    public String XML_DISALLOW_DOCTYPE_FEATURE() {
        return this.XML_DISALLOW_DOCTYPE_FEATURE;
    }

    public String XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE() {
        return this.XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE;
    }

    public String XML_EXTERNAL_GENERAL_ENTITIES_FEATURE() {
        return this.XML_EXTERNAL_GENERAL_ENTITIES_FEATURE;
    }

    public String XML_LOAD_EXTERNAL_DTD_FEATURE() {
        return this.XML_LOAD_EXTERNAL_DTD_FEATURE;
    }

    public void setSecureDefaults(XMLReader xmlReader) {
        xmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        xmlReader.setFeature(this.XML_DISALLOW_DOCTYPE_FEATURE(), true);
        xmlReader.setFeature(this.XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE(), false);
        xmlReader.setFeature(this.XML_EXTERNAL_GENERAL_ENTITIES_FEATURE(), false);
    }

    public String FILE_ATTRIBUTE_NAME() {
        return this.FILE_ATTRIBUTE_NAME;
    }

    public String LINE_ATTRIBUTE_NAME() {
        return this.LINE_ATTRIBUTE_NAME;
    }

    public String COLUMN_ATTRIBUTE_NAME() {
        return this.COLUMN_ATTRIBUTE_NAME;
    }

    public NS xsdURI() {
        return this.xsdURI;
    }

    public NS dfdlURI() {
        return this.dfdlURI;
    }

    public NS dfdlxURI() {
        return this.dfdlxURI;
    }

    public NS dfdlAppinfoSource() {
        return this.dfdlAppinfoSource;
    }

    public NS targetNS() {
        return this.targetNS;
    }

    public NS xsiURI() {
        return this.xsiURI;
    }

    public NS fnURI() {
        return this.fnURI;
    }

    public NS mathURI() {
        return this.mathURI;
    }

    public NS dafintURI() {
        return this.dafintURI;
    }

    public List<String> DFDL_SIMPLE_BUILT_IN_TYPES() {
        return this.DFDL_SIMPLE_BUILT_IN_TYPES;
    }

    public String slashify(String s) {
        String string = s;
        String string2 = "";
        return !(string == null ? string2 != null : !string.equals(string2)) || s.endsWith("/") ? s : new java.lang.StringBuilder(1).append(s).append("/").toString();
    }

    public Seq<NamespaceBinding> namespaceBindings(NamespaceBinding nsBinding) {
        Nil$ nil$;
        if (nsBinding == null) {
            nil$ = Nil$.MODULE$;
        } else {
            Nil$ thisOne = nsBinding.uri() != null ? new .colon.colon((Object)nsBinding, (List)Nil$.MODULE$) : Nil$.MODULE$;
            Seq<NamespaceBinding> others = this.namespaceBindings(nsBinding.parent());
            nil$ = (Seq)thisOne.$plus$plus(others, List$.MODULE$.canBuildFrom());
        }
        return nil$;
    }

    public MetaData dfdlAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dfdlAttributes$1(n, x$2)));
    }

    public MetaData dfdlxAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dfdlxAttributes$1(n, x$3)));
    }

    public MetaData dafAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dafAttributes$1(n, a)));
    }

    public NamespaceBinding combineScopes(NamespaceBinding local, NamespaceBinding outer) {
        NamespaceBinding namespaceBinding;
        block5: {
            String outerURI;
            NamespaceBinding moreBindings;
            String uri;
            String pre;
            while (true) {
                NamespaceBinding namespaceBinding2 = local;
                TopScope$ topScope$ = TopScope$.MODULE$;
                if (!(namespaceBinding2 != null ? !namespaceBinding2.equals(topScope$) : topScope$ != null)) {
                    namespaceBinding = outer;
                    break block5;
                }
                NamespaceBinding namespaceBinding3 = local;
                if (namespaceBinding3 == null) {
                    throw new MatchError((Object)namespaceBinding3);
                }
                String pre2 = namespaceBinding3.prefix();
                String uri2 = namespaceBinding3.uri();
                NamespaceBinding moreBindings2 = namespaceBinding3.parent();
                Tuple3 tuple3 = new Tuple3((Object)pre2, (Object)uri2, (Object)moreBindings2);
                Tuple3 tuple32 = tuple3;
                pre = (String)tuple32._1();
                uri = (String)tuple32._2();
                moreBindings = (NamespaceBinding)tuple32._3();
                String string = outerURI = outer.getURI(pre);
                String string2 = uri;
                if (string != null ? !string.equals(string2) : string2 != null) break;
                local = moreBindings;
            }
            if (outerURI == null) {
                namespaceBinding = new NamespaceBinding(pre, uri, this.combineScopes(moreBindings, outer));
            } else {
                NamespaceBinding outerWithoutDuplicate = this.removeBindings(new NamespaceBinding(pre, uri, (NamespaceBinding)TopScope$.MODULE$), outer);
                NamespaceBinding moreBindingsWithoutConflict = this.removeBindings(new NamespaceBinding(pre, uri, (NamespaceBinding)TopScope$.MODULE$), moreBindings);
                namespaceBinding = new NamespaceBinding(pre, uri, this.combineScopes(moreBindingsWithoutConflict, outerWithoutDuplicate));
            }
        }
        return namespaceBinding;
    }

    public NamespaceBinding removeBindings(NamespaceBinding nb, NamespaceBinding scope) {
        NamespaceBinding namespaceBinding;
        block4: {
            NamespaceBinding more;
            while (true) {
                NamespaceBinding namespaceBinding2 = nb;
                TopScope$ topScope$ = TopScope$.MODULE$;
                if (!(namespaceBinding2 != null ? !namespaceBinding2.equals(topScope$) : topScope$ != null)) {
                    namespaceBinding = scope;
                    break block4;
                }
                NamespaceBinding namespaceBinding3 = scope;
                TopScope$ topScope$2 = TopScope$.MODULE$;
                if (!(namespaceBinding3 != null ? !namespaceBinding3.equals(topScope$2) : topScope$2 != null)) {
                    namespaceBinding = scope;
                    break block4;
                }
                NamespaceBinding namespaceBinding4 = scope;
                if (namespaceBinding4 == null) {
                    throw new MatchError((Object)namespaceBinding4);
                }
                String pre = namespaceBinding4.prefix();
                NamespaceBinding more2 = namespaceBinding4.parent();
                Tuple2 tuple2 = new Tuple2((Object)pre, (Object)more2);
                Tuple2 tuple22 = tuple2;
                String pre2 = (String)tuple22._1();
                more = (NamespaceBinding)tuple22._2();
                if (nb.getURI(pre2) == null) break;
                scope = more;
            }
            NamespaceBinding x$1 = this.removeBindings(nb, more);
            String x$2 = scope.copy$default$1();
            String x$3 = scope.copy$default$2();
            namespaceBinding = scope.copy(x$2, x$3, x$1);
        }
        return namespaceBinding;
    }

    public NamespaceBinding combineScopes(String prefix, NS ns, NamespaceBinding outer) {
        NamespaceBinding namespaceBinding;
        if (Maybe$.MODULE$.isEmpty$extension(ns.optURI())) {
            namespaceBinding = outer;
        } else {
            String uri = ((URI)Maybe$.MODULE$.get$extension(ns.optURI())).toString();
            NamespaceBinding inner = new NamespaceBinding(prefix, uri, (NamespaceBinding)TopScope$.MODULE$);
            namespaceBinding = this.combineScopes(inner, outer);
        }
        return namespaceBinding;
    }

    public Node collapseScopes(Node x, NamespaceBinding outer) {
        Node node;
        Node node2 = x;
        Option option = Elem$.MODULE$.unapplySeq(node2);
        if (!option.isEmpty()) {
            String pre = (String)((Tuple5)option.get())._1();
            String lab = (String)((Tuple5)option.get())._2();
            MetaData md = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scp = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq child = (Seq)((Tuple5)option.get())._5();
            NamespaceBinding newScope = this.combineScopes(scp, outer);
            node = Elem$.MODULE$.apply(pre, lab, md, newScope, true, (Seq)child.flatMap((Function1 & Serializable & scala.Serializable)ch -> MODULE$.collapseScopes((Node)ch, newScope), Seq$.MODULE$.canBuildFrom()));
        } else {
            node = x;
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    public NamespaceBinding filterScope(NamespaceBinding nsb, Seq<NS> nss) {
        void var3_8;
        TopScope$ topScope$;
        NamespaceBinding namespaceBinding = nsb;
        TopScope$ topScope$2 = TopScope$.MODULE$;
        if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$2) : topScope$2 != null)) {
            topScope$ = TopScope$.MODULE$;
        } else {
            NamespaceBinding parentCopy = this.filterScope(nsb.parent(), nss);
            if (nss.contains((Object)NS$.MODULE$.apply(nsb.uri()))) {
                topScope$ = parentCopy;
            } else {
                NamespaceBinding x$1 = parentCopy;
                String x$2 = nsb.copy$default$1();
                String x$3 = nsb.copy$default$2();
                topScope$ = nsb.copy(x$2, x$3, x$1);
            }
        }
        TopScope$ newHead = topScope$;
        return var3_8;
    }

    /*
     * WARNING - void declaration
     */
    public boolean prefixInScope(String prefix, NamespaceBinding scope) {
        void var3_4;
        boolean bl;
        if (scope == null) {
            bl = false;
        } else {
            String string = prefix;
            String string2 = scope.prefix();
            bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : this.prefixInScope(prefix, scope.parent());
        }
        boolean ret = bl;
        return (boolean)var3_4;
    }

    public Node removeComments(Node e) {
        Node node;
        Node node2 = e;
        Option option = Elem$.MODULE$.unapplySeq(node2);
        if (!option.isEmpty()) {
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attribs = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq child = (Seq)((Tuple5)option.get())._5();
            Seq newChildren = (Seq)((TraversableLike)child.filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeComments$1(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.removeComments((Node)x$7), Seq$.MODULE$.canBuildFrom());
            node = Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
        } else {
            node = node2;
        }
        return node;
    }

    public Node removeAttributes(Node n, Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        Node res1 = (Node)this.removeAttributes1(n, ns, parentScope);
        Node res2 = this.removeMixedWhitespace(res1);
        Node res = res2.apply(0);
        return res;
    }

    public Seq<NS> removeAttributes$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public Option<NamespaceBinding> removeAttributes$default$3() {
        return None$.MODULE$;
    }

    private Node removeMixedWhitespace(Node ns2) {
        Elem elem;
        Seq noMixedChildren;
        if (!(ns2 instanceof Elem)) {
            return ns2;
        }
        Elem e = (Elem)ns2;
        Seq children = e.child();
        Seq seq = noMixedChildren = children.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$1(x$8))) ? (Seq)((TraversableLike)children.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$2(e, x0$1)))).map((Function1 & Serializable & scala.Serializable)ns -> MODULE$.removeMixedWhitespace((Node)ns), Seq$.MODULE$.canBuildFrom()) : (Seq)children.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$4(x0$2)));
        if (noMixedChildren == children) {
            elem = e;
        } else {
            Seq x$1 = noMixedChildren;
            String x$2 = e.copy$default$1();
            String x$3 = e.copy$default$2();
            MetaData x$4 = e.copy$default$3();
            NamespaceBinding x$5 = e.copy$default$4();
            boolean x$6 = e.copy$default$5();
            elem = e.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        }
        Elem res = elem;
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private Node convertPCDataToText(Node n) {
        void var3_13;
        Text text;
        Node node = n;
        if (node instanceof Text) {
            Text text2;
            text = text2 = (Text)node;
        } else if (node instanceof Atom) {
            Atom atom = (Atom)node;
            text = Text$.MODULE$.apply(atom.text());
        } else {
            Option option = Elem$.MODULE$.unapplySeq(node);
            if (!option.isEmpty()) {
                String prefix = (String)((Tuple5)option.get())._1();
                String label = (String)((Tuple5)option.get())._2();
                MetaData attributes = (MetaData)((Tuple5)option.get())._3();
                NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
                Seq children = (Seq)((Tuple5)option.get())._5();
                Seq newChildren = (Seq)children.map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.convertPCDataToText((Node)x$9), Seq$.MODULE$.canBuildFrom());
                text = Elem$.MODULE$.apply(prefix, label, attributes, scope, true, newChildren);
            } else {
                text = n;
            }
        }
        Text res = text;
        return var3_13;
    }

    private NodeSeq removeAttributes1(Node n, Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        Object object;
        Node node = n;
        Option option = Elem$.MODULE$.unapplySeq(node);
        if (!option.isEmpty()) {
            TopScope$ topScope$;
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attributes = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq children = (Seq)((Tuple5)option.get())._5();
            TopScope$ filteredScope = ns.length() > 0 ? this.filterScope(scope, ns) : TopScope$.MODULE$;
            Option<NamespaceBinding> option2 = parentScope;
            if (option2 instanceof Some) {
                NamespaceBinding ps;
                Some some = (Some)option2;
                NamespaceBinding namespaceBinding = ps = (NamespaceBinding)some.value();
                TopScope$ topScope$2 = filteredScope;
                topScope$ = !(namespaceBinding != null ? !namespaceBinding.equals(topScope$2) : topScope$2 != null) ? ps : filteredScope;
            } else if (None$.MODULE$.equals(option2)) {
                topScope$ = filteredScope;
            } else {
                throw new MatchError(option2);
            }
            TopScope$ newScope = topScope$;
            NodeSeq newChildren = NodeSeq$.MODULE$.seqToNodeSeq((Seq)children.flatMap(arg_0 -> XMLUtils$.$anonfun$removeAttributes1$1(ns, (NamespaceBinding)newScope, arg_0), Seq$.MODULE$.canBuildFrom()));
            Seq<Node> textMergedChildren = this.coalesceAdjacentTextNodes((Seq<Node>)newChildren);
            String newPrefix = this.prefixInScope(prefix, (NamespaceBinding)newScope) ? prefix : null;
            MetaData newAttributes = attributes.filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeAttributes1$2(node, m)));
            object = Elem$.MODULE$.apply(newPrefix, label, newAttributes, (NamespaceBinding)newScope, true, textMergedChildren);
        } else {
            object = node instanceof Comment ? NodeSeq$.MODULE$.Empty() : node;
        }
        NodeSeq res = object;
        return res;
    }

    public Node normalize(Node n) {
        Node noComments = this.removeComments(n);
        Node noPCData = this.convertPCDataToText(noComments);
        Node combinedText = this.coalesceAllAdjacentTextNodes(noPCData);
        Node noMixedWS = this.removeMixedWhitespace(combinedText);
        return noMixedWS;
    }

    public void compareAndReport(Node expected, Node actual, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces) {
        Node actualMinimized;
        Node expectedMinimized = this.normalize(expected);
        Seq<Tuple3<String, String, String>> diffs = this.computeDiff(expectedMinimized, actualMinimized = this.normalize(actual), ignoreProcInstr, checkPrefixes, checkNamespaces);
        if (diffs.length() > 0) {
            throw new XMLUtils.XMLDifferenceException(new StringOps(Predef$.MODULE$.augmentString("\nComparison failed.\nExpected (attributes %s)\n          %s\nActual (attributes %s for diff)\n          %s\nDifferences were (path, expected, actual):\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkPrefixes || checkNamespaces ? "compared for diff" : "stripped", checkPrefixes || checkNamespaces ? expected : this.removeAttributes(expected, this.removeAttributes$default$2(), this.removeAttributes$default$3()).toString(), checkPrefixes || checkNamespaces ? "compared" : "ignored", actual, ((TraversableOnce)diffs.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), Seq$.MODULE$.canBuildFrom())).mkString("- ", "\n- ", "\n")})));
        }
    }

    public boolean compareAndReport$default$3() {
        return true;
    }

    public boolean compareAndReport$default$4() {
        return false;
    }

    public boolean compareAndReport$default$5() {
        return false;
    }

    public Seq<Tuple3<String, String, String>> computeDiff(Node a, Node b, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces) {
        return this.computeDiffOne(a, b, (NamespaceBinding)TopScope$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, (Option<Object>)None$.MODULE$, (Seq<String>)Nil$.MODULE$, ignoreProcInstr, checkPrefixes, checkNamespaces, (Option<String>)None$.MODULE$);
    }

    public boolean computeDiff$default$3() {
        return true;
    }

    public boolean computeDiff$default$4() {
        return false;
    }

    public boolean computeDiff$default$5() {
        return false;
    }

    public scala.collection.immutable.Map<String, Object> childArrayCounters(Elem e) {
        Seq children;
        Elem elem = e;
        Option option = Elem$.MODULE$.unapplySeq((Node)elem);
        if (option.isEmpty()) {
            throw new MatchError((Object)elem);
        }
        Seq seq = children = (Seq)((Tuple5)option.get())._5();
        Seq children2 = seq;
        Seq labels = (Seq)children2.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.label(), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map groups = labels.groupBy((Function1 & Serializable & scala.Serializable)x -> x);
        scala.collection.immutable.Map counts = (scala.collection.immutable.Map)groups.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String label = (String)tuple2._1();
            Seq labelList = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)label, (Object)BoxesRunTime.boxToInteger((int)labelList.length()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map arrayCounts = (scala.collection.immutable.Map)counts.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$childArrayCounters$4(x0$2)));
        scala.collection.immutable.Map arrayCounters = (scala.collection.immutable.Map)arrayCounts.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String label = (String)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)label, (Object)BoxesRunTime.boxToLong((long)1));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return arrayCounters;
    }

    /*
     * Unable to fully structure code
     */
    public Seq<Tuple3<String, String, String>> computeDiffOne(Node an, Node bn, NamespaceBinding aParentScope, NamespaceBinding bParentScope, Option<Object> maybeIndex, Seq<String> parentPathSteps, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces, Option<String> maybeType) {
        block19: {
            block20: {
                block15: {
                    block17: {
                        block18: {
                            block16: {
                                zPath$lzy = new LazyRef();
                                var18_12 = new Tuple2((Object)an, (Object)bn);
                                if (var18_12 == null) break block15;
                                a = (Node)var18_12._1();
                                b = (Node)var18_12._2();
                                if (!(a instanceof Elem)) break block15;
                                var21_15 = (Elem)a;
                                if (!(b instanceof Elem)) break block15;
                                var22_16 = (Elem)b;
                                var24_17 = var21_15;
                                var25_18 = Elem$.MODULE$.unapplySeq((Node)var24_17);
                                if (var25_18.isEmpty()) {
                                    throw new MatchError((Object)var24_17);
                                }
                                prefixA = (String)((Tuple5)var25_18.get())._1();
                                labelA = (String)((Tuple5)var25_18.get())._2();
                                attribsA = (MetaData)((Tuple5)var25_18.get())._3();
                                nsbA = (NamespaceBinding)((Tuple5)var25_18.get())._4();
                                childrenA = (Seq)((Tuple5)var25_18.get())._5();
                                var16_24 = new Tuple5((Object)prefixA, (Object)labelA, (Object)attribsA, (Object)nsbA, (Object)childrenA);
                                var23_25 = var16_24;
                                prefixA = (String)var23_25._1();
                                labelA = (String)var23_25._2();
                                attribsA = (MetaData)var23_25._3();
                                nsbA = (NamespaceBinding)var23_25._4();
                                childrenA = (Seq)var23_25._5();
                                var37_31 = var22_16;
                                var38_32 = Elem$.MODULE$.unapplySeq((Node)var37_31);
                                if (var38_32.isEmpty()) {
                                    throw new MatchError((Object)var37_31);
                                }
                                prefixB = (String)((Tuple5)var38_32.get())._1();
                                labelB = (String)((Tuple5)var38_32.get())._2();
                                attribsB = (MetaData)((Tuple5)var38_32.get())._3();
                                nsbB = (NamespaceBinding)((Tuple5)var38_32.get())._4();
                                childrenB = (Seq)((Tuple5)var38_32.get())._5();
                                var15_38 = new Tuple5((Object)prefixB, (Object)labelB, (Object)attribsB, (Object)nsbB, (Object)childrenB);
                                var36_39 = var15_38;
                                prefixB = (String)var36_39._1();
                                labelB = (String)var36_39._2();
                                attribsB = (MetaData)var36_39._3();
                                nsbB = (NamespaceBinding)var36_39._4();
                                childrenB = (Seq)var36_39._5();
                                typeA = var21_15.attribute(this.XSI_NAMESPACE().toString(), "type").map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$1(scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)());
                                typeB = var22_16.attribute(this.XSI_NAMESPACE().toString(), "type").map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$2(scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)());
                                maybeType = Option$.MODULE$.apply(typeA.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$computeDiffOne$3(scala.Option ), ()Ljava/lang/String;)((Option)typeB)));
                                nilledA = var21_15.attribute(this.XSI_NAMESPACE().toString(), "nil");
                                nilledB = var22_16.attribute(this.XSI_NAMESPACE().toString(), "nil");
                                mappingsA = checkNamespaces != false ? nsbA.buildString(aParentScope).trim() : "";
                                mappingsB = checkNamespaces != false ? nsbB.buildString(bParentScope).trim() : "";
                                v0 = labelA;
                                var56_52 = labelB;
                                if (!(v0 == null ? var56_52 != null : v0.equals(var56_52) == false)) break block16;
                                v1 = new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)labelA, (Object)labelB), (List)Nil$.MODULE$);
                                break block17;
                            }
                            if (!checkPrefixes) break block18;
                            v2 = prefixA;
                            var57_53 = prefixB;
                            if (!(v2 == null ? var57_53 != null : v2.equals(var57_53) == false)) break block18;
                            v1 = new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(8).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA).append("@prefix").toString(), (Object)prefixA, (Object)prefixB), (List)Nil$.MODULE$);
                            break block17;
                        }
                        if (!checkNamespaces) ** GOTO lbl-1000
                        v3 = mappingsA;
                        var58_54 = mappingsB;
                        if (v3 == null ? var58_54 != null : v3.equals(var58_54) == false) {
                            v1 = new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(7).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA).append("@xmlns").toString(), (Object)mappingsA, (Object)mappingsB), (List)Nil$.MODULE$);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = nilledA;
                            var59_55 = nilledB;
                            if (v4 == null ? var59_55 != null : v4.equals(var59_55) == false) {
                                v1 = new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(9).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA).append("@xsi:nil").toString(), nilledA.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$5(scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)()).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$computeDiffOne$6(), ()Ljava/lang/String;)()), nilledB.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$7(scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)()).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$computeDiffOne$8(), ()Ljava/lang/String;)())), (List)Nil$.MODULE$);
                            } else {
                                v5 = typeA;
                                var60_56 = typeB;
                                if ((v5 == null ? var60_56 != null : v5.equals(var60_56) == false) && typeA.isDefined() && typeB.isDefined()) {
                                    v1 = new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(10).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA).append("@xsi:type").toString(), typeA.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$9(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$computeDiffOne$10(), ()Ljava/lang/String;)()), typeA.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$11(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$computeDiffOne$12(), ()Ljava/lang/String;)())), (List)Nil$.MODULE$);
                                } else {
                                    var63_58 = pathLabel = new java.lang.StringBuilder(0).append(labelA).append(maybeIndex.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$13$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)()).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$computeDiffOne$14(), ()Ljava/lang/String;)())).toString();
                                    thisPathStep = (Seq)parentPathSteps.$plus$colon((Object)var63_58, Seq$.MODULE$.canBuildFrom());
                                    if (ignoreProcInstr) {
                                        ca = (Seq)childrenA.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$15$adapted(scala.xml.Node ), (Lscala/xml/Node;)Ljava/lang/Object;)());
                                        cb = (Seq)childrenB.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$16$adapted(scala.xml.Node ), (Lscala/xml/Node;)Ljava/lang/Object;)());
                                        v6 = new Tuple2((Object)ca, (Object)cb);
                                    } else {
                                        v6 = var65_62 = new Tuple2((Object)childrenA, (Object)childrenB);
                                    }
                                    if (var65_62 == null) {
                                        throw new MatchError((Object)var65_62);
                                    }
                                    childrenACompare = (Seq)var65_62._1();
                                    childrenBCompare = (Seq)var65_62._2();
                                    var14_65 = new Tuple2((Object)childrenACompare, (Object)childrenBCompare);
                                    var64_66 = var14_65;
                                    childrenACompare = (Seq)var64_66._1();
                                    childrenBCompare = (Seq)var64_66._2();
                                    repeatingChildrenLabels = ((MapLike)childrenA.groupBy((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$17(scala.xml.Node ), (Lscala/xml/Node;)Ljava/lang/String;)()).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$18$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)())).keys();
                                    labelsWithZeroCount = (Iterable)repeatingChildrenLabels.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$19(java.lang.String ), (Ljava/lang/String;)Lscala/Tuple2;)(), Iterable$.MODULE$.canBuildFrom());
                                    countMap = (Map)Map$.MODULE$.apply(labelsWithZeroCount.toSeq());
                                    childrenDiffs = (Seq)((TraversableLike)childrenACompare.zip((GenIterable)childrenBCompare, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeDiffOne$20(scala.collection.mutable.Map scala.xml.NamespaceBinding scala.xml.NamespaceBinding scala.collection.Seq boolean boolean boolean scala.Option scala.Tuple2 ), (Lscala/Tuple2;)Lscala/collection/Seq;)((Map)countMap, (NamespaceBinding)nsbA, (NamespaceBinding)nsbB, (Seq)thisPathStep, (boolean)ignoreProcInstr, (boolean)checkPrefixes, (boolean)checkNamespaces, (Option)maybeType), Seq$.MODULE$.canBuildFrom());
                                    childrenLengthDiff = childrenA.length() != childrenB.length() ? new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(15).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA).append("::child@count)").toString(), (Object)Integer.toString(childrenA.length()), (Object)Integer.toString(childrenB.length())), (List)Nil$.MODULE$) : Nil$.MODULE$;
                                    v1 = (Seq)childrenDiffs.$plus$plus((GenTraversableOnce)childrenLengthDiff, Seq$.MODULE$.canBuildFrom());
                                }
                            }
                        }
                    }
                    var11_74 = v1;
                    break block19;
                }
                if (var18_12 == null) break block20;
                tA = (Node)var18_12._1();
                tB = (Node)var18_12._2();
                if (!(tA instanceof Text)) break block20;
                var79_77 = (Text)tA;
                if (!(tB instanceof Text)) break block20;
                var80_78 = (Text)tB;
                var11_74 = thisDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), var79_77, var80_78, maybeType);
                break block19;
            }
            if (var18_12 == null) ** GOTO lbl-1000
            pA = (Node)var18_12._1();
            pB = (Node)var18_12._2();
            if (!(pA instanceof ProcInstr)) ** GOTO lbl-1000
            var84_82 = (ProcInstr)pA;
            if (pB instanceof ProcInstr) {
                var85_83 = (ProcInstr)pB;
                var87_84 = var84_82;
                if (var87_84 == null) {
                    throw new MatchError((Object)var87_84);
                }
                tA1label = var87_84.target();
                tA1content = var87_84.proctext();
                var13_87 = new Tuple2((Object)tA1label, (Object)tA1content);
                var86_88 = var13_87;
                tA1label = (String)var86_88._1();
                tA1content = (String)var86_88._2();
                var93_91 = var85_83;
                if (var93_91 == null) {
                    throw new MatchError((Object)var93_91);
                }
                tB1label = var93_91.target();
                tB1content = var93_91.proctext();
                var12_94 = new Tuple2((Object)tB1label, (Object)tB1content);
                var92_95 = var12_94;
                tB1label = (String)var92_95._1();
                tB1content = (String)var92_95._2();
                labelDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), tA1label, tB1label, (Option<String>)None$.MODULE$);
                contentDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), tA1content, tB1content, maybeType);
                var11_74 = (Seq)labelDiff.$plus$plus(contentDiff, Seq$.MODULE$.canBuildFrom());
            } else lbl-1000:
            // 3 sources

            {
                var11_74 = new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)an.toString(), (Object)bn.toString()), (List)Nil$.MODULE$);
            }
        }
        return var11_74;
    }

    public Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, Text tA, Text tB, Option<String> maybeType) {
        String dataA = tA.toString();
        String dataB = tB.toString();
        return this.computeTextDiff(zPath, dataA, dataB, maybeType);
    }

    public Seq<Tuple3<String, String, String>> computeBlobDiff(String zPath, String dataA, String dataB) {
        Seq seq;
        Option<URI> uriA = Misc$.MODULE$.searchResourceOption(dataA, (Option<URI>)None$.MODULE$);
        Option<URI> uriB = Misc$.MODULE$.searchResourceOption(dataB, (Option<URI>)None$.MODULE$);
        Option pathA = uriA.map((Function1 & Serializable & scala.Serializable)u -> Paths.get(u));
        Option pathB = uriB.map((Function1 & Serializable & scala.Serializable)u -> Paths.get(u));
        boolean canReadA = BoxesRunTime.unboxToBoolean((Object)pathA.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$3(p))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        boolean canReadB = BoxesRunTime.unboxToBoolean((Object)pathB.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$5(p))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        if (!canReadA || !canReadB) {
            String path = new java.lang.StringBuilder(8).append(zPath).append(".canRead").toString();
            seq = (Seq)new .colon.colon((Object)new Tuple3((Object)path, (Object)Boolean.toString(canReadA), (Object)Boolean.toString(canReadB)), (List)Nil$.MODULE$);
        } else {
            int CHUNK_SIZE = 1024;
            byte[] arrayA = new byte[CHUNK_SIZE];
            byte[] arrayB = new byte[CHUNK_SIZE];
            InputStream streamA = Files.newInputStream((Path)pathA.get(), StandardOpenOption.READ);
            InputStream streamB = Files.newInputStream((Path)pathB.get(), StandardOpenOption.READ);
            int lenA = 0;
            int lenB = 0;
            int numSameBytes = 0;
            boolean areSame = true;
            while ((areSame = (lenA = streamA.read(arrayA)) == (lenB = streamB.read(arrayB)) && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayA)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(arrayB))) && lenA != -1 && lenB != -1) {
                numSameBytes += lenA;
            }
            if (!areSame) {
                Tuple2[] zip = (Tuple2[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayA)).zip((GenIterable)Predef$.MODULE$.wrapByteArray(arrayB), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                int firstDiffIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])zip)).indexWhere((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$7(z)));
                int MAX_CONTEXT = 40;
                byte[] contextA = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayA)).take(lenA))).drop(firstDiffIndex))).take(MAX_CONTEXT);
                byte[] contextB = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayB)).take(lenB))).drop(firstDiffIndex))).take(MAX_CONTEXT);
                String hexA = Misc$.MODULE$.bytes2Hex(contextA);
                String hexB = Misc$.MODULE$.bytes2Hex(contextB);
                int absoluteIndex = numSameBytes + firstDiffIndex;
                String path = new java.lang.StringBuilder(10).append(zPath).append(".bytesAt(").append(absoluteIndex + 1).append(")").toString();
                seq = (Seq)new .colon.colon((Object)new Tuple3((Object)path, (Object)hexA, (Object)hexB), (List)Nil$.MODULE$);
            } else {
                seq = Nil$.MODULE$;
            }
        }
        return seq;
    }

    /*
     * Unable to fully structure code
     */
    public Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, String dataA, String dataB, Option<String> maybeType) {
        if (!maybeType.isDefined()) ** GOTO lbl-1000
        v0 = maybeType.get();
        var6_5 = "xs:anyURI";
        if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        hasBlobType = v1;
        dataLooksLikeBlobURI = ((IterableLike)new .colon.colon((Object)dataA, (List)new .colon.colon((Object)dataB, (List)Nil$.MODULE$))).forall((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeTextDiff$1$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)());
        if (hasBlobType || dataLooksLikeBlobURI) {
            v2 = this.computeBlobDiff(zPath, dataA, dataB);
        } else if (this.textIsSame(dataA, dataB, maybeType)) {
            v2 = Nil$.MODULE$;
        } else {
            CHARS_TO_SHOW_AFTER_DIFF = 40;
            lenA = dataA.length();
            lenB = dataB.length();
            for (index = 0; index < lenA && index < lenB && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataA), index) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataB), index); ++index) {
            }
            contextA = Misc$.MODULE$.remapControlsAndLineEndingsToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataA), index, index + CHARS_TO_SHOW_AFTER_DIFF));
            contextB = Misc$.MODULE$.remapControlsAndLineEndingsToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataB), index, index + CHARS_TO_SHOW_AFTER_DIFF));
            path = new java.lang.StringBuilder(9).append(zPath).append(".charAt(").append(index + 1).append(")").toString();
            v2 = (Seq)new .colon.colon((Object)new Tuple3((Object)path, (Object)contextA, (Object)contextB), (List)Nil$.MODULE$);
        }
        return v2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean textIsSame(String dataA, String dataB, Option<String> maybeType) {
        String string;
        String string2;
        String string3;
        boolean bl = false;
        Some some = null;
        Option<String> option = maybeType;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string4 = (String)some.value();
            if ("xs:hexBinary".equals(string4)) {
                return dataA.equalsIgnoreCase(dataB);
            }
        }
        if (bl && "xs:date".equals(string3 = (String)some.value())) {
            DFDLDate a = DFDLDateConversion$.MODULE$.fromXMLString(dataA);
            DFDLDate b = DFDLDateConversion$.MODULE$.fromXMLString(dataB);
            DFDLDate dFDLDate = a;
            DFDLDate dFDLDate2 = b;
            if (dFDLDate != null) {
                if (!((Object)dFDLDate).equals(dFDLDate2)) return false;
                return true;
            }
            if (dFDLDate2 == null) return true;
            return false;
        }
        if (bl && "xs:time".equals(string2 = (String)some.value())) {
            DFDLTime a = DFDLTimeConversion$.MODULE$.fromXMLString(dataA);
            DFDLTime b = DFDLTimeConversion$.MODULE$.fromXMLString(dataB);
            DFDLTime dFDLTime = a;
            DFDLTime dFDLTime2 = b;
            if (dFDLTime != null) {
                if (!((Object)dFDLTime).equals(dFDLTime2)) return false;
                return true;
            }
            if (dFDLTime2 == null) return true;
            return false;
        }
        if (bl && "xs:dateTime".equals(string = (String)some.value())) {
            DFDLDateTime a = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataA);
            DFDLDateTime b = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataB);
            DFDLDateTime dFDLDateTime = a;
            DFDLDateTime dFDLDateTime2 = b;
            if (dFDLDateTime != null) {
                if (!((Object)dFDLDateTime).equals(dFDLDateTime2)) return false;
                return true;
            }
            if (dFDLDateTime2 == null) return true;
            return false;
        }
        String string5 = dataA;
        String string6 = dataB;
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    public File convertNodeToTempFile(Node xml, File tmpDir, String nameHint) {
        String prefix = this.prefixFromHint(nameHint);
        File tmpSchemaFile = File.createTempFile(prefix, ".dfdl.xsd", tmpDir);
        tmpSchemaFile.deleteOnExit();
        PrettyPrinter pp = new PrettyPrinter(2);
        String xmlString = pp.format(xml);
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        fw.write(xmlString);
        fw.close();
        return tmpSchemaFile;
    }

    public String convertNodeToTempFile$default$3() {
        return "daffodil_tmp_";
    }

    private String prefixFromHint(String nameHint) {
        String string;
        int n = nameHint.length();
        switch (n) {
            case 0: {
                string = "daffodil_tmp_";
                break;
            }
            case 1: {
                string = new java.lang.StringBuilder(2).append(nameHint).append("__").toString();
                break;
            }
            case 2: {
                string = new java.lang.StringBuilder(1).append(nameHint).append("_").toString();
                break;
            }
            default: {
                string = nameHint;
                break;
            }
        }
        return string;
    }

    public File convertInputStreamToTempFile(InputStream is, File tmpDir, String nameHint, String suffix) {
        String prefix = this.prefixFromHint(nameHint);
        File tmpSchemaFile = File.createTempFile(prefix, suffix, tmpDir);
        tmpSchemaFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        IOUtils.copy((InputStream)is, (OutputStream)fos);
        fos.close();
        return tmpSchemaFile;
    }

    public StringBuilder escape(String str, StringBuilder sb) {
        int i = 0;
        while (i < str.length()) {
            char x = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), i);
            char c = BoxesRunTime.unboxToChar((Object)this.escapeMapper().apply((Object)BoxesRunTime.boxToCharacter((char)x)));
            ++i;
            char c2 = c;
            switch (c2) {
                case '\'': {
                    StringBuilder stringBuilder = sb.append("&#x27;");
                    break;
                }
                case '\"': {
                    StringBuilder stringBuilder = sb.append("&quot;");
                    break;
                }
                case '&': {
                    StringBuilder stringBuilder = sb.append("&amp;");
                    break;
                }
                case '<': {
                    StringBuilder stringBuilder = sb.append("&lt;");
                    break;
                }
                case '>': {
                    StringBuilder stringBuilder = sb.append("&gt;");
                    break;
                }
                default: {
                    StringBuilder stringBuilder;
                    if (RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                        stringBuilder = sb.append(c);
                        break;
                    }
                    if (RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c)) || RichChar$.MODULE$.isControl$extension(Predef$.MODULE$.charWrapper(c))) {
                        stringBuilder = this.toNumericCharacterEntity(c, sb);
                        break;
                    }
                    if (c == '\u00a0') {
                        stringBuilder = this.toNumericCharacterEntity(c, sb);
                        break;
                    }
                    if (c < '\u00ff') {
                        stringBuilder = sb.append(c);
                        break;
                    }
                    stringBuilder = this.toNumericCharacterEntity(c, sb);
                    break;
                }
            }
        }
        return sb;
    }

    public StringBuilder escape$default$2() {
        return new StringBuilder();
    }

    private Function1<Object, Object> escapeMapper() {
        return this.escapeMapper;
    }

    public StringBuilder toNumericCharacterEntity(char c, StringBuilder sb) {
        char i = c;
        if (i <= '\u0000') {
            throw Assert$.MODULE$.abort("Usage error: i.>(0)");
        }
        String s = Integer.toHexString(i).toUpperCase();
        sb.append("&#x");
        sb.append(s);
        return sb.append(";");
    }

    private Regex xmlEntityPattern() {
        return this.xmlEntityPattern;
    }

    /*
     * WARNING - void declaration
     */
    public String unescape(String raw) {
        void var2_3;
        void var3_2;
        String res = this.xmlEntityPattern().replaceAllIn((CharSequence)raw, (Function1 & Serializable & scala.Serializable)m -> {
            StringBuilder sb = Utility$.MODULE$.unescape(m.group("entity"), new StringBuilder());
            if (sb == null) {
                throw Assert$.MODULE$.abort("Invariant broken: sb.ne(null)");
            }
            return sb.toString();
        });
        void withoutNamedXMLCharEntities = var3_2;
        return var2_3;
    }

    public Object maybeURI(NamespaceBinding nsb, String prefix) {
        Object object;
        while (true) {
            if (nsb == null) {
                object = Maybe$.MODULE$.Nope();
                break;
            }
            String string = nsb.prefix();
            String string2 = prefix;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = Maybe$One$.MODULE$.apply(nsb.uri());
                break;
            }
            nsb = nsb.parent();
        }
        return object;
    }

    public Object maybePrefix(NamespaceBinding nsb, String uri) {
        Object object;
        while (true) {
            if (nsb == null) {
                object = Maybe$.MODULE$.Nope();
                break;
            }
            String string = nsb.uri();
            String string2 = uri;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (nsb.prefix() == null) {
                    object = Maybe$.MODULE$.Nope();
                    break;
                }
                object = Maybe$One$.MODULE$.apply(nsb.prefix());
                break;
            }
            nsb = nsb.parent();
        }
        return object;
    }

    private final char remapOneChar$1(char previous, char current, char next, Function1 remapFunc$1) {
        if (this.isLeadingSurrogate(current) && this.isTrailingSurrogate(next)) {
            return current;
        }
        if (this.isTrailingSurrogate(current) && this.isLeadingSurrogate(previous)) {
            return current;
        }
        return BoxesRunTime.unboxToChar((Object)remapFunc$1.apply((Object)BoxesRunTime.boxToCharacter((char)current)));
    }

    private static final void processText$1(ObjectRef tn$1, ObjectRef sb$1, ArrayBuilder ab$1) {
        if ((Node)tn$1.elem == null) {
            if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() > 0) {
                ab$1.$plus$eq((Object)new Text(((StringBuilder)sb$1.elem).toString()));
                ((StringBuilder)sb$1.elem).clear();
            }
        } else {
            if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() != 0) {
                throw Assert$.MODULE$.abort("Invariant broken: sb.==(null).||(sb.length.==(0))");
            }
            ab$1.$plus$eq((Object)((Node)tn$1.elem));
            tn$1.elem = null;
        }
    }

    public static final /* synthetic */ boolean $anonfun$dfdlAttributes$1(Node n$1, MetaData x$2) {
        String string = x$2.getNamespace(n$1);
        String string2 = MODULE$.DFDL_NAMESPACE().toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$dfdlxAttributes$1(Node n$2, MetaData x$3) {
        String string = x$3.getNamespace(n$2);
        String string2 = MODULE$.DFDLX_NAMESPACE().toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$dafAttributes$1(Node n$3, MetaData a) {
        String string = a.getNamespace(n$3);
        String string2 = MODULE$.EXT_NS_NCSA().toString();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = a.getNamespace(n$3);
        String string4 = MODULE$.EXT_NS_APACHE().toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$removeComments$1(Node x$6) {
        return x$6 instanceof Comment;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$1(Node x$8) {
        return x$8 instanceof Elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$2(Elem e$1, Node x0$1) {
        boolean bl;
        String data;
        Node node = x0$1;
        Option option = Text$.MODULE$.unapply((Object)node);
        if (!option.isEmpty() && (data = (String)option.get()).matches("\\s*")) {
            bl = false;
        } else {
            Option option2 = Text$.MODULE$.unapply((Object)node);
            if (!option2.isEmpty()) {
                String data2 = (String)option2.get();
                throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Element %s contains mixed data: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e$1.label(), data2})));
            }
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$4(Node x0$2) {
        String string;
        Node node = x0$2;
        Option option = Text$.MODULE$.unapply((Object)node);
        boolean bl = option.isEmpty() || !"".equals(string = (String)option.get());
        return bl;
    }

    public static final /* synthetic */ NodeSeq $anonfun$removeAttributes1$1(Seq ns$1, NamespaceBinding newScope$2, Node x$10) {
        return MODULE$.removeAttributes1(x$10, (Seq<NS>)ns$1, (Option<NamespaceBinding>)new Some((Object)newScope$2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$removeAttributes1$2(Node x1$1, MetaData m) {
        String string;
        Some some;
        String pre;
        Some some2;
        Some some3;
        boolean bl = false;
        PrefixedAttribute prefixedAttribute = null;
        MetaData metaData = m;
        if (metaData instanceof PrefixedAttribute) {
            bl = true;
            prefixedAttribute = (PrefixedAttribute)metaData;
            Some some4 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute);
            if (!some4.isEmpty()) {
                String string2;
                Option option;
                String string3 = (String)((Tuple4)some4.get())._2();
                Seq seq = (Seq)((Tuple4)some4.get())._3();
                if ("nil".equals(string3) && !(option = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string2 = (String)option.get())) {
                    NS nS = NS$.MODULE$.apply(prefixedAttribute.getNamespace(x1$1));
                    NS nS2 = MODULE$.XSI_NAMESPACE();
                    if (nS == null) {
                        if (nS2 == null) return true;
                    } else if (((Object)nS).equals(nS2)) {
                        return true;
                    }
                }
            }
        }
        if (bl && !(some3 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty()) {
            String string4;
            Option option;
            String string5 = (String)((Tuple4)some3.get())._1();
            String string6 = (String)((Tuple4)some3.get())._2();
            Seq seq = (Seq)((Tuple4)some3.get())._3();
            if ("xsi".equals(string5) && "nil".equals(string6) && !(option = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string4 = (String)option.get()) && prefixedAttribute.getNamespace(x1$1) == null) {
                return true;
            }
        }
        if (bl && !(some2 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty() && (pre = (String)((Tuple4)some2.get())._1()) != null) {
            String string7 = prefixedAttribute.getNamespace(x1$1);
            String string8 = MODULE$.DAFFODIL_INTERNAL_NAMESPACE().toString();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                String string9 = pre;
                String string10 = "";
                if (string9 != null) {
                    if (!string9.equals(string10)) return false;
                    throw Assert$.MODULE$.abort("Invariant broken: pre.!=(\"\")");
                }
                if (string10 == null) throw Assert$.MODULE$.abort("Invariant broken: pre.!=(\"\")");
                return false;
            }
        }
        if (bl && !(some = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty() && "type".equals(string = (String)((Tuple4)some.get())._2())) {
            NS nS = NS$.MODULE$.apply(prefixedAttribute.getNamespace(x1$1));
            NS nS3 = MODULE$.XSI_NAMESPACE();
            if (nS == null) {
                if (nS3 == null) return true;
            } else if (((Object)nS).equals(nS3)) {
                return true;
            }
        }
        if (!bl) return true;
        Some some5 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute);
        if (some5.isEmpty()) return true;
        String string11 = (String)((Tuple4)some5.get())._1();
        String string12 = (String)((Tuple4)some5.get())._2();
        if (!"xsi".equals(string11)) return true;
        if (!"type".equals(string12)) return true;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$childArrayCounters$4(Tuple2 x0$2) {
        int n;
        Tuple2 tuple2 = x0$2;
        boolean bl = tuple2 == null || 1 != (n = tuple2._2$mcI$sp());
        return bl;
    }

    private static final /* synthetic */ String zPath$lzycompute$1(LazyRef zPath$lzy$1, Seq parentPathSteps$1) {
        String string;
        LazyRef lazyRef = zPath$lzy$1;
        synchronized (lazyRef) {
            string = zPath$lzy$1.initialized() ? (String)zPath$lzy$1.value() : (String)zPath$lzy$1.initialize((Object)((TraversableOnce)parentPathSteps$1.reverse()).mkString("/"));
        }
        return string;
    }

    private static final String zPath$1(LazyRef zPath$lzy$1, Seq parentPathSteps$1) {
        return zPath$lzy$1.initialized() ? (String)zPath$lzy$1.value() : XMLUtils$.zPath$lzycompute$1(zPath$lzy$1, parentPathSteps$1);
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$1(Seq x$15) {
        return ((Node)x$15.head()).text();
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$2(Seq x$16) {
        return ((Node)x$16.head()).text();
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$3(Option typeB$1) {
        return (String)typeB$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$5(Seq x$17) {
        return x$17.toString();
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$6() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$7(Seq x$18) {
        return x$18.toString();
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$8() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$9(String x$19) {
        return x$19.toString();
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$10() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$11(String x$20) {
        return x$20.toString();
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$12() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$13(int x$21) {
        return new java.lang.StringBuilder(2).append("[").append(x$21).append("]").toString();
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$14() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$15(Node x$23) {
        return x$23 instanceof ProcInstr;
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$16(Node x$24) {
        return x$24 instanceof ProcInstr;
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$17(Node x$26) {
        return x$26.label();
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$18(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq v = (Seq)tuple2._2();
        boolean bl = v.length() > 1;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$computeDiffOne$19(String x$27) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$27), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ Seq $anonfun$computeDiffOne$20(Map countMap$1, NamespaceBinding nsbA$1, NamespaceBinding nsbB$1, Seq thisPathStep$1, boolean ignoreProcInstr$1, boolean checkPrefixes$1, boolean checkNamespaces$1, Option maybeType$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Node ca = (Node)tuple2._1();
        Node cb = (Node)tuple2._2();
        Option maybeChildCount = countMap$1.get((Object)ca.label());
        Option maybeChildIndex = maybeChildCount.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)count -> {
            String string = ca.label();
            countMap$1.update((Object)string, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)countMap$1.apply((Object)string)) + 1)));
            return count + 1;
        });
        Seq<Tuple3<String, String, String>> seq = MODULE$.computeDiffOne(ca, cb, nsbA$1, nsbB$1, (Option<Object>)maybeChildIndex, (Seq<String>)thisPathStep$1, ignoreProcInstr$1, checkPrefixes$1, checkNamespaces$1, (Option<String>)maybeType$1);
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$3(Path p) {
        return Files.isReadable(p);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$5(Path p) {
        return Files.isReadable(p);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$7(Tuple2 z) {
        return BoxesRunTime.unboxToByte((Object)z._1()) != BoxesRunTime.unboxToByte((Object)z._2());
    }

    private XMLUtils$() {
        MODULE$ = this;
        this.xmlNilAttribute = new PrefixedAttribute("xsi", "nil", "true", (MetaData)Null$.MODULE$);
        this.PositiveInfinityString = "INF";
        this.NegativeInfinityString = "-INF";
        this.NaNString = "NaN";
        this.XSD_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema");
        this.XSI_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema-instance");
        this.XPATH_FUNCTION_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions");
        this.XPATH_MATH_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions/math");
        this.DFDL_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/");
        this.DFDLX_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/extensions");
        this.TDML_NAMESPACE = NS$.MODULE$.apply("http://www.ibm.com/xmlns/dfdl/testData");
        this.EXAMPLE_NAMESPACE = NS$.MODULE$.apply("http://example.com");
        this.XHTML_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/1999/xhtml");
        this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA = "urn:ogf:dfdl:2013:imp:opensource.ncsa.illinois.edu:2012";
        this.DAFFODIL_EXTENSION_NAMESPACE_NCSA = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA()).append(":ext").toString());
        this.EXT_PREFIX_NCSA = "daf";
        this.EXT_NS_NCSA = NS$.MODULE$.apply(this.DAFFODIL_EXTENSION_NAMESPACE_NCSA().uri());
        this.DAFFODIL_NAMESPACE_ROOT_APACHE = "urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018";
        this.DAFFODIL_EXTENSION_NAMESPACE_APACHE = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(this.DAFFODIL_NAMESPACE_ROOT_APACHE()).append(":ext").toString());
        this.EXT_PREFIX_APACHE = "daf";
        this.EXT_NS_APACHE = NS$.MODULE$.apply(this.DAFFODIL_EXTENSION_NAMESPACE_APACHE().uri());
        this.DAFFODIL_INTERNAL_NAMESPACE = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(this.DAFFODIL_NAMESPACE_ROOT_APACHE()).append(":int").toString());
        this.INT_PREFIX = "dafint";
        this.INT_NS = NS$.MODULE$.apply(this.DAFFODIL_INTERNAL_NAMESPACE().uri());
        this.DAFFODIL_SAX_URN_ROOT = new java.lang.StringBuilder(4).append(this.DAFFODIL_NAMESPACE_ROOT_APACHE()).append(":sax").toString();
        this.DAFFODIL_SAX_URN_PARSERESULT = new java.lang.StringBuilder(12).append(this.DAFFODIL_SAX_URN_ROOT()).append(":ParseResult").toString();
        this.DAFFODIL_SAX_URN_BLOBDIRECTORY = new java.lang.StringBuilder(14).append(this.DAFFODIL_SAX_URN_ROOT()).append(":BlobDirectory").toString();
        this.DAFFODIL_SAX_URN_BLOBPREFIX = new java.lang.StringBuilder(11).append(this.DAFFODIL_SAX_URN_ROOT()).append(":BlobPrefix").toString();
        this.DAFFODIL_SAX_URN_BLOBSUFFIX = new java.lang.StringBuilder(11).append(this.DAFFODIL_SAX_URN_ROOT()).append(":BlobSuffix").toString();
        this.SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
        this.SAX_NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
        this.XML_DISALLOW_DOCTYPE_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        this.XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
        this.XML_EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
        this.XML_LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        this.FILE_ATTRIBUTE_NAME = "file";
        this.LINE_ATTRIBUTE_NAME = "line";
        this.COLUMN_ATTRIBUTE_NAME = "col";
        this.xsdURI = this.XSD_NAMESPACE();
        this.dfdlURI = this.DFDL_NAMESPACE();
        this.dfdlxURI = this.DFDLX_NAMESPACE();
        this.dfdlAppinfoSource = NS$.MODULE$.apply("http://www.ogf.org/dfdl/");
        this.targetNS = this.EXAMPLE_NAMESPACE();
        this.xsiURI = this.XSI_NAMESPACE();
        this.fnURI = this.XPATH_FUNCTION_NAMESPACE();
        this.mathURI = this.XPATH_MATH_NAMESPACE();
        this.dafintURI = this.DAFFODIL_INTERNAL_NAMESPACE();
        this.DFDL_SIMPLE_BUILT_IN_TYPES = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "float", "double", "decimal", "integer", "long", "int", "short", "byte", "unsignedLong", "unsignedInt", "nonNegativeInteger", "unsignedShort", "unsignedByte", "boolean", "date", "time", "dateTime", "hexBinary"}));
        this.escapeMapper = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)XMLUtils$.MODULE$.remapXMLIllegalCharToPUA(false, false, BoxesRunTime.unboxToChar((Object)c)));
        this.xmlEntityPattern = new Regex("&(quot|amp|apos|lt|gt);", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"entity"}));
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$13$adapted(Object x$21) {
        return XMLUtils$.$anonfun$computeDiffOne$13(BoxesRunTime.unboxToInt((Object)x$21));
    }

    public static final /* synthetic */ Object $anonfun$computeDiffOne$15$adapted(Node x$23) {
        return BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$15(x$23));
    }

    public static final /* synthetic */ Object $anonfun$computeDiffOne$16$adapted(Node x$24) {
        return BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$16(x$24));
    }

    public static final /* synthetic */ Object $anonfun$computeDiffOne$18$adapted(Tuple2 x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$18(x0$1));
    }

    public static final /* synthetic */ Object $anonfun$computeTextDiff$1$adapted(String x$30) {
        return BoxesRunTime.boxToBoolean((boolean)x$30.startsWith("file://"));
    }
}

