/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.charset;

import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.processors.charset.BitsCharsetDecoderCreatesSurrogates;
import org.apache.daffodil.processors.charset.BitsCharsetDecoderMalformedException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000112Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C)1\tI\")\u001b;t\u0007\"\f'o]3u\t\u0016\u001cw\u000eZ3s+R3\u0015G\u000e'F\u0015\t)a!A\u0004dQ\u0006\u00148/\u001a;\u000b\u0005\u001dA\u0011A\u00039s_\u000e,7o]8sg*\u0011\u0011BC\u0001\tI\u00064gm\u001c3jY*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0003\n\u0005M!!a\t\"jiN\u001c\u0005.\u0019:tKR$UmY8eKJ\u001c%/Z1uKN\u001cVO\u001d:pO\u0006$Xm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0001\"!\u0005\u0001\u0002)\u0011,7m\u001c3f\u001f:,WK\\5d_\u0012,7\t[1s)\rIrd\n\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0005\u0007\"\f'\u000fC\u0003!\u0005\u0001\u0007\u0011%A\u0002eSN\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\u0005\u0002\u0005%|\u0017B\u0001\u0014$\u0005iIe\u000e];u'>,(oY3ECR\f\u0017J\u001c9viN#(/Z1n\u0011\u0015A#\u00011\u0001*\u0003\u00151\u0017N\u001c4p!\t\u0011#&\u0003\u0002,G\tQai\u001c:nCRLeNZ8")
public class BitsCharsetDecoderUTF16LE
extends BitsCharsetDecoderCreatesSurrogates {
    @Override
    public char decodeOneUnicodeChar(InputSourceDataInputStream dis, FormatInfo finfo) {
        int high;
        block2: {
            int byte2 = this.getByte(dis, 0);
            int byte1 = this.getByte(dis, 8);
            high = byte1 << 8 | byte2;
            if (high < 55296 || high > 57343) break block2;
            if (high >= 56320) {
                throw new BitsCharsetDecoderMalformedException(16);
            }
            int byte4 = this.getByte(dis, 16);
            int byte3 = this.getByte(dis, 24);
            int low = byte3 << 8 | byte4;
            if (low < 56320 || low > 57343) {
                throw new BitsCharsetDecoderMalformedException(32);
            }
            this.setLowSurrogate((char)low);
        }
        return (char)high;
    }
}

