/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.tdml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.api.DaffodilTunables;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.processors.charset.BitsCharsetEncoder;
import org.apache.daffodil.processors.charset.CharsetUtils$;
import org.apache.daffodil.schema.annotation.props.gen.BinaryFloatRep;
import org.apache.daffodil.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.schema.annotation.props.gen.EncodingErrorPolicy;
import org.apache.daffodil.tdml.ErrorWarningBase;
import org.apache.daffodil.tdml.Infoset;
import org.apache.daffodil.tdml.TDMLException$;
import org.apache.daffodil.tdml.VerifyTestCase;
import org.apache.daffodil.tdml.processor.TDMLResult;
import org.apache.daffodil.util.Misc$;
import org.apache.daffodil.xml.XMLUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.xml.Node;

public final class VerifyTestCase$ {
    public static VerifyTestCase$ MODULE$;
    private final Charset cs8859;

    static {
        new VerifyTestCase$();
    }

    public void verifyParserTestData(Node actual, Infoset infoset, Option<String> implString) {
        Node expected = infoset.contents();
        try {
            XMLUtils$.MODULE$.compareAndReport(expected, actual, XMLUtils$.MODULE$.compareAndReport$default$3(), XMLUtils$.MODULE$.compareAndReport$default$4(), XMLUtils$.MODULE$.compareAndReport$default$5());
        }
        catch (Exception e) {
            throw TDMLException$.MODULE$.apply(e, implString);
        }
    }

    public void verifyUnparserTestData(InputStream expectedData, ByteArrayOutputStream actualOutStream, Option<String> implString) {
        LazyRef actualAsString$lzy = new LazyRef();
        LazyRef expectedAsString$lzy = new LazyRef();
        byte[] actualBytes = actualOutStream.toByteArray();
        byte[] expectedBytes = IOUtils.toByteArray((InputStream)expectedData);
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(expectedBytes)).isEmpty() && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(actualBytes)).nonEmpty()) {
            throw TDMLException$.MODULE$.apply("Unexpected data was created.", implString);
        }
        int readCount = expectedBytes.length;
        if (actualBytes.length != readCount) {
            throw TDMLException$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("Output data length %s for '%s' doesn't match expected value %s for '%s'.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)actualBytes.length), VerifyTestCase$.actualAsString$1(actualAsString$lzy, actualBytes), BoxesRunTime.boxToInteger((int)readCount), VerifyTestCase$.expectedAsString$1(expectedAsString$lzy, expectedBytes)})), implString);
        }
        Tuple2[] pairs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(expectedBytes)).zip((GenIterable)Predef$.MODULE$.wrapByteArray(actualBytes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zip((GenIterable)package$.MODULE$.Stream().from(1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pairs)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VerifyTestCase$.$anonfun$verifyUnparserTestData$1(implString, actualAsString$lzy, actualBytes, expectedAsString$lzy, expectedBytes, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyAllDiagnosticsFound(Seq<Throwable> actualDiags, Option<ErrorWarningBase> expectedDiags, Option<String> implString) {
        Seq actualDiagMsgs = (Seq)actualDiags.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.toString(), Seq$.MODULE$.canBuildFrom());
        Seq expectedDiagMsgs = (Seq)expectedDiags.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.messages()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        if (expectedDiags.isDefined() && actualDiags.isEmpty()) {
            throw TDMLException$.MODULE$.apply(new java.lang.StringBuilder(63).append("\"Diagnostic message(s) were expected but not found.\"\nExpected: ").append(expectedDiagMsgs.mkString("\n")).append((Object)(actualDiagMsgs.isEmpty() ? "\n No diagnostic messages were issued." : new java.lang.StringBuilder(40).append("\n The actual diagnostics messages were: ").append(actualDiagMsgs.mkString("\n")).toString())).toString(), implString);
        }
        expectedDiagMsgs.foreach((Function1 & Serializable & scala.Serializable)expected -> {
            VerifyTestCase$.$anonfun$verifyAllDiagnosticsFound$4(actualDiagMsgs, implString, expected);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyNoValidationErrorsFound(TDMLResult actual, Option<String> implString) {
        Seq actualDiags = (Seq)actual.getDiagnostics().filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)d.isValidation()));
        if (actualDiags.nonEmpty()) {
            Seq actualDiagMsgs = (Seq)actualDiags.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.toString(), Seq$.MODULE$.canBuildFrom());
            throw TDMLException$.MODULE$.apply(new java.lang.StringBuilder(67).append("Validation errors found where none were expected by the test case.\n").append(actualDiagMsgs.mkString("\n")).toString(), implString);
        }
    }

    public String decodeDataToString(BitsCharsetDecoder decoder, byte[] bytes) {
        int numDecoded;
        InputSourceDataInputStream dis = InputSourceDataInputStream$.MODULE$.apply(bytes);
        public class Org_apache_daffodil_tdml_VerifyTestCase$FormatInfoForTDMLDecode$1
        implements FormatInfo {
            public final boolean isFixedWidthEncoding() {
                return FormatInfo.isFixedWidthEncoding$((FormatInfo)this);
            }

            public ByteOrder byteOrder() {
                return ByteOrder.BigEndian$.MODULE$;
            }

            public BitOrder bitOrder() {
                return BitOrder.LeastSignificantBitFirst$.MODULE$;
            }

            public EncodingErrorPolicy encodingErrorPolicy() {
                return EncodingErrorPolicy.Replace$.MODULE$;
            }

            private Nothing$ doNotUse() {
                return Assert$.MODULE$.usageError("Should not be used");
            }

            public BitsCharsetEncoder encoder() {
                throw this.doNotUse();
            }

            public BitsCharsetDecoder decoder() {
                throw this.doNotUse();
            }

            public byte fillByte() {
                throw this.doNotUse();
            }

            public BinaryFloatRep binaryFloatRep() {
                throw this.doNotUse();
            }

            public long maybeCharWidthInBits() {
                throw this.doNotUse();
            }

            public Object maybeUTF16Width() {
                throw this.doNotUse();
            }

            public int encodingMandatoryAlignmentInBits() {
                throw this.doNotUse();
            }

            public DaffodilTunables tunable() {
                throw this.doNotUse();
            }

            public CharBuffer regexMatchBuffer() {
                throw this.doNotUse();
            }

            public LongBuffer regexMatchBitPositionBuffer() {
                throw this.doNotUse();
            }

            public Org_apache_daffodil_tdml_VerifyTestCase$FormatInfoForTDMLDecode$1() {
                FormatInfo.$init$((FormatInfo)this);
            }
        }
        Org_apache_daffodil_tdml_VerifyTestCase$FormatInfoForTDMLDecode$1 finfo = new Org_apache_daffodil_tdml_VerifyTestCase$FormatInfoForTDMLDecode$1();
        CharBuffer cb = CharBuffer.allocate(256);
        StringBuilder sb = new StringBuilder(256);
        while ((numDecoded = decoder.decode(dis, (FormatInfo)finfo, cb, decoder.decode$default$4())) > 0) {
            cb.flip();
            sb.append((Object)cb);
            cb.clear();
        }
        return sb.toString();
    }

    public void verifyTextData(InputStream expectedData, ByteArrayOutputStream actualOutStream, String encodingName, Option<String> implString) {
        String expectedCharsToShow;
        byte[] expectedBytes;
        BitsCharsetDecoder decoder = CharsetUtils$.MODULE$.getCharset(encodingName).newDecoder();
        byte[] actualBytes = actualOutStream.toByteArray();
        if (actualBytes == (expectedBytes = IOUtils.toByteArray((InputStream)expectedData))) {
            return;
        }
        String actualText = this.decodeDataToString(decoder, actualBytes);
        String expectedText = this.decodeDataToString(decoder, expectedBytes);
        expectedData.close();
        if (expectedText.length() == 0) {
            if (actualText.length() > 0) {
                throw TDMLException$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("Unexpected data '%s' was created.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{actualText})), implString);
            }
            return;
        }
        int maxTextCharsToShow = 100;
        String actualCharsToShow = actualText.length() == 0 ? "" : new java.lang.StringBuilder(7).append(" for '").append(VerifyTestCase$.trimToMax$1(actualText, maxTextCharsToShow)).append("'").toString();
        String string = expectedCharsToShow = expectedText.length() == 0 ? "" : new java.lang.StringBuilder(7).append(" for '").append(VerifyTestCase$.trimToMax$1(expectedText, maxTextCharsToShow)).append("'").toString();
        if (actualText.length() != expectedText.length()) {
            String actualCharsToShow2 = actualText.length() == 0 ? "" : new java.lang.StringBuilder(7).append(" for '").append(VerifyTestCase$.trimToMax$1(actualText, maxTextCharsToShow)).append("'").toString();
            String expectedCharsToShow2 = expectedText.length() == 0 ? "" : new java.lang.StringBuilder(7).append(" for '").append(VerifyTestCase$.trimToMax$1(expectedText, maxTextCharsToShow)).append("'").toString();
            throw TDMLException$.MODULE$.apply(new java.lang.StringBuilder(50).append("output data length ").append(actualText.length()).append(actualCharsToShow2).append(" doesn't match expected length ").append(expectedText.length()).append(expectedCharsToShow2).toString(), implString);
        }
        Seq pairs = (Seq)((IterableLike)new StringOps(Predef$.MODULE$.augmentString(expectedText)).toSeq().zip((GenIterable)new StringOps(Predef$.MODULE$.augmentString(actualText)).toSeq(), Seq$.MODULE$.canBuildFrom())).zip((GenIterable)package$.MODULE$.Stream().from(1), Seq$.MODULE$.canBuildFrom());
        pairs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VerifyTestCase$.$anonfun$verifyTextData$1(expectedCharsToShow, actualCharsToShow, implString, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Charset cs8859() {
        return this.cs8859;
    }

    public void verifyBinaryOrMixedData(InputStream expectedData, ByteArrayOutputStream actualOutStream, Option<String> implString) {
        LazyRef actual8859String$lzy = new LazyRef();
        LazyRef displayableActual$lzy = new LazyRef();
        LazyRef expected8859String$lzy = new LazyRef();
        LazyRef displayableExpected$lzy = new LazyRef();
        LazyRef expectedAndActualDisplayStrings$lzy = new LazyRef();
        byte[] actualBytes = actualOutStream.toByteArray();
        byte[] expectedBytes = IOUtils.toByteArray((InputStream)expectedData);
        int readCount = expectedBytes.length;
        expectedData.close();
        if (readCount == 0) {
            if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(actualBytes)).nonEmpty()) {
                throw TDMLException$.MODULE$.apply(new java.lang.StringBuilder(31).append("Unexpected data was created: '").append(this.displayableActual$1(displayableActual$lzy, actual8859String$lzy, actualBytes)).append("'").toString(), implString);
            }
            return;
        }
        if (actualBytes.length != readCount) {
            String bytesToShow = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(actualBytes)).isEmpty() ? "" : new java.lang.StringBuilder(5).append(" for ").append(Misc$.MODULE$.bytes2Hex(actualBytes)).toString();
            throw TDMLException$.MODULE$.apply(new java.lang.StringBuilder(55).append("output data length ").append(actualBytes.length).append(bytesToShow).append(" doesn't match expected length ").append(readCount).append(" for ").append(Misc$.MODULE$.bytes2Hex(expectedBytes)).append(this.expectedAndActualDisplayStrings$1(expectedAndActualDisplayStrings$lzy, expectedBytes, actualBytes, displayableExpected$lzy, expected8859String$lzy, displayableActual$lzy, actual8859String$lzy)).toString(), implString);
        }
        Tuple2[] pairs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(expectedBytes)).zip((GenIterable)Predef$.MODULE$.wrapByteArray(actualBytes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zip((GenIterable)package$.MODULE$.Stream().from(1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pairs)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VerifyTestCase$.$anonfun$verifyBinaryOrMixedData$1(this, implString, expectedAndActualDisplayStrings$lzy, expectedBytes, actualBytes, displayableExpected$lzy, expected8859String$lzy, displayableActual$lzy, actual8859String$lzy, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final /* synthetic */ String actualAsString$lzycompute$1(LazyRef actualAsString$lzy$1, byte[] actualBytes$1) {
        String string;
        LazyRef lazyRef = actualAsString$lzy$1;
        synchronized (lazyRef) {
            string = actualAsString$lzy$1.initialized() ? (String)actualAsString$lzy$1.value() : (String)actualAsString$lzy$1.initialize((Object)Misc$.MODULE$.remapBytesToStringOfVisibleGlyphs(actualBytes$1));
        }
        return string;
    }

    private static final String actualAsString$1(LazyRef actualAsString$lzy$1, byte[] actualBytes$1) {
        return actualAsString$lzy$1.initialized() ? (String)actualAsString$lzy$1.value() : VerifyTestCase$.actualAsString$lzycompute$1(actualAsString$lzy$1, actualBytes$1);
    }

    private static final /* synthetic */ String expectedAsString$lzycompute$1(LazyRef expectedAsString$lzy$1, byte[] expectedBytes$1) {
        String string;
        LazyRef lazyRef = expectedAsString$lzy$1;
        synchronized (lazyRef) {
            string = expectedAsString$lzy$1.initialized() ? (String)expectedAsString$lzy$1.value() : (String)expectedAsString$lzy$1.initialize((Object)Misc$.MODULE$.remapBytesToStringOfVisibleGlyphs(expectedBytes$1));
        }
        return string;
    }

    private static final String expectedAsString$1(LazyRef expectedAsString$lzy$1, byte[] expectedBytes$1) {
        return expectedAsString$lzy$1.initialized() ? (String)expectedAsString$lzy$1.value() : VerifyTestCase$.expectedAsString$lzycompute$1(expectedAsString$lzy$1, expectedBytes$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyUnparserTestData$1(Option implString$5, LazyRef actualAsString$lzy$1, byte[] actualBytes$1, LazyRef expectedAsString$lzy$1, byte[] expectedBytes$1, Tuple2 x0$1) {
        byte actual;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int index = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        byte expected = BoxesRunTime.unboxToByte((Object)tuple22._1());
        if (expected != (actual = BoxesRunTime.unboxToByte((Object)tuple22._2()))) {
            String msg = new StringOps(Predef$.MODULE$.augmentString("Unparsed data differs at byte %d. Expected 0x%02x. Actual was 0x%02x.\nData (as strings) was\n(actual) '%s'\n(expected) '%s'.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), BoxesRunTime.boxToByte((byte)expected), BoxesRunTime.boxToByte((byte)actual), VerifyTestCase$.actualAsString$1(actualAsString$lzy$1, actualBytes$1), VerifyTestCase$.expectedAsString$1(expectedAsString$lzy$1, expectedBytes$1)}));
            throw TDMLException$.MODULE$.apply(msg, (Option<String>)implString$5);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$verifyAllDiagnosticsFound$5(String expected$1, String actual) {
        return actual.toLowerCase().contains(expected$1.toLowerCase());
    }

    public static final /* synthetic */ void $anonfun$verifyAllDiagnosticsFound$4(Seq actualDiagMsgs$1, Option implString$6, String expected) {
        boolean wasFound = actualDiagMsgs$1.exists((Function1 & Serializable & scala.Serializable)actual -> BoxesRunTime.boxToBoolean((boolean)VerifyTestCase$.$anonfun$verifyAllDiagnosticsFound$5(expected, actual)));
        if (!wasFound) {
            throw TDMLException$.MODULE$.apply(new java.lang.StringBuilder(78).append("Did not find diagnostic message \"").append(expected).append("\" in any of the actual diagnostic messages: ").append("\n").append(actualDiagMsgs$1.mkString("\n")).toString(), (Option<String>)implString$6);
        }
    }

    private static final String trimToMax$1(String str, int maxTextCharsToShow$1) {
        return str.length() <= maxTextCharsToShow$1 ? str : new java.lang.StringBuilder(3).append(str.substring(0, maxTextCharsToShow$1)).append("...").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyTextData$1(String expectedCharsToShow$1, String actualCharsToShow$1, Option implString$7, Tuple2 x0$1) {
        char actual;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int index = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        char expected = tuple22._1$mcC$sp();
        if (expected != (actual = tuple22._2$mcC$sp())) {
            String msg = new StringOps(Predef$.MODULE$.augmentString("Unparsed data differs at character %d. Expected '%s'. Actual was '%s'. Expected data %s, actual data %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), BoxesRunTime.boxToCharacter((char)expected), BoxesRunTime.boxToCharacter((char)actual), expectedCharsToShow$1, actualCharsToShow$1}));
            throw TDMLException$.MODULE$.apply(msg, (Option<String>)implString$7);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final /* synthetic */ String actual8859String$lzycompute$1(LazyRef actual8859String$lzy$1, byte[] actualBytes$2) {
        String string;
        LazyRef lazyRef = actual8859String$lzy$1;
        synchronized (lazyRef) {
            string = actual8859String$lzy$1.initialized() ? (String)actual8859String$lzy$1.value() : (String)actual8859String$lzy$1.initialize((Object)this.cs8859().newDecoder().decode(ByteBuffer.wrap(actualBytes$2)).toString());
        }
        return string;
    }

    private final String actual8859String$1(LazyRef actual8859String$lzy$1, byte[] actualBytes$2) {
        return actual8859String$lzy$1.initialized() ? (String)actual8859String$lzy$1.value() : this.actual8859String$lzycompute$1(actual8859String$lzy$1, actualBytes$2);
    }

    private final /* synthetic */ String displayableActual$lzycompute$1(LazyRef displayableActual$lzy$1, LazyRef actual8859String$lzy$1, byte[] actualBytes$2) {
        String string;
        LazyRef lazyRef = displayableActual$lzy$1;
        synchronized (lazyRef) {
            string = displayableActual$lzy$1.initialized() ? (String)displayableActual$lzy$1.value() : (String)displayableActual$lzy$1.initialize((Object)Misc$.MODULE$.remapControlsAndLineEndingsToVisibleGlyphs(this.actual8859String$1(actual8859String$lzy$1, actualBytes$2)));
        }
        return string;
    }

    private final String displayableActual$1(LazyRef displayableActual$lzy$1, LazyRef actual8859String$lzy$1, byte[] actualBytes$2) {
        return displayableActual$lzy$1.initialized() ? (String)displayableActual$lzy$1.value() : this.displayableActual$lzycompute$1(displayableActual$lzy$1, actual8859String$lzy$1, actualBytes$2);
    }

    private final /* synthetic */ String expected8859String$lzycompute$1(LazyRef expected8859String$lzy$1, byte[] expectedBytes$2) {
        String string;
        LazyRef lazyRef = expected8859String$lzy$1;
        synchronized (lazyRef) {
            string = expected8859String$lzy$1.initialized() ? (String)expected8859String$lzy$1.value() : (String)expected8859String$lzy$1.initialize((Object)this.cs8859().newDecoder().decode(ByteBuffer.wrap(expectedBytes$2)).toString());
        }
        return string;
    }

    private final String expected8859String$1(LazyRef expected8859String$lzy$1, byte[] expectedBytes$2) {
        return expected8859String$lzy$1.initialized() ? (String)expected8859String$lzy$1.value() : this.expected8859String$lzycompute$1(expected8859String$lzy$1, expectedBytes$2);
    }

    private final /* synthetic */ String displayableExpected$lzycompute$1(LazyRef displayableExpected$lzy$1, LazyRef expected8859String$lzy$1, byte[] expectedBytes$2) {
        String string;
        LazyRef lazyRef = displayableExpected$lzy$1;
        synchronized (lazyRef) {
            string = displayableExpected$lzy$1.initialized() ? (String)displayableExpected$lzy$1.value() : (String)displayableExpected$lzy$1.initialize((Object)Misc$.MODULE$.remapControlsAndLineEndingsToVisibleGlyphs(this.expected8859String$1(expected8859String$lzy$1, expectedBytes$2)));
        }
        return string;
    }

    private final String displayableExpected$1(LazyRef displayableExpected$lzy$1, LazyRef expected8859String$lzy$1, byte[] expectedBytes$2) {
        return displayableExpected$lzy$1.initialized() ? (String)displayableExpected$lzy$1.value() : this.displayableExpected$lzycompute$1(displayableExpected$lzy$1, expected8859String$lzy$1, expectedBytes$2);
    }

    private final /* synthetic */ String expectedAndActualDisplayStrings$lzycompute$1(LazyRef expectedAndActualDisplayStrings$lzy$1, byte[] expectedBytes$2, byte[] actualBytes$2, LazyRef displayableExpected$lzy$1, LazyRef expected8859String$lzy$1, LazyRef displayableActual$lzy$1, LazyRef actual8859String$lzy$1) {
        String string;
        LazyRef lazyRef = expectedAndActualDisplayStrings$lzy$1;
        synchronized (lazyRef) {
            string = expectedAndActualDisplayStrings$lzy$1.initialized() ? (String)expectedAndActualDisplayStrings$lzy$1.value() : (String)expectedAndActualDisplayStrings$lzy$1.initialize((Object)new java.lang.StringBuilder(112).append("\nExcected data (as iso8859-1): ").append(this.displayableExpected$1(displayableExpected$lzy$1, expected8859String$lzy$1, expectedBytes$2)).append("\n").append("Actual data   (as iso8859-1): ").append(this.displayableActual$1(displayableActual$lzy$1, actual8859String$lzy$1, actualBytes$2)).append("\n").append("Expected data (as hex): ").append(Misc$.MODULE$.bytes2Hex(expectedBytes$2)).append("\n").append("Actual data   (as hex): ").append(Misc$.MODULE$.bytes2Hex(actualBytes$2)).toString());
        }
        return string;
    }

    private final String expectedAndActualDisplayStrings$1(LazyRef expectedAndActualDisplayStrings$lzy$1, byte[] expectedBytes$2, byte[] actualBytes$2, LazyRef displayableExpected$lzy$1, LazyRef expected8859String$lzy$1, LazyRef displayableActual$lzy$1, LazyRef actual8859String$lzy$1) {
        return expectedAndActualDisplayStrings$lzy$1.initialized() ? (String)expectedAndActualDisplayStrings$lzy$1.value() : this.expectedAndActualDisplayStrings$lzycompute$1(expectedAndActualDisplayStrings$lzy$1, expectedBytes$2, actualBytes$2, displayableExpected$lzy$1, expected8859String$lzy$1, displayableActual$lzy$1, actual8859String$lzy$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyBinaryOrMixedData$1(VerifyTestCase$ $this, Option implString$8, LazyRef expectedAndActualDisplayStrings$lzy$1, byte[] expectedBytes$2, byte[] actualBytes$2, LazyRef displayableExpected$lzy$1, LazyRef expected8859String$lzy$1, LazyRef displayableActual$lzy$1, LazyRef actual8859String$lzy$1, Tuple2 x0$1) {
        byte actual;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int index = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        byte expected = BoxesRunTime.unboxToByte((Object)tuple22._1());
        if (expected != (actual = BoxesRunTime.unboxToByte((Object)tuple22._2()))) {
            String msg = new java.lang.StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("Unparsed data differs at byte %d. Expected 0x%02x. Actual was 0x%02x.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), BoxesRunTime.boxToByte((byte)expected), BoxesRunTime.boxToByte((byte)actual)}))).append($this.expectedAndActualDisplayStrings$1(expectedAndActualDisplayStrings$lzy$1, expectedBytes$2, actualBytes$2, displayableExpected$lzy$1, expected8859String$lzy$1, displayableActual$lzy$1, actual8859String$lzy$1)).toString();
            throw TDMLException$.MODULE$.apply(msg, (Option<String>)implString$8);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private VerifyTestCase$() {
        MODULE$ = this;
        this.cs8859 = Charset.forName("iso-8859-1");
    }
}

