/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.ZipException;
import org.apache.daffodil.api.DFDL;
import org.apache.daffodil.api.DaffodilSchemaSource;
import org.apache.daffodil.api.DaffodilTunables;
import org.apache.daffodil.api.DaffodilTunables$;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.URISchemaSource;
import org.apache.daffodil.api.URISchemaSource$;
import org.apache.daffodil.api.UnitTestSchemaSource;
import org.apache.daffodil.compiler.Compiler$;
import org.apache.daffodil.compiler.InvalidParserException;
import org.apache.daffodil.compiler.ProcessorFactory;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.externalvars.Binding;
import org.apache.daffodil.externalvars.Binding$;
import org.apache.daffodil.externalvars.ExternalVariablesLoader$;
import org.apache.daffodil.processors.DataProcessor;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogWriter;
import org.apache.daffodil.util.Logging;
import org.apache.daffodil.util.Misc$;
import org.apache.daffodil.xml.NS$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Properties$;
import scala.xml.Node;

@ScalaSignature(bytes="\u0006\u0001\r]a\u0001\u0002 @\u0001!C\u0001B\u0018\u0001\u0003\u0002\u0004%\ta\u0018\u0005\tG\u0002\u0011\t\u0019!C\u0001I\"A!\u000e\u0001B\u0001B\u0003&\u0001\r\u0003\u0005l\u0001\t\u0005\r\u0011\"\u0001m\u0011!\u0001\bA!a\u0001\n\u0003\t\b\u0002C:\u0001\u0005\u0003\u0005\u000b\u0015B7\t\u0011Q\u0004!\u00111A\u0005\nUD!\"!\u0003\u0001\u0005\u0003\u0007I\u0011BA\u0006\u0011%\ty\u0001\u0001B\u0001B\u0003&a\u000fC\u0005\u0002\u0012\u0001\u0011\t\u0019!C\u0005?\"Q\u00111\u0003\u0001\u0003\u0002\u0004%I!!\u0006\t\u0013\u0005e\u0001A!A!B\u0013\u0001\u0007BCA\u000e\u0001\t\u0005\r\u0011\"\u0003\u0002\u001e!Q\u00111\b\u0001\u0003\u0002\u0004%I!!\u0010\t\u0015\u0005\u0005\u0003A!A!B\u0013\ty\u0002\u0003\u0006\u0002D\u0001\u0011\t\u0019!C\u0005\u0003;A!\"!\u0012\u0001\u0005\u0003\u0007I\u0011BA$\u0011)\tY\u0005\u0001B\u0001B\u0003&\u0011q\u0004\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\ti\u0005\u0001C\u0005\u0003CBq!!\u001a\u0001\t\u0013\t9\u0007C\u0005\u0002v\u0001\t\n\u0011\"\u0003\u0002x!I\u0011Q\u0012\u0001\u0012\u0002\u0013%\u0011q\u0012\u0005\n\u0003'\u0003\u0011\u0013!C\u0005\u0003+C\u0011\"!'\u0001#\u0003%I!a\u001e\t\u0013\u0005m\u0005!%A\u0005\n\u0005u\u0005\"CAQ\u0001E\u0005I\u0011BAO\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!a0\u0001\t\u0003\t\t\rC\u0004\u0002H\u0002!\t!!3\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"9\u00111\u001c\u0001\u0005B\u0005u\u0007bBAv\u0001\u0011%\u0011Q\u001e\u0005\b\u00037\u0004A\u0011AA{\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u007fDqA!\u0007\u0001\t\u0003\u0011Y\u0002C\u0004\u0002~\u0002!\tAa\b\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B(\u0001\u0011\u0005!\u0011\u000b\u0005\b\u0005G\u0002A\u0011\u0001B3\u0011\u001d\u0011I\u0007\u0001C\u0001\u0005WBqAa\u001e\u0001\t\u0003\u0011I\bC\u0004\u0003~\u0001!\tAa \t\u000f\tu\u0004\u0001\"\u0001\u0003\f\"9!q\u0014\u0001\u0005\u0002\t\u0005\u0006\"\u0003BY\u0001E\u0005I\u0011AAO\u0011%\u0011\u0019\fAI\u0001\n\u0003\ti\nC\u0004\u00036\u0002!\tAa.\t\u0013\t\u001d\u0007!%A\u0005\u0002\u0005u\u0005\"\u0003Be\u0001E\u0005I\u0011AAO\u0011\u001d\u0011Y\r\u0001C\u0005\u0005\u001bDqA!7\u0001\t\u0003\u0011Y\u000eC\u0005\u0003r\u0002\t\n\u0011\"\u0001\u0003t\u001e9!q_ \t\u0002\tehA\u0002 @\u0011\u0003\u0011Y\u0010C\u0004\u0002Na\"\tA!@\t\u000f\t}\b\b\"\u0001\u0004\u0002!I1Q\u0001\u001d\u0012\u0002\u0013\u0005\u0011q\u000f\u0005\b\u0007\u000fAD\u0011BB\u0005\u0011%\u0019)\u0002OI\u0001\n\u0013\t9H\u0001\u0005D_6\u0004\u0018\u000e\\3s\u0015\t\u0001\u0015)\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\t\u00115)\u0001\u0005eC\u001a4w\u000eZ5m\u0015\t!U)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\r\u0006\u0019qN]4\u0004\u0001M!\u0001!S(Y!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0019\te.\u001f*fMB\u0011\u0001K\u0016\b\u0003#Rk\u0011A\u0015\u0006\u0003'\u0006\u000b1!\u00199j\u0013\t)&+\u0001\u0003E\r\u0012c\u0015B\u0001 X\u0015\t)&\u000b\u0005\u0002Z96\t!L\u0003\u0002\\\u0003\u0006!Q\u000f^5m\u0013\ti&LA\u0004M_\u001e<\u0017N\\4\u0002'Y\fG.\u001b3bi\u0016$e\t\u0012'TG\",W.Y:\u0016\u0003\u0001\u0004\"AS1\n\u0005\t\\%a\u0002\"p_2,\u0017M\\\u0001\u0018m\u0006d\u0017\u000eZ1uK\u00123E\tT*dQ\u0016l\u0017m]0%KF$\"!\u001a5\u0011\u0005)3\u0017BA4L\u0005\u0011)f.\u001b;\t\u000f%\u0014\u0011\u0011!a\u0001A\u0006\u0019\u0001\u0010J\u0019\u0002)Y\fG.\u001b3bi\u0016$e\t\u0012'TG\",W.Y:!\u0003!!XO\\1cY\u0016\u001cX#A7\u0011\u0005Es\u0017BA8S\u0005A!\u0015M\u001a4pI&dG+\u001e8bE2,7/\u0001\u0007uk:\f'\r\\3t?\u0012*\u0017\u000f\u0006\u0002fe\"9\u0011.BA\u0001\u0002\u0004i\u0017!\u0003;v]\u0006\u0014G.Z:!\u0003U)\u0007\u0010^3s]\u0006dGI\u0012#M-\u0006\u0014\u0018.\u00192mKN,\u0012A\u001e\t\u0004ortX\"\u0001=\u000b\u0005eT\u0018!C5n[V$\u0018M\u00197f\u0015\tY8*\u0001\u0006d_2dWm\u0019;j_:L!! =\u0003\u000bE+X-^3\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A!\u0002\u0019\u0015DH/\u001a:oC24\u0018M]:\n\t\u0005\u001d\u0011\u0011\u0001\u0002\b\u0005&tG-\u001b8h\u0003e)\u0007\u0010^3s]\u0006dGI\u0012#M-\u0006\u0014\u0018.\u00192mKN|F%Z9\u0015\u0007\u0015\fi\u0001C\u0004j\u0011\u0005\u0005\t\u0019\u0001<\u0002-\u0015DH/\u001a:oC2$e\t\u0012'WCJL\u0017M\u00197fg\u0002\n\u0001c\u00195fG.\fE\u000e\u001c+pa2+g/\u001a7\u0002)\rDWmY6BY2$v\u000e\u001d'fm\u0016dw\fJ3r)\r)\u0017q\u0003\u0005\bS.\t\t\u00111\u0001a\u0003E\u0019\u0007.Z2l\u00032dGk\u001c9MKZ,G\u000eI\u0001\f_B$(k\\8u\u001d\u0006lW-\u0006\u0002\u0002 A)!*!\t\u0002&%\u0019\u00111E&\u0003\r=\u0003H/[8o!\u0011\t9#!\u000e\u000f\t\u0005%\u0012\u0011\u0007\t\u0004\u0003WYUBAA\u0017\u0015\r\tycR\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M2*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\tID\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003gY\u0015aD8qiJ{w\u000e\u001e(b[\u0016|F%Z9\u0015\u0007\u0015\fy\u0004\u0003\u0005j\u001d\u0005\u0005\t\u0019AA\u0010\u00031y\u0007\u000f\u001e*p_Rt\u0015-\\3!\u0003Ay\u0007\u000f\u001e*p_Rt\u0015-\\3ta\u0006\u001cW-\u0001\u000bpaR\u0014vn\u001c;OC6,7\u000f]1dK~#S-\u001d\u000b\u0004K\u0006%\u0003\u0002C5\u0012\u0003\u0003\u0005\r!a\b\u0002#=\u0004HOU8pi:\u000bW.Z:qC\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003#\n)&a\u0016\u0002Z\u0005m\u0013QLA0!\r\t\u0019\u0006A\u0007\u0002\u007f!)al\u0005a\u0001A\")1n\u0005a\u0001[\")Ao\u0005a\u0001m\"1\u0011\u0011C\nA\u0002\u0001Dq!a\u0007\u0014\u0001\u0004\ty\u0002C\u0004\u0002DM\u0001\r!a\b\u0015\t\u0005E\u00131\r\u0005\b=R\u0001\n\u00111\u0001a\u0003\u0011\u0019w\u000e]=\u0015\u001d\u0005E\u0013\u0011NA6\u0003[\ny'!\u001d\u0002t!9a,\u0006I\u0001\u0002\u0004\u0001\u0007bB6\u0016!\u0003\u0005\r!\u001c\u0005\biV\u0001\n\u00111\u0001w\u0011!\t\t\"\u0006I\u0001\u0002\u0004\u0001\u0007\"CA\u000e+A\u0005\t\u0019AA\u0010\u0011%\t\u0019%\u0006I\u0001\u0002\u0004\ty\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e$f\u00011\u0002|-\u0012\u0011Q\u0010\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003%)hn\u00195fG.,GMC\u0002\u0002\b.\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY)!!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E%fA7\u0002|\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAALU\r1\u00181P\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!a(+\t\u0005}\u00111P\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u0003a\u0019X\r\u001e#jgRLgnZ;jg\",GMU8pi:{G-\u001a\u000b\u0006K\u0006\u001d\u00161\u0016\u0005\b\u0003Sc\u0002\u0019AA\u0013\u0003\u0011q\u0017-\\3\t\u000f\u00055F\u00041\u0001\u0002&\u0005Ia.Y7fgB\f7-\u001a\u0015\b9\u0005E\u0016qWA^!\rQ\u00151W\u0005\u0004\u0003k[%A\u00033faJ,7-\u0019;fI\u0006\u0012\u0011\u0011X\u00011!\u0006\u001c8\u000fI1sOVlWM\u001c;tAQ|\u0007eY8na&dWmU8ve\u000e,G\u0006I8sA\r|W\u000e]5mK\u001aKG.\u001a\u0018\"\u0005\u0005u\u0016!\u0002\u001a/m9\u0002\u0014!G<ji\"$\u0015n\u001d;j]\u001e,\u0018n\u001d5fIJ{w\u000e\u001e(pI\u0016$b!!\u0015\u0002D\u0006\u0015\u0007bBAU;\u0001\u0007\u0011Q\u0005\u0005\b\u0003[k\u0002\u0019AA\u0013\u0003Y\u0019X\r\u001e,bY&$\u0017\r^3E\r\u0012c5k\u00195f[\u0006\u001cHcA3\u0002L\"1\u0011Q\u001a\u0010A\u0002\u0001\fQA^1mk\u0016DsAHAY\u0003#\fY,\t\u0002\u0002T\u0006IRk]3!G>t7\u000f\u001e:vGR|'\u000fI1sOVlWM\u001c;/\u0003]9\u0018\u000e\u001e5WC2LG-\u0019;f\t\u001a#EjU2iK6\f7\u000f\u0006\u0003\u0002R\u0005e\u0007BBAg?\u0001\u0007\u0001-A\ftKR,\u0005\u0010^3s]\u0006dGI\u0012#M-\u0006\u0014\u0018.\u00192mKR9Q-a8\u0002b\u0006\r\bbBAUA\u0001\u0007\u0011Q\u0005\u0005\b\u0003[\u0003\u0003\u0019AA\u0013\u0011\u001d\ti\r\ta\u0001\u0003KAs\u0001IAY\u0003O\fY,\t\u0002\u0002j\u0006ASk]3!\t\u0006$\u0018\r\u0015:pG\u0016\u001c8o\u001c:/o&$\b.\u0012=uKJt\u0017\r\u001c,be&\f'\r\\3t]\u0005Qq-\u001a;CS:$\u0017N\\4\u0015\u000fy\fy/!=\u0002t\"9\u0011\u0011V\u0011A\u0002\u0005\u0015\u0002bBAWC\u0001\u0007\u0011Q\u0005\u0005\b\u0003\u001b\f\u0003\u0019AA\u0013)\r)\u0017q\u001f\u0005\u0007\u0003s\u0014\u0003\u0019\u0001@\u0002\u0011Y\f'/[1cY\u0016DsAIAY\u0003O\fY,\u0001\rtKR,\u0005\u0010^3s]\u0006dGI\u0012#M-\u0006\u0014\u0018.\u00192mKN$2!\u001aB\u0001\u0011\u001d\u0011\u0019a\ta\u0001\u0005\u000b\t\u0011B^1sS\u0006\u0014G.Z:\u0011\u000b\t\u001d!\u0011\u0003@\u000f\t\t%!Q\u0002\b\u0005\u0003W\u0011Y!C\u0001M\u0013\r\u0011yaS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019B!\u0006\u0003\u0007M+\u0017OC\u0002\u0003\u0010-CsaIAY\u0003O\fY,A\u000fxSRDW\t\u001f;fe:\fG\u000e\u0012$E\u0019Z\u000b'/[1cY\u0016\u001c\u0018*\u001c9m)\u0011\t\tF!\b\t\u000f\t\rA\u00051\u0001\u0003\u0006Q\u0019QM!\t\t\u000f\t\rR\u00051\u0001\u0003&\u0005YQ\r\u001f;WCJ\u001ch)\u001b7f!\u0011\u00119C!\r\u000e\u0005\t%\"\u0002\u0002B\u0016\u0005[\t!![8\u000b\u0005\t=\u0012\u0001\u00026bm\u0006LAAa\r\u0003*\t!a)\u001b7fQ\u001d)\u0013\u0011WAt\u0003w\u000b!b]3u)Vt\u0017M\u00197f)\u0015)'1\bB \u0011\u001d\u0011iD\na\u0001\u0003K\tq\u0001^;oC\ndW\rC\u0004\u0002N\u001a\u0002\r!!\n)\u000f\u0019\n\tLa\u0011\u0002<\u0006\u0012!QI\u0001\u0011+N,\u0007e^5uQR+h.\u00192mK:\n1b^5uQR+h.\u00192mKR1\u0011\u0011\u000bB&\u0005\u001bBqA!\u0010(\u0001\u0004\t)\u0003C\u0004\u0002N\u001e\u0002\r!!\n\u0002\u0017M,G\u000fV;oC\ndWm\u001d\u000b\u0004K\nM\u0003b\u0002B+Q\u0001\u0007!qK\u0001\fiVt\u0017M\u00197fg\u0006\u0013x\r\u0005\u0005\u0002(\te\u0013QEA\u0013\u0013\u0011\u0011Y&!\u000f\u0003\u00075\u000b\u0007\u000fK\u0004)\u0003c\u0013y&a/\"\u0005\t\u0005\u0014!E+tK\u0002:\u0018\u000e\u001e5Uk:\f'\r\\3t]\u0005aq/\u001b;i)Vt\u0017M\u00197fgR!\u0011\u0011\u000bB4\u0011\u001d\u0011)&\u000ba\u0001\u0005/\n1c]3u\u0007\",7m[!mYR{\u0007\u000fT3wK2$2!\u001aB7\u0011\u0019\u0011yG\u000ba\u0001A\u0006!a\r\\1hQ\u001dQ\u0013\u0011\u0017B:\u0003w\u000b#A!\u001e\u00023U\u001bX\rI<ji\"\u001c\u0005.Z2l\u00032dGk\u001c9MKZ,GNL\u0001\u0015o&$\bn\u00115fG.\fE\u000e\u001c+pa2+g/\u001a7\u0015\t\u0005E#1\u0010\u0005\u0007\u0005_Z\u0003\u0019\u00011\u0002\rI,Gn\\1e)\u0011\u0011\tIa\"\u0011\u0007A\u0013\u0019)C\u0002\u0003\u0006^\u0013Q\u0002R1uCB\u0013xnY3tg>\u0014\bb\u0002BEY\u0001\u0007!QE\u0001\fg\u00064X\r\u001a)beN,'\u000f\u0006\u0003\u0003\u0002\n5\u0005b\u0002BE[\u0001\u0007!q\u0012\t\u0005\u0005#\u0013Y*\u0004\u0002\u0003\u0014*!!Q\u0013BL\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002\u0002BM\u0005[\t1A\\5p\u0013\u0011\u0011iJa%\u0003'I+\u0017\rZ1cY\u0016\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\u0002\u0017\r|W\u000e]5mK\u001aKG.\u001a\u000b\t\u0005G\u0013IK!,\u00030B!\u00111\u000bBS\u0013\r\u00119k\u0010\u0002\u0011!J|7-Z:t_J4\u0015m\u0019;pefDqAa+/\u0001\u0004\u0011)#\u0001\u0003gS2,\u0007\"CA\u000e]A\u0005\t\u0019AA\u0010\u0011%\t\u0019E\fI\u0001\u0002\u0004\ty\"A\u000bd_6\u0004\u0018\u000e\\3GS2,G\u0005Z3gCVdG\u000f\n\u001a\u0002+\r|W\u000e]5mK\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005i1m\\7qS2,7k\\;sG\u0016$\u0002Ba)\u0003:\n\r'Q\u0019\u0005\b\u0005w\u000b\u0004\u0019\u0001B_\u00031\u00198\r[3nCN{WO]2f!\r\t&qX\u0005\u0004\u0005\u0003\u0014&\u0001\u0006#bM\u001a|G-\u001b7TG\",W.Y*pkJ\u001cW\rC\u0005\u0002\u001cE\u0002\n\u00111\u0001\u0002 !I\u00111I\u0019\u0011\u0002\u0003\u0007\u0011qD\u0001\u0018G>l\u0007/\u001b7f'>,(oY3%I\u00164\u0017-\u001e7uII\nqcY8na&dWmU8ve\u000e,G\u0005Z3gCVdG\u000fJ\u001a\u0002+\r|W\u000e]5mKN{WO]2f\u0013:$XM\u001d8bYRA!1\u0015Bh\u0005#\u0014)\u000eC\u0004\u0003<R\u0002\rA!0\t\u000f\tMG\u00071\u0001\u0002 \u0005qq\u000e\u001d;S_>$h*Y7f\u0003J<\u0007b\u0002Bli\u0001\u0007\u0011qD\u0001\u0014_B$(k\\8u\u001d\u0006lWm\u001d9bG\u0016\f%oZ\u0001\fG>l\u0007/\u001b7f\u001d>$W\r\u0006\u0004\u0003$\nu'1\u001e\u0005\b\u0005?,\u0004\u0019\u0001Bq\u0003\rAX\u000e\u001c\t\u0005\u0005G\u00149/\u0004\u0002\u0003f*\u0019!q\\&\n\t\t%(Q\u001d\u0002\u0005\u001d>$W\rC\u0005\u0003nV\u0002\n\u00111\u0001\u0003p\u0006Iq\u000e\u001d;U[B$\u0015N\u001d\t\u0006\u0015\u0006\u0005\"QE\u0001\u0016G>l\u0007/\u001b7f\u001d>$W\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)P\u000b\u0003\u0003p\u0006m\u0014\u0001C\"p[BLG.\u001a:\u0011\u0007\u0005M\u0003h\u0005\u00029\u0013R\u0011!\u0011`\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0003#\u001a\u0019\u0001C\u0004_uA\u0005\t\u0019\u00011\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE\n\u0011dY8na&dWmU8ve\u000e,7+\u001f8dQJ|g.\u001b>feRQ!1UB\u0006\u0007\u001f\u0019\tba\u0005\t\u000f\r5A\b1\u0001\u0002R\u0005\t1\rC\u0004\u0003<r\u0002\rA!0\t\u000f\u0005mA\b1\u0001\u0002 !9\u00111\t\u001fA\u0002\u0005}\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007")
public class Compiler
implements DFDL.Compiler,
Logging {
    private boolean validateDFDLSchemas;
    private DaffodilTunables tunables;
    private Queue<Binding> externalDFDLVariables;
    private boolean checkAllTopLevel;
    private Option<String> optRootName;
    private Option<String> optRootNamespace;
    private String logID;
    private Object logWriter;
    private Object logLevel;
    private volatile boolean bitmap$0;

    public static boolean apply$default$1() {
        return Compiler$.MODULE$.apply$default$1();
    }

    public static Compiler apply(boolean bl) {
        return Compiler$.MODULE$.apply(bl);
    }

    public void setLoggingLevel(LogLevel.Type level) {
        Logging.setLoggingLevel$((Logging)this, (LogLevel.Type)level);
    }

    public final LogLevel.Type getLoggingLevel() {
        return Logging.getLoggingLevel$((Logging)this);
    }

    public void setLogWriter(LogWriter lw) {
        Logging.setLogWriter$((Logging)this, (LogWriter)lw);
    }

    public LogWriter getLogWriter() {
        return Logging.getLogWriter$((Logging)this);
    }

    public final boolean areLogging(LogLevel.Type lvl) {
        return Logging.areLogging$((Logging)this, (LogLevel.Type)lvl);
    }

    public void doLogging(LogLevel.Type lvl, String msg, Seq<Object> args) {
        Logging.doLogging$((Logging)this, (LogLevel.Type)lvl, (String)msg, args);
    }

    public <S> LogLevel.Type withLoggingLevel$default$1() {
        return Logging.withLoggingLevel$default$1$((Logging)this);
    }

    private String logID$lzycompute() {
        Compiler compiler = this;
        synchronized (compiler) {
            if (!this.bitmap$0) {
                this.logID = Logging.logID$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logID;
    }

    public String logID() {
        return !this.bitmap$0 ? this.logID$lzycompute() : this.logID;
    }

    public Object logWriter() {
        return this.logWriter;
    }

    public void logWriter_$eq(Object x$1) {
        this.logWriter = x$1;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public void logLevel_$eq(Object x$1) {
        this.logLevel = x$1;
    }

    public boolean validateDFDLSchemas() {
        return this.validateDFDLSchemas;
    }

    public void validateDFDLSchemas_$eq(boolean x$1) {
        this.validateDFDLSchemas = x$1;
    }

    public DaffodilTunables tunables() {
        return this.tunables;
    }

    public void tunables_$eq(DaffodilTunables x$1) {
        this.tunables = x$1;
    }

    private Queue<Binding> externalDFDLVariables() {
        return this.externalDFDLVariables;
    }

    private void externalDFDLVariables_$eq(Queue<Binding> x$1) {
        this.externalDFDLVariables = x$1;
    }

    private boolean checkAllTopLevel() {
        return this.checkAllTopLevel;
    }

    private void checkAllTopLevel_$eq(boolean x$1) {
        this.checkAllTopLevel = x$1;
    }

    private Option<String> optRootName() {
        return this.optRootName;
    }

    private void optRootName_$eq(Option<String> x$1) {
        this.optRootName = x$1;
    }

    private Option<String> optRootNamespace() {
        return this.optRootNamespace;
    }

    private void optRootNamespace_$eq(Option<String> x$1) {
        this.optRootNamespace = x$1;
    }

    private Compiler copy(boolean validateDFDLSchemas, DaffodilTunables tunables, Queue<Binding> externalDFDLVariables, boolean checkAllTopLevel, Option<String> optRootName, Option<String> optRootNamespace) {
        return new Compiler(validateDFDLSchemas, tunables, externalDFDLVariables, checkAllTopLevel, optRootName, optRootNamespace);
    }

    private boolean copy$default$1() {
        return this.validateDFDLSchemas();
    }

    private DaffodilTunables copy$default$2() {
        return this.tunables();
    }

    private Queue<Binding> copy$default$3() {
        return this.externalDFDLVariables();
    }

    private boolean copy$default$4() {
        return this.checkAllTopLevel();
    }

    private Option<String> copy$default$5() {
        return this.optRootName();
    }

    private Option<String> copy$default$6() {
        return this.optRootNamespace();
    }

    public void setDistinguishedRootNode(String name, String namespace) {
        if (name == null) {
            throw Assert$.MODULE$.abort("Usage error: name.ne(null)");
        }
        this.optRootName_$eq((Option<String>)Option$.MODULE$.apply((Object)name));
        this.optRootNamespace_$eq((Option<String>)Option$.MODULE$.apply((Object)namespace));
    }

    public Compiler withDistinguishedRootNode(String name, String namespace) {
        if (name == null) {
            throw Assert$.MODULE$.abort("Usage error: name.ne(null)");
        }
        Option x$1 = Option$.MODULE$.apply((Object)name);
        Option x$2 = Option$.MODULE$.apply((Object)namespace);
        boolean x$3 = this.copy$default$1();
        DaffodilTunables x$4 = this.copy$default$2();
        Queue<Binding> x$5 = this.copy$default$3();
        boolean x$6 = this.copy$default$4();
        return this.copy(x$3, x$4, x$5, x$6, (Option<String>)x$1, (Option<String>)x$2);
    }

    public void setValidateDFDLSchemas(boolean value) {
        this.validateDFDLSchemas_$eq(value);
    }

    public Compiler withValidateDFDLSchemas(boolean value) {
        return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public void setExternalDFDLVariable(String name, String namespace, String value) {
        this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)this.getBinding(name, namespace, value)));
    }

    private Binding getBinding(String name, String namespace, String value) {
        String string = namespace;
        Object object = string == null ? None$.MODULE$ : new Some((Object)NS$.MODULE$.apply(namespace));
        None$ ns = object;
        Binding b = Binding$.MODULE$.apply(name, (Option)ns, value);
        return b;
    }

    public void setExternalDFDLVariable(Binding variable) {
        this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)variable));
    }

    public void setExternalDFDLVariables(Seq<Binding> variables) {
        variables.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)b));
            return BoxedUnit.UNIT;
        });
    }

    public Compiler withExternalDFDLVariablesImpl(Seq<Binding> variables) {
        ObjectRef extVars = ObjectRef.create(this.externalDFDLVariables());
        variables.foreach((Function1 & Serializable & scala.Serializable)b -> {
            extVars.elem = ((Queue)extVars.elem).enqueue((Object)b);
            return BoxedUnit.UNIT;
        });
        Queue x$1 = (Queue)extVars.elem;
        boolean x$2 = this.copy$default$1();
        DaffodilTunables x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, (Queue<Binding>)x$1, x$4, x$5, x$6);
    }

    public void setExternalDFDLVariables(File extVarsFile) {
        Queue extVars = ExternalVariablesLoader$.MODULE$.fileToBindings(extVarsFile);
        extVars.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)b));
            return BoxedUnit.UNIT;
        });
    }

    public void setTunable(String tunable, String value) {
        this.tunables_$eq(this.tunables().setTunable(tunable, value));
    }

    public Compiler withTunable(String tunable, String value) {
        DaffodilTunables x$1 = this.tunables().setTunable(tunable, value);
        boolean x$2 = this.copy$default$1();
        Queue<Binding> x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$1, x$3, x$4, x$5, x$6);
    }

    public void setTunables(Map<String, String> tunablesArg) {
        this.tunables_$eq(this.tunables().setTunables(tunablesArg));
    }

    public Compiler withTunables(Map<String, String> tunablesArg) {
        DaffodilTunables x$1 = this.tunables().setTunables(tunablesArg);
        boolean x$2 = this.copy$default$1();
        Queue<Binding> x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$1, x$3, x$4, x$5, x$6);
    }

    public void setCheckAllTopLevel(boolean flag) {
        this.checkAllTopLevel_$eq(flag);
    }

    public Compiler withCheckAllTopLevel(boolean flag) {
        boolean x$1 = flag;
        boolean x$2 = this.copy$default$1();
        DaffodilTunables x$3 = this.copy$default$2();
        Queue<Binding> x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6);
    }

    public DFDL.DataProcessor reload(File savedParser) {
        return this.reload(new FileInputStream(savedParser).getChannel());
    }

    public DFDL.DataProcessor reload(ReadableByteChannel savedParser) {
        DataProcessor dataProcessor;
        try {
            DataProcessor dp;
            ObjectInputStream objInput = new ObjectInputStream(null, savedParser){

                public Class<?> resolveClass(ObjectStreamClass desc) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(desc.getName(), false, this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException ex) {
                        clazz = super.resolveClass(desc);
                    }
                    return clazz;
                }
            };
            Object dpObj = objInput.readObject();
            objInput.close();
            dataProcessor = dp = (DataProcessor)dpObj;
        }
        catch (ZipException ex) {
            throw new InvalidParserException("The saved parser file is not the correct format.", ex);
        }
        catch (StreamCorruptedException ex) {
            throw new InvalidParserException("The saved parser file is not a valid parser.", ex);
        }
        catch (ClassNotFoundException cnf) {
            String cpString = Misc$.MODULE$.classPath().isEmpty() ? " empty." : new StringBuilder(2).append(":\n").append(Misc$.MODULE$.classPath().mkString("\n\t")).toString();
            String fmtMsg = "%s\nThe class may not exist in this Java JVM version (%s), or it is missing from the classpath which is%s";
            String msg = new StringOps(Predef$.MODULE$.augmentString(fmtMsg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cnf.getMessage(), Properties$.MODULE$.javaVersion(), cpString}));
            throw new InvalidParserException(msg, cnf);
        }
        return dataProcessor;
    }

    public ProcessorFactory compileFile(File file, Option<String> optRootName, Option<String> optRootNamespace) {
        URISchemaSource source = URISchemaSource$.MODULE$.apply(file.toURI());
        return this.compileSource((DaffodilSchemaSource)source, (Option)optRootName, (Option)optRootNamespace);
    }

    public Option<String> compileFile$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileFile$default$3() {
        return None$.MODULE$;
    }

    public ProcessorFactory compileSource(DaffodilSchemaSource schemaSource, Option<String> optRootName, Option<String> optRootNamespace) {
        return Compiler$.MODULE$.org$apache$daffodil$compiler$Compiler$$compileSourceSynchronizer(this, schemaSource, optRootName, optRootNamespace);
    }

    public Option<String> compileSource$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileSource$default$3() {
        return None$.MODULE$;
    }

    public ProcessorFactory org$apache$daffodil$compiler$Compiler$$compileSourceInternal(DaffodilSchemaSource schemaSource, Option<String> optRootNameArg, Option<String> optRootNamespaceArg) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Option rootName = optRootNameArg.orElse((Function0 & Serializable & scala.Serializable)() -> this.optRootName());
        Option rootNamespace = optRootNamespaceArg.orElse((Function0 & Serializable & scala.Serializable)() -> this.optRootNamespace());
        ProcessorFactory pf = new ProcessorFactory((Option<String>)rootName, (Option<String>)rootNamespace, this.externalDFDLVariables(), schemaSource, this.validateDFDLSchemas(), this.checkAllTopLevel(), this.tunables());
        boolean err = pf.isError();
        Seq<Diagnostic> diags = pf.getDiagnostics();
        if (err) {
            if (!diags.nonEmpty()) {
                throw Assert$.MODULE$.abort("Invariant broken: diags.nonEmpty");
            }
            LogLevel.Compile$ fresh$macro$1 = LogLevel.Compile$.MODULE$;
            int fresh$macro$2 = fresh$macro$1.lvl();
            if (this.getLoggingLevel().lvl() >= fresh$macro$2) {
                this.doLogging((LogLevel.Type)fresh$macro$1, "Compilation (ProcessorFactory) produced %d errors/warnings.", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)diags.length())}))));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (diags.nonEmpty()) {
            LogLevel.Compile$ fresh$macro$3 = LogLevel.Compile$.MODULE$;
            int fresh$macro$4 = fresh$macro$3.lvl();
            if (this.getLoggingLevel().lvl() >= fresh$macro$4) {
                this.doLogging((LogLevel.Type)fresh$macro$3, "Compilation (ProcessorFactory) produced %d warnings.", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)diags.length())}))));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            LogLevel.Compile$ fresh$macro$5 = LogLevel.Compile$.MODULE$;
            int fresh$macro$6 = fresh$macro$5.lvl();
            if (this.getLoggingLevel().lvl() >= fresh$macro$6) {
                this.doLogging((LogLevel.Type)fresh$macro$5, "ProcessorFactory completed with no errors.", (Seq<Object>)((Seq)Nil$.MODULE$));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        }
        LogLevel.Compile$ fresh$macro$7 = LogLevel.Compile$.MODULE$;
        int fresh$macro$8 = fresh$macro$7.lvl();
        if (this.getLoggingLevel().lvl() >= fresh$macro$8) {
            this.doLogging((LogLevel.Type)fresh$macro$7, "Schema had %s elements.", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)pf.elementBaseInstanceCount())}))));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return pf;
    }

    public ProcessorFactory compileNode(Node xml, Option<File> optTmpDir) {
        return this.compileSource((DaffodilSchemaSource)new UnitTestSchemaSource(xml, "anon", optTmpDir), (Option)None$.MODULE$, (Option)None$.MODULE$);
    }

    public Option<File> compileNode$default$2() {
        return None$.MODULE$;
    }

    private Compiler(boolean validateDFDLSchemas, DaffodilTunables tunables, Queue<Binding> externalDFDLVariables, boolean checkAllTopLevel, Option<String> optRootName, Option<String> optRootNamespace) {
        this.validateDFDLSchemas = validateDFDLSchemas;
        this.tunables = tunables;
        this.externalDFDLVariables = externalDFDLVariables;
        this.checkAllTopLevel = checkAllTopLevel;
        this.optRootName = optRootName;
        this.optRootNamespace = optRootNamespace;
        Logging.$init$((Logging)this);
    }

    public Compiler(boolean validateDFDLSchemas) {
        this(validateDFDLSchemas, DaffodilTunables$.MODULE$.apply(), (Queue<Binding>)Queue$.MODULE$.empty(), true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }
}

