/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.cookers;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.daffodil.cookers.EntityReplacer$;
import org.apache.daffodil.cookers.EntitySyntaxException;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.exceptions.ThrowsSDE;
import org.apache.daffodil.util.Maybe$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\tef\u0001B(Q\u0005eCQ\u0001\u0019\u0001\u0005\u0002\u0005Dq\u0001\u001a\u0001C\u0002\u0013\u0005Q\r\u0003\u0004o\u0001\u0001\u0006IA\u001a\u0005\b_\u0002\u0011\r\u0011\"\u0001f\u0011\u0019\u0001\b\u0001)A\u0005M\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\bbBA\u0012\u0001\u0001\u0006Ia\u001d\u0005\t\u0003K\u0001!\u0019!C\u0001e\"9\u0011q\u0005\u0001!\u0002\u0013\u0019\b\u0002CA\u0015\u0001\t\u0007I\u0011\u0001:\t\u000f\u0005-\u0002\u0001)A\u0005g\"I\u0011Q\u0006\u0001C\u0002\u0013\u0005\u0011q\u0006\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002\u0014!I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011q\u0006\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002\u0014!I\u0011q\u0007\u0001C\u0002\u0013\u0005\u0011q\u0006\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002\u0014!I\u00111\b\u0001C\u0002\u0013\u0005\u0011q\u0006\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002\u0014!I\u0011q\b\u0001C\u0002\u0013\u0005\u0011q\u0006\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002\u0014!I\u00111\t\u0001C\u0002\u0013\u0005\u0011Q\t\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002H!I\u0011q\u000b\u0001C\u0002\u0013\u0005\u0011Q\t\u0005\t\u00033\u0002\u0001\u0015!\u0003\u0002H!I\u00111\f\u0001C\u0002\u0013\u0005\u0011Q\t\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002H!I\u0011q\f\u0001C\u0002\u0013\u0005\u0011Q\t\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002H!I\u00111\r\u0001C\u0002\u0013\u0005\u0011Q\t\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002H!I\u0011q\r\u0001C\u0002\u0013\u0005\u0011Q\t\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002H!9\u00111\u000e\u0001\u0005\u0002\u00055\u0004bBA=\u0001\u0011%\u00111\u0010\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\u0016\u0002!\t!a&\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0003g\u0003A\u0011AA[\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!!)\u0001\t\u0003\t\t\rC\u0004\u0002,\u0002!\t!!2\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\t\u00037\u0004!\u0019!C\u0001K\"9\u0011Q\u001c\u0001!\u0002\u00131\u0007\u0002CAp\u0001\t\u0007I\u0011B3\t\u000f\u0005\u0005\b\u0001)A\u0005M\"I\u00111\u001d\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003K\u0004\u0001\u0015!\u0003\u0002\u0014!I\u0011q\u001d\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003S\u0004\u0001\u0015!\u0003\u0002\u0014!I\u00111\u001e\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003[\u0004\u0001\u0015!\u0003\u0002\u0014!I\u0011q\u001e\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003c\u0004\u0001\u0015!\u0003\u0002\u0014!9\u00111\u001f\u0001\u0005\u0002\u0005U\bbBA~\u0001\u0011\u0005\u0011Q \u0005\b\u0005\u000b\u0001A\u0011\u0002B\u0004\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001fAqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003T\u0001!IA!\u0016\t\u000f\tu\u0003\u0001\"\u0003\u0003`!I!Q\u000e\u0001\u0012\u0002\u0013%!q\u000e\u0005\b\u0005\u000b\u0003A\u0011\u0002BD\u0011\u001d\u0011Y\t\u0001C\u0001\u0005\u001bC\u0011Ba&\u0001#\u0003%\tA!'\t\u0013\tu\u0005!%A\u0005\u0002\t=\u0004\"\u0003BP\u0001E\u0005I\u0011\u0001B8\u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005G;qAa+Q\u0011\u0003\u0011iK\u0002\u0004P!\"\u0005!q\u0016\u0005\u0007A6#\tAa.\u0003\u001d\u0015sG/\u001b;z%\u0016\u0004H.Y2fe*\u0011\u0011KU\u0001\bG>|7.\u001a:t\u0015\t\u0019F+\u0001\u0005eC\u001a4w\u000eZ5m\u0015\t)f+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0006\u0019qN]4\u0004\u0001M\u0011\u0001A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0002;\u0006)1oY1mC&\u0011q\f\u0018\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0007CA2\u0001\u001b\u0005\u0001\u0016A\u00043gI2,e\u000e^5us:\u000bW.Z\u000b\u0002MB\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\u0005Y\u0006twMC\u0001l\u0003\u0011Q\u0017M^1\n\u00055D'AB*ue&tw-A\beM\u0012dWI\u001c;jift\u0015-\\3!\u0003]!g\r\u001a7DQ\u0006\u00148\t\\1tg\u0016sG/\u001b;z\u001d\u0006lW-\u0001\reM\u0012d7\t[1s\u00072\f7o]#oi&$\u0018PT1nK\u0002\na#\u001a8uSRL8\t[1sC\u000e$XM]+oS\u000e|G-Z\u000b\u0002gB\u0019A\u000f`@\u000f\u0005UThB\u0001<z\u001b\u00059(B\u0001=Y\u0003\u0019a$o\\8u}%\tQ,\u0003\u0002|9\u00069\u0001/Y2lC\u001e,\u0017BA?\u007f\u0005\u0011a\u0015n\u001d;\u000b\u0005md\u0006#C.\u0002\u0002\u0005\u0015\u0011QAA\n\u0013\r\t\u0019\u0001\u0018\u0002\u0007)V\u0004H.Z\u001a\u0011\t\u0005\u001d\u0011q\u0002\b\u0005\u0003\u0013\tY\u0001\u0005\u0002w9&\u0019\u0011Q\u0002/\u0002\rA\u0013X\rZ3g\u0013\ri\u0017\u0011\u0003\u0006\u0004\u0003\u001ba\u0006\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0006e\u0016<W\r\u001f\u0006\u0004\u0003;Q\u0017\u0001B;uS2LA!!\t\u0002\u0018\t9Q*\u0019;dQ\u0016\u0014\u0018aF3oi&$\u0018p\u00115be\u0006\u001cG/\u001a:V]&\u001cw\u000eZ3!\u0003U\u0019\u0007.\u0019:DY\u0006\u001c8OU3qY\u0006\u001cW-\\3oiN\fac\u00195be\u000ec\u0017m]:SKBd\u0017mY3nK:$8\u000fI\u0001\u0013KN\u001c\u0017\r]3SKBd\u0017mY3nK:$8/A\nfg\u000e\f\u0007/\u001a*fa2\f7-Z7f]R\u001c\b%A\tdQ\u0006\u0014XI\u001c;jif\u0004\u0016\r\u001e;fe:,\"!a\u0005\u0002%\rD\u0017M]#oi&$\u0018\u0010U1ui\u0016\u0014h\u000eI\u0001\u000bQ\u0016D\b+\u0019;uKJt\u0017a\u00035fqB\u000bG\u000f^3s]\u0002\n!\u0002Z3d!\u0006$H/\u001a:o\u0003-!Wm\u0019)biR,'O\u001c\u0011\u0002\u0017\tLH/\u001a)biR,'O\\\u0001\rEf$X\rU1ui\u0016\u0014h\u000eI\u0001\u0017G\"\f'o\u00117bgN,e\u000e^5usB\u000bG\u000f^3s]\u000692\r[1s\u00072\f7o]#oi&$\u0018\u0010U1ui\u0016\u0014h\u000eI\u0001\u0010G\"\f'/\u00128uSRL(+Z4fqV\u0011\u0011q\t\t\u0005\u0003\u0013\n\t&\u0004\u0002\u0002L)!\u0011QJA(\u0003!i\u0017\r^2iS:<'bAA\u000f9&!\u00111KA&\u0005\u0015\u0011VmZ3y\u0003A\u0019\u0007.\u0019:F]RLG/\u001f*fO\u0016D\b%\u0001\u0005iKb\u0014VmZ3y\u0003%AW\r\u001f*fO\u0016D\b%\u0001\u0005eK\u000e\u0014VmZ3y\u0003%!Wm\u0019*fO\u0016D\b%A\u0005csR,'+Z4fq\u0006Q!-\u001f;f%\u0016<W\r\u001f\u0011\u0002)\rD\u0017M]\"mCN\u001cXI\u001c;jif\u0014VmZ3y\u0003U\u0019\u0007.\u0019:DY\u0006\u001c8/\u00128uSRL(+Z4fq\u0002\nq\u0002\u001a4eY\u0016sG/\u001b;z%\u0016<W\r_\u0001\u0011I\u001a$G.\u00128uSRL(+Z4fq\u0002\nQ\u0002[1t\t\u001a$G.\u00128uSRLH\u0003BA8\u0003k\u00022aWA9\u0013\r\t\u0019\b\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\t9H\ta\u0001\u0003\u000b\tQ!\u001b8qkR\f\u0011\"[:NCR\u001c\u0007.\u001a3\u0015\r\u0005=\u0014QPA@\u0011\u001d\t9h\ta\u0001\u0003\u000bAq!!!$\u0001\u0004\t\u0019\"A\u0001n\u0003YA\u0017m\u001d#gI2\u001c\u0005.\u0019:DY\u0006\u001c8/\u00128uSRLH\u0003BA8\u0003\u000fCq!a\u001e%\u0001\u0004\t)!A\tiCN$e\r\u001a7DQ\u0006\u0014XI\u001c;jif$B!a\u001c\u0002\u000e\"9\u0011qO\u0013A\u0002\u0005\u0015\u0011a\u00055bg\u0012+7-[7bY\u000e{G-\u001a)pS:$H\u0003BA8\u0003'Cq!a\u001e'\u0001\u0004\t)!A\biCNDU\r_\"pI\u0016\u0004v.\u001b8u)\u0011\ty'!'\t\u000f\u0005]t\u00051\u0001\u0002\u0006\u0005\u0001\u0002.Y:CsR,7i\u001c3f!>Lg\u000e\u001e\u000b\u0005\u0003_\ny\nC\u0004\u0002x!\u0002\r!!\u0002\u0002\u0015I,\u0007\u000f\\1dK\"+\u0007\u0010\u0006\u0004\u0002\u0006\u0005\u0015\u0016q\u0015\u0005\b\u0003oJ\u0003\u0019AA\u0003\u0011\u001d\tI+\u000ba\u0001\u0003\u000b\ta\u0001\u001d:fM&D\u0018A\u0004:fa2\f7-\u001a#fG&l\u0017\r\u001c\u000b\u0007\u0003\u000b\ty+!-\t\u000f\u0005]$\u00061\u0001\u0002\u0006!9\u0011\u0011\u0016\u0016A\u0002\u0005\u0015\u0011\u0001\u0004:fa2\f7-\u001a\"zi\u0016\u001cHCBA\u0003\u0003o\u000bI\fC\u0004\u0002x-\u0002\r!!\u0002\t\u000f\u0005%6\u00061\u0001\u0002\u0006\u0005Y!/\u001a9mC\u000e,')\u001f;f)\u0011\t)!a0\t\u000f\u0005]D\u00061\u0001\u0002\u0006Q!\u0011QAAb\u0011\u001d\t9(\fa\u0001\u0003\u000b!B!!\u0002\u0002H\"9\u0011q\u000f\u0018A\u0002\u0005\u0015\u0011!\u0005:fa2\f7-\u001a#gI2,e\u000e^5usR!\u0011QAAg\u0011\u001d\t9h\fa\u0001\u0003\u000b\taB]3qY\u0006\u001cW-R:dCB,7\u000f\u0006\u0003\u0002\u0006\u0005M\u0007bBA<a\u0001\u0007\u0011QA\u0001\u001be\u0016\u0004H.Y2f\u0007\"\f'o\u00117bgN4uN]+oa\u0006\u00148/\u001a\u000b\u0005\u0003\u000b\tI\u000eC\u0004\u0002xE\u0002\r!!\u0002\u0002\u00175\f'o[3s\r>\u0014h\nT\u0001\r[\u0006\u00148.\u001a:G_JtE\nI\u0001\u0017[\u0006\u00148.\u001a:G_J$u.\u001e2mKB+'oY3oi\u00069R.\u0019:lKJ4uN\u001d#pk\ndW\rU3sG\u0016tG\u000fI\u0001\n\tBk\u0015\r^2iKJ\f!\u0002\u0012)NCR\u001c\u0007.\u001a:!\u0003Ii\u0017M]6fe\u001a{'\u000f\u0012)NCR\u001c\u0007.\u001a:\u0002'5\f'o[3s\r>\u0014H\tU'bi\u000eDWM\u001d\u0011\u0002\u00139cU*\u0019;dQ\u0016\u0014\u0018A\u0003(M\u001b\u0006$8\r[3sA\u0005\u0011R.\u0019:lKJ4uN\u001d(M\u001b\u0006$8\r[3s\u0003Mi\u0017M]6fe\u001a{'O\u0014'NCR\u001c\u0007.\u001a:!\u0003E\u0011X\r\u001d7bG\u00164uN]+oa\u0006\u00148/\u001a\u000b\u0005\u0003\u000b\t9\u0010C\u0004\u0002zz\u0002\r!!\u0002\u0002\u0007I\fw/A\nsKBd\u0017mY3O\u0019\u001a{'/\u00168qCJ\u001cX\r\u0006\u0004\u0002\u0006\u0005}(\u0011\u0001\u0005\b\u0003oz\u0004\u0019AA\u0003\u0011\u001d\u0011\u0019a\u0010a\u0001\u0003\u000b\t1B]3qY\u0006\u001cW-\\3oi\u0006\u00192\u000f\u001e:ja2+\u0017\rZ5oOB+'oY3oiR\u0019aM!\u0003\t\u000f\t-\u0001\t1\u0001\u0002\u0006\u0005\t1/A\u0007sKBd\u0017mY3F]RLG/\u001f\u000b\r\u0003\u000b\u0011\tB!\u0006\u0003\u001a\t=\"1\u0007\u0005\b\u0005'\t\u0005\u0019AA\u0003\u00039\u0001(o\u001c9pg\u0016$WI\u001c;jifDqAa\u0006B\u0001\u0004\t)!\u0001\u0003pe&<\u0007b\u0002B\u000e\u0003\u0002\u0007!QD\u0001\bG>tG/\u001a=u!\u0015Y&q\u0004B\u0012\u0013\r\u0011\t\u0003\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t\u0015\"1F\u0007\u0003\u0005OQ1A!\u000bS\u0003))\u0007pY3qi&|gn]\u0005\u0005\u0005[\u00119CA\u0005UQJ|wo]*E\u000b\"9!\u0011G!A\u0002\u0005=\u0014A\u00034peVs\u0007/\u0019:tK\"9!QG!A\u0002\u0005=\u0014aD1mY><()\u001f;f\u000b:$\u0018\u000e^=\u0002/\u0015\u0014(OQ1e\u000b:$\u0018\u000e^=M_:,\u0007+\u001a:dK:$H\u0003\u0003B\u001e\u0005\u0003\u0012)Ea\u0012\u0011\u0007m\u0013i$C\u0002\u0003@q\u0013A!\u00168ji\"9!1\t\"A\u0002\u0005\u0015\u0011aA3oi\"9!q\u0003\"A\u0002\u0005\u0015\u0001b\u0002B\u000e\u0005\u0002\u0007!\u0011\n\t\u0007\u0005\u0017\u0012yEa\t\u000e\u0005\t5#bAA\u000f%&!!\u0011\u000bB'\u0005\u0015i\u0015-\u001f2f\u0003I)'O\u001d\"bI\u0016sG/\u001b;z\u001d>\u001cV-\\5\u0015\u0011\tm\"q\u000bB-\u00057BqAa\u0011D\u0001\u0004\t)\u0001C\u0004\u0003\u0018\r\u0003\r!!\u0002\t\u000f\tm1\t1\u0001\u0003J\u00059\u0001O]8dKN\u001cH\u0003DA\u0003\u0005C\u0012\u0019G!\u001a\u0003h\t%\u0004bBA<\t\u0002\u0007\u0011Q\u0001\u0005\b\u0005/!\u0005\u0019AA\u0003\u0011\u001d\u0011Y\u0002\u0012a\u0001\u0005;AqA!\rE\u0001\u0004\ty\u0007C\u0005\u0003l\u0011\u0003\n\u00111\u0001\u0002p\u0005\t\u0012\r\u001c7po\nKH/Z#oi&$\u0018.Z:\u0002#A\u0014xnY3tg\u0012\"WMZ1vYR$S'\u0006\u0002\u0003r)\"\u0011q\u000eB:W\t\u0011)\b\u0005\u0003\u0003x\t\u0005UB\u0001B=\u0015\u0011\u0011YH! \u0002\u0013Ut7\r[3dW\u0016$'b\u0001B@9\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r%\u0011\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00065bg\u0012{WO\u00197f!\u0016\u00148-\u001a8u\u000b:$\u0017N\\4\u0015\t\u0005=$\u0011\u0012\u0005\b\u0003o2\u0005\u0019AA\u0003\u0003)\u0011X\r\u001d7bG\u0016\fE\u000e\u001c\u000b\u000b\u0003\u000b\u0011yI!%\u0003\u0014\nU\u0005bBA<\u000f\u0002\u0007\u0011Q\u0001\u0005\n\u000579\u0005\u0013!a\u0001\u0005;A\u0011B!\rH!\u0003\u0005\r!a\u001c\t\u0013\t-t\t%AA\u0002\u0005=\u0014\u0001\u0006:fa2\f7-Z!mY\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u001c*\"!Q\u0004B:\u0003Q\u0011X\r\u001d7bG\u0016\fE\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u0005!\"/\u001a9mC\u000e,\u0017\t\u001c7%I\u00164\u0017-\u001e7uIQ\nqA]3qY\u0006\u001cW\r\u0006\u0004\u0002\u0006\t\u0015&q\u0015\u0005\b\u0003oZ\u0005\u0019AA\u0003\u0011\u0019\u0011Ik\u0013a\u0001g\u0006)1\r[1sg\u0006qQI\u001c;jif\u0014V\r\u001d7bG\u0016\u0014\bCA2N'\ri%\u0011\u0017\t\u0006\u0005\u0017\u0012\u0019LY\u0005\u0005\u0005k\u0013iEA\u0004P]N#\u0018mY6\u0015\u0005\t5\u0006")
public final class EntityReplacer {
    private final String dfdlEntityName;
    private final String dfdlCharClassEntityName;
    private final List<Tuple3<String, String, Matcher>> entityCharacterUnicode = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"NUL", (Object)"\u0000", (Object)Pattern.compile("%NUL;", 8).matcher("")), new Tuple3((Object)"SOH", (Object)"\u0001", (Object)Pattern.compile("%SOH;", 8).matcher("")), new Tuple3((Object)"STX", (Object)"\u0002", (Object)Pattern.compile("%STX;", 8).matcher("")), new Tuple3((Object)"ETX", (Object)"\u0003", (Object)Pattern.compile("%ETX;", 8).matcher("")), new Tuple3((Object)"EOT", (Object)"\u0004", (Object)Pattern.compile("%EOT;", 8).matcher("")), new Tuple3((Object)"ENQ", (Object)"\u0005", (Object)Pattern.compile("%ENQ;", 8).matcher("")), new Tuple3((Object)"ACK", (Object)"\u0006", (Object)Pattern.compile("%ACK;", 8).matcher("")), new Tuple3((Object)"BEL", (Object)"\u0007", (Object)Pattern.compile("%BEL;", 8).matcher("")), new Tuple3((Object)"BS", (Object)"\b", (Object)Pattern.compile("%BS;", 8).matcher("")), new Tuple3((Object)"HT", (Object)"\t", (Object)Pattern.compile("%HT;", 8).matcher("")), new Tuple3((Object)"LF", (Object)"\n", (Object)Pattern.compile("%LF;", 8).matcher("")), new Tuple3((Object)"VT", (Object)"\u000b", (Object)Pattern.compile("%VT;", 8).matcher("")), new Tuple3((Object)"FF", (Object)"\f", (Object)Pattern.compile("%FF;", 8).matcher("")), new Tuple3((Object)"CR", (Object)"\r", (Object)Pattern.compile("%CR;", 8).matcher("")), new Tuple3((Object)"SO", (Object)"\u000e", (Object)Pattern.compile("%SO;", 8).matcher("")), new Tuple3((Object)"SI", (Object)"\u000f", (Object)Pattern.compile("%SI;", 8).matcher("")), new Tuple3((Object)"DLE", (Object)"\u0010", (Object)Pattern.compile("%DLE;", 8).matcher("")), new Tuple3((Object)"DC1", (Object)"\u0011", (Object)Pattern.compile("%DC1;", 8).matcher("")), new Tuple3((Object)"DC2", (Object)"\u0012", (Object)Pattern.compile("%DC2;", 8).matcher("")), new Tuple3((Object)"DC3", (Object)"\u0013", (Object)Pattern.compile("%DC3;", 8).matcher("")), new Tuple3((Object)"DC4", (Object)"\u0014", (Object)Pattern.compile("%DC4;", 8).matcher("")), new Tuple3((Object)"NAK", (Object)"\u0015", (Object)Pattern.compile("%NAK;", 8).matcher("")), new Tuple3((Object)"SYN", (Object)"\u0016", (Object)Pattern.compile("%SYN;", 8).matcher("")), new Tuple3((Object)"ETB", (Object)"\u0017", (Object)Pattern.compile("%ETB;", 8).matcher("")), new Tuple3((Object)"CAN", (Object)"\u0018", (Object)Pattern.compile("%CAN;", 8).matcher("")), new Tuple3((Object)"EM", (Object)"\u0019", (Object)Pattern.compile("%EM;", 8).matcher("")), new Tuple3((Object)"SUB", (Object)"\u001a", (Object)Pattern.compile("%SUB;", 8).matcher("")), new Tuple3((Object)"ESC", (Object)"\u001b", (Object)Pattern.compile("%ESC;", 8).matcher("")), new Tuple3((Object)"FS", (Object)"\u001c", (Object)Pattern.compile("%FS;", 8).matcher("")), new Tuple3((Object)"GS", (Object)"\u001d", (Object)Pattern.compile("%GS;", 8).matcher("")), new Tuple3((Object)"RS", (Object)"\u001e", (Object)Pattern.compile("%RS;", 8).matcher("")), new Tuple3((Object)"US", (Object)"\u001f", (Object)Pattern.compile("%US;", 8).matcher("")), new Tuple3((Object)"SP", (Object)" ", (Object)Pattern.compile("%SP;", 8).matcher("")), new Tuple3((Object)"DEL", (Object)"\u007f", (Object)Pattern.compile("%DEL;", 8).matcher("")), new Tuple3((Object)"NBSP", (Object)"\u00a0", (Object)Pattern.compile("%NBSP;", 8).matcher("")), new Tuple3((Object)"NEL", (Object)"\u0085", (Object)Pattern.compile("%NEL;", 8).matcher("")), new Tuple3((Object)"LS", (Object)"\u2028", (Object)Pattern.compile("%LS;", 8).matcher(""))}));
    private final List<Tuple3<String, String, Matcher>> charClassReplacements = new .colon.colon((Object)new Tuple3((Object)"WSP", (Object)" ", (Object)Pattern.compile("%WSP;", 8).matcher("")), (List)new .colon.colon((Object)new Tuple3((Object)"WSP*", (Object)"", (Object)Pattern.compile("%WSP\\*;", 8).matcher("")), (List)new .colon.colon((Object)new Tuple3((Object)"WSP+", (Object)" ", (Object)Pattern.compile("%WSP\\+;", 8).matcher("")), (List)new .colon.colon((Object)new Tuple3((Object)"ES", (Object)"", (Object)Pattern.compile("%ES;", 8).matcher("")), (List)Nil$.MODULE$))));
    private final List<Tuple3<String, String, Matcher>> escapeReplacements = new .colon.colon((Object)new Tuple3((Object)"%", (Object)"%", (Object)Pattern.compile("%%", 8).matcher("")), (List)Nil$.MODULE$);
    private final Matcher charEntityPattern = Pattern.compile(new StringBuilder(4).append("%(").append(this.dfdlEntityName()).append(");").toString(), 8).matcher("");
    private final Matcher hexPattern = Pattern.compile("%#x[0-9a-fA-F]+;", 8).matcher("");
    private final Matcher decPattern = Pattern.compile("%#[0-9]+;", 8).matcher("");
    private final Matcher bytePattern = Pattern.compile("%#r[0-9a-fA-F]{2};", 8).matcher("");
    private final Matcher charClassEntityPattern = Pattern.compile(new StringBuilder(4).append("%(").append(this.dfdlCharClassEntityName()).append(");").toString(), 8).matcher("");
    private final Regex charEntityRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(12).append("(%(?:").append(this.dfdlEntityName()).append(");)(.*)").toString())).r();
    private final Regex hexRegex = new StringOps(Predef$.MODULE$.augmentString("(%#x[0-9a-fA-F]+;)(.*)")).r();
    private final Regex decRegex = new StringOps(Predef$.MODULE$.augmentString("(%#[0-9]+;)(.*)")).r();
    private final Regex byteRegex = new StringOps(Predef$.MODULE$.augmentString("(%#r[0-9a-fA-F]{2};)(.*)")).r();
    private final Regex charClassEntityRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(12).append("(%(?:").append(this.dfdlCharClassEntityName()).append(");)(.*)").toString())).r();
    private final Regex dfdlEntityRegex = new StringOps(Predef$.MODULE$.augmentString("(%[^%]*?;)(.*)")).r();
    private final String markerForNL;
    private final String markerForDoublePercent;
    private final Matcher DPMatcher = Pattern.compile("(?<!%)%%", 8).matcher("");
    private final Matcher markerForDPMatcher = Pattern.compile(this.markerForDoublePercent(), 8).matcher("");
    private final Matcher NLMatcher = Pattern.compile("%NL;", 8).matcher("");
    private final Matcher markerForNLMatcher = Pattern.compile(this.markerForNL(), 8).matcher("");

    public static <R> R apply(Function1<EntityReplacer, R> function1) {
        return EntityReplacer$.MODULE$.apply(function1);
    }

    public String dfdlEntityName() {
        return this.dfdlEntityName;
    }

    public String dfdlCharClassEntityName() {
        return this.dfdlCharClassEntityName;
    }

    public List<Tuple3<String, String, Matcher>> entityCharacterUnicode() {
        return this.entityCharacterUnicode;
    }

    public List<Tuple3<String, String, Matcher>> charClassReplacements() {
        return this.charClassReplacements;
    }

    public List<Tuple3<String, String, Matcher>> escapeReplacements() {
        return this.escapeReplacements;
    }

    public Matcher charEntityPattern() {
        return this.charEntityPattern;
    }

    public Matcher hexPattern() {
        return this.hexPattern;
    }

    public Matcher decPattern() {
        return this.decPattern;
    }

    public Matcher bytePattern() {
        return this.bytePattern;
    }

    public Matcher charClassEntityPattern() {
        return this.charClassEntityPattern;
    }

    public Regex charEntityRegex() {
        return this.charEntityRegex;
    }

    public Regex hexRegex() {
        return this.hexRegex;
    }

    public Regex decRegex() {
        return this.decRegex;
    }

    public Regex byteRegex() {
        return this.byteRegex;
    }

    public Regex charClassEntityRegex() {
        return this.charClassEntityRegex;
    }

    public Regex dfdlEntityRegex() {
        return this.dfdlEntityRegex;
    }

    public boolean hasDfdlEntity(String input) {
        return this.hasDfdlCharEntity(input) || this.hasDecimalCodePoint(input) || this.hasHexCodePoint(input) || this.hasByteCodePoint(input) || this.hasDfdlCharClassEntity(input);
    }

    private boolean isMatched(String input, Matcher m) {
        m.reset(input);
        return m.find();
    }

    public boolean hasDfdlCharClassEntity(String input) {
        return this.isMatched(input, this.charClassEntityPattern());
    }

    public boolean hasDfdlCharEntity(String input) {
        return this.isMatched(input, this.charEntityPattern());
    }

    public boolean hasDecimalCodePoint(String input) {
        return this.isMatched(input, this.decPattern());
    }

    public boolean hasHexCodePoint(String input) {
        return this.isMatched(input, this.hexPattern());
    }

    public boolean hasByteCodePoint(String input) {
        return this.isMatched(input, this.bytePattern());
    }

    /*
     * WARNING - void declaration
     */
    public String replaceHex(String input, String prefix) {
        void var3_3;
        String res = input;
        while (this.hasHexCodePoint(res)) {
            String newChar;
            Matcher m = this.hexPattern();
            m.reset(res);
            if (!m.find()) continue;
            String rawStr = m.group().toString();
            String trimmedStr = rawStr.replace(prefix, "").replace(";", "");
            int intStr = Integer.parseInt(trimmedStr, 16);
            String string = newChar = Character.toString((char)intStr);
            String string2 = "$";
            String newCharNotDollar = !(string != null ? !string.equals(string2) : string2 != null) ? "\\$" : newChar;
            res = res.replaceAll(rawStr, newCharNotDollar);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String replaceDecimal(String input, String prefix) {
        void var3_3;
        String res = input;
        while (this.hasDecimalCodePoint(res)) {
            Matcher m = this.decPattern();
            m.reset(res);
            if (!m.find()) continue;
            String rawStr = m.group().toString();
            String trimmedStr = rawStr.replace(prefix, "").replace(";", "");
            int intStr = Integer.parseInt(trimmedStr, 10);
            res = res.replaceAll(rawStr, Character.toString((char)intStr));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String replaceBytes(String input, String prefix) {
        void var3_3;
        String res = input;
        while (this.hasByteCodePoint(res)) {
            Matcher m = this.bytePattern();
            m.reset(res);
            if (!m.find()) continue;
            String rawStr = m.group().toString();
            String trimmedStr = rawStr.replace(prefix, "").replace(";", "");
            int upperNibble = Byte.parseByte(trimmedStr.substring(0, 1), 16) << 4;
            Byte lowerNibble = Predef$.MODULE$.byte2Byte(Byte.parseByte(trimmedStr.substring(1, 2), 16));
            int byteStr = upperNibble | Predef$.MODULE$.Byte2byte(lowerNibble);
            res = res.replaceAll(rawStr, Character.toString((char)byteStr));
        }
        return var3_3;
    }

    public String replaceByte(String input) {
        return this.replaceBytes(input, "%#r");
    }

    public String replaceHex(String input) {
        return this.replaceHex(input, "%#x");
    }

    public String replaceDecimal(String input) {
        return this.replaceDecimal(input, "%#");
    }

    public String replaceDfdlEntity(String input) {
        return this.replace(input, this.entityCharacterUnicode());
    }

    public String replaceEscapes(String input) {
        return this.replace(input, this.escapeReplacements());
    }

    public String replaceCharClassForUnparse(String input) {
        return this.replace(input, this.charClassReplacements());
    }

    public String markerForNL() {
        return this.markerForNL;
    }

    private String markerForDoublePercent() {
        return this.markerForDoublePercent;
    }

    private Matcher DPMatcher() {
        return this.DPMatcher;
    }

    private Matcher markerForDPMatcher() {
        return this.markerForDPMatcher;
    }

    private Matcher NLMatcher() {
        return this.NLMatcher;
    }

    private Matcher markerForNLMatcher() {
        return this.markerForNLMatcher;
    }

    public String replaceForUnparse(String raw) {
        this.markerForDPMatcher().reset(raw);
        if (this.markerForDPMatcher().find()) {
            throw Assert$.MODULE$.abort2(new StringBuilder(35).append("Usage error: ").append("string cannot contain ").append(this.markerForDPMatcher()).toString(), "EntityReplacer.this.markerForDPMatcher.find().unary_!");
        }
        this.markerForNLMatcher().reset(raw);
        if (this.markerForNLMatcher().find()) {
            throw Assert$.MODULE$.abort2(new StringBuilder(35).append("Usage error: ").append("string cannot contain ").append(this.markerForNL()).toString(), "EntityReplacer.this.markerForNLMatcher.find().unary_!");
        }
        this.DPMatcher().reset(raw);
        String dpMarked = this.DPMatcher().replaceAll(this.markerForDoublePercent());
        String forUnp = this.replaceAll(dpMarked, (Option<ThrowsSDE>)None$.MODULE$, true, this.replaceAll$default$4());
        this.NLMatcher().reset(forUnp);
        String nlMarked = this.NLMatcher().replaceAll(this.markerForNL());
        String s2 = nlMarked.replaceAll(this.markerForDoublePercent(), "%");
        return s2;
    }

    public String replaceNLForUnparse(String input, String replacement) {
        this.markerForNLMatcher().reset(input);
        String a = this.markerForNLMatcher().replaceAll(replacement);
        this.markerForDPMatcher().reset(a);
        String b = this.markerForDPMatcher().replaceAll("%");
        return b;
    }

    private String stripLeadingPercent(String s) {
        return s.startsWith("%") ? s.substring(1) : s;
    }

    private String replaceEntity(String proposedEntity, String orig, Option<ThrowsSDE> context, boolean forUnparse, boolean allowByteEntity) {
        String string;
        String string2 = proposedEntity;
        Option option = this.charClassEntityRegex().unapplySeq((CharSequence)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            string = forUnparse ? this.replaceCharClassForUnparse(proposedEntity) : proposedEntity;
        } else {
            Option option2 = this.hexRegex().unapplySeq((CharSequence)string2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                string = this.replaceHex(proposedEntity);
            } else {
                Option option3 = this.decRegex().unapplySeq((CharSequence)string2);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                    string = this.replaceDecimal(proposedEntity);
                } else {
                    Option option4 = this.byteRegex().unapplySeq((CharSequence)string2);
                    if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(2) == 0) {
                        String string3;
                        if (allowByteEntity) {
                            string3 = this.replaceByte(proposedEntity);
                        } else {
                            String msg = "DFDL Byte Entity (%%%s) is not allowed, but was found in \"%s\"";
                            string3 = (String)context.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.SDE(msg, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(proposedEntity), orig}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                throw new EntitySyntaxException(new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(proposedEntity), orig})));
                            });
                        }
                        string = string3;
                    } else {
                        Option option5 = this.charEntityRegex().unapplySeq((CharSequence)string2);
                        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(2) == 0) {
                            string = this.replace(proposedEntity, this.entityCharacterUnicode());
                        } else {
                            Option option6 = this.dfdlEntityRegex().unapplySeq((CharSequence)string2);
                            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(2) == 0) {
                                String invalidEntity = (String)((LinearSeqOptimized)option6.get()).apply(0);
                                String msg = "Invalid DFDL Entity (%%%s) found in \"%s\"";
                                string = (String)context.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.SDE(msg, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(invalidEntity), orig}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                    throw new EntitySyntaxException(new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(invalidEntity), orig})));
                                });
                            } else {
                                string = string2;
                            }
                        }
                    }
                }
            }
        }
        String result = string;
        return result;
    }

    private void errBadEntityLonePercent(String ent, String orig, Object context) {
        String msg = new StringOps(Predef$.MODULE$.augmentString("Invalid DFDL Entity (%s) found in \"%s\". If a single percent was intended instead of a DFDL Entity, it must be self escaped (%%%%).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ent, orig}));
        if (Maybe$.MODULE$.isDefined$extension(context)) {
            throw ((ThrowsSDE)Maybe$.MODULE$.get$extension(context)).SDE(msg, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new EntitySyntaxException(msg);
    }

    private void errBadEntityNoSemi(String ent, String orig, Object context) {
        String msg = new StringOps(Predef$.MODULE$.augmentString("Invalid DFDL Entity (%%%s) found in \"%s\". Missing semicolon at end of entity name?")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(ent), orig}));
        if (Maybe$.MODULE$.isDefined$extension(context)) {
            throw ((ThrowsSDE)Maybe$.MODULE$.get$extension(context)).SDE(msg, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new EntitySyntaxException(msg);
    }

    private String process(String input, String orig, Option<ThrowsSDE> context, boolean forUnparse, boolean allowByteEntities) {
        if (input.contains("%%")) {
            throw Assert$.MODULE$.abort("Usage error: input.contains(\"%%\").unary_!");
        }
        if (!input.contains("%")) {
            return input;
        }
        if (input.equals("%")) {
            this.errBadEntityLonePercent(input, orig, Maybe$.MODULE$.toMaybe(context));
        }
        String[] tokens = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])input.split("%"))).$plus$plus((GenTraversableOnce)(input.endsWith("%") ? new .colon.colon((Object)"", (List)Nil$.MODULE$) : Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String startingToken = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).head();
        String[] possibleEntityTokens = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).tail();
        String[] tokens2 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])possibleEntityTokens)).map((Function1 & Serializable & scala.Serializable)tok -> {
            if (tok.contains("%")) {
                throw Assert$.MODULE$.abort("Invariant broken: tok.contains(\"%\").unary_!");
            }
            if (!tok.contains(";")) {
                this.errBadEntityNoSemi((String)tok, orig, Maybe$.MODULE$.toMaybe(context));
            }
            int semiPos = tok.indexOf(";");
            String possibleEntityName = tok.substring(0, semiPos);
            String afterEntity = tok.substring(semiPos + 1);
            String newEntity = this.replaceEntity(new StringBuilder(2).append("%").append(possibleEntityName).append(";").toString(), orig, context, forUnparse, allowByteEntities);
            String res = new StringBuilder(0).append(newEntity).append(afterEntity).toString();
            return res;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String output = new StringBuilder(0).append(startingToken).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens2)).mkString()).toString();
        return output;
    }

    private boolean process$default$5() {
        return true;
    }

    private boolean hasDoublePercentEnding(String input) {
        String string = input;
        String string2 = "";
        return !(string == null ? string2 != null : !string.equals(string2)) || input.length() < 2 ? false : input.charAt(input.length() - 2) == '%' && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(input)).last()) == '%';
    }

    public String replaceAll(String input, Option<ThrowsSDE> context, boolean forUnparse, boolean allowByteEntities) {
        if (!input.contains("%")) {
            return input;
        }
        int startOfPossibleEntity = input.indexOf("%");
        String inputUntilPossibleEntity = input.substring(0, startOfPossibleEntity);
        String inputWithPossibleEntity = input.substring(startOfPossibleEntity);
        if (!inputWithPossibleEntity.contains("%%")) {
            String processedInput = this.process(inputWithPossibleEntity, input, context, forUnparse, allowByteEntities);
            String fullResult = new StringBuilder(0).append(inputUntilPossibleEntity).append(processedInput).toString();
            return fullResult;
        }
        boolean endedWithDoublePercent = this.hasDoublePercentEnding(inputWithPossibleEntity);
        String[] splitByDoublePercent = inputWithPossibleEntity.split("%%");
        String[] replaced = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitByDoublePercent)).map((Function1 & Serializable & scala.Serializable)token -> this.process((String)token, input, context, forUnparse, this.process$default$5()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String replacementForDoublePercents = forUnparse ? "%" : "%%";
        String recomposedWithLiteralPercents = new StringBuilder(0).append(inputUntilPossibleEntity).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replaced)).mkString(replacementForDoublePercents)).append((Object)(endedWithDoublePercent ? replacementForDoublePercents : "")).toString();
        return recomposedWithLiteralPercents;
    }

    private String replace(String input, List<Tuple3<String, String, Matcher>> chars) {
        ObjectRef res = ObjectRef.create((Object)input);
        chars.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            EntityReplacer.$anonfun$replace$1(res, x0$1);
            return BoxedUnit.UNIT;
        });
        return (String)res.elem;
    }

    public Option<ThrowsSDE> replaceAll$default$2() {
        return None$.MODULE$;
    }

    public boolean replaceAll$default$3() {
        return false;
    }

    public boolean replaceAll$default$4() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$replace$1(ObjectRef res$1, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String unicode = (String)tuple3._2();
        Matcher m = (Matcher)tuple3._3();
        m.reset((String)res$1.elem);
        res$1.elem = m.replaceAll(unicode);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public EntityReplacer() {
        this.dfdlEntityName = "NUL|SOH|STX|ETX|EOT|ENQ|ACK|BEL|BS|HT|LF|VT|FF|CR|SO|SI|DLE|DC[1-4]|NAK|SYN|ETB|CAN|EM|SUB|ESC|FS|GS|RS|US|SP|DEL|NBSP|NEL|LS";
        this.dfdlCharClassEntityName = "NL|WSP|WSP\\*|WSP\\+|ES";
        this.markerForNL = "\ufffc__NL_ENTITY__\ufffc";
        this.markerForDoublePercent = "\ufffc__DOUBLE_PERCENT__\ufffc";
    }
}

