/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.metrics;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpageMetric;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import java.util.List;
import java.util.function.Function;

public final class NettyPooledAllocatorMetrics
implements MeterBinder {
    private static final String BYTES_UNIT = "bytes";
    private final PooledByteBufAllocatorMetric metric;
    private final Tags commonTags;

    public NettyPooledAllocatorMetrics(PooledByteBufAllocatorMetric pooledAllocatorMetric, Tags commonTags) {
        this.metric = pooledAllocatorMetric;
        this.commonTags = commonTags;
    }

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)"netty.pooled.used.memory", (Object)this.metric, metric -> metric.usedDirectMemory()).tags((Iterable)this.commonTags).tags(new String[]{"type", "direct"}).description("The used memory").baseUnit(BYTES_UNIT).register(registry);
        Gauge.builder((String)"netty.pooled.used.memory", (Object)this.metric, metric -> metric.usedHeapMemory()).tags((Iterable)this.commonTags).tags(new String[]{"type", "heap"}).description("The used memory").baseUnit(BYTES_UNIT).register(registry);
        Gauge.builder((String)"netty.pooled.arenas.num", (Object)this.metric, metric -> metric.numDirectArenas()).tags((Iterable)this.commonTags).tags(new String[]{"type", "direct"}).description("The number of arenas").register(registry);
        Gauge.builder((String)"netty.pooled.arenas.num", (Object)this.metric, metric -> metric.numHeapArenas()).tags((Iterable)this.commonTags).tags(new String[]{"type", "heap"}).description("The number or arenas").register(registry);
        Gauge.builder((String)"netty.pooled.cachesize", (Object)this.metric, metric -> metric.tinyCacheSize()).tags((Iterable)this.commonTags).tags(new String[]{"type", "tiny"}).description("The cachesize used by this netty allocator").register(registry);
        Gauge.builder((String)"netty.pooled.cachesize", (Object)this.metric, metric -> metric.smallCacheSize()).tags((Iterable)this.commonTags).tags(new String[]{"type", "small"}).description("The cachesize used by this netty allocator").register(registry);
        Gauge.builder((String)"netty.pooled.cachesize", (Object)this.metric, metric -> metric.normalCacheSize()).tags((Iterable)this.commonTags).tags(new String[]{"type", "normal"}).description("The cachesize used by this netty allocator").register(registry);
        Gauge.builder((String)"netty.pooled.threadlocalcache.num", (Object)this.metric, metric -> metric.numThreadLocalCaches()).tags((Iterable)this.commonTags).description("The number of thread local caches used by this netty allocator").register(registry);
        Gauge.builder((String)"netty.pooled.chunk.size", (Object)this.metric, metric -> metric.chunkSize()).tags((Iterable)this.commonTags).description("The arena chunk size of this netty allocator").baseUnit(BYTES_UNIT).register(registry);
        int i = 0;
        for (PoolArenaMetric poolArenaMetric : this.metric.directArenas()) {
            this.metricsOfPoolArena(registry, poolArenaMetric, i++, "direct");
        }
        i = 0;
        for (PoolArenaMetric poolArenaMetric : this.metric.heapArenas()) {
            this.metricsOfPoolArena(registry, poolArenaMetric, i++, "heap");
        }
    }

    private void metricsOfPoolArena(MeterRegistry registry, PoolArenaMetric poolArenaMetric, int poolArenaIndex, String poolArenaType) {
        String poolArenaIndexString = Integer.toString(poolArenaIndex);
        Gauge.builder((String)"netty.pooled.arena.threadcaches.num", (Object)poolArenaMetric, metric -> metric.numThreadCaches()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString}).description("The number of thread caches backed by this arena").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.allocations.num", (Object)poolArenaMetric, metric -> metric.numAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "all"}).description("The number of allocations done via the arena. This includes all sizes").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.allocations.num", (Object)poolArenaMetric, metric -> metric.numTinyAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "tiny"}).description("The number of tiny allocations done via the arena").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.allocations.num", (Object)poolArenaMetric, metric -> metric.numSmallAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "small"}).description("The number of small allocations done via the arena").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.allocations.num", (Object)poolArenaMetric, metric -> metric.numNormalAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "normal"}).description("The number of normal allocations done via the arena").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.allocations.num", (Object)poolArenaMetric, metric -> metric.numHugeAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "huge"}).description("The number of huge allocations done via the arena").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.deallocations.num", (Object)poolArenaMetric, metric -> metric.numDeallocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "all"}).description("The number of deallocations done via the arena. This includes all sizes").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.deallocations.num", (Object)poolArenaMetric, metric -> metric.numTinyDeallocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "tiny"}).description("The number of tiny deallocations done via the arena").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.deallocations.num", (Object)poolArenaMetric, metric -> metric.numSmallDeallocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "small"}).description("The number of small deallocations done via the arena").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.deallocations.num", (Object)poolArenaMetric, metric -> metric.numNormalDeallocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "normal"}).description("The number of normal deallocations done via the arena").register(registry);
        FunctionCounter.builder((String)"netty.pooled.arena.deallocations.num", (Object)poolArenaMetric, metric -> metric.numHugeDeallocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "huge"}).description("The number of huge deallocations done via the arena").register(registry);
        Gauge.builder((String)"netty.pooled.arena.active.allocations.num", (Object)poolArenaMetric, metric -> metric.numActiveAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "all"}).description("The number of currently active allocations").register(registry);
        Gauge.builder((String)"netty.pooled.arena.active.allocations.num", (Object)poolArenaMetric, metric -> metric.numActiveTinyAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "tiny"}).description("The number of currently active tiny allocations").register(registry);
        Gauge.builder((String)"netty.pooled.arena.active.allocations.num", (Object)poolArenaMetric, metric -> metric.numActiveSmallAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "small"}).description("The number of currently active small allocations").register(registry);
        Gauge.builder((String)"netty.pooled.arena.active.allocations.num", (Object)poolArenaMetric, metric -> metric.numActiveNormalAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "normal"}).description("The number of currently active normal allocations").register(registry);
        Gauge.builder((String)"netty.pooled.arena.active.allocations.num", (Object)poolArenaMetric, metric -> metric.numActiveHugeAllocations()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "huge"}).description("The number of currently active huge allocations").register(registry);
        Gauge.builder((String)"netty.pooled.arena.active.allocated.num", (Object)poolArenaMetric, metric -> metric.numActiveBytes()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString}).description("The number of active bytes that are currently allocated by the arena").baseUnit(BYTES_UNIT).register(registry);
        Gauge.builder((String)"netty.pooled.arena.chunk.num", (Object)poolArenaMetric, metric -> metric.numChunkLists()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString}).description("The number of chunk lists for the arena").register(registry);
        Gauge.builder((String)"netty.pooled.arena.subpages.num", (Object)poolArenaMetric, metric -> metric.numTinySubpages()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "tiny"}).description("The number of tiny sub-pages for the arena").register(registry);
        Gauge.builder((String)"netty.pooled.arena.subpages.num", (Object)poolArenaMetric, metric -> metric.numSmallSubpages()).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndexString, "size", "small"}).description("The number of small sub-pages for the arena").register(registry);
        List poolChunkListMetrics = poolArenaMetric.chunkLists();
        assert (poolChunkListMetrics.size() == 6);
        for (PoolChunkListMetric poolChunkListMetric : poolChunkListMetrics) {
            String poolChunkListType = NettyPooledAllocatorMetrics.usageTypeOf(poolChunkListMetric);
            this.metricsOfPoolChunkListMetric(registry, poolChunkListMetric, poolArenaIndexString, poolArenaType, poolChunkListType);
        }
        this.metricsOfPoolSubpageMetric(registry, poolArenaMetric, PoolArenaMetric::smallSubpages, poolArenaIndexString, poolArenaType, "small");
        this.metricsOfPoolSubpageMetric(registry, poolArenaMetric, PoolArenaMetric::tinySubpages, poolArenaIndexString, poolArenaType, "tiny");
    }

    private void metricsOfPoolSubpageMetric(MeterRegistry registry, PoolArenaMetric poolArenaMetric, Function<? super PoolArenaMetric, List<PoolSubpageMetric>> poolSubpageMetricProvider, String poolArenaIndex, String poolArenaType, String size) {
        Gauge.builder((String)"netty.pooled.arena.subpages.count", (Object)poolArenaMetric, metric -> {
            long total = 0L;
            for (PoolSubpageMetric poolSubpageMetric : (List)poolSubpageMetricProvider.apply((PoolArenaMetric)metric)) {
                ++total;
            }
            return total;
        }).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndex, "size", size}).description("The total count of subpages").register(registry);
        Gauge.builder((String)"netty.pooled.arena.subpages.elementsize", (Object)poolArenaMetric, metric -> {
            long total = 0L;
            for (PoolSubpageMetric poolSubpageMetric : (List)poolSubpageMetricProvider.apply((PoolArenaMetric)metric)) {
                total += (long)poolSubpageMetric.elementSize();
            }
            return total;
        }).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndex, "size", size}).description("The total size (in bytes) of the elements that will be allocated").baseUnit(BYTES_UNIT).register(registry);
        Gauge.builder((String)"netty.pooled.arena.subpages.maxnumelements", (Object)poolArenaMetric, metric -> {
            long total = 0L;
            for (PoolSubpageMetric poolSubpageMetric : (List)poolSubpageMetricProvider.apply((PoolArenaMetric)metric)) {
                total += (long)poolSubpageMetric.maxNumElements();
            }
            return total;
        }).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndex, "size", size}).description("The total number of maximal elements that can be allocated out of the sub-page.").register(registry);
        Gauge.builder((String)"netty.pooled.arena.subpages.numavailable", (Object)poolArenaMetric, metric -> {
            long total = 0L;
            for (PoolSubpageMetric poolSubpageMetric : (List)poolSubpageMetricProvider.apply((PoolArenaMetric)metric)) {
                total += (long)poolSubpageMetric.numAvailable();
            }
            return total;
        }).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndex, "size", size}).description("The total number of available elements to be allocated").register(registry);
        Gauge.builder((String)"netty.pooled.arena.subpages.pagesize", (Object)poolArenaMetric, metric -> {
            long total = 0L;
            for (PoolSubpageMetric poolSubpageMetric : (List)poolSubpageMetricProvider.apply((PoolArenaMetric)metric)) {
                total += (long)poolSubpageMetric.pageSize();
            }
            return total;
        }).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndex, "size", size}).description("The total size (in bytes) of the pages").baseUnit(BYTES_UNIT).register(registry);
    }

    private static String usageTypeOf(PoolChunkListMetric metric) {
        StringBuilder builder = new StringBuilder("75~100%".length());
        int minUsage = metric.minUsage();
        if (minUsage <= 1) {
            minUsage = 0;
        }
        builder.append(minUsage);
        int maxUsage = metric.maxUsage();
        if (maxUsage != minUsage) {
            builder.append('~').append(maxUsage);
        }
        builder.append('%');
        return builder.toString();
    }

    private void metricsOfPoolChunkListMetric(MeterRegistry registry, PoolChunkListMetric poolChunkListMetrics, String poolArenaIndex, String poolArenaType, String poolChunkListType) {
        Gauge.builder((String)"netty.pooled.arena.chunk.list.capacity", (Object)poolChunkListMetrics, metric -> {
            long total = 0L;
            for (PoolChunkMetric poolChunkMetric : poolChunkListMetrics) {
                total += (long)poolChunkMetric.chunkSize();
            }
            return total;
        }).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndex, "pool_chunk_list_type", poolChunkListType}).description("The total capacity in bytes of the chunks in the list").baseUnit(BYTES_UNIT).register(registry);
        Gauge.builder((String)"netty.pooled.arena.chunk.list.free", (Object)poolChunkListMetrics, metric -> {
            long total = 0L;
            for (PoolChunkMetric poolChunkMetric : poolChunkListMetrics) {
                total += (long)poolChunkMetric.freeBytes();
            }
            return total;
        }).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndex, "pool_chunk_list_type", poolChunkListType}).description("The total free bytes of the chunks in the list").baseUnit(BYTES_UNIT).register(registry);
        Gauge.builder((String)"netty.pooled.arena.chunk.list.count", (Object)poolChunkListMetrics, metric -> {
            long total = 0L;
            for (PoolChunkMetric poolChunkMetric : poolChunkListMetrics) {
                ++total;
            }
            return total;
        }).tags((Iterable)this.commonTags).tags(new String[]{"pool_arena_type", poolArenaType, "pool_arena_index", poolArenaIndex, "pool_chunk_list_type", poolChunkListType}).description("The number of chunks in the list").register(registry);
    }
}

