/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.common;

import org.apache.cxf.rs.security.jose.common.AbstractJoseConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jwt.JwtException;

public class JoseConsumer
extends AbstractJoseConsumer {
    public String getData(String data) {
        super.checkProcessRequirements();
        if (this.isJweRequired()) {
            JweCompactConsumer jweConsumer = new JweCompactConsumer(data);
            JweDecryptionProvider theDecryptor = this.getInitializedDecryptionProvider(jweConsumer.getJweHeaders());
            if (theDecryptor == null) {
                throw new JwtException("Unable to decrypt JWT");
            }
            if (!this.isJwsRequired()) {
                return jweConsumer.getDecryptedContentText(theDecryptor);
            }
            JweDecryptionOutput decOutput = theDecryptor.decrypt(data);
            data = decOutput.getContentText();
        }
        JwsCompactConsumer jwsConsumer = new JwsCompactConsumer(data);
        if (this.isJwsRequired()) {
            JwsSignatureVerifier theSigVerifier = this.getInitializedSignatureVerifier(jwsConsumer.getJwsHeaders());
            if (theSigVerifier == null) {
                throw new JwtException("Unable to validate JWT");
            }
            if (!jwsConsumer.verifySignatureWith(theSigVerifier)) {
                throw new JwtException("Invalid Signature");
            }
        }
        return jwsConsumer.getDecodedJwsPayload();
    }
}

