/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.io.IOException;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.logs.AuditLogger;

public class JaasAuthenticator
implements JMXAuthenticator {
    private String realm;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    @Override
    public Subject authenticate(final Object credentials) throws SecurityException {
        Subject subject = new Subject();
        try {
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    String[] params = null;
                    if (credentials instanceof String[] && ((String[])credentials).length == 2) {
                        params = (String[])credentials;
                    }
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            if (params == null) continue;
                            ((NameCallback)callbacks[i]).setName(params[0]);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            if (params == null) continue;
                            ((PasswordCallback)callbacks[i]).setPassword(params[1].toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i]);
                    }
                }
            });
            loginContext.login();
            if (AuditLogger.isResourceLoggingEnabled()) {
                AuditLogger.userSuccesfullyAuthenticatedInAudit((Subject)subject);
            }
            return subject;
        }
        catch (LoginException e) {
            if (AuditLogger.isResourceLoggingEnabled()) {
                AuditLogger.userFailedAuthenticationInAudit((Subject)subject, (String)e.getMessage());
            }
            throw new SecurityException("Authentication failed", e);
        }
    }
}

