/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceDescriptor;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class PropertySourceProcessor {
    private static final PropertySourceFactory DEFAULT_PROPERTY_SOURCE_FACTORY = new DefaultPropertySourceFactory();
    private static final Log logger = LogFactory.getLog(PropertySourceProcessor.class);
    private final ConfigurableEnvironment environment;
    private final ResourceLoader resourceLoader;
    private final List<String> propertySourceNames;

    public PropertySourceProcessor(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        this.environment = environment;
        this.resourceLoader = resourceLoader;
        this.propertySourceNames = new ArrayList<String>();
    }

    public void processPropertySource(PropertySourceDescriptor descriptor) throws IOException {
        String name = descriptor.name();
        String encoding = descriptor.encoding();
        List<String> locations = descriptor.locations();
        Assert.isTrue(locations.size() > 0, "At least one @PropertySource(value) location is required");
        boolean ignoreResourceNotFound = descriptor.ignoreResourceNotFound();
        PropertySourceFactory factory = descriptor.propertySourceFactory() != null ? this.instantiateClass(descriptor.propertySourceFactory()) : DEFAULT_PROPERTY_SOURCE_FACTORY;
        for (String location : locations) {
            try {
                String resolvedLocation = this.environment.resolveRequiredPlaceholders(location);
                Resource resource = this.resourceLoader.getResource(resolvedLocation);
                this.addPropertySource(factory.createPropertySource(name, new EncodedResource(resource, encoding)));
            }
            catch (FileNotFoundException | IllegalArgumentException | SocketException | UnknownHostException ex) {
                if (ignoreResourceNotFound) {
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("Properties location [" + location + "] not resolvable: " + ex.getMessage()));
                    continue;
                }
                throw ex;
            }
        }
    }

    private void addPropertySource(PropertySource<?> propertySource) {
        ResourcePropertySource existing;
        String name = propertySource.getName();
        MutablePropertySources propertySources = this.environment.getPropertySources();
        if (this.propertySourceNames.contains(name) && (existing = propertySources.get(name)) != null) {
            ResourcePropertySource newSource;
            if (propertySource instanceof ResourcePropertySource) {
                ResourcePropertySource rps = propertySource;
                v0 = rps.withResourceName();
            } else {
                v0 = newSource = propertySource;
            }
            if (existing instanceof CompositePropertySource) {
                CompositePropertySource cps = (CompositePropertySource)((Object)existing);
                cps.addFirstPropertySource(newSource);
            } else {
                if (existing instanceof ResourcePropertySource) {
                    ResourcePropertySource rps = existing;
                    existing = rps.withResourceName();
                }
                CompositePropertySource composite = new CompositePropertySource(name);
                composite.addPropertySource(newSource);
                composite.addPropertySource(existing);
                propertySources.replace(name, composite);
            }
            return;
        }
        if (this.propertySourceNames.isEmpty()) {
            propertySources.addLast(propertySource);
        } else {
            String firstProcessed = this.propertySourceNames.get(this.propertySourceNames.size() - 1);
            propertySources.addBefore(firstProcessed, propertySource);
        }
        this.propertySourceNames.add(name);
    }

    private PropertySourceFactory instantiateClass(Class<? extends PropertySourceFactory> type) {
        try {
            Constructor<? extends PropertySourceFactory> constructor = type.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(constructor);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to instantiate " + type, ex);
        }
    }
}

