/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.Collection;
import org.apache.activemq.artemis.utils.collections.ResettableIterator;

public class ArrayResettableIterator<E>
implements ResettableIterator<E> {
    private final Object[] array;
    private int cursor = 0;
    private int endPos = -1;
    private boolean hasNext;

    public ArrayResettableIterator(Object[] array) {
        this.array = array;
        this.reset();
    }

    public static <E> ResettableIterator<E> iterator(Collection<E> collection) {
        return new ArrayResettableIterator<E>(collection.toArray());
    }

    @Override
    public void reset() {
        this.endPos = this.cursor;
        this.hasNext = this.array.length > 0;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (!this.hasNext) {
            throw new IllegalStateException();
        }
        Object result = this.array[this.cursor];
        ++this.cursor;
        if (this.cursor == this.array.length) {
            this.cursor = 0;
        }
        if (this.cursor == this.endPos) {
            this.hasNext = false;
        }
        return (E)result;
    }
}

