/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlSequenceBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

public final class IdlSequence
extends IdlSequenceBase {
    private static final Logger LOG = LogUtils.getL7dLogger(IdlSequence.class);

    private IdlSequence(IdlScopeBase parent, String name, IdlType elem, int bound) {
        super(parent, name, elem, bound);
    }

    public static IdlSequence create(IdlScopeBase parent, String name, IdlType elem) {
        return new IdlSequence(parent, name, elem, 0);
    }

    public static IdlSequence create(IdlScopeBase parent, String name, IdlType elem, int bound) {
        return new IdlSequence(parent, name, elem, bound);
    }

    @Override
    public void write(PrintWriter pw) {
        if (!this.elemType().isEmptyDef()) {
            if (!this.isCircular()) {
                this.writeTypedef(pw);
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Ignoring Sequence " + this.localName() + " with Empty Element Type.");
        }
    }

    @Override
    public void writeFwd(PrintWriter pw) {
        if (!this.elemType().isEmptyDef() && this.isCircular()) {
            this.writeTypedef(pw);
        }
    }

    private void writeTypedef(PrintWriter pw) {
        if (!this.elemType().isEmptyDef()) {
            pw.print(IdlSequence.indent() + "typedef ");
            super.write(pw);
            pw.println(this.localName() + ";");
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Ignoring Sequence " + this.localName() + " with Empty Element Type.");
        }
    }
}

