/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso.state;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.cxf.rs.security.saml.sso.state.MemorySPStateManager;
import org.apache.cxf.rs.security.saml.sso.state.RequestState;
import org.apache.cxf.rs.security.saml.sso.state.ResponseState;
import org.apache.cxf.rs.security.saml.sso.state.SPStateManager;

@Path(value="state")
public class HTTPSPStateManager
implements SPStateManager {
    private SPStateManager manager = new MemorySPStateManager();

    public void setStateProvider(SPStateManager stateManager) {
        this.manager = stateManager;
    }

    @Override
    @POST
    @Path(value="/request/{relayState}")
    @Consumes(value={"application/xml"})
    public void setRequestState(@Encoded @PathParam(value="relayState") String relayState, RequestState state) {
        this.manager.setRequestState(relayState, state);
    }

    @Override
    @DELETE
    @Path(value="/request/{relayState}")
    @Produces(value={"application/xml"})
    public RequestState removeRequestState(@Encoded @PathParam(value="relayState") String relayState) {
        return this.manager.removeRequestState(relayState);
    }

    @Override
    @POST
    @Path(value="/response/{contextKey}")
    @Consumes(value={"application/xml"})
    public void setResponseState(@Encoded @PathParam(value="contextKey") String contextKey, ResponseState state) {
        this.manager.setResponseState(contextKey, state);
    }

    @Override
    @GET
    @Path(value="/response/{contextKey}")
    @Produces(value={"application/xml"})
    public ResponseState getResponseState(@Encoded @PathParam(value="contextKey") String contextKey) {
        return this.manager.getResponseState(contextKey);
    }

    @Override
    @DELETE
    @Path(value="/response/{contextKey}")
    @Produces(value={"application/xml"})
    public ResponseState removeResponseState(String contextKey) {
        return this.manager.getResponseState(contextKey);
    }

    @Override
    @POST
    @Path(value="close")
    public void close() throws IOException {
    }
}

