/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.ClientRegistrationProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJoseJwtProducer;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.ProviderAuthenticationStrategy;
import org.apache.cxf.rs.security.oauth2.tokens.bearer.BearerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rs.security.oauth2.utils.JwtTokenUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class AbstractOAuthDataProvider
implements OAuthDataProvider,
ClientRegistrationProvider {
    private long accessTokenLifetime = 3600L;
    private long refreshTokenLifetime;
    private boolean recycleRefreshTokens = true;
    private Object refreshTokenLock;
    private Map<String, OAuthPermission> permissionMap = new HashMap<String, OAuthPermission>();
    private MessageContext messageContext;
    private List<String> defaultScopes;
    private List<String> requiredScopes;
    private List<String> invisibleToClientScopes;
    private boolean supportPreauthorizedTokens;
    private boolean useJwtFormatForAccessTokens;
    private boolean persistJwtEncoding = true;
    private OAuthJoseJwtProducer jwtAccessTokenProducer;
    private Map<String, String> jwtAccessTokenClaimMap;
    private ProviderAuthenticationStrategy authenticationStrategy;
    private String issuer;

    protected AbstractOAuthDataProvider() {
    }

    @Override
    public ServerAccessToken createAccessToken(AccessTokenRegistration reg) throws OAuthServiceException {
        ServerAccessToken at = this.doCreateAccessToken(reg);
        this.saveAccessToken(at);
        if (this.isRefreshTokenSupported(reg.getApprovedScope())) {
            this.createNewRefreshToken(at);
        }
        return at;
    }

    protected ServerAccessToken doCreateAccessToken(AccessTokenRegistration atReg) {
        String certCnf;
        ServerAccessToken at = this.createNewAccessToken(atReg.getClient(), atReg.getSubject());
        at.setAudiences(atReg.getAudiences());
        at.setGrantType(atReg.getGrantType());
        List<String> theScopes = atReg.getApprovedScope();
        List<OAuthPermission> thePermissions = this.convertScopeToPermissions(atReg.getClient(), theScopes);
        at.setScopes(thePermissions);
        at.setSubject(atReg.getSubject());
        at.setClientCodeVerifier(atReg.getClientCodeVerifier());
        at.setNonce(atReg.getNonce());
        at.setResponseType(atReg.getResponseType());
        at.setGrantCode(atReg.getGrantCode());
        at.getExtraProperties().putAll(atReg.getExtraProperties());
        if (this.messageContext != null && (certCnf = (String)this.messageContext.get((Object)"x5t#S256")) != null) {
            at.getExtraProperties().put("x5t#S256", certCnf);
        }
        if (this.isUseJwtFormatForAccessTokens()) {
            JwtClaims claims = this.createJwtAccessToken(at);
            String jose = this.processJwtAccessToken(claims);
            if (this.isPersistJwtEncoding()) {
                at.setTokenKey(jose);
            } else {
                at.setEncodedToken(jose);
            }
        }
        return at;
    }

    protected JwtClaims createJwtAccessToken(ServerAccessToken at) {
        UserSubject userSubject;
        JwtClaims claims = new JwtClaims();
        claims.setTokenId(at.getTokenKey());
        String clientIdClaimName = JwtTokenUtils.getClaimName("client_id", "client_id", this.getJwtAccessTokenClaimMap());
        claims.setClaim(clientIdClaimName, (Object)at.getClient().getClientId());
        claims.setIssuedAt(Long.valueOf(at.getIssuedAt()));
        if (at.getExpiresIn() > 0L) {
            claims.setExpiryTime(Long.valueOf(at.getIssuedAt() + at.getExpiresIn()));
        }
        if ((userSubject = at.getSubject()) != null) {
            if (userSubject.getId() != null) {
                claims.setSubject(userSubject.getId());
            }
            String usernameProp = "username";
            String usernameClaimName = JwtTokenUtils.getClaimName("username", "username", this.getJwtAccessTokenClaimMap());
            claims.setClaim(usernameClaimName, (Object)userSubject.getLogin());
        }
        if (at.getIssuer() != null) {
            claims.setIssuer(at.getIssuer());
        }
        if (!at.getScopes().isEmpty()) {
            claims.setClaim("scope", (Object)OAuthUtils.convertListOfScopesToString(OAuthUtils.convertPermissionsToScopeList(at.getScopes())));
        }
        if (!at.getAudiences().isEmpty()) {
            List<String> resourceAudiences = at.getAudiences();
            if (resourceAudiences.size() == 1) {
                claims.setAudience(resourceAudiences.get(0));
            } else {
                claims.setAudiences(resourceAudiences);
            }
        }
        if (!at.getExtraProperties().isEmpty()) {
            HashMap<String, String> actualExtraProps = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : at.getExtraProperties().entrySet()) {
                if ("x5t#S256".equals(entry.getKey())) {
                    claims.setClaim("cnf", Collections.singletonMap("x5t#S256", entry.getValue()));
                    continue;
                }
                actualExtraProps.put(entry.getKey(), entry.getValue());
            }
            claims.setClaim("extra_properties", actualExtraProps);
        }
        if (at.getGrantType() != null) {
            claims.setClaim("grant_type", (Object)at.getGrantType());
        }
        if (at.getGrantCode() != null) {
            claims.setClaim("authorization_code", (Object)at.getGrantCode());
        }
        if (at.getClientCodeVerifier() != null) {
            claims.setClaim("code_verifier", (Object)at.getClientCodeVerifier());
        }
        if (at.getNonce() != null) {
            claims.setClaim("nonce", (Object)at.getNonce());
        }
        return claims;
    }

    protected ServerAccessToken createNewAccessToken(Client client, UserSubject userSub) {
        BearerAccessToken token = new BearerAccessToken(client, this.accessTokenLifetime);
        if (this.issuer != null) {
            token.setIssuer(this.issuer);
        }
        return token;
    }

    @Override
    public ServerAccessToken refreshAccessToken(Client client, String refreshTokenKey, List<String> restrictedScopes) throws OAuthServiceException {
        RefreshToken currentRefreshToken;
        RefreshToken refreshToken = currentRefreshToken = this.recycleRefreshTokens ? this.revokeRefreshToken(client, refreshTokenKey) : this.getRefreshToken(refreshTokenKey);
        if (currentRefreshToken == null) {
            throw new OAuthServiceException("access_denied");
        }
        if (OAuthUtils.isExpired(currentRefreshToken.getIssuedAt(), currentRefreshToken.getExpiresIn())) {
            if (!this.recycleRefreshTokens) {
                this.revokeRefreshToken(client, refreshTokenKey);
            }
            throw new OAuthServiceException("access_denied");
        }
        if (this.recycleRefreshTokens) {
            this.revokeAccessTokens(client, currentRefreshToken);
        }
        ServerAccessToken at = this.doRefreshAccessToken(client, currentRefreshToken, restrictedScopes);
        this.saveAccessToken(at);
        if (this.recycleRefreshTokens) {
            this.createNewRefreshToken(at);
        } else {
            this.updateExistingRefreshToken(currentRefreshToken, at);
        }
        return at;
    }

    @Override
    public void revokeToken(Client client, String tokenKey, String tokenTypeHint) throws OAuthServiceException {
        ServerAccessToken accessToken = null;
        if (!"refresh_token".equals(tokenTypeHint)) {
            accessToken = this.revokeAccessToken(client, tokenKey);
        }
        if (accessToken != null) {
            this.handleLinkedRefreshToken(client, accessToken);
        } else if (!"access_token".equals(tokenTypeHint)) {
            RefreshToken currentRefreshToken = this.revokeRefreshToken(client, tokenKey);
            this.revokeAccessTokens(client, currentRefreshToken);
        }
    }

    protected void handleLinkedRefreshToken(Client client, ServerAccessToken accessToken) {
        if (accessToken != null && accessToken.getRefreshToken() != null) {
            RefreshToken rt = this.getRefreshToken(accessToken.getRefreshToken());
            if (rt == null) {
                return;
            }
            this.unlinkRefreshAccessToken(rt, accessToken.getTokenKey());
            if (rt.getAccessTokens().isEmpty()) {
                this.revokeRefreshToken(client, rt.getTokenKey());
            } else {
                this.saveRefreshToken(rt);
            }
        }
    }

    protected void revokeAccessTokens(Client client, RefreshToken currentRefreshToken) {
        if (currentRefreshToken != null) {
            for (String accessTokenKey : currentRefreshToken.getAccessTokens()) {
                this.revokeAccessToken(client, accessTokenKey);
            }
        }
    }

    protected void unlinkRefreshAccessToken(RefreshToken rt, String tokenKey) {
        List<String> accessTokenKeys = rt.getAccessTokens();
        for (int i = 0; i < accessTokenKeys.size(); ++i) {
            if (!accessTokenKeys.get(i).equals(tokenKey)) continue;
            accessTokenKeys.remove(i);
            break;
        }
    }

    @Override
    public List<OAuthPermission> convertScopeToPermissions(Client client, List<String> requestedScopes) {
        this.checkRequestedScopes(client, requestedScopes);
        if (requestedScopes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OAuthPermission> list = new ArrayList<OAuthPermission>();
        for (String scope : requestedScopes) {
            this.convertSingleScopeToPermission(client, scope, list);
        }
        if (!list.isEmpty()) {
            return list;
        }
        throw new OAuthServiceException("Requested scopes can not be mapped");
    }

    protected void checkRequestedScopes(Client client, List<String> requestedScopes) {
        if (this.requiredScopes != null && !requestedScopes.containsAll(this.requiredScopes)) {
            throw new OAuthServiceException("Required scopes are missing");
        }
    }

    protected void convertSingleScopeToPermission(Client client, String scope, List<OAuthPermission> perms) {
        OAuthPermission permission = this.permissionMap.get(scope);
        if (permission == null) {
            throw new OAuthServiceException("Unexpected scope: " + scope);
        }
        perms.add(permission);
    }

    @Override
    public ServerAccessToken getPreauthorizedToken(Client client, List<String> requestedScopes, UserSubject sub, String grantType) throws OAuthServiceException {
        if (!this.isSupportPreauthorizedTokens()) {
            return null;
        }
        ServerAccessToken token = null;
        for (ServerAccessToken at : this.getAccessTokens(client, sub)) {
            if (!at.getClient().getClientId().equals(client.getClientId()) || !at.getGrantType().equals(grantType) || (sub != null || at.getSubject() != null) && (sub == null || !at.getSubject().getLogin().equals(sub.getLogin()))) continue;
            if (!OAuthUtils.isExpired(at.getIssuedAt(), at.getExpiresIn())) {
                token = at;
                break;
            }
            this.revokeToken(client, at.getTokenKey(), "access_token");
            break;
        }
        return token;
    }

    protected boolean isRefreshTokenSupported(List<String> theScopes) {
        return theScopes.contains("refreshToken");
    }

    protected String getCurrentRequestedGrantType() {
        return this.messageContext != null ? (String)this.messageContext.get((Object)"grant_type") : null;
    }

    protected String getCurrentClientSecret() {
        return this.messageContext != null ? (String)this.messageContext.get((Object)"client_secret") : null;
    }

    protected MultivaluedMap<String, String> getCurrentTokenRequestParams() {
        if (this.messageContext != null) {
            MultivaluedMap params = (MultivaluedMap)this.messageContext.get((Object)"token_request_params");
            return params;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RefreshToken updateExistingRefreshToken(RefreshToken rt, ServerAccessToken at) {
        Object object = this.refreshTokenLock;
        synchronized (object) {
            return this.updateRefreshToken(rt, at);
        }
    }

    protected RefreshToken updateRefreshToken(RefreshToken rt, ServerAccessToken at) {
        this.linkAccessTokenToRefreshToken(rt, at);
        this.saveRefreshToken(rt);
        this.linkRefreshTokenToAccessToken(rt, at);
        return rt;
    }

    protected RefreshToken createNewRefreshToken(ServerAccessToken at) {
        RefreshToken rt = this.doCreateNewRefreshToken(at);
        return this.updateRefreshToken(rt, at);
    }

    protected RefreshToken doCreateNewRefreshToken(ServerAccessToken at) {
        RefreshToken rt = new RefreshToken(at.getClient(), this.refreshTokenLifetime);
        if (at.getAudiences() != null) {
            rt.setAudiences(new ArrayList<String>(at.getAudiences()));
        }
        rt.setGrantType(at.getGrantType());
        if (at.getScopes() != null) {
            rt.setScopes(new ArrayList<OAuthPermission>(at.getScopes()));
        }
        rt.setGrantCode(at.getGrantCode());
        rt.setNonce(at.getNonce());
        rt.setSubject(at.getSubject());
        rt.setClientCodeVerifier(at.getClientCodeVerifier());
        return rt;
    }

    protected void linkAccessTokenToRefreshToken(RefreshToken rt, ServerAccessToken at) {
        if (!rt.getAccessTokens().contains(at.getTokenKey())) {
            rt.getAccessTokens().add(at.getTokenKey());
        }
    }

    protected void linkRefreshTokenToAccessToken(RefreshToken rt, ServerAccessToken at) {
        at.setRefreshToken(rt.getTokenKey());
    }

    protected ServerAccessToken doRefreshAccessToken(Client client, RefreshToken oldRefreshToken, List<String> restrictedScopes) {
        ServerAccessToken at = this.createNewAccessToken(client, oldRefreshToken.getSubject());
        at.setAudiences((List<String>)(oldRefreshToken.getAudiences() != null ? new ArrayList<String>(oldRefreshToken.getAudiences()) : null));
        at.setGrantType(oldRefreshToken.getGrantType());
        at.setGrantCode(oldRefreshToken.getGrantCode());
        at.setSubject(oldRefreshToken.getSubject());
        at.setNonce(oldRefreshToken.getNonce());
        at.setClientCodeVerifier(oldRefreshToken.getClientCodeVerifier());
        at.getExtraProperties().putAll(oldRefreshToken.getExtraProperties());
        if (restrictedScopes.isEmpty()) {
            at.setScopes((List<OAuthPermission>)(oldRefreshToken.getScopes() != null ? new ArrayList<OAuthPermission>(oldRefreshToken.getScopes()) : null));
        } else {
            List<OAuthPermission> theNewScopes = this.convertScopeToPermissions(client, restrictedScopes);
            if (oldRefreshToken.getScopes().containsAll(theNewScopes)) {
                at.setScopes(theNewScopes);
            } else {
                throw new OAuthServiceException("Invalid scopes");
            }
        }
        if (this.isUseJwtFormatForAccessTokens()) {
            JwtClaims claims = this.createJwtAccessToken(at);
            String jose = this.processJwtAccessToken(claims);
            if (this.isPersistJwtEncoding()) {
                at.setTokenKey(jose);
            } else {
                at.setEncodedToken(jose);
            }
        }
        return at;
    }

    public void setAccessTokenLifetime(long accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public void setRefreshTokenLifetime(long refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    public void setRecycleRefreshTokens(boolean recycleRefreshTokens) {
        this.recycleRefreshTokens = recycleRefreshTokens;
        this.refreshTokenLock = recycleRefreshTokens ? null : new Object();
    }

    public boolean isRecycleRefreshTokens() {
        return this.recycleRefreshTokens;
    }

    public void init() {
        for (OAuthPermission perm : this.permissionMap.values()) {
            if (this.defaultScopes != null && this.defaultScopes.contains(perm.getPermission())) {
                perm.setDefaultPermission(true);
            }
            if (this.invisibleToClientScopes == null || !this.invisibleToClientScopes.contains(perm.getPermission())) continue;
            perm.setInvisibleToClient(true);
        }
    }

    public void close() {
    }

    public Map<String, OAuthPermission> getPermissionMap() {
        return this.permissionMap;
    }

    public void setPermissionMap(Map<String, OAuthPermission> permissionMap) {
        this.permissionMap = permissionMap;
    }

    public void setSupportedScopes(Map<String, String> scopes) {
        for (Map.Entry<String, String> entry : scopes.entrySet()) {
            OAuthPermission permission = new OAuthPermission(entry.getKey(), entry.getValue());
            this.permissionMap.put(entry.getKey(), permission);
        }
    }

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
        if (this.authenticationStrategy != null) {
            OAuthUtils.injectContextIntoOAuthProvider(messageContext, this.authenticationStrategy);
        }
    }

    protected void removeClientTokens(Client c) {
        List<ServerAccessToken> accessTokens;
        List<RefreshToken> refreshTokens = this.getRefreshTokens(c, null);
        if (refreshTokens != null) {
            for (RefreshToken rt : refreshTokens) {
                this.revokeRefreshToken(c, rt.getTokenKey());
            }
        }
        if ((accessTokens = this.getAccessTokens(c, null)) != null) {
            for (ServerAccessToken at : accessTokens) {
                this.revokeAccessToken(c, at.getTokenKey());
            }
        }
    }

    @Override
    public Client removeClient(String clientId) {
        Client c = this.doGetClient(clientId);
        this.removeClientTokens(c);
        this.doRemoveClient(c);
        return c;
    }

    @Override
    public Client getClient(String clientId) {
        String clientSecret;
        Client client = this.doGetClient(clientId);
        if (client != null) {
            return client;
        }
        String grantType = this.getCurrentRequestedGrantType();
        if ("client_credentials".equals(grantType) && (clientSecret = this.getCurrentClientSecret()) != null) {
            return this.createClientCredentialsClient(clientId, clientSecret);
        }
        return null;
    }

    public void setAuthenticationStrategy(ProviderAuthenticationStrategy authenticationStrategy) {
        this.authenticationStrategy = authenticationStrategy;
    }

    protected boolean authenticateUnregisteredClient(String clientId, String clientSecret) {
        return this.authenticationStrategy != null && this.authenticationStrategy.authenticate(clientId, clientSecret);
    }

    protected Client createClientCredentialsClient(String clientId, String password) {
        if (this.authenticateUnregisteredClient(clientId, password)) {
            Client c = new Client(clientId, password, true);
            c.setAllowedGrantTypes(Collections.singletonList("client_credentials"));
            return c;
        }
        return null;
    }

    protected ServerAccessToken revokeAccessToken(Client client, String accessTokenKey) {
        ServerAccessToken at = this.getAccessToken(accessTokenKey);
        if (at != null) {
            if (!at.getClient().getClientId().equals(client.getClientId())) {
                throw new OAuthServiceException("invalid_grant");
            }
            this.doRevokeAccessToken(at);
        }
        return at;
    }

    protected RefreshToken revokeRefreshToken(Client client, String refreshTokenKey) {
        RefreshToken refreshToken = this.getRefreshToken(refreshTokenKey);
        if (refreshToken != null) {
            if (!refreshToken.getClient().getClientId().equals(client.getClientId())) {
                throw new OAuthServiceException("invalid_grant");
            }
            this.doRevokeRefreshToken(refreshToken);
        }
        return refreshToken;
    }

    protected abstract void saveAccessToken(ServerAccessToken var1);

    protected abstract void saveRefreshToken(RefreshToken var1);

    protected abstract void doRevokeAccessToken(ServerAccessToken var1);

    protected abstract void doRevokeRefreshToken(RefreshToken var1);

    protected abstract RefreshToken getRefreshToken(String var1);

    protected abstract Client doGetClient(String var1);

    protected abstract void doRemoveClient(Client var1);

    public List<String> getDefaultScopes() {
        return this.defaultScopes;
    }

    public void setDefaultScopes(List<String> defaultScopes) {
        this.defaultScopes = defaultScopes;
    }

    public List<String> getRequiredScopes() {
        return this.requiredScopes;
    }

    public void setRequiredScopes(List<String> requiredScopes) {
        this.requiredScopes = requiredScopes;
    }

    public List<String> getInvisibleToClientScopes() {
        return this.invisibleToClientScopes;
    }

    public void setInvisibleToClientScopes(List<String> invisibleToClientScopes) {
        this.invisibleToClientScopes = invisibleToClientScopes;
    }

    public boolean isSupportPreauthorizedTokens() {
        return this.supportPreauthorizedTokens;
    }

    public void setSupportPreauthorizedTokens(boolean supportPreauthorizedTokens) {
        this.supportPreauthorizedTokens = supportPreauthorizedTokens;
    }

    protected static boolean isClientMatched(Client c, UserSubject resourceOwner) {
        return resourceOwner == null || c.getResourceOwnerSubject() != null && c.getResourceOwnerSubject().getLogin().equals(resourceOwner.getLogin());
    }

    protected static boolean isTokenMatched(ServerAccessToken token, Client c, UserSubject sub) {
        if (token != null && (c == null || token.getClient().getClientId().equals(c.getClientId()))) {
            UserSubject tokenSub = token.getSubject();
            if (sub == null || tokenSub != null && tokenSub.getLogin().equals(sub.getLogin())) {
                return true;
            }
        }
        return false;
    }

    public void setClients(List<Client> clients) {
        for (Client c : clients) {
            this.setClient(c);
        }
    }

    public boolean isUseJwtFormatForAccessTokens() {
        return this.useJwtFormatForAccessTokens;
    }

    public void setUseJwtFormatForAccessTokens(boolean useJwtFormatForAccessTokens) {
        this.useJwtFormatForAccessTokens = useJwtFormatForAccessTokens;
    }

    public OAuthJoseJwtProducer getJwtAccessTokenProducer() {
        return this.jwtAccessTokenProducer;
    }

    public void setJwtAccessTokenProducer(OAuthJoseJwtProducer jwtAccessTokenProducer) {
        this.jwtAccessTokenProducer = jwtAccessTokenProducer;
    }

    protected String processJwtAccessToken(JwtClaims jwtCliams) {
        OAuthJoseJwtProducer processor = this.getJwtAccessTokenProducer() == null ? new OAuthJoseJwtProducer() : this.getJwtAccessTokenProducer();
        return processor.processJwt(new JwtToken(jwtCliams));
    }

    public Map<String, String> getJwtAccessTokenClaimMap() {
        return this.jwtAccessTokenClaimMap;
    }

    public void setJwtAccessTokenClaimMap(Map<String, String> jwtAccessTokenClaimMap) {
        this.jwtAccessTokenClaimMap = jwtAccessTokenClaimMap;
    }

    public boolean isPersistJwtEncoding() {
        return this.persistJwtEncoding;
    }

    public void setPersistJwtEncoding(boolean persistJwtEncoding) {
        this.persistJwtEncoding = persistJwtEncoding;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }
}

