/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.services;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth.data.AccessToken;
import org.apache.cxf.rs.security.oauth.data.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth.data.RequestToken;
import org.apache.cxf.rs.security.oauth.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth.utils.OAuthUtils;

public class AccessTokenHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(AccessTokenHandler.class);
    private static final String[] REQUIRED_PARAMETERS = new String[]{"oauth_consumer_key", "oauth_token", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce"};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response handle(MessageContext mc, OAuthDataProvider dataProvider, OAuthValidator validator) {
        try {
            OAuthMessage oAuthMessage = OAuthUtils.getOAuthMessage(mc, mc.getHttpServletRequest(), REQUIRED_PARAMETERS);
            RequestToken requestToken = dataProvider.getRequestToken(oAuthMessage.getToken());
            if (requestToken == null) {
                throw new OAuthProblemException("token_rejected");
            }
            String oauthVerifier = oAuthMessage.getParameter("oauth_verifier");
            if (StringUtils.isEmpty((String)oauthVerifier)) {
                if (requestToken.getSubject() == null || !requestToken.isPreAuthorized()) throw new OAuthProblemException("verifier_invalid");
                LOG.fine("Preauthorized request token");
            } else if (!oauthVerifier.equals(requestToken.getVerifier())) {
                throw new OAuthProblemException("verifier_invalid");
            }
            OAuthUtils.validateMessage(oAuthMessage, requestToken.getClient(), requestToken, dataProvider, validator);
            AccessTokenRegistration reg = new AccessTokenRegistration();
            reg.setRequestToken(requestToken);
            AccessToken accessToken = dataProvider.createAccessToken(reg);
            HashMap<String, String> responseParams = new HashMap<String, String>();
            responseParams.put("oauth_token", accessToken.getTokenKey());
            responseParams.put("oauth_token_secret", accessToken.getTokenSecret());
            String responseString = OAuth.formEncode(responseParams.entrySet());
            return Response.ok((Object)responseString).build();
        }
        catch (OAuthProblemException e) {
            LOG.log(Level.WARNING, "An OAuth-related problem: {0}", new Object[]{e.fillInStackTrace()});
            int code = e.getHttpStatusCode();
            if (code != 200) return OAuthUtils.handleException(mc, (Exception)((Object)e), code);
            code = "consumer_key_unknown".equals(e.getProblem()) ? 401 : 400;
            return OAuthUtils.handleException(mc, (Exception)((Object)e), code);
        }
        catch (OAuthServiceException e) {
            return OAuthUtils.handleException(mc, e, 400);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unexpected internal server exception: {0}", new Object[]{e.fillInStackTrace()});
            return OAuthUtils.handleException(mc, e, 500);
        }
    }
}

