/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.tika;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.ws.rs.ext.ParamConverterProvider;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.search.ParamConverterUtils;
import org.apache.cxf.jaxrs.ext.search.tika.LuceneDocumentMetadata;
import org.apache.cxf.jaxrs.ext.search.tika.TikaContentExtractor;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ToTextContentHandler;
import org.xml.sax.ContentHandler;

public class TikaLuceneContentExtractor {
    private final LuceneDocumentMetadata defaultDocumentMetadata;
    private final TikaContentExtractor extractor;

    public TikaLuceneContentExtractor(Parser parser) {
        this(parser, true);
    }

    public TikaLuceneContentExtractor(Parser parser, boolean validateMediaType) {
        this(parser, validateMediaType, new LuceneDocumentMetadata());
    }

    public TikaLuceneContentExtractor(Parser parser, LuceneDocumentMetadata documentMetadata) {
        this(parser, false, documentMetadata);
    }

    public TikaLuceneContentExtractor(Parser parser, boolean validateMediaType, LuceneDocumentMetadata documentMetadata) {
        this.extractor = new TikaContentExtractor(parser, validateMediaType);
        this.defaultDocumentMetadata = documentMetadata;
    }

    public TikaLuceneContentExtractor(List<Parser> parsers, LuceneDocumentMetadata documentMetadata) {
        this.extractor = new TikaContentExtractor(parsers);
        this.defaultDocumentMetadata = documentMetadata;
    }

    public Document extract(InputStream in) {
        return this.extractAll(in, null, true, true);
    }

    public Document extract(InputStream in, LuceneDocumentMetadata documentMetadata) {
        return this.extractAll(in, documentMetadata, true, true);
    }

    public Document extractContent(InputStream in) {
        return this.extractAll(in, null, true, false);
    }

    public Document extractMetadata(InputStream in) {
        return this.extractAll(in, null, false, true);
    }

    public Document extractMetadata(InputStream in, LuceneDocumentMetadata documentMetadata) {
        return this.extractAll(in, documentMetadata, false, true);
    }

    private Document extractAll(InputStream in, LuceneDocumentMetadata documentMetadata, boolean extractContent, boolean extractMetadata) {
        TikaContentExtractor.TikaContent content = this.extractor.extract(in, (ContentHandler)(extractContent ? new ToTextContentHandler() : null));
        if (content == null) {
            return null;
        }
        Document document = new Document();
        if (documentMetadata == null) {
            documentMetadata = this.defaultDocumentMetadata;
        }
        if (content.getContent() != null) {
            document.add((IndexableField)TikaLuceneContentExtractor.getContentField(documentMetadata, content.getContent()));
        }
        if (extractMetadata) {
            Metadata metadata = content.getMetadata();
            for (String property : metadata.names()) {
                TikaLuceneContentExtractor.addField(document, documentMetadata, property, metadata.get(property));
            }
        }
        if (!StringUtils.isEmpty((String)documentMetadata.getSource())) {
            document.add((IndexableField)new StringField(documentMetadata.getSourceFieldName(), documentMetadata.getSource(), Field.Store.YES));
        }
        return document;
    }

    private static Field getContentField(LuceneDocumentMetadata documentMetadata, String content) {
        return new TextField(documentMetadata.getContentFieldName(), content, Field.Store.YES);
    }

    private static void addField(Document document, LuceneDocumentMetadata documentMetadata, String name, String value) {
        Class<?> type = documentMetadata.getFieldType(name);
        ParamConverterProvider provider = documentMetadata.getFieldTypeConverter();
        if (type != null) {
            if (Number.class.isAssignableFrom(type)) {
                if (Double.class.isAssignableFrom(type)) {
                    Double number = ParamConverterUtils.getValue(Double.class, provider, value);
                    document.add((IndexableField)new DoublePoint(name, new double[]{number}));
                    document.add((IndexableField)new StoredField(name, number.doubleValue()));
                } else if (Float.class.isAssignableFrom(type)) {
                    Float number = ParamConverterUtils.getValue(Float.class, provider, value);
                    document.add((IndexableField)new FloatPoint(name, new float[]{number.floatValue()}));
                    document.add((IndexableField)new StoredField(name, number.floatValue()));
                } else if (Long.class.isAssignableFrom(type)) {
                    Long number = ParamConverterUtils.getValue(Long.class, provider, value);
                    document.add((IndexableField)new LongPoint(name, new long[]{number}));
                    document.add((IndexableField)new StoredField(name, number.longValue()));
                } else if (Integer.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
                    Integer number = ParamConverterUtils.getValue(Integer.class, provider, value);
                    document.add((IndexableField)new IntPoint(name, new int[]{number}));
                    document.add((IndexableField)new StoredField(name, number.intValue()));
                } else {
                    document.add((IndexableField)new StringField(name, value, Field.Store.YES));
                }
                return;
            }
            if (Date.class.isAssignableFrom(type)) {
                Date date = ParamConverterUtils.getValue(Date.class, provider, value);
                StringField field = null;
                field = date != null ? new StringField(name, ParamConverterUtils.getString(Date.class, provider, date), Field.Store.YES) : new StringField(name, value, Field.Store.YES);
                document.add((IndexableField)field);
                return;
            }
        }
        document.add((IndexableField)new StringField(name, value, Field.Store.YES));
    }
}

