/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClientIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ClientIdentifier.class.getName());
    private final long pid;
    private final String name;
    private final String connectionUid;
    private final String hostAddress;

    private ClientIdentifier(long pid, String hostAddress, String name, String connectionUid) {
        this.hostAddress = Objects.requireNonNull(hostAddress);
        this.pid = pid;
        this.connectionUid = Objects.requireNonNull(connectionUid);
        this.name = Objects.requireNonNull(name);
        if (hostAddress.isEmpty()) {
            throw new IllegalArgumentException("Empty host address");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty name");
        }
    }

    public String getConnectionUid() {
        return this.connectionUid;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public long getPid() {
        return this.pid;
    }

    public String getName() {
        return this.name;
    }

    public String getVmId() {
        String ha = this.hostAddress;
        if (this.hostAddress.contains(":")) {
            ha = "[" + this.hostAddress + "]";
        }
        return this.pid + "@" + ha;
    }

    public String getClientId() {
        return this.getVmId() + ":" + this.name + ":" + this.connectionUid;
    }

    public String toString() {
        return this.getClientId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientIdentifier that = (ClientIdentifier)o;
        return this.pid == that.pid && this.name.equals(that.name) && this.connectionUid.equals(that.connectionUid) && this.hostAddress.equals(that.hostAddress);
    }

    public int hashCode() {
        int result = (int)(this.pid ^ this.pid >>> 32);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.connectionUid.hashCode();
        result = 31 * result + this.hostAddress.hashCode();
        return result;
    }

    public static ClientIdentifier create(long pid, String hostAddress, String name, String uuid) {
        return new ClientIdentifier(pid, hostAddress, name, uuid);
    }

    public static ClientIdentifier create(String name, String logicalConnectionUid) {
        try {
            InetAddress inetAddress = ClientIdentifier.discoverLANAddress();
            return new ClientIdentifier(ClientIdentifier.discoverPID(), inetAddress.getHostAddress(), name, logicalConnectionUid);
        }
        catch (UnknownHostException e) {
            return new ClientIdentifier(ClientIdentifier.discoverPID(), "127.0.0.1", name, logicalConnectionUid);
        }
    }

    public static ClientIdentifier valueOf(String identifier) {
        try {
            int firstColon;
            String hostAddress;
            int ampIdx = identifier.indexOf(64);
            if (identifier.charAt(ampIdx + 1) == '[') {
                int end = identifier.indexOf("]");
                hostAddress = identifier.substring(ampIdx + 2, end);
                firstColon = identifier.indexOf(58, end + 1);
            } else {
                firstColon = identifier.indexOf(58, ampIdx + 1);
                hostAddress = identifier.substring(ampIdx + 1, firstColon);
            }
            int lastColon = identifier.lastIndexOf(58);
            return new ClientIdentifier(Long.parseLong(identifier.substring(0, ampIdx)), hostAddress, identifier.substring(firstColon + 1, lastColon), identifier.substring(lastColon + 1));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(identifier);
        }
    }

    static String discoverHostName() {
        String hostname;
        block9: {
            hostname = null;
            try {
                Process process;
                String procname = "hostname";
                if (System.getProperty("os.name", "").toLowerCase().contains("win")) {
                    procname = procname + ".exe";
                }
                if ((process = Runtime.getRuntime().exec(procname)).waitFor() == 0) {
                    int r;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream in = process.getInputStream();
                    while ((r = in.read()) != -1) {
                        baos.write(r);
                    }
                    in.close();
                    hostname = new String(baos.toByteArray(), "UTF-8");
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block9;
                LOGGER.log(Level.FINEST, "ERR getHostName(): " + e.getMessage(), e);
            }
        }
        if (hostname != null) {
            return hostname;
        }
        try {
            InetAddress address = ClientIdentifier.discoverLANAddress();
            String resolved = address.getCanonicalHostName();
            if (!address.getHostAddress().equals(resolved)) {
                hostname = resolved;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostname;
    }

    static long discoverPID() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        long pid = 0L;
        for (int i = 0; i < name.length() && Character.isDigit(name.charAt(i)); ++i) {
            pid = pid * 10L + (long)Character.getNumericValue(name.charAt(i));
        }
        return pid;
    }

    static InetAddress discoverLANAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (!inetAddress.isLoopbackAddress() && inetAddress.isSiteLocalAddress()) {
            return inetAddress;
        }
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }
}

