/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.http.netty.server.NettyHttpServerEngine;
import org.apache.cxf.transport.http.netty.server.ThreadingParameters;

@NoJSR250Annotations(unlessNull={"bus"})
public class NettyHttpServerEngineFactory
implements BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpServerEngineFactory.class);
    private static ConcurrentHashMap<Integer, NettyHttpServerEngine> portMap = new ConcurrentHashMap();
    private Bus bus;
    private BusLifeCycleManager lifeCycleManager;
    private Map<String, ThreadingParameters> threadingParametersMap = new TreeMap<String, ThreadingParameters>();
    private Map<String, TLSServerParameters> tlsServerParametersMap = new TreeMap<String, TLSServerParameters>();

    public NettyHttpServerEngineFactory() {
    }

    public NettyHttpServerEngineFactory(Bus b) {
        this.setBus(b);
    }

    public NettyHttpServerEngineFactory(Bus b, Map<String, TLSServerParameters> tls, Map<String, ThreadingParameters> threads) {
        this.setBus(b);
        this.tlsServerParametersMap = tls;
        this.threadingParametersMap = threads;
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource(name="cxf")
    public final void setBus(Bus bus) {
        this.bus = bus;
        if (bus != null) {
            bus.setExtension((Object)this, NettyHttpServerEngineFactory.class);
            this.lifeCycleManager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
            if (null != this.lifeCycleManager) {
                this.lifeCycleManager.registerLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public Map<String, TLSServerParameters> getTlsServerParametersMap() {
        return this.tlsServerParametersMap;
    }

    public void setTlsServerParameters(Map<String, TLSServerParameters> tlsParametersMap) {
        this.tlsServerParametersMap = tlsParametersMap;
    }

    public Map<String, ThreadingParameters> getThreadingParametersMap() {
        return this.threadingParametersMap;
    }

    public void setThreadingParametersMap(Map<String, ThreadingParameters> parameterMap) {
        this.threadingParametersMap = parameterMap;
    }

    public void setEnginesList(List<NettyHttpServerEngine> enginesList) {
        for (NettyHttpServerEngine engine : enginesList) {
            portMap.putIfAbsent(engine.getPort(), engine);
        }
    }

    public void initComplete() {
    }

    public void postShutdown() {
        NettyHttpServerEngine[] engines;
        for (NettyHttpServerEngine engine : engines = portMap.values().toArray(new NettyHttpServerEngine[portMap.values().size()])) {
            engine.shutdown();
        }
        portMap.clear();
        this.threadingParametersMap.clear();
        this.tlsServerParametersMap.clear();
    }

    public void preShutdown() {
    }

    private static NettyHttpServerEngine getOrCreate(NettyHttpServerEngineFactory factory, String host, int port, TLSServerParameters tlsParams) throws IOException {
        NettyHttpServerEngine ref = portMap.get(port);
        if (ref == null) {
            ref = new NettyHttpServerEngine(host, port);
            if (tlsParams != null) {
                ref.setTlsServerParameters(tlsParams);
            }
            ref.finalizeConfig();
            NettyHttpServerEngine tmpRef = portMap.putIfAbsent(port, ref);
            if (tmpRef != null) {
                ref = tmpRef;
            }
        }
        return ref;
    }

    public synchronized NettyHttpServerEngine retrieveNettyHttpServerEngine(int port) {
        return portMap.get(port);
    }

    public synchronized NettyHttpServerEngine createNettyHttpServerEngine(String host, int port, String protocol) throws IOException {
        NettyHttpServerEngine ref;
        LOG.log(Level.FINE, "CREATING_NETTY_SERVER_ENGINE", port);
        TLSServerParameters tlsServerParameters = null;
        if ("https".equals(protocol) && this.tlsServerParametersMap != null) {
            tlsServerParameters = this.tlsServerParametersMap.get(Integer.toString(port));
        }
        if (!protocol.equals((ref = NettyHttpServerEngineFactory.getOrCreate(this, host, port, tlsServerParameters)).getProtocol())) {
            throw new IOException("Protocol mismatch for port " + port + ": engine's protocol is " + ref.getProtocol() + ", the url protocol is " + protocol);
        }
        return ref;
    }

    public synchronized NettyHttpServerEngine createNettyHttpServerEngine(int port, String protocol) throws IOException {
        return this.createNettyHttpServerEngine(null, port, protocol);
    }

    public static synchronized void destroyForPort(int port) {
        NettyHttpServerEngine ref = portMap.remove(port);
        if (ref != null) {
            LOG.log(Level.FINE, "STOPPING_NETTY_SERVER_ENGINE", port);
            try {
                ref.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

