/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.micrometer.provider;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.annotation.TimedSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.metrics.micrometer.provider.TimedAnnotationProvider;

public class DefaultTimedAnnotationProvider
implements TimedAnnotationProvider {
    private final ConcurrentHashMap<HandlerMethod, Set<Timed>> timedAnnotationCache = new ConcurrentHashMap();

    @Override
    public Set<Timed> getTimedAnnotations(Exchange ex) {
        HandlerMethod handlerMethod = HandlerMethod.create(ex);
        if (handlerMethod == null) {
            return Collections.emptySet();
        }
        Set<Timed> exists = this.timedAnnotationCache.get(handlerMethod);
        if (exists != null) {
            return exists;
        }
        return this.timedAnnotationCache.computeIfAbsent(handlerMethod, method -> {
            Set<Timed> timed = this.findTimedAnnotations(((HandlerMethod)method).getMethod());
            if (timed.isEmpty() && (timed = this.findTimedAnnotations(((HandlerMethod)method).getBeanType())).isEmpty()) {
                return Collections.emptySet();
            }
            return timed;
        });
    }

    Set<Timed> findTimedAnnotations(AnnotatedElement element) {
        HashSet<Annotation> foundAnnotations = new HashSet<Annotation>();
        DefaultTimedAnnotationProvider.findAllAnnotations(element, foundAnnotations);
        Stream<Timed> timedAnnotations = foundAnnotations.stream().filter(annotation -> annotation.annotationType().equals(Timed.class)).map(annotation -> (Timed)annotation);
        Stream timedAnnotationsFromTimedSet = foundAnnotations.stream().filter(annotation -> annotation.annotationType().equals(TimedSet.class)).map(annotation -> (TimedSet)annotation).map(TimedSet::value).flatMap(Arrays::stream);
        return Stream.concat(timedAnnotations, timedAnnotationsFromTimedSet).collect(Collectors.toSet());
    }

    private static void findAllAnnotations(AnnotatedElement annotatedElement, Set<Annotation> foundAnnotations) {
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            if (foundAnnotations.contains(annotation)) continue;
            foundAnnotations.add(annotation);
            DefaultTimedAnnotationProvider.findAllAnnotations(annotation.annotationType(), foundAnnotations);
        }
    }

    private static final class HandlerMethod {
        private final Class<?> beanType;
        private final Method method;

        private HandlerMethod(Class<?> beanType, Method method) {
            this.method = method;
            this.beanType = beanType;
        }

        private static HandlerMethod create(Exchange exchange) {
            return MessageUtils.getTargetMethod((Message)exchange.getInMessage()).map(method -> new HandlerMethod(method.getDeclaringClass(), (Method)method)).orElse(null);
        }

        private Class<?> getBeanType() {
            return this.beanType;
        }

        private Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerMethod that = (HandlerMethod)o;
            return Objects.equals(this.beanType, that.beanType) && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.beanType, this.method);
        }
    }
}

