/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.micrometer;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.metrics.MetricsContext;
import org.apache.cxf.metrics.micrometer.provider.TagsCustomizer;
import org.apache.cxf.metrics.micrometer.provider.TagsProvider;
import org.apache.cxf.metrics.micrometer.provider.TimedAnnotationProvider;

public class MicrometerMetricsContext
implements MetricsContext {
    private static final Logger LOG = LogUtils.getL7dLogger(MicrometerMetricsContext.class);
    private final MeterRegistry registry;
    private final TagsProvider tagsProvider;
    private final TimedAnnotationProvider timedAnnotationProvider;
    private final List<TagsCustomizer> tagsCustomizers;
    private final String metricName;
    private final boolean autoTimeRequests;

    public MicrometerMetricsContext(MeterRegistry registry, TagsProvider tagsProvider, TimedAnnotationProvider timedAnnotationProvider, List<TagsCustomizer> tagsCustomizers, String metricName, boolean autoTimeRequests) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.timedAnnotationProvider = timedAnnotationProvider;
        this.tagsCustomizers = tagsCustomizers;
        this.metricName = metricName;
        this.autoTimeRequests = autoTimeRequests;
    }

    @Override
    public void start(Exchange ex) {
        Message request = ex.getInMessage();
        TimingContext timingContext = TimingContext.get(request);
        if (timingContext == null) {
            this.startAndAttachTimingContext(request);
        }
    }

    @Override
    public void stop(long timeInNS, long inSize, long outSize, Exchange ex) {
        Message request = ex.getInMessage();
        TimingContext timingContext = TimingContext.get(request);
        if (timingContext == null) {
            LOG.warning("Unable for record metric for exchange: " + ex);
        } else {
            this.record(timingContext, ex);
        }
    }

    private void startAndAttachTimingContext(Message request) {
        Timer.Sample timerSample = Timer.start((MeterRegistry)this.registry);
        TimingContext timingContext = new TimingContext(timerSample);
        timingContext.attachTo(request);
    }

    private void record(TimingContext timingContext, Exchange ex) {
        Set<Timed> annotations = this.timedAnnotationProvider.getTimedAnnotations(ex);
        Timer.Sample timerSample = timingContext.getTimerSample();
        Supplier<Iterable<Tag>> tags = () -> this.getAllTags(ex);
        if (annotations.isEmpty()) {
            if (this.autoTimeRequests) {
                this.stop(timerSample, tags, Timer.builder((String)this.metricName));
            }
        } else {
            for (Timed annotation : annotations) {
                this.stop(timerSample, tags, Timer.builder((Timed)annotation, (String)this.metricName));
            }
        }
    }

    private Iterable<Tag> getAllTags(Exchange ex) {
        Stream<Tag> defaultTags = this.getStreamFrom(this.tagsProvider.getTags(ex));
        Stream additionalTags = this.tagsCustomizers.stream().map(tagsCustomizer -> tagsCustomizer.getAdditionalTags(ex)).flatMap(this::getStreamFrom);
        return Stream.concat(defaultTags, additionalTags).collect(Collectors.toList());
    }

    private Stream<Tag> getStreamFrom(Iterable<Tag> tags) {
        return StreamSupport.stream(tags.spliterator(), false);
    }

    private void stop(Timer.Sample timerSample, Supplier<Iterable<Tag>> tags, Timer.Builder builder) {
        timerSample.stop(builder.tags(tags.get()).register(this.registry));
    }

    static class TimingContext {
        private final Timer.Sample timerSample;

        TimingContext(Timer.Sample timerSample) {
            this.timerSample = timerSample;
        }

        public Timer.Sample getTimerSample() {
            return this.timerSample;
        }

        public void attachTo(Message request) {
            request.setContent(TimingContext.class, (Object)this);
        }

        public static TimingContext get(Message request) {
            return (TimingContext)request.getContent(TimingContext.class);
        }
    }
}

