/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.gbind;

import com.sun.tools.xjc.reader.gbind.ElementSet;
import com.sun.tools.xjc.reader.gbind.ElementSets;
import com.sun.tools.xjc.reader.gbind.Expression;

public final class Sequence
extends Expression {
    private final Expression lhs;
    private final Expression rhs;
    private final boolean isNullable;
    private ElementSet lastSet;

    public Sequence(Expression lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.isNullable = lhs.isNullable() && rhs.isNullable();
    }

    @Override
    ElementSet lastSet() {
        if (this.lastSet == null) {
            this.lastSet = this.rhs.isNullable() ? ElementSets.union(this.lhs.lastSet(), this.rhs.lastSet()) : this.rhs.lastSet();
        }
        return this.lastSet;
    }

    @Override
    boolean isNullable() {
        return this.isNullable;
    }

    @Override
    void buildDAG(ElementSet incoming) {
        this.lhs.buildDAG(incoming);
        if (this.lhs.isNullable()) {
            this.rhs.buildDAG(ElementSets.union(incoming, this.lhs.lastSet()));
        } else {
            this.rhs.buildDAG(this.lhs.lastSet());
        }
    }

    public String toString() {
        return '(' + this.lhs.toString() + ',' + this.rhs.toString() + ')';
    }
}

