/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContext;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContextImpl;
import org.apache.cxf.rs.security.oidc.rp.OidcSecurityContext;

@PreMatching
@Priority(value=1002)
public class OidcRpAuthenticationFilter
implements ContainerRequestFilter {
    @Context
    private MessageContext mc;
    private ClientTokenContextManager stateManager;
    private String redirectUri;
    private String roleClaim;
    private boolean addRequestUriAsRedirectQuery;

    public void filter(ContainerRequestContext rc) {
        if (this.checkSecurityContext(rc)) {
            return;
        }
        if (this.redirectUri != null) {
            UriBuilder redirectBuilder = null;
            if (this.redirectUri.startsWith("/")) {
                String basePath = (String)this.mc.get((Object)"http.base.path");
                redirectBuilder = UriBuilder.fromUri((String)basePath).path(this.redirectUri);
            } else {
                redirectBuilder = this.redirectUri.startsWith("http") ? UriBuilder.fromUri((URI)URI.create(this.redirectUri)) : rc.getUriInfo().getBaseUriBuilder().path(this.redirectUri);
            }
            if (this.addRequestUriAsRedirectQuery) {
                redirectBuilder.queryParam("state", new Object[]{rc.getUriInfo().getRequestUri().toString()});
            }
            URI redirectAddress = redirectBuilder.build(new Object[0]);
            rc.abortWith(Response.seeOther((URI)redirectAddress).header("Cache-Control", (Object)"no-cache, no-store").header("Pragma", (Object)"no-cache").build());
        } else {
            rc.abortWith(Response.status((int)401).build());
        }
    }

    protected boolean checkSecurityContext(ContainerRequestContext rc) {
        OidcClientTokenContext tokenContext = (OidcClientTokenContext)this.stateManager.getClientTokenContext(this.mc);
        if (tokenContext == null) {
            return false;
        }
        IdToken idToken = tokenContext.getIdToken();
        try {
            JwtUtils.validateJwtExpiry((JwtClaims)idToken, (int)0, (idToken.getExpiryTime() != null ? 1 : 0) != 0);
        }
        catch (JwtException ex) {
            this.stateManager.removeClientTokenContext((MessageContext)new MessageContextImpl(JAXRSUtils.getCurrentMessage()));
            return false;
        }
        OidcClientTokenContextImpl newTokenContext = new OidcClientTokenContextImpl();
        newTokenContext.setToken(tokenContext.getToken());
        newTokenContext.setIdToken(idToken);
        newTokenContext.setUserInfo(tokenContext.getUserInfo());
        newTokenContext.setState(this.toRequestState(rc));
        JAXRSUtils.getCurrentMessage().setContent(ClientTokenContext.class, (Object)newTokenContext);
        OidcSecurityContext oidcSecCtx = new OidcSecurityContext(newTokenContext);
        oidcSecCtx.setRoleClaim(this.roleClaim);
        rc.setSecurityContext((SecurityContext)oidcSecCtx);
        return true;
    }

    private MultivaluedMap<String, String> toRequestState(ContainerRequestContext rc) {
        MetadataMap requestState = new MetadataMap();
        requestState.putAll((Map)rc.getUriInfo().getQueryParameters(true));
        if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(rc.getMediaType())) {
            String body = FormUtils.readBody((InputStream)rc.getEntityStream(), (String)StandardCharsets.UTF_8.name());
            FormUtils.populateMapFromString((MultivaluedMap)requestState, (Message)JAXRSUtils.getCurrentMessage(), (String)body, (String)StandardCharsets.UTF_8.name(), (boolean)true);
            rc.setEntityStream((InputStream)new ByteArrayInputStream(StringUtils.toBytesUTF8((String)body)));
        }
        return requestState;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setClientTokenContextManager(ClientTokenContextManager manager) {
        this.stateManager = manager;
    }

    public void setRoleClaim(String roleClaim) {
        this.roleClaim = roleClaim;
    }

    public void setAddRequestUriAsRedirectQuery(boolean addRequestUriAsRedirectQuery) {
        this.addRequestUriAsRedirectQuery = addRequestUriAsRedirectQuery;
    }
}

