/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.websocket.WebSocketUtils;
import org.apache.cxf.transport.websocket.jetty.WebSocketServletHolder;

public class WebSocketVirtualServletResponse
implements HttpServletResponse {
    private static final Logger LOG = LogUtils.getL7dLogger(WebSocketVirtualServletResponse.class);
    private WebSocketServletHolder webSocketHolder;
    private Map<String, String> responseHeaders;
    private ServletOutputStream outputStream;

    public WebSocketVirtualServletResponse(WebSocketServletHolder websocket) {
        this.webSocketHolder = websocket;
        this.responseHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.outputStream = this.createOutputStream();
    }

    public void flushBuffer() throws IOException {
        LOG.log(Level.FINE, "flushBuffer()");
        this.outputStream.flush();
    }

    public int getBufferSize() {
        LOG.log(Level.FINE, "getBufferSize()");
        return 0;
    }

    public String getCharacterEncoding() {
        LOG.log(Level.FINE, "getCharacterEncoding()");
        return null;
    }

    public String getContentType() {
        LOG.log(Level.FINE, "getContentType()");
        return this.responseHeaders.get("Content-Type");
    }

    public Locale getLocale() {
        LOG.log(Level.FINE, "getLocale");
        return null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        LOG.log(Level.FINE, "getWriter()");
        return new PrintWriter((OutputStream)this.getOutputStream());
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void resetBuffer() {
        LOG.log(Level.FINE, "resetBuffer()");
    }

    public void setBufferSize(int size) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setBufferSize({0})", size);
        }
    }

    public void setCharacterEncoding(String charset) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setCharacterEncoding({0})", charset);
        }
    }

    public void setContentLength(int len) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setContentLength({0})", len);
        }
        this.responseHeaders.put("Content-Length", Integer.toString(len));
    }

    public void setContentType(String type) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setContentType({0})", type);
        }
        this.responseHeaders.put("Content-Type", type);
    }

    public void setLocale(Locale loc) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setLocale({0})", loc);
        }
    }

    public void addCookie(Cookie cookie) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "addCookie({0})", cookie);
        }
    }

    public void addDateHeader(String name, long date) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "addDateHeader({0}, {1})", new Object[]{name, date});
        }
    }

    public void addHeader(String name, String value) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "addHeader({0}, {1})", new Object[]{name, value});
        }
        this.responseHeaders.put(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "addIntHeader({0}, {1})", new Object[]{name, value});
        }
        this.responseHeaders.put(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "containsHeader({0})", name);
        }
        return this.responseHeaders.containsKey(name);
    }

    public String encodeRedirectURL(String url) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "encodeRedirectURL({0})", url);
        }
        return null;
    }

    public String encodeRedirectUrl(String url) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "encodeRedirectUrl({0})", url);
        }
        return null;
    }

    public String encodeURL(String url) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "encodeURL({0})", url);
        }
        return null;
    }

    public String encodeUrl(String url) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "encodeUrl({0})", url);
        }
        return null;
    }

    public String getHeader(String name) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getHeader({0})", name);
        }
        return null;
    }

    public Collection<String> getHeaderNames() {
        LOG.log(Level.FINE, "getHeaderNames()");
        return null;
    }

    public Collection<String> getHeaders(String name) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getHeaders({0})", name);
        }
        return null;
    }

    public int getStatus() {
        LOG.log(Level.FINE, "getStatus()");
        String v = this.responseHeaders.get("$sc");
        return v == null ? 200 : Integer.parseInt(v);
    }

    public void sendError(int sc) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "sendError{0}", sc);
        }
        this.responseHeaders.put("$sc", Integer.toString(sc));
        byte[] data = WebSocketUtils.buildResponse(this.responseHeaders, null, 0, 0);
        this.webSocketHolder.write(data, 0, data.length);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "sendError({0}, {1})", new Object[]{sc, msg});
        }
        this.responseHeaders.put("$sc", Integer.toString(sc));
        byte[] data = WebSocketUtils.buildResponse(this.responseHeaders, null, 0, 0);
        this.webSocketHolder.write(data, 0, data.length);
    }

    public void sendRedirect(String location) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "sendRedirect({0})", location);
        }
    }

    public void setDateHeader(String name, long date) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setDateHeader({0}, {1})", new Object[]{name, date});
        }
    }

    public void setHeader(String name, String value) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setHeader({0}, {1})", new Object[]{name, value});
        }
        this.responseHeaders.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setIntHeader({0}, {1})", new Object[]{name, value});
        }
    }

    public void setStatus(int sc) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setStatus({0})", sc);
        }
        this.responseHeaders.put("$sc", Integer.toString(sc));
    }

    public void setStatus(int sc, String sm) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setStatus({0}, {1})", new Object[]{sc, sm});
        }
        this.responseHeaders.put("$sc", Integer.toString(sc));
    }

    private ServletOutputStream createOutputStream() {
        return new ServletOutputStream(){
            private InternalByteArrayOutputStream buffer = new InternalByteArrayOutputStream();

            public void write(int b) throws IOException {
                byte[] data = new byte[]{(byte)b};
                this.write(data, 0, 1);
            }

            public void write(byte[] data) throws IOException {
                this.write(data, 0, data.length);
            }

            public void write(byte[] data, int offset, int length) throws IOException {
                if (WebSocketVirtualServletResponse.this.responseHeaders.get("$flushed") == null) {
                    this.buffer.write(data, offset, length);
                } else {
                    String respid = (String)WebSocketVirtualServletResponse.this.responseHeaders.get("responseId");
                    byte[] headers = respid != null ? WebSocketUtils.buildHeaderLine("responseId", respid) : null;
                    data = WebSocketUtils.buildResponse(headers, data, offset, length);
                    WebSocketVirtualServletResponse.this.webSocketHolder.write(data, 0, data.length);
                }
            }

            public void close() throws IOException {
                if (WebSocketVirtualServletResponse.this.responseHeaders.get("$flushed") == null) {
                    byte[] data = WebSocketUtils.buildResponse(WebSocketVirtualServletResponse.this.responseHeaders, this.buffer.getBytes(), 0, this.buffer.size());
                    WebSocketVirtualServletResponse.this.webSocketHolder.write(data, 0, data.length);
                    WebSocketVirtualServletResponse.this.responseHeaders.put("$flushed", "true");
                }
                super.close();
            }

            public boolean isReady() {
                throw new UnsupportedOperationException();
            }

            public void setWriteListener(WriteListener arg0) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setContentLengthLong(long arg0) {
        throw new UnsupportedOperationException();
    }

    private static class InternalByteArrayOutputStream
    extends ByteArrayOutputStream {
        private InternalByteArrayOutputStream() {
        }

        public byte[] getBytes() {
            return this.buf;
        }
    }
}

