/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.types.AbstractCorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaAnonStructEventProducer;
import org.apache.cxf.binding.corba.types.CorbaAnyEventProducer;
import org.apache.cxf.binding.corba.types.CorbaAnyHandler;
import org.apache.cxf.binding.corba.types.CorbaAnyListener;
import org.apache.cxf.binding.corba.types.CorbaArrayEventProducer;
import org.apache.cxf.binding.corba.types.CorbaArrayHandler;
import org.apache.cxf.binding.corba.types.CorbaArrayListener;
import org.apache.cxf.binding.corba.types.CorbaEnumEventProducer;
import org.apache.cxf.binding.corba.types.CorbaEnumHandler;
import org.apache.cxf.binding.corba.types.CorbaEnumListener;
import org.apache.cxf.binding.corba.types.CorbaExceptionEventProducer;
import org.apache.cxf.binding.corba.types.CorbaExceptionHandler;
import org.apache.cxf.binding.corba.types.CorbaExceptionListener;
import org.apache.cxf.binding.corba.types.CorbaFixedEventProducer;
import org.apache.cxf.binding.corba.types.CorbaFixedHandler;
import org.apache.cxf.binding.corba.types.CorbaFixedListener;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaObjectReferenceEventProducer;
import org.apache.cxf.binding.corba.types.CorbaObjectReferenceHandler;
import org.apache.cxf.binding.corba.types.CorbaObjectReferenceListener;
import org.apache.cxf.binding.corba.types.CorbaOctetSequenceEventProducer;
import org.apache.cxf.binding.corba.types.CorbaOctetSequenceHandler;
import org.apache.cxf.binding.corba.types.CorbaOctetSequenceListener;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveListener;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveTypeEventProducer;
import org.apache.cxf.binding.corba.types.CorbaSequenceEventProducer;
import org.apache.cxf.binding.corba.types.CorbaSequenceHandler;
import org.apache.cxf.binding.corba.types.CorbaSequenceListener;
import org.apache.cxf.binding.corba.types.CorbaStructEventProducer;
import org.apache.cxf.binding.corba.types.CorbaStructHandler;
import org.apache.cxf.binding.corba.types.CorbaStructListener;
import org.apache.cxf.binding.corba.types.CorbaTypeEventProducer;
import org.apache.cxf.binding.corba.types.CorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaUnionEventProducer;
import org.apache.cxf.binding.corba.types.CorbaUnionHandler;
import org.apache.cxf.binding.corba.types.CorbaUnionListener;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.wsdl.Abstractanonsequence;
import org.apache.cxf.binding.corba.wsdl.Abstractsequence;
import org.apache.cxf.binding.corba.wsdl.Alias;
import org.apache.cxf.binding.corba.wsdl.Anonarray;
import org.apache.cxf.binding.corba.wsdl.Anonsequence;
import org.apache.cxf.binding.corba.wsdl.Array;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.binding.corba.wsdl.Exception;
import org.apache.cxf.binding.corba.wsdl.MemberType;
import org.apache.cxf.binding.corba.wsdl.Sequence;
import org.apache.cxf.binding.corba.wsdl.Struct;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.binding.corba.wsdl.Unionbranch;
import org.apache.cxf.binding.corba.wsdl.W3CConstants;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;

public final class CorbaHandlerUtils {
    private CorbaHandlerUtils() {
    }

    public static CorbaObjectHandler createTypeHandler(ORB orb, QName name, QName idlType, CorbaTypeMap typeMap) {
        CorbaObjectHandler handler = null;
        TypeCode tc = CorbaUtils.getTypeCode(orb, idlType, typeMap);
        try {
            while (tc.kind().value() == 21) {
                Alias alias = (Alias)CorbaUtils.getCorbaType(idlType, typeMap);
                if (alias == null) {
                    throw new CorbaBindingException("Couldn't find corba alias type: " + idlType);
                }
                tc = tc.content_type();
                idlType = alias.getBasetype();
            }
        }
        catch (Throwable ex) {
            throw new CorbaBindingException(ex);
        }
        if (CorbaUtils.isPrimitiveIdlType(idlType)) {
            handler = new CorbaPrimitiveHandler(name, idlType, tc, null);
        } else if (tc.kind().value() == 11) {
            handler = new CorbaAnyHandler(name, idlType, tc, null);
            ((CorbaAnyHandler)handler).setTypeMap(typeMap);
        } else {
            CorbaType type = CorbaUtils.getCorbaType(idlType, typeMap);
            switch (tc.kind().value()) {
                case 20: {
                    handler = new CorbaArrayHandler(name, idlType, tc, type);
                    break;
                }
                case 17: {
                    handler = new CorbaEnumHandler(name, idlType, tc, type);
                    break;
                }
                case 22: {
                    handler = new CorbaExceptionHandler(name, idlType, tc, type);
                    break;
                }
                case 28: {
                    handler = new CorbaFixedHandler(name, idlType, tc, type);
                    break;
                }
                case 19: {
                    if (CorbaHandlerUtils.isOctets(type)) {
                        handler = new CorbaOctetSequenceHandler(name, idlType, tc, type);
                        break;
                    }
                    handler = new CorbaSequenceHandler(name, idlType, tc, type);
                    break;
                }
                case 15: {
                    handler = new CorbaStructHandler(name, idlType, tc, type);
                    break;
                }
                case 16: {
                    handler = new CorbaUnionHandler(name, idlType, tc, type);
                    break;
                }
                case 18: 
                case 27: {
                    handler = new CorbaPrimitiveHandler(name, idlType, tc, type);
                    break;
                }
                case 14: {
                    handler = new CorbaObjectReferenceHandler(name, idlType, tc, type);
                    break;
                }
                default: {
                    handler = new CorbaObjectHandler(name, idlType, tc, type);
                }
            }
        }
        return handler;
    }

    public static CorbaObjectHandler initializeObjectHandler(ORB orb, QName name, QName idlType, CorbaTypeMap typeMap, ServiceInfo serviceInfo) {
        HashMap<QName, CorbaObjectHandler> seenTypes = new HashMap<QName, CorbaObjectHandler>();
        return CorbaHandlerUtils.initializeObjectHandler(orb, name, idlType, typeMap, serviceInfo, seenTypes);
    }

    public static CorbaObjectHandler initializeObjectHandler(ORB orb, QName name, QName idlType, CorbaTypeMap typeMap, ServiceInfo serviceInfo, Map<QName, CorbaObjectHandler> seenTypes) {
        CorbaObjectHandler obj = CorbaHandlerUtils.createTypeHandler(orb, name, idlType, typeMap);
        if (!CorbaUtils.isPrimitiveIdlType(idlType)) {
            switch (obj.getTypeCode().kind().value()) {
                case 11: {
                    ((CorbaAnyHandler)obj).setValue(orb.create_any());
                    break;
                }
                case 20: {
                    CorbaHandlerUtils.initializeArrayHandler(orb, obj, typeMap, serviceInfo, seenTypes);
                    break;
                }
                case 22: {
                    CorbaHandlerUtils.initializeExceptionHandler(orb, obj, typeMap, serviceInfo, seenTypes);
                    break;
                }
                case 19: {
                    if (CorbaHandlerUtils.isOctets(obj.getType())) break;
                    CorbaHandlerUtils.initializeSequenceHandler(orb, obj, typeMap, serviceInfo, seenTypes);
                    break;
                }
                case 15: {
                    CorbaHandlerUtils.initializeStructHandler(orb, obj, typeMap, serviceInfo, seenTypes);
                    break;
                }
                case 16: {
                    CorbaHandlerUtils.initializeUnionHandler(orb, obj, typeMap, serviceInfo, seenTypes);
                    break;
                }
            }
        }
        return obj;
    }

    public static void initializeArrayHandler(ORB orb, CorbaObjectHandler obj, CorbaTypeMap typeMap, ServiceInfo serviceInfo, Map<QName, CorbaObjectHandler> seenTypes) {
        QName elementName;
        QName arrayElementType = null;
        long arrayBound = 0L;
        CorbaType baseType = obj.getType();
        if (baseType instanceof Array) {
            Array arrayType = (Array)baseType;
            arrayElementType = arrayType.getElemtype();
            arrayBound = arrayType.getBound();
            elementName = arrayType.getElemname();
        } else {
            Anonarray anonArrayType = (Anonarray)baseType;
            arrayElementType = anonArrayType.getElemtype();
            arrayBound = anonArrayType.getBound();
            elementName = anonArrayType.getElemname();
        }
        int i = 0;
        while ((long)i < arrayBound) {
            CorbaObjectHandler elementObj = CorbaHandlerUtils.initializeObjectHandler(orb, elementName, arrayElementType, typeMap, serviceInfo, seenTypes);
            ((CorbaArrayHandler)obj).addElement(elementObj);
            ++i;
        }
    }

    public static void initializeExceptionHandler(ORB orb, CorbaObjectHandler obj, CorbaTypeMap typeMap, ServiceInfo serviceInfo, Map<QName, CorbaObjectHandler> seenTypes) {
        Exception exceptType = (Exception)obj.getType();
        List<MemberType> exceptMembers = exceptType.getMember();
        QName typeName = exceptType.getType();
        for (int i = 0; i < exceptMembers.size(); ++i) {
            MemberType member = exceptMembers.get(i);
            QName memberName = member.isSetQualified() && member.isQualified() && typeName != null ? new QName(typeName.getNamespaceURI(), member.getName()) : new QName("", member.getName());
            QName memberType = member.getIdltype();
            CorbaObjectHandler memberObj = CorbaHandlerUtils.initializeObjectHandler(orb, memberName, memberType, typeMap, serviceInfo, seenTypes);
            ((CorbaExceptionHandler)obj).addMember(memberObj);
        }
    }

    public static void initializeSequenceHandler(ORB orb, CorbaObjectHandler obj, CorbaTypeMap typeMap, ServiceInfo serviceInfo, Map<QName, CorbaObjectHandler> seenTypes) {
        QName elementName;
        CorbaType seqType;
        QName seqElementType = null;
        long seqBound = 0L;
        CorbaType baseType = obj.getType();
        if (baseType instanceof Sequence) {
            seqType = (Sequence)baseType;
            seqElementType = ((Abstractsequence)seqType).getElemtype();
            seqBound = ((Abstractsequence)seqType).getBound();
            elementName = ((Abstractsequence)seqType).getElemname();
        } else {
            seqType = (Anonsequence)baseType;
            seqElementType = ((Abstractanonsequence)seqType).getElemtype();
            seqBound = ((Abstractanonsequence)seqType).getBound();
            elementName = ((Abstractanonsequence)seqType).getElemname();
        }
        if (seqBound == 0L) {
            CorbaObjectHandler elementObj = null;
            if (seenTypes.get(seqElementType) != null) {
                elementObj = seenTypes.get(seqElementType);
                elementObj.setRecursive(true);
                ((CorbaSequenceHandler)obj).hasRecursiveTypeElement(true);
            } else {
                elementObj = CorbaHandlerUtils.initializeObjectHandler(orb, elementName, seqElementType, typeMap, serviceInfo, seenTypes);
            }
            ((CorbaSequenceHandler)obj).setTemplateElement(elementObj);
        }
        int i = 0;
        while ((long)i < seqBound) {
            CorbaObjectHandler elementObj = null;
            if (seenTypes.get(seqElementType) != null) {
                elementObj = seenTypes.get(seqElementType);
                elementObj.setRecursive(true);
                ((CorbaSequenceHandler)obj).hasRecursiveTypeElement(true);
                ((CorbaSequenceHandler)obj).setTemplateElement(elementObj);
            } else {
                elementObj = CorbaHandlerUtils.initializeObjectHandler(orb, elementName, seqElementType, typeMap, serviceInfo, seenTypes);
                ((CorbaSequenceHandler)obj).addElement(elementObj);
            }
            ++i;
        }
    }

    public static void initializeStructHandler(ORB orb, CorbaObjectHandler obj, CorbaTypeMap typeMap, ServiceInfo serviceInfo, Map<QName, CorbaObjectHandler> seenTypes) {
        Struct structType = (Struct)obj.getType();
        List<MemberType> structMembers = structType.getMember();
        QName typeName = structType.getType();
        seenTypes.put(obj.getIdlType(), obj);
        for (int i = 0; i < structMembers.size(); ++i) {
            MemberType member = structMembers.get(i);
            QName memberName = member.isSetQualified() && member.isQualified() && typeName != null ? new QName(typeName.getNamespaceURI(), member.getName()) : new QName("", member.getName());
            QName memberType = member.getIdltype();
            CorbaObjectHandler memberObj = CorbaHandlerUtils.initializeObjectHandler(orb, memberName, memberType, typeMap, serviceInfo, seenTypes);
            if (member.isSetAnonschematype() && member.isAnonschematype()) {
                memberObj.setAnonymousType(true);
            }
            ((CorbaStructHandler)obj).addMember(memberObj);
        }
        seenTypes.remove(obj.getIdlType());
    }

    public static void initializeUnionHandler(ORB orb, CorbaObjectHandler obj, CorbaTypeMap typeMap, ServiceInfo serviceInfo, Map<QName, CorbaObjectHandler> seenTypes) {
        Union unionType = (Union)obj.getType();
        CorbaObjectHandler discObj = CorbaHandlerUtils.initializeObjectHandler(orb, new QName("discriminator"), unionType.getDiscriminator(), typeMap, serviceInfo, seenTypes);
        ((CorbaUnionHandler)obj).setDiscriminator(discObj);
        QName typeName = unionType.getType();
        seenTypes.put(obj.getIdlType(), obj);
        List<Unionbranch> unionBranches = unionType.getUnionbranch();
        for (int i = 0; i < unionBranches.size(); ++i) {
            Unionbranch branch = unionBranches.get(i);
            QName branchName = branch.isSetQualified() && branch.isQualified() && typeName != null ? new QName(typeName.getNamespaceURI(), branch.getName()) : new QName("", branch.getName());
            QName branchIdlType = branch.getIdltype();
            CorbaObjectHandler branchObj = CorbaHandlerUtils.initializeObjectHandler(orb, branchName, branchIdlType, typeMap, serviceInfo, seenTypes);
            ((CorbaUnionHandler)obj).addCase(branchObj);
        }
        seenTypes.remove(obj.getIdlType());
    }

    public static String getNamespaceURI(ServiceInfo serviceInfo, QName typeName) {
        String nsUri = "";
        if (typeName != null && CorbaUtils.isElementFormQualified(serviceInfo, typeName.getNamespaceURI())) {
            nsUri = typeName.getNamespaceURI();
        }
        return nsUri;
    }

    public static XmlSchemaElement getXmlSchemaSequenceElement(XmlSchemaObject schemaType, ServiceInfo serviceInfo) {
        XmlSchemaObject stype = schemaType;
        XmlSchemaElement el = null;
        if (schemaType instanceof XmlSchemaElement && (stype = ((XmlSchemaElement)schemaType).getSchemaType()) == null) {
            stype = CorbaUtils.getXmlSchemaType(serviceInfo, ((XmlSchemaElement)schemaType).getRef().getTargetQName());
        }
        if (stype instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType ctype = (XmlSchemaComplexType)stype;
            XmlSchemaParticle group = ctype.getParticle();
            XmlSchemaSequence seq = (XmlSchemaSequence)group;
            el = (XmlSchemaElement)seq.getItems().get(0);
        } else {
            el = (XmlSchemaElement)schemaType;
        }
        return el;
    }

    public static CorbaTypeListener getTypeListener(QName name, QName idlType, CorbaTypeMap typeMap, ORB orb, ServiceInfo serviceInfo) throws CorbaBindingException {
        CorbaObjectHandler handler = null;
        TypeCode tc = CorbaUtils.getTypeCode(orb, idlType, typeMap);
        try {
            while (tc.kind().value() == 21) {
                Alias alias = (Alias)CorbaUtils.getCorbaType(idlType, typeMap);
                if (alias == null) {
                    throw new CorbaBindingException("Couldn't find corba alias type: " + idlType);
                }
                tc = tc.content_type();
                idlType = alias.getBasetype();
            }
        }
        catch (Throwable ex) {
            throw new CorbaBindingException(ex);
        }
        AbstractCorbaTypeListener result = null;
        if (CorbaUtils.isPrimitiveIdlType(idlType)) {
            handler = new CorbaPrimitiveHandler(name, idlType, tc, null);
            result = new CorbaPrimitiveListener(handler);
        } else {
            CorbaType type = CorbaUtils.getCorbaType(idlType, typeMap);
            switch (tc.kind().value()) {
                case 11: {
                    handler = new CorbaAnyHandler(name, idlType, tc, type);
                    ((CorbaAnyHandler)handler).setTypeMap(typeMap);
                    result = new CorbaAnyListener(handler, typeMap, orb, serviceInfo);
                    break;
                }
                case 20: {
                    handler = new CorbaArrayHandler(name, idlType, tc, type);
                    result = new CorbaArrayListener(handler, typeMap, orb, serviceInfo);
                    break;
                }
                case 17: {
                    handler = new CorbaEnumHandler(name, idlType, tc, type);
                    result = new CorbaEnumListener(handler);
                    break;
                }
                case 22: {
                    handler = new CorbaExceptionHandler(name, idlType, tc, type);
                    result = new CorbaExceptionListener(handler, typeMap, orb, serviceInfo);
                    break;
                }
                case 28: {
                    handler = new CorbaFixedHandler(name, idlType, tc, type);
                    result = new CorbaFixedListener(handler);
                    break;
                }
                case 19: {
                    if (CorbaHandlerUtils.isOctets(type)) {
                        handler = new CorbaOctetSequenceHandler(name, idlType, tc, type);
                        result = new CorbaOctetSequenceListener(handler);
                        break;
                    }
                    handler = new CorbaSequenceHandler(name, idlType, tc, type);
                    result = new CorbaSequenceListener(handler, typeMap, orb, serviceInfo);
                    break;
                }
                case 18: 
                case 27: {
                    handler = new CorbaPrimitiveHandler(name, idlType, tc, type);
                    result = new CorbaPrimitiveListener(handler);
                    break;
                }
                case 15: {
                    handler = new CorbaStructHandler(name, idlType, tc, type);
                    result = new CorbaStructListener(handler, typeMap, orb, serviceInfo);
                    break;
                }
                case 16: {
                    handler = new CorbaUnionHandler(name, idlType, tc, type);
                    result = new CorbaUnionListener(handler, typeMap, orb, serviceInfo);
                    break;
                }
                case 14: {
                    handler = new CorbaObjectReferenceHandler(name, idlType, tc, type);
                    result = new CorbaObjectReferenceListener(handler, orb);
                    break;
                }
                default: {
                    throw new CorbaBindingException("Unsupported complex type " + idlType);
                }
            }
        }
        return result;
    }

    public static CorbaTypeEventProducer getTypeEventProducer(CorbaObjectHandler handler, ServiceInfo serviceInfo, ORB orb) throws CorbaBindingException {
        QName idlType = handler.getIdlType();
        TypeCode tc = handler.getTypeCode();
        CorbaTypeEventProducer result = null;
        if (CorbaUtils.isPrimitiveIdlType(idlType)) {
            result = new CorbaPrimitiveTypeEventProducer(handler);
        } else {
            switch (tc.kind().value()) {
                case 11: {
                    result = new CorbaAnyEventProducer(handler, serviceInfo, orb);
                    break;
                }
                case 20: {
                    result = new CorbaArrayEventProducer(handler, serviceInfo, orb);
                    break;
                }
                case 17: {
                    result = new CorbaEnumEventProducer(handler);
                    break;
                }
                case 22: {
                    result = new CorbaExceptionEventProducer(handler, serviceInfo, orb);
                    break;
                }
                case 28: {
                    result = new CorbaFixedEventProducer(handler);
                    break;
                }
                case 19: {
                    if (CorbaHandlerUtils.isOctets(handler.getType())) {
                        result = new CorbaOctetSequenceEventProducer(handler);
                        break;
                    }
                    result = new CorbaSequenceEventProducer(handler, serviceInfo, orb);
                    break;
                }
                case 18: 
                case 27: {
                    result = new CorbaPrimitiveTypeEventProducer(handler);
                    break;
                }
                case 15: {
                    if (handler.isAnonymousType()) {
                        result = new CorbaAnonStructEventProducer(handler, serviceInfo, orb);
                        break;
                    }
                    result = new CorbaStructEventProducer(handler, serviceInfo, orb);
                    break;
                }
                case 16: {
                    result = new CorbaUnionEventProducer(handler, serviceInfo, orb);
                    break;
                }
                case 14: {
                    result = new CorbaObjectReferenceEventProducer(handler, serviceInfo, orb);
                    break;
                }
                default: {
                    throw new CorbaBindingException("Unsupported complex type " + idlType);
                }
            }
        }
        return result;
    }

    public static boolean isPrimitiveIDLTypeSequence(CorbaObjectHandler handler) {
        QName seqElementType;
        CorbaType seqType = handler.getType();
        if (seqType instanceof Anonsequence) {
            Anonsequence anonSeqType = (Anonsequence)seqType;
            seqElementType = anonSeqType.getElemtype();
        } else {
            Sequence type = (Sequence)seqType;
            seqElementType = type.getElemtype();
        }
        return CorbaUtils.isPrimitiveIdlType(seqElementType);
    }

    public static boolean isAnonType(XmlSchemaObject schemaObj) {
        boolean result = false;
        if (schemaObj != null && !(schemaObj instanceof XmlSchemaElement) && !(schemaObj instanceof XmlSchemaComplexType)) {
            result = true;
        }
        return result;
    }

    public static boolean isOctets(CorbaType baseType) {
        return baseType.getType().equals(W3CConstants.NT_SCHEMA_BASE64) || baseType.getType().equals(W3CConstants.NT_SCHEMA_HBIN);
    }
}

