/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow.spring;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.TLSServerParametersConfig;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.http_undertow.ThreadingParameters;
import org.apache.cxf.transports.http_undertow.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_undertow.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_undertow.configuration.ThreadingParametersType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NoJSR250Annotations
public final class UndertowSpringTypesFactory {
    private static Map<String, ThreadingParameters> toThreadingParameters(List<ThreadingParametersIdentifiedType> list) {
        TreeMap<String, ThreadingParameters> map = new TreeMap<String, ThreadingParameters>();
        for (ThreadingParametersIdentifiedType t : list) {
            ThreadingParameters parameter = UndertowSpringTypesFactory.toThreadingParameters(t.getThreadingParameters());
            map.put(t.getId(), parameter);
        }
        return map;
    }

    private static ThreadingParameters toThreadingParameters(ThreadingParametersType paramtype) {
        ThreadingParameters params = new ThreadingParameters();
        params.setMaxThreads(paramtype.getMaxThreads());
        params.setMinThreads(paramtype.getMinThreads());
        params.setWorkerIOThreads(paramtype.getWorkerIOThreads());
        return params;
    }

    private static Map<String, TLSServerParameters> toTLSServerParamenters(List<TLSServerParametersIdentifiedType> list) {
        TreeMap<String, TLSServerParameters> map = new TreeMap<String, TLSServerParameters>();
        for (TLSServerParametersIdentifiedType t : list) {
            try {
                TLSServerParametersConfig parameter = new TLSServerParametersConfig(t.getTlsServerParameters());
                map.put(t.getId(), (TLSServerParameters)parameter);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not configure TLS for id " + t.getId(), e);
            }
        }
        return map;
    }

    public Map<String, ThreadingParameters> createThreadingParametersMap(String s, JAXBContext ctx) throws Exception {
        Document doc = StaxUtils.read((Reader)new StringReader(s));
        List<ThreadingParametersIdentifiedType> threadingParametersIdentifiedTypes = UndertowSpringTypesFactory.parseListElement(doc.getDocumentElement(), new QName("http://cxf.apache.org/transports/http-undertow/configuration", "identifiedThreadingParameters"), ThreadingParametersIdentifiedType.class, ctx);
        return UndertowSpringTypesFactory.toThreadingParameters(threadingParametersIdentifiedTypes);
    }

    public Map<String, TLSServerParameters> createTLSServerParametersMap(String s, JAXBContext ctx) throws Exception {
        Document doc = StaxUtils.read((Reader)new StringReader(s));
        List<TLSServerParametersIdentifiedType> tlsServerParameters = UndertowSpringTypesFactory.parseListElement(doc.getDocumentElement(), new QName("http://cxf.apache.org/transports/http-undertow/configuration", "identifiedTLSServerParameters"), TLSServerParametersIdentifiedType.class, ctx);
        return UndertowSpringTypesFactory.toTLSServerParamenters(tlsServerParameters);
    }

    public static <V> List<V> parseListElement(Element parent, QName name, Class<?> c, JAXBContext context) throws JAXBException {
        ArrayList<Object> list = new ArrayList<Object>();
        Node data = null;
        Unmarshaller u = context.createUnmarshaller();
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object obj;
            if (node.getNodeType() != 1 || !name.getLocalPart().equals(node.getLocalName()) || !name.getNamespaceURI().equals(node.getNamespaceURI()) || (obj = UndertowSpringTypesFactory.unmarshal(u, data = node, c)) == null) continue;
            list.add(obj);
        }
        return list;
    }

    private static Object unmarshal(Unmarshaller u, Node data, Class<?> c) {
        if (u == null) {
            return null;
        }
        Object obj = null;
        try {
            obj = c != null ? u.unmarshal(data, c) : u.unmarshal(data);
            if (obj instanceof JAXBElement) {
                JAXBElement el = (JAXBElement)obj;
                obj = el.getValue();
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not parse configuration.", e);
        }
        return obj;
    }
}

