/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.idp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Path;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.oauth2.services.AuthorizationMetadataService;

@Path(value="openid-configuration")
public class OidcConfigurationService
extends AuthorizationMetadataService {
    private static final List<String> DEFAULT_RESPONSE_TYPES = Arrays.asList("code", "code id_token", "id_token", "token id_token");
    private List<String> responseTypes;
    private boolean userInfoEndpointNotAvailable;
    private String userInfoEndpointAddress;
    private boolean endSessionEndpointNotAvailable;
    private String endSessionEndpointAddress;
    private boolean backChannelLogoutSupported;

    protected void prepareConfigurationData(Map<String, Object> cfg, String baseUri) {
        Properties sigProps;
        super.prepareConfigurationData(cfg, baseUri);
        if (!this.isUserInfoEndpointNotAvailable()) {
            String theUserInfoEndpointAddress = OidcConfigurationService.calculateEndpointAddress((String)this.userInfoEndpointAddress, (String)baseUri, (String)"/users/userinfo");
            cfg.put("userinfo_endpoint", theUserInfoEndpointAddress);
        }
        if ((sigProps = JwsUtils.loadSignatureOutProperties((boolean)false)) != null && sigProps.containsKey("rs.security.signature.algorithm")) {
            cfg.put("id_token_signing_alg_values_supported", Collections.singletonList(sigProps.get("rs.security.signature.algorithm")));
        }
        if (!this.isEndSessionEndpointNotAvailable()) {
            String theEndSessionEndpointAddress = OidcConfigurationService.calculateEndpointAddress((String)this.endSessionEndpointAddress, (String)baseUri, (String)"/idp/logout");
            cfg.put("end_session_endpoint", theEndSessionEndpointAddress);
        }
        if (this.isBackChannelLogoutSupported()) {
            cfg.put("backchannel_logout_supported", Boolean.TRUE);
        }
        cfg.put("subject_types_supported", Collections.singletonList("public"));
        List<String> theResponseTypes = this.responseTypes == null ? DEFAULT_RESPONSE_TYPES : this.responseTypes;
        cfg.put("response_types_supported", theResponseTypes);
    }

    public boolean isUserInfoEndpointNotAvailable() {
        return this.userInfoEndpointNotAvailable;
    }

    public void setUserInfoEndpointNotAvailable(boolean userInfoEndpointNotAvailable) {
        this.userInfoEndpointNotAvailable = userInfoEndpointNotAvailable;
    }

    public boolean isEndSessionEndpointNotAvailable() {
        return this.endSessionEndpointNotAvailable;
    }

    public void setEndSessionEndpointNotAvailable(boolean endSessionEndpointNotAvailable) {
        this.endSessionEndpointNotAvailable = endSessionEndpointNotAvailable;
    }

    public String getEndSessionEndpointAddress() {
        return this.endSessionEndpointAddress;
    }

    public void setEndSessionEndpointAddress(String endSessionEndpointAddress) {
        this.endSessionEndpointAddress = endSessionEndpointAddress;
    }

    public boolean isBackChannelLogoutSupported() {
        return this.backChannelLogoutSupported;
    }

    public void setBackChannelLogoutSupported(boolean backChannelLogoutSupported) {
        this.backChannelLogoutSupported = backChannelLogoutSupported;
    }

    public List<String> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<String> responseTypes) {
        this.responseTypes = responseTypes;
    }
}

