/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl;

public interface CDIInterceptorWrapper {
    public static final Logger LOG = LogUtils.getL7dLogger(CDIInterceptorWrapper.class);

    public static CDIInterceptorWrapper createWrapper(Class<?> restClient) {
        try {
            return AccessController.doPrivileged(() -> {
                Class<?> cdiClass = Class.forName("javax.enterprise.inject.spi.CDI", false, restClient.getClassLoader());
                Method currentMethod = cdiClass.getMethod("current", new Class[0]);
                Object cdiCurrent = currentMethod.invoke(null, new Object[0]);
                Method getBeanMgrMethod = cdiClass.getMethod("getBeanManager", new Class[0]);
                return new CDIInterceptorWrapperImpl(restClient, getBeanMgrMethod.invoke(cdiCurrent, new Object[0]));
            });
        }
        catch (PrivilegedActionException pae) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Unable to load CDI SPI classes, assuming no CDI is available", pae);
            }
            return new BasicCDIInterceptorWrapper();
        }
    }

    public Object invoke(Object var1, Method var2, Object[] var3, Callable<Object> var4) throws Exception;

    public static class BasicCDIInterceptorWrapper
    implements CDIInterceptorWrapper {
        BasicCDIInterceptorWrapper() {
        }

        @Override
        public Object invoke(Object restClient, Method m, Object[] params, Callable<Object> callable) throws Exception {
            return callable.call();
        }
    }
}

