/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.lang.reflect.Type;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import javax.ws.rs.client.InvocationCallback;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.message.Message;

public class MPRestClientCallback<T>
extends JaxrsClientCallback<T> {
    private final ExecutorService executor;

    public MPRestClientCallback(InvocationCallback<T> handler, Message outMessage, Class<?> responseClass, Type outGenericType) {
        super(handler, responseClass, outGenericType);
        ExecutorService es = (ExecutorService)outMessage.get(ExecutorService.class);
        this.executor = es != null ? es : ForkJoinPool.commonPool();
    }

    public Future<T> createFuture() {
        return CompletableFuture.supplyAsync(() -> {
            MPRestClientCallback mPRestClientCallback = this;
            synchronized (mPRestClientCallback) {
                if (!this.isDone()) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException e) {
                        throw new CompletionException(e);
                    }
                }
            }
            if (this.exception != null) {
                throw new CompletionException(this.exception);
            }
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            if (!this.isDone()) {
                throw new IllegalStateException("CompletionStage has been notified, indicating completion, but is not completed.");
            }
            try {
                return this.get()[0];
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, this.executor);
    }
}

