/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AuthenticationTagProducer;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweCompactBuilder;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.rt.security.crypto.KeyProperties;

public abstract class AbstractJweEncryption
implements JweEncryptionProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJweEncryption.class);
    protected static final int DEFAULT_AUTH_TAG_LENGTH = 128;
    private ContentEncryptionProvider contentEncryptionAlgo;
    private KeyEncryptionProvider keyEncryptionAlgo;
    private JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter();

    protected AbstractJweEncryption(ContentEncryptionProvider contentEncryptionAlgo, KeyEncryptionProvider keyEncryptionAlgo) {
        this.keyEncryptionAlgo = keyEncryptionAlgo;
        this.contentEncryptionAlgo = contentEncryptionAlgo;
    }

    protected ContentEncryptionProvider getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgo;
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
        return this.getContentEncryptionAlgorithm().getAlgorithmParameterSpec(theIv);
    }

    protected byte[] getContentEncryptionKey(JweHeaders headers) {
        return this.getContentEncryptionAlgorithm().getContentEncryptionKey(headers);
    }

    protected byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] theCek) {
        return this.getKeyEncryptionAlgo().getEncryptedContentEncryptionKey(headers, theCek);
    }

    protected String getContentEncryptionAlgoJwt() {
        return this.getContentEncryptionAlgorithm().getAlgorithm().getJwaName();
    }

    protected String getContentEncryptionAlgoJava() {
        return this.getContentEncryptionAlgorithm().getAlgorithm().getJavaName();
    }

    protected byte[] getAAD(String protectedHeaders, byte[] aad) {
        return this.getContentEncryptionAlgorithm().getAdditionalAuthenticationData(protectedHeaders, aad);
    }

    @Override
    public String encrypt(byte[] content, JweHeaders jweHeaders) {
        JweEncryptionInternal state = this.getInternalState(jweHeaders, new JweEncryptionInput());
        byte[] encryptedContent = this.encryptInternal(state, content);
        byte[] cipher = this.getActualCipher(encryptedContent);
        byte[] authTag = this.getAuthenticationTag(state, encryptedContent);
        JweCompactBuilder producer = new JweCompactBuilder(state.protectedHeadersJson, state.jweContentEncryptionKey, state.theIv, cipher, authTag);
        return producer.getJweContent();
    }

    @Override
    public JweEncryptionOutput getEncryptionOutput(JweEncryptionInput jweInput) {
        JweEncryptionInternal state = this.getInternalState(jweInput.getJweHeaders(), jweInput);
        Cipher c = null;
        AuthenticationTagProducer authTagProducer = null;
        byte[] cipher = null;
        byte[] authTag = null;
        if (jweInput.isContentEncryptionRequired()) {
            if (jweInput.getContent() == null) {
                c = CryptoUtils.initCipher((Key)this.createCekSecretKey(state), (KeyProperties)state.keyProps, (int)1);
                authTagProducer = this.getAuthenticationTagProducer(state);
            } else {
                byte[] encryptedContent = this.encryptInternal(state, jweInput.getContent());
                cipher = this.getActualCipher(encryptedContent);
                authTag = this.getAuthenticationTag(state, encryptedContent);
            }
        }
        return new JweEncryptionOutput(c, state.theHeaders, state.jweContentEncryptionKey, state.theIv, authTagProducer, state.keyProps, cipher, authTag);
    }

    protected byte[] encryptInternal(JweEncryptionInternal state, byte[] content) {
        try {
            SecretKey createCekSecretKey = this.createCekSecretKey(state);
            byte[] encryptedBytes = CryptoUtils.encryptBytes((byte[])content, (Key)createCekSecretKey, (KeyProperties)state.keyProps);
            try {
                createCekSecretKey.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
            return encryptedBytes;
        }
        catch (SecurityException ex) {
            LOG.fine(ex.getMessage());
            if (ex.getCause() instanceof NoSuchAlgorithmException) {
                LOG.warning("Unsupported algorithm: " + state.keyProps.getKeyAlgo());
                throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
            }
            throw new JweException(JweException.Error.CONTENT_ENCRYPTION_FAILURE, (Throwable)ex);
        }
    }

    protected byte[] getActualCipher(byte[] cipher) {
        return Arrays.copyOf(cipher, cipher.length - 16);
    }

    protected byte[] getAuthenticationTag(JweEncryptionInternal state, byte[] cipher) {
        return Arrays.copyOfRange(cipher, cipher.length - 16, cipher.length);
    }

    @Override
    public KeyAlgorithm getKeyAlgorithm() {
        KeyAlgorithm keyAlgo = this.getKeyEncryptionAlgo().getAlgorithm();
        return keyAlgo != null ? keyAlgo : null;
    }

    @Override
    public ContentAlgorithm getContentAlgorithm() {
        return this.getContentEncryptionAlgorithm().getAlgorithm();
    }

    protected JsonMapObjectReaderWriter getJwtHeadersWriter() {
        return this.writer;
    }

    protected AuthenticationTagProducer getAuthenticationTagProducer(JweEncryptionInternal state) {
        return null;
    }

    protected SecretKey createCekSecretKey(JweEncryptionInternal state) {
        return CryptoUtils.createSecretKeySpec((byte[])this.getActualCek(state.secretKey, this.getContentEncryptionAlgoJwt()), (String)state.keyProps.getKeyAlgo());
    }

    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        return theCek;
    }

    private JweEncryptionInternal getInternalState(JweHeaders jweInHeaders, JweEncryptionInput jweInput) {
        JweHeaders theHeaders = new JweHeaders();
        if (this.getKeyAlgorithm() != null) {
            theHeaders.setKeyEncryptionAlgorithm(this.getKeyAlgorithm());
        }
        theHeaders.setContentEncryptionAlgorithm(this.getContentEncryptionAlgorithm().getAlgorithm());
        JweHeaders protectedHeaders = null;
        if (jweInHeaders != null) {
            if (!(jweInHeaders.getKeyEncryptionAlgorithm() == null || this.getKeyAlgorithm() != null && this.getKeyAlgorithm().equals((Object)jweInHeaders.getKeyEncryptionAlgorithm()))) {
                LOG.warning("Invalid key encryption algorithm");
                throw new JweException(JweException.Error.INVALID_KEY_ALGORITHM);
            }
            if (jweInHeaders.getContentEncryptionAlgorithm() != null && !this.getContentEncryptionAlgoJwt().equals(jweInHeaders.getContentEncryptionAlgorithm().getJwaName())) {
                LOG.warning("Invalid content encryption algorithm");
                throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
            }
            theHeaders.asMap().putAll(jweInHeaders.asMap());
            protectedHeaders = jweInHeaders.getProtectedHeaders() != null ? jweInHeaders.getProtectedHeaders() : theHeaders;
        } else {
            protectedHeaders = theHeaders;
        }
        byte[] theCek = jweInput.getCek() != null ? jweInput.getCek() : this.getContentEncryptionKey(theHeaders);
        JweEncryptionInternal state = new JweEncryptionInternal();
        state.jweContentEncryptionKey = this.getEncryptedContentEncryptionKey(theHeaders, theCek);
        if (jweInput.isContentEncryptionRequired()) {
            String contentEncryptionAlgoJavaName = this.getContentEncryptionAlgoJava();
            KeyProperties keyProps = new KeyProperties(contentEncryptionAlgoJavaName);
            keyProps.setCompressionSupported(this.compressionRequired(theHeaders));
            byte[] theIv = jweInput.getIv() != null ? jweInput.getIv() : this.getContentEncryptionAlgorithm().getInitVector();
            AlgorithmParameterSpec specParams = this.getAlgorithmParameterSpec(theIv);
            keyProps.setAlgoSpec(specParams);
            String protectedHeadersJson = this.writer.toJson((JsonMapObject)protectedHeaders);
            byte[] additionalEncryptionParam = this.getAAD(protectedHeadersJson, jweInput.getAad());
            keyProps.setAdditionalData(additionalEncryptionParam);
            state.keyProps = keyProps;
            state.theIv = theIv;
            state.theHeaders = theHeaders;
            state.protectedHeadersJson = protectedHeadersJson;
            state.aad = jweInput.getAad();
            state.secretKey = theCek;
        }
        return state;
    }

    private boolean compressionRequired(JweHeaders theHeaders) {
        return "DEF".equals(theHeaders.getZipAlgorithm());
    }

    protected KeyEncryptionProvider getKeyEncryptionAlgo() {
        return this.keyEncryptionAlgo;
    }

    protected static class JweEncryptionInternal {
        JweHeaders theHeaders;
        byte[] jweContentEncryptionKey;
        byte[] theIv;
        KeyProperties keyProps;
        byte[] secretKey;
        String protectedHeadersJson;
        byte[] aad;

        protected JweEncryptionInternal() {
        }
    }
}

