/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tomitribe.auth.signatures.Join;
import org.tomitribe.auth.signatures.MissingRequiredHeaderException;

public enum Signatures {


    public static String createSigningString(List<String> required, String method, String uri, Map<String, String> headers) {
        method = Signatures.lowercase(method);
        headers = Signatures.lowercase(headers);
        ArrayList<String> list = new ArrayList<String>(required.size());
        for (String key : required) {
            if ("(request-target)".equals(key)) {
                list.add(Join.join(" ", "(request-target):", method, uri));
                continue;
            }
            String value = headers.get(key);
            if (value == null) {
                throw new MissingRequiredHeaderException(key);
            }
            list.add(key + ": " + value);
        }
        return Join.join("\n", list);
    }

    private static Map<String, String> lowercase(Map<String, String> headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            map.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return map;
    }

    private static String lowercase(String spec) {
        return spec.toLowerCase();
    }
}

