/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.security.Principal;
import org.apache.cxf.rt.security.claims.Claim;

public class ProcessedClaim
extends Claim {
    private static final long serialVersionUID = -336574019841442184L;
    private String issuer;
    private String originalIssuer;
    private transient Principal principal;

    public ProcessedClaim() {
    }

    public ProcessedClaim(ProcessedClaim processedClaim) {
        super((Claim)processedClaim);
        this.issuer = processedClaim.issuer;
        this.originalIssuer = processedClaim.originalIssuer;
        this.principal = processedClaim.principal;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getOriginalIssuer() {
        return this.originalIssuer;
    }

    public void setOriginalIssuer(String originalIssuer) {
        this.originalIssuer = originalIssuer;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProcessedClaim [");
        builder.append(super.toString());
        builder.append(", issuer=");
        builder.append(this.issuer);
        builder.append(", originalIssuer=");
        builder.append(this.originalIssuer);
        builder.append(", principal=");
        builder.append(this.principal);
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.issuer == null ? 0 : this.issuer.hashCode());
        result = 31 * result + (this.originalIssuer == null ? 0 : this.originalIssuer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProcessedClaim)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ProcessedClaim other = (ProcessedClaim)((Object)obj);
        if (this.issuer == null ? other.issuer != null : !this.issuer.equals(other.issuer)) {
            return false;
        }
        return !(this.originalIssuer == null ? other.originalIssuer != null : !this.originalIssuer.equals(other.originalIssuer));
    }

    public ProcessedClaim clone() {
        super.clone();
        return new ProcessedClaim(this);
    }
}

