/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.tools.util.PropertyUtil;
import org.xml.sax.InputSource;

public class ProcessorEnvironment {
    private Map<String, Object> paramMap;
    private String packageName;
    private Map<String, String> namespacePackageMap = new HashMap<String, String>();
    private Map<String, String> excludeNamespacePackageMap = new HashMap<String, String>();
    private final Map<String, InputSource> jaxbBindingFiles = new HashMap<String, InputSource>();

    public void loadDefaultNS2Pck() {
        try {
            PropertyUtil properties = new PropertyUtil();
            properties.load(this.getResourceAsStream("toolspec/toolspecs/namespace2package.cfg"));
            this.namespacePackageMap.putAll(properties.getMaps());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadDefaultExcludes() {
        try {
            PropertyUtil properties = new PropertyUtil();
            properties.load(this.getResourceAsStream("toolspec/toolspecs/wsdltojavaexclude.cfg"));
            this.excludeNamespacePackageMap.putAll(properties.getMaps());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InputStream getResourceAsStream(String file) throws IOException {
        return ProcessorEnvironment.class.getResourceAsStream(file);
    }

    public void setParameters(Map<String, Object> map) {
        this.paramMap = map;
    }

    public boolean containsKey(String key) {
        return this.paramMap != null && this.paramMap.containsKey(key);
    }

    public Object get(String key) {
        return this.paramMap == null ? null : this.paramMap.get(key);
    }

    public Object get(String key, Object defaultValue) {
        if (!this.optionSet(key)) {
            return defaultValue;
        }
        return this.get(key);
    }

    public boolean getBooleanValue(String key, String defaultValue) {
        return Boolean.valueOf((String)this.get(key, defaultValue));
    }

    public void put(String key, Object value) {
        if (this.paramMap == null) {
            this.paramMap = new HashMap<String, Object>();
        }
        this.paramMap.put(key, value);
    }

    public void remove(String key) {
        if (this.paramMap == null) {
            return;
        }
        this.paramMap.remove(key);
    }

    public boolean optionSet(String key) {
        return this.get(key) != null;
    }

    public boolean isVerbose() {
        return this.optionSet("verbose");
    }

    public void addNamespacePackageMap(String namespace, String pn) {
        this.namespacePackageMap.put(namespace, pn);
    }

    private String mapNamespaceToPackageName(String ns) {
        return this.namespacePackageMap.get(ns);
    }

    public boolean hasNamespace(String ns) {
        return this.namespacePackageMap.containsKey(ns);
    }

    public void addExcludeNamespacePackageMap(String namespace, String pn) {
        this.excludeNamespacePackageMap.put(namespace, pn);
    }

    public boolean hasExcludeNamespace(String ns) {
        return this.excludeNamespacePackageMap.containsKey(ns);
    }

    public String getExcludePackageName(String ns) {
        return this.excludeNamespacePackageMap.get(ns);
    }

    public void setPackageName(String pkgName) {
        this.packageName = pkgName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String mapPackageName(String ns) {
        if (this.hasNamespace(ns)) {
            return this.mapNamespaceToPackageName(ns);
        }
        return this.getPackageName();
    }

    public String getCustomizedNS(String ns) {
        return PackageUtils.getNamespace((String)this.mapPackageName(ns));
    }

    public void addJaxbBindingFile(String location, InputSource is) {
        this.jaxbBindingFiles.put(location, is);
    }

    public Map<String, InputSource> getJaxbBindingFile() {
        return this.jaxbBindingFiles;
    }

    public boolean isExcludeNamespaceEnabled() {
        return !this.excludeNamespacePackageMap.isEmpty();
    }
}

