/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.filters;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.httpsignature.MessageSigner;
import org.apache.cxf.rs.security.httpsignature.filters.VerifySignatureFilter;

@Provider
@PreMatching
@Priority(value=1000)
public final class CreateSignatureFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(VerifySignatureFilter.class);
    private MessageSigner messageSigner;
    private boolean enabled;

    public CreateSignatureFilter() {
        this.setEnabled(true);
    }

    public void filter(ContainerRequestContext requestCtx) {
        if (!this.enabled) {
            LOG.fine("Create signature filter is disabled");
            return;
        }
        if (this.messageSigner == null) {
            LOG.warning("Message signer cannot be null");
            return;
        }
        MultivaluedMap responseHeaders = requestCtx.getHeaders();
        if (responseHeaders.containsKey((Object)"Signature")) {
            LOG.fine("Message already contains a signature");
            return;
        }
        LOG.fine("Starting filter message signing process");
        try {
            this.messageSigner.sign((Map<String, List<String>>)responseHeaders, requestCtx.getUriInfo().getAbsolutePath().getPath(), requestCtx.getMethod());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOG.fine("Finished filter message verification process");
    }

    public MessageSigner getMessageSigner() {
        return this.messageSigner;
    }

    public void setMessageSigner(MessageSigner messageSigner) {
        Objects.requireNonNull(messageSigner);
        this.messageSigner = messageSigner;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

