/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature;

import java.security.Security;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.httpsignature.SignatureValidator;
import org.apache.cxf.rs.security.httpsignature.TomitribeSignatureValidator;
import org.apache.cxf.rs.security.httpsignature.exception.MissingSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.exception.MultipleSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.provider.AlgorithmProvider;
import org.apache.cxf.rs.security.httpsignature.provider.PublicKeyProvider;
import org.apache.cxf.rs.security.httpsignature.provider.SecurityProvider;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;

public class MessageVerifier {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageVerifier.class);
    private AlgorithmProvider algorithmProvider;
    private PublicKeyProvider publicKeyProvider;
    private SecurityProvider securityProvider;
    private final SignatureValidator signatureValidator;

    public MessageVerifier(PublicKeyProvider publicKeyProvider) {
        this(publicKeyProvider, keyId -> Security.getProvider("SunRsaSign"), keyId -> "rsa-sha256");
    }

    public MessageVerifier(PublicKeyProvider publicKeyProvider, SecurityProvider securityProvider, AlgorithmProvider algorithmProvider) {
        this.setPublicKeyProvider(publicKeyProvider);
        this.setSecurityProvider(securityProvider);
        this.setAlgorithmProvider(algorithmProvider);
        this.signatureValidator = new TomitribeSignatureValidator();
    }

    public final void setPublicKeyProvider(PublicKeyProvider publicKeyProvider) {
        this.publicKeyProvider = Objects.requireNonNull(publicKeyProvider, "public key provider cannot be null");
    }

    public final void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = Objects.requireNonNull(securityProvider, "security provider cannot be null");
    }

    public final void setAlgorithmProvider(AlgorithmProvider algorithmProvider) {
        this.algorithmProvider = Objects.requireNonNull(algorithmProvider, "algorithm provider cannot be null");
    }

    public void verifyMessage(Map<String, List<String>> messageHeaders, String method, String uri) {
        SignatureHeaderUtils.inspectMessageHeaders(messageHeaders);
        this.inspectMissingSignatureHeader(messageHeaders);
        this.inspectMultipleSignatureHeaders(messageHeaders);
        LOG.fine("Starting signature verification");
        this.signatureValidator.validate(messageHeaders, this.algorithmProvider, this.publicKeyProvider, this.securityProvider, method, uri);
        LOG.fine("Finished signature verification");
    }

    private void inspectMultipleSignatureHeaders(Map<String, List<String>> responseHeaders) {
        if (responseHeaders.get("Signature").size() > 1) {
            throw new MultipleSignatureHeaderException("there are multiple signature headers in request");
        }
    }

    private void inspectMissingSignatureHeader(Map<String, List<String>> responseHeaders) {
        if (!responseHeaders.containsKey("Signature")) {
            throw new MissingSignatureHeaderException("there is no signature header in request");
        }
    }
}

