/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.filters;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.httpsignature.MessageSigner;
import org.apache.cxf.rs.security.httpsignature.filters.VerifySignatureFilter;

@Provider
@Priority(value=1000)
public final class CreateSignatureClientFilter
implements ClientRequestFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(VerifySignatureFilter.class);
    private MessageSigner messageSigner;
    private boolean enabled;

    public CreateSignatureClientFilter() {
        this.setEnabled(true);
    }

    public void filter(ClientRequestContext requestCtx) {
        if (!this.enabled) {
            LOG.fine("Create signature filter is disabled");
            return;
        }
        if (this.messageSigner == null) {
            LOG.warning("Message signer cannot be null");
            return;
        }
        MultivaluedMap requestHeaders = requestCtx.getHeaders();
        if (requestHeaders.containsKey((Object)"Signature")) {
            LOG.fine("Message already contains a signature");
            return;
        }
        LOG.fine("Starting filter message signing process");
        Map<String, List<String>> convertedHeaders = this.convertHeaders((MultivaluedMap<String, Object>)requestHeaders);
        try {
            this.messageSigner.sign(convertedHeaders, requestCtx.getUri().getPath(), requestCtx.getMethod());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        requestHeaders.put((Object)"Signature", Collections.singletonList(convertedHeaders.get("Signature").get(0)));
        LOG.fine("Finished filter message verification process");
    }

    private Map<String, List<String>> convertHeaders(MultivaluedMap<String, Object> requestHeaders) {
        HashMap<String, List<String>> convertedHeaders = new HashMap<String, List<String>>(requestHeaders.size());
        for (Map.Entry entry : requestHeaders.entrySet()) {
            convertedHeaders.put((String)entry.getKey(), ((List)entry.getValue()).stream().map(o -> o.toString()).collect(Collectors.toList()));
        }
        return convertedHeaders;
    }

    public MessageSigner getMessageSigner() {
        return this.messageSigner;
    }

    public void setMessageSigner(MessageSigner messageSigner) {
        Objects.requireNonNull(messageSigner);
        this.messageSigner = messageSigner;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

