/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature;

import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cxf.rs.security.httpsignature.SignatureCreator;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.Signer;

public class TomitribeSignatureCreator
implements SignatureCreator {
    private final String signatureAlgorithmName;
    private final PrivateKey privateKey;
    private final String keyId;

    public TomitribeSignatureCreator(String signatureAlgorithmName, PrivateKey privateKey, String keyId) {
        this.signatureAlgorithmName = signatureAlgorithmName;
        this.privateKey = privateKey;
        this.keyId = keyId;
    }

    @Override
    public String createSignature(Map<String, List<String>> messageHeaders, String uri, String method) throws IOException {
        if (messageHeaders == null) {
            throw new IllegalArgumentException("message headers cannot be null");
        }
        List headers = messageHeaders.keySet().stream().map(String::toLowerCase).collect(Collectors.toList());
        headers.add("(request-target)");
        if (this.keyId == null) {
            throw new IllegalArgumentException("key id cannot be null");
        }
        Signature signature = new Signature(this.keyId, this.signatureAlgorithmName, null, headers);
        Signer signer = new Signer((Key)this.privateKey, signature);
        return signer.sign(method, uri, SignatureHeaderUtils.mapHeaders(messageHeaders)).toString();
    }
}

