/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.cxf.sts.claims.ClaimsUtils;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;
import org.apache.cxf.sts.token.provider.AttributeStatementProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;

public class ClaimsAttributeStatementProvider
implements AttributeStatementProvider {
    private String nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";

    @Override
    public AttributeStatementBean getStatement(TokenProviderParameters providerParameters) {
        ProcessedClaimCollection retrievedClaims = ClaimsUtils.processClaims(providerParameters);
        if (retrievedClaims == null) {
            return null;
        }
        Iterator claimIterator = retrievedClaims.iterator();
        if (!claimIterator.hasNext()) {
            return null;
        }
        ArrayList<AttributeBean> attributeList = new ArrayList<AttributeBean>();
        String tokenType = providerParameters.getTokenRequirements().getTokenType();
        boolean saml2 = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType);
        AttributeStatementBean attrBean = new AttributeStatementBean();
        while (claimIterator.hasNext()) {
            ProcessedClaim claim = (ProcessedClaim)((Object)claimIterator.next());
            AttributeBean attributeBean = new AttributeBean();
            String claimType = claim.getClaimType();
            if (saml2) {
                attributeBean.setQualifiedName(claimType);
                attributeBean.setNameFormat(this.nameFormat);
            } else {
                String uri = claimType;
                int lastSlash = uri.lastIndexOf("/");
                if (lastSlash == uri.length() - 1) {
                    uri = uri.substring(0, lastSlash);
                    lastSlash = uri.lastIndexOf("/");
                }
                String namespace = uri.substring(0, lastSlash);
                String name = uri.substring(lastSlash + 1, uri.length());
                attributeBean.setSimpleName(name);
                attributeBean.setQualifiedName(namespace);
            }
            attributeBean.setAttributeValues(claim.getValues());
            attributeList.add(attributeBean);
        }
        attrBean.setSamlAttributes(attributeList);
        return attrBean;
    }

    public String getNameFormat() {
        return this.nameFormat;
    }

    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }
}

