/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.TypeMappingType;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Element;

public class WSDLSchemaManager {
    Map<String, Definition> defns = new HashMap<String, Definition>();
    Map<String, XmlSchema> schemas = new HashMap<String, XmlSchema>();
    Map<File, Definition> importedDefns = new HashMap<File, Definition>();
    Map<File, XmlSchema> importedSchemas = new HashMap<File, XmlSchema>();
    Map<String, XmlSchema> defnSchemas = new HashMap<String, XmlSchema>();
    boolean ignoreImports;
    List<DeferredSchemaAttachment> deferredAttachments = new ArrayList<DeferredSchemaAttachment>();

    public Definition createWSDLDefinition(String tns) throws WSDLException, JAXBException {
        WSDLManager wm = (WSDLManager)BusFactory.getThreadDefaultBus().getExtension(WSDLManager.class);
        WSDLFactory wsdlFactory = wm.getWSDLFactory();
        Definition wsdlDefinition = wsdlFactory.newDefinition();
        wsdlDefinition.setExtensionRegistry(wm.getExtensionRegistry());
        wsdlDefinition.setTargetNamespace(tns);
        wsdlDefinition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        wsdlDefinition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        wsdlDefinition.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        wsdlDefinition.addNamespace("tns", tns);
        wsdlDefinition.addNamespace("corba", "http://cxf.apache.org/bindings/corba");
        this.defns.put(tns, wsdlDefinition);
        return wsdlDefinition;
    }

    public void setIgnoreImports(boolean flag) {
        this.ignoreImports = flag;
    }

    public Definition getWSDLDefinition(String ns) {
        return this.defns.get(ns);
    }

    public XmlSchema getXmlSchema(String ns) {
        return this.schemas.get(ns);
    }

    public XmlSchema createXmlSchema(String schemans, XmlSchemaCollection schemaCol) {
        XmlSchema xmlSchema = new XmlSchema(schemans, schemaCol);
        this.schemas.put(schemans, xmlSchema);
        return xmlSchema;
    }

    public XmlSchema createXmlSchemaForDefinition(Definition defn, String schemans, XmlSchemaCollection schemaCol) {
        XmlSchema xmlSchema = this.createXmlSchema(schemans, schemaCol);
        this.defnSchemas.put(schemans, xmlSchema);
        return xmlSchema;
    }

    public boolean isXmlSchemaInDefinition(String schemans) {
        return this.defnSchemas.containsKey(schemans);
    }

    public void addWSDLDefinitionNamespace(Definition defn, String prefix, String ns) {
        if (!defn.getNamespaces().values().contains(ns)) {
            defn.addNamespace(prefix, ns);
        }
    }

    public void addWSDLDefinitionImport(Definition rootDefn, Definition defn, String prefix, String fileName) {
        if (!fileName.endsWith(".wsdl")) {
            fileName = fileName + ".wsdl";
        }
        File file = new File(fileName);
        this.addWSDLDefinitionImport(rootDefn, defn, prefix, file);
    }

    public void addWSDLDefinitionImport(Definition rootDefn, Definition defn, String prefix, File file) {
        if (rootDefn.getImports().get(defn.getTargetNamespace()) == null && !file.getName().equals(".wsdl")) {
            Import importDefn = rootDefn.createImport();
            if (!this.ignoreImports) {
                importDefn.setLocationURI(file.toURI().toString());
            }
            importDefn.setNamespaceURI(defn.getTargetNamespace());
            rootDefn.addImport(importDefn);
        }
        if (!rootDefn.getNamespaces().values().contains(defn.getTargetNamespace())) {
            rootDefn.addNamespace(prefix, defn.getTargetNamespace());
        }
        if (!this.importedDefns.containsKey(file)) {
            this.importedDefns.put(file, defn);
        }
    }

    public void addXmlSchemaImport(XmlSchema rootSchema, XmlSchema schema, String fileName) {
        if (!fileName.endsWith(".xsd")) {
            fileName = fileName + ".xsd";
        }
        File file = new File(fileName);
        this.addXmlSchemaImport(rootSchema, schema, file);
    }

    public void addXmlSchemaImport(XmlSchema rootSchema, XmlSchema schema, File file) {
        String importNamespace = schema.getTargetNamespace();
        boolean included = false;
        for (XmlSchemaExternal ext : rootSchema.getExternals()) {
            XmlSchemaImport imp;
            if (!(ext instanceof XmlSchemaImport) || !(imp = (XmlSchemaImport)ext).getNamespace().equals(importNamespace)) continue;
            included = true;
            break;
        }
        if (!included) {
            XmlSchemaImport importSchema = new XmlSchemaImport(rootSchema);
            if (!this.ignoreImports) {
                importSchema.setSchemaLocation(file.toURI().toString());
            }
            importSchema.setNamespace(schema.getTargetNamespace());
        }
        if (!this.importedSchemas.containsKey(file)) {
            this.importedSchemas.put(file, schema);
        }
    }

    public void addWSDLSchemaImport(Definition def, String tns, String schemaFileName) throws Exception {
        if (!schemaFileName.endsWith(".xsd")) {
            schemaFileName = schemaFileName + ".xsd";
        }
        File file = new File(schemaFileName);
        this.addWSDLSchemaImport(def, tns, file);
    }

    public void addWSDLSchemaImport(Definition def, String tns, File file) throws Exception {
        Types types = def.getTypes();
        if (types == null) {
            types = def.createTypes();
            def.setTypes(types);
        }
        Schema wsdlSchema = (Schema)def.getExtensionRegistry().createExtension(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"));
        this.addWSDLSchemaImport(wsdlSchema, tns, file);
        types.addExtensibilityElement((ExtensibilityElement)wsdlSchema);
    }

    private void addWSDLSchemaImport(Schema wsdlSchema, String tns, File file) {
        if (!wsdlSchema.getImports().containsKey(tns)) {
            SchemaImport schemaimport = wsdlSchema.createImport();
            schemaimport.setNamespaceURI(tns);
            if (file != null && !this.ignoreImports) {
                schemaimport.setSchemaLocationURI(file.toURI().toString());
            }
            wsdlSchema.addImport(schemaimport);
        }
    }

    public void deferAttachSchemaToWSDL(Definition definition, XmlSchema schema, boolean isSchemaGenerated) throws Exception {
        DeferredSchemaAttachment attachment = new DeferredSchemaAttachment();
        attachment.defn = definition;
        attachment.schema = schema;
        attachment.isGenerated = isSchemaGenerated;
        this.deferredAttachments.add(attachment);
    }

    public void attachDeferredSchemasToWSDL() throws Exception {
        for (DeferredSchemaAttachment attachment : this.deferredAttachments) {
            this.attachSchemaToWSDL(attachment.defn, attachment.schema, attachment.isGenerated);
        }
    }

    public void attachSchemaToWSDL(Definition definition, XmlSchema schema, boolean isSchemaGenerated) throws Exception {
        Types types = definition.getTypes();
        if (types == null) {
            types = definition.createTypes();
            definition.setTypes(types);
        }
        Schema wsdlSchema = (Schema)definition.getExtensionRegistry().createExtension(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"));
        NamespaceMap nsMap = null;
        try {
            nsMap = (NamespaceMap)schema.getNamespaceContext();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (nsMap == null) {
            nsMap = new NamespaceMap();
            nsMap.add("xs", "http://www.w3.org/2001/XMLSchema");
            schema.setNamespaceContext((NamespacePrefixList)nsMap);
        } else {
            nsMap.add("xs", "http://www.w3.org/2001/XMLSchema");
        }
        if (isSchemaGenerated) {
            nsMap.add("tns", schema.getTargetNamespace());
        }
        Element el = schema.getAllSchemas()[0].getDocumentElement();
        wsdlSchema.setElement(el);
        for (XmlSchemaExternal ext : schema.getExternals()) {
            if (!(ext instanceof XmlSchemaImport)) continue;
            XmlSchemaImport xmlSchemaImport = (XmlSchemaImport)ext;
            SchemaImport schemaimport = wsdlSchema.createImport();
            schemaimport.setNamespaceURI(xmlSchemaImport.getNamespace());
            if (xmlSchemaImport.getSchemaLocation() != null && !this.ignoreImports) {
                schemaimport.setSchemaLocationURI(xmlSchemaImport.getSchemaLocation());
            }
            wsdlSchema.addImport(schemaimport);
        }
        types.addExtensibilityElement((ExtensibilityElement)wsdlSchema);
    }

    public TypeMappingType createCorbaTypeMap(Definition definition, String corbatypemaptns) throws WSDLException {
        TypeMappingType typeMap = (TypeMappingType)definition.getExtensionRegistry().createExtension(Definition.class, CorbaConstants.NE_CORBA_TYPEMAPPING);
        if (corbatypemaptns == null) {
            typeMap.setTargetNamespace(definition.getTargetNamespace() + "/" + "typemap");
        } else {
            typeMap.setTargetNamespace(corbatypemaptns);
        }
        definition.addExtensibilityElement((ExtensibilityElement)typeMap);
        return typeMap;
    }

    public Map<String, Definition> getWSDLDefinitions() {
        return this.defns;
    }

    public Map<String, XmlSchema> getXmlSchemas() {
        return this.schemas;
    }

    public Map<File, Definition> getImportedWSDLDefinitions() {
        return this.importedDefns;
    }

    public Map<File, XmlSchema> getImportedXmlSchemas() {
        return this.importedSchemas;
    }

    public File getImportedWSDLDefinitionFile(String ns) {
        for (Map.Entry<File, Definition> entry : this.importedDefns.entrySet()) {
            if (!entry.getValue().getTargetNamespace().equals(ns)) continue;
            return entry.getKey();
        }
        return null;
    }

    public File getImportedXmlSchemaFile(String ns) {
        for (Map.Entry<File, XmlSchema> entry : this.importedSchemas.entrySet()) {
            if (!entry.getValue().getTargetNamespace().equals(ns)) continue;
            return entry.getKey();
        }
        return null;
    }

    static class DeferredSchemaAttachment {
        Definition defn;
        XmlSchema schema;
        boolean isGenerated;

        DeferredSchemaAttachment() {
        }
    }
}

