/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.ParamConverterUtils;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractSearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.visitor.ThreadLocalVisitorState;
import org.apache.cxf.jaxrs.ext.search.visitor.VisitorState;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.QueryBuilder;

public class LuceneQueryVisitor<T>
extends AbstractSearchConditionVisitor<T, Query> {
    private String contentsFieldName;
    private Map<String, String> contentsFieldMap;
    private boolean caseInsensitiveMatch;
    private VisitorState<Stack<List<Query>>> state = new ThreadLocalVisitorState<Stack<List<Query>>>();
    private QueryBuilder queryBuilder;

    public LuceneQueryVisitor() {
        this(Collections.emptyMap());
    }

    public LuceneQueryVisitor(Analyzer analyzer) {
        this(Collections.emptyMap(), null, analyzer);
    }

    public LuceneQueryVisitor(String contentsFieldAlias, String contentsFieldName) {
        this(Collections.singletonMap(contentsFieldAlias, contentsFieldName));
    }

    public LuceneQueryVisitor(String contentsFieldName) {
        this(Collections.emptyMap(), contentsFieldName);
    }

    public LuceneQueryVisitor(String contentsFieldName, Analyzer analyzer) {
        this(Collections.emptyMap(), contentsFieldName, analyzer);
    }

    public LuceneQueryVisitor(Map<String, String> fieldsMap) {
        this(fieldsMap, null);
    }

    public LuceneQueryVisitor(Map<String, String> fieldsMap, String contentsFieldName) {
        this(fieldsMap, contentsFieldName, null);
    }

    public LuceneQueryVisitor(String contentsFieldAlias, String contentsFieldName, Analyzer analyzer) {
        this(Collections.singletonMap(contentsFieldAlias, contentsFieldName), null, analyzer);
    }

    public LuceneQueryVisitor(Map<String, String> fieldsMap, String contentsFieldName, Analyzer analyzer) {
        super(fieldsMap);
        this.contentsFieldName = contentsFieldName;
        if (analyzer != null) {
            this.queryBuilder = new QueryBuilder(analyzer);
        }
    }

    public void setContentsFieldMap(Map<String, String> map) {
        this.contentsFieldMap = map;
    }

    public void reset() {
        this.state.set(new Stack());
        this.state.get().push(new ArrayList());
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement;
        if (this.state.get() == null) {
            this.reset();
        }
        if ((statement = sc.getStatement()) != null) {
            if (statement.getProperty() != null) {
                this.state.get().peek().add(this.buildSimpleQuery(sc.getConditionType(), statement.getProperty(), statement.getValue()));
            }
        } else {
            this.state.get().push(new ArrayList());
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                condition.accept(this);
            }
            boolean orCondition = sc.getConditionType() == ConditionType.OR;
            List<Query> queries = this.state.get().pop();
            this.state.get().peek().add(this.createCompositeQuery(queries, orCondition));
        }
    }

    @Override
    public Query getQuery() {
        List<Query> queries = this.state.get().peek();
        return queries.isEmpty() ? null : queries.get(0);
    }

    public void setCaseInsensitiveMatch(boolean caseInsensitiveMatch) {
        this.caseInsensitiveMatch = caseInsensitiveMatch;
    }

    private Query buildSimpleQuery(ConditionType ct, String name, Object value) {
        name = super.getRealPropertyName(name);
        this.validatePropertyValue(name, value);
        Class<?> clazz = this.getPrimitiveFieldClass(name, value.getClass());
        Query query = null;
        switch (ct) {
            case EQUALS: {
                query = this.createEqualsQuery(clazz, name, value);
                break;
            }
            case NOT_EQUALS: {
                BooleanQuery booleanQuery = new BooleanQuery();
                booleanQuery.add(this.createEqualsQuery(clazz, name, value), BooleanClause.Occur.MUST_NOT);
                query = booleanQuery;
                break;
            }
            case GREATER_THAN: {
                query = this.createRangeQuery(clazz, name, value, ct);
                break;
            }
            case GREATER_OR_EQUALS: {
                query = this.createRangeQuery(clazz, name, value, ct);
                break;
            }
            case LESS_THAN: {
                query = this.createRangeQuery(clazz, name, value, ct);
                break;
            }
            case LESS_OR_EQUALS: {
                query = this.createRangeQuery(clazz, name, value, ct);
                break;
            }
        }
        return query;
    }

    private Query createEqualsQuery(Class<?> cls, String name, Object value) {
        Object query = null;
        if (cls == String.class) {
            String strValue = value.toString();
            if (this.caseInsensitiveMatch) {
                strValue = strValue.toLowerCase();
            }
            boolean isWildCard = strValue.contains("*") || super.isWildcardStringMatch();
            String theContentsFieldName = this.getContentsFieldName(name);
            query = theContentsFieldName == null ? (!isWildCard ? this.newTermQuery(name, strValue) : new WildcardQuery(new Term(name, strValue))) : (!isWildCard ? this.newPhraseQuery(theContentsFieldName, strValue) : new WildcardQuery(new Term(theContentsFieldName, strValue)));
        } else {
            query = this.createRangeQuery(cls, name, value, ConditionType.EQUALS);
        }
        return query;
    }

    private String getContentsFieldName(String name) {
        String fieldName = null;
        if (this.contentsFieldMap != null) {
            fieldName = this.contentsFieldMap.get(name);
        }
        if (fieldName == null) {
            fieldName = this.contentsFieldName;
        }
        return fieldName;
    }

    private Query createRangeQuery(Class<?> cls, String name, Object value, ConditionType type) {
        boolean maxInclusive;
        boolean minInclusive = type == ConditionType.GREATER_OR_EQUALS || type == ConditionType.EQUALS;
        boolean bl = maxInclusive = type == ConditionType.LESS_OR_EQUALS || type == ConditionType.EQUALS;
        if (String.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls)) {
            Query query = null;
            query = Double.class.isAssignableFrom(cls) ? this.createDoubleRangeQuery(name, value, type, minInclusive, maxInclusive) : (Float.class.isAssignableFrom(cls) ? this.createFloatRangeQuery(name, value, type, minInclusive, maxInclusive) : (Long.class.isAssignableFrom(cls) ? this.createLongRangeQuery(name, value, type, minInclusive, maxInclusive) : this.createIntRangeQuery(name, value, type, minInclusive, maxInclusive)));
            return query;
        }
        if (Date.class.isAssignableFrom(cls)) {
            Date date = ParamConverterUtils.getValue(Date.class, this.getFieldTypeConverter(), value.toString());
            String luceneDateValue = ParamConverterUtils.getString(Date.class, this.getFieldTypeConverter(), date);
            if (type == ConditionType.LESS_THAN || type == ConditionType.LESS_OR_EQUALS) {
                return TermRangeQuery.newStringRange((String)name, null, (String)luceneDateValue, (boolean)minInclusive, (boolean)maxInclusive);
            }
            return TermRangeQuery.newStringRange((String)name, (String)luceneDateValue, (String)DateTools.dateToString((Date)new Date(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), (boolean)minInclusive, (boolean)maxInclusive);
        }
        return null;
    }

    private Query createIntRangeQuery(String name, Object value, ConditionType type, boolean minInclusive, boolean maxInclusive) {
        Integer intValue = Integer.valueOf(value.toString());
        return NumericRangeQuery.newIntRange((String)name, (Integer)this.getMin(type, intValue), (Integer)this.getMax(type, intValue), (boolean)minInclusive, (boolean)maxInclusive);
    }

    private Query createLongRangeQuery(String name, Object value, ConditionType type, boolean minInclusive, boolean maxInclusive) {
        Long longValue = Long.valueOf(value.toString());
        return NumericRangeQuery.newLongRange((String)name, (Long)this.getMin(type, longValue), (Long)this.getMax(type, longValue), (boolean)minInclusive, (boolean)maxInclusive);
    }

    private Query createDoubleRangeQuery(String name, Object value, ConditionType type, boolean minInclusive, boolean maxInclusive) {
        Double doubleValue = Double.valueOf(value.toString());
        return NumericRangeQuery.newDoubleRange((String)name, (Double)this.getMin(type, doubleValue), (Double)this.getMax(type, doubleValue), (boolean)minInclusive, (boolean)maxInclusive);
    }

    private Query createFloatRangeQuery(String name, Object value, ConditionType type, boolean minInclusive, boolean maxInclusive) {
        Float floatValue = Float.valueOf(value.toString());
        return NumericRangeQuery.newFloatRange((String)name, (Float)this.getMin(type, floatValue), (Float)this.getMax(type, floatValue), (boolean)minInclusive, (boolean)maxInclusive);
    }

    private <N> N getMax(ConditionType type, N value) {
        return type == ConditionType.GREATER_THAN || type == ConditionType.GREATER_OR_EQUALS ? null : (N)value;
    }

    private <N> N getMin(ConditionType type, N value) {
        return type == ConditionType.LESS_THAN || type == ConditionType.LESS_OR_EQUALS ? null : (N)value;
    }

    private Query createCompositeQuery(List<Query> queries, boolean orCondition) {
        BooleanClause.Occur clause = orCondition ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
        BooleanQuery booleanQuery = new BooleanQuery();
        for (Query query : queries) {
            booleanQuery.add(query, clause);
        }
        return booleanQuery;
    }

    private Query newTermQuery(String field, String query) {
        return this.queryBuilder != null ? this.queryBuilder.createBooleanQuery(field, query) : new TermQuery(new Term(field, query));
    }

    private Query newPhraseQuery(String field, String query) {
        if (this.queryBuilder != null) {
            return this.queryBuilder.createPhraseQuery(field, query);
        }
        PhraseQuery phraseQuery = new PhraseQuery();
        phraseQuery.add(new Term(field, query));
        return phraseQuery;
    }
}

