/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.outbound;

import java.io.PrintWriter;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.work.WorkManager;
import javax.security.auth.Subject;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.logging.LoggerHelper;
import org.apache.cxf.jca.cxf.ResourceAdapterImpl;
import org.apache.cxf.jca.outbound.ConnectionFactoryImpl;
import org.apache.cxf.jca.outbound.DefaultConnectionManager;
import org.apache.cxf.jca.outbound.ManagedConnectionImpl;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    private static final long serialVersionUID = -5294527634981120642L;
    private static final Logger LOG = LogUtils.getL7dLogger(ManagedConnectionFactoryImpl.class);
    private String busConfigURL;
    private PrintWriter printWriter;
    private ResourceAdapter resourceAdapter;
    private ConnectionManager defaultConnectionManager = new DefaultConnectionManager();

    public void setBusConfigURL(String busConfigURL) {
        this.busConfigURL = busConfigURL;
    }

    public String getBusConfigURL() {
        return this.busConfigURL;
    }

    public Object createConnectionFactory() throws ResourceException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Create connection factory for unmanaged connections");
        }
        return new ConnectionFactoryImpl(this, this.defaultConnectionManager);
    }

    public Object createConnectionFactory(ConnectionManager connMgr) throws ResourceException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Create connection factory by app server connMgr " + connMgr);
        }
        return new ConnectionFactoryImpl(this, connMgr == null ? this.defaultConnectionManager : connMgr);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connReqInfo) throws ResourceException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Create managed connection subject=" + subject + "connReqInfo=" + connReqInfo);
        }
        return new ManagedConnectionImpl(this, connReqInfo, subject);
    }

    public int hashCode() {
        int retval = 0;
        if (this.busConfigURL != null) {
            retval += this.busConfigURL.hashCode();
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (o != null && !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        if (!(o instanceof ManagedConnectionFactoryImpl)) {
            return false;
        }
        ManagedConnectionFactoryImpl that = (ManagedConnectionFactoryImpl)o;
        return Objects.equals(that.getBusConfigURL(), this.busConfigURL);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public void setLogWriter(PrintWriter aPrintWriter) throws ResourceException {
        if (aPrintWriter == null) {
            throw new IllegalArgumentException("NULL_LOG_WRITER");
        }
        this.printWriter = aPrintWriter;
        LoggerHelper.initializeLoggingOnWriter(this.printWriter);
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo reqInfo) throws ResourceException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("match connections: set=" + mcs + ", subject=" + subject + " reqInfo=" + reqInfo);
        }
        for (Object obj : mcs) {
            ManagedConnectionImpl mc;
            if (!(obj instanceof ManagedConnectionImpl) || !Objects.equals(this.busConfigURL, (mc = (ManagedConnectionImpl)obj).getManagedConnectionFactoryImpl().getBusConfigURL()) || !Objects.equals(reqInfo, mc.getRequestInfo())) continue;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("found matched connection " + mc);
            }
            return mc;
        }
        return null;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        this.resourceAdapter = ra;
    }

    public WorkManager getWorkManager() {
        if (this.resourceAdapter instanceof ResourceAdapterImpl) {
            return ((ResourceAdapterImpl)this.resourceAdapter).getBootstrapContext().getWorkManager();
        }
        return null;
    }

    static {
        LoggerHelper.init();
    }
}

