/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.wsdl;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.xml.bind.JAXBException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.corba.common.ProcessorEnvironment;
import org.apache.cxf.tools.corba.common.WSDLUtils;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLToCorbaBinding;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLToIDLAction;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLToProcessor;

public class WSDLToCorbaProcessor
extends WSDLToProcessor {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLToCorbaProcessor.class);
    WSDLToCorbaBinding wsdlToCorbaBinding;
    WSDLToIDLAction idlAction;
    Definition definition;
    String bindName;
    String outputfile;
    String outputdir = ".";
    String wsdlOutput;
    String idlOutput;
    ProcessorEnvironment env;

    @Override
    public void process() throws ToolException {
        Definition def = null;
        this.env = this.getEnvironment();
        try {
            if (this.env.optionSet("corba")) {
                this.wsdlToCorbaBinding = new WSDLToCorbaBinding();
            }
            if (this.env.optionSet("idl")) {
                this.idlAction = new WSDLToIDLAction();
            }
            if (this.wsdlToCorbaBinding == null && this.idlAction == null) {
                this.wsdlToCorbaBinding = new WSDLToCorbaBinding();
                this.idlAction = new WSDLToIDLAction();
            }
            this.setOutputFile();
            String filename = this.getFileBase(this.env.get("wsdlurl").toString());
            if (this.wsdlOutput == null && this.wsdlToCorbaBinding != null) {
                this.wsdlOutput = filename + "-corba.wsdl";
            }
            if (this.idlOutput == null && this.idlAction != null) {
                this.idlOutput = filename + ".idl";
            }
            if (this.wsdlToCorbaBinding != null) {
                this.wsdltoCorba();
                def = this.wsdlToCorbaBinding.generateCORBABinding();
                this.writeToWSDL(def);
            }
            if (this.idlAction != null) {
                this.wsdltoIdl();
                this.idlAction.generateIDL(def);
                this.writeToIDL(def);
            }
        }
        catch (ToolException ex) {
            throw ex;
        }
        catch (JAXBException ex) {
            throw new ToolException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new ToolException((Throwable)ex);
        }
    }

    private void writeToWSDL(Definition def) throws ToolException {
        try {
            WSDLUtils.writeWSDL(def, this.outputdir, this.wsdlOutput);
        }
        catch (Throwable t) {
            Message msg = new Message("FAIL_TO_WRITE_WSDL", LOG, new Object[0]);
            throw new ToolException(msg, t);
        }
    }

    private void writeToIDL(Definition def) throws ToolException {
    }

    public void wsdltoCorba() {
        if (this.env.optionSet("binding")) {
            this.wsdlToCorbaBinding.setBindingName(this.env.get("binding").toString());
        }
        if (this.env.optionSet("porttype")) {
            this.wsdlToCorbaBinding.addInterfaceName(this.env.get("porttype").toString());
        }
        if (this.env.optionSet("porttype") && this.env.optionSet("binding")) {
            this.wsdlToCorbaBinding.mapBindingToInterface(this.env.get("porttype").toString(), this.env.get("binding").toString());
        }
        if (!this.env.optionSet("porttype") && !this.env.optionSet("binding")) {
            this.wsdlToCorbaBinding.setAllBindings(true);
        }
        if (this.env.optionSet("wsdlurl")) {
            this.wsdlToCorbaBinding.setWsdlFile(this.env.get("wsdlurl").toString());
        }
        if (this.env.optionSet("namespace")) {
            this.wsdlToCorbaBinding.setNamespace(this.env.get("namespace").toString());
        }
        if (this.env.optionSet("address")) {
            this.wsdlToCorbaBinding.setAddress(this.env.get("address").toString());
        }
        if (this.env.optionSet("addressfile")) {
            this.wsdlToCorbaBinding.setAddressFile(this.env.get("addressfile").toString());
        }
        this.wsdlToCorbaBinding.setOutputDirectory(this.getOutputDir());
        this.wsdlToCorbaBinding.setOutputFile(this.wsdlOutput);
    }

    private void wsdltoIdl() {
        if (this.env.optionSet("binding")) {
            this.idlAction.setBindingName(this.env.get("binding").toString());
        } else if (this.wsdlToCorbaBinding != null) {
            String portType = null;
            if (this.env.optionSet("porttype")) {
                String bindingName;
                portType = this.env.get("porttype").toString();
                if (portType != null && (bindingName = this.wsdlToCorbaBinding.getMappedBindingName(portType)) != null) {
                    this.idlAction.setBindingName(bindingName);
                }
            } else {
                List<String> bindingNames = this.wsdlToCorbaBinding.getGeneratedBindingNames();
                if (bindingNames != null && !bindingNames.isEmpty()) {
                    this.idlAction.setBindingName(bindingNames.get(0));
                    if (bindingNames.size() > 1) {
                        System.err.println("Warning: Generating idl only for the binding " + bindingNames.get(0));
                    }
                } else {
                    this.idlAction.setGenerateAllBindings(true);
                }
            }
        } else {
            this.idlAction.setGenerateAllBindings(true);
        }
        if (this.env.optionSet("wsdlurl")) {
            String name = this.env.get("wsdlurl").toString();
            this.idlAction.setWsdlFile(name);
        }
        if (this.env.optionSet("verbose")) {
            this.idlAction.setVerboseOn(Boolean.TRUE);
        }
        this.idlAction.setOutputDirectory(this.getOutputDir());
        this.idlAction.setOutputFile(this.idlOutput);
    }

    private String getOutputDir() {
        if (this.env.optionSet("outputdir")) {
            this.outputdir = this.env.get("outputdir").toString();
            File fileOutputDir = new File(this.outputdir);
            if (!fileOutputDir.exists()) {
                fileOutputDir.mkdir();
            }
        }
        return this.outputdir;
    }

    private void setOutputFile() {
        this.wsdlOutput = (String)this.env.get("wsdloutputfile");
        this.idlOutput = (String)this.env.get("idloutputfile");
        if (this.wsdlOutput == null && this.idlOutput == null) {
            LOG.log(Level.WARNING, "Using default wsdl/idl filenames...");
        }
    }

    public String getFileBase(String wsdlUrl) {
        String fileBase = wsdlUrl;
        StringTokenizer tok = new StringTokenizer(wsdlUrl, "\\/");
        while (tok.hasMoreTokens()) {
            fileBase = tok.nextToken();
        }
        if (fileBase.endsWith(".wsdl")) {
            fileBase = fileBase.substring(0, fileBase.length() - 5);
        }
        return fileBase;
    }
}

