/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.common;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.MapKeyColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

@MappedSuperclass
public abstract class AccessToken
implements Serializable {
    private static final long serialVersionUID = -5750544301887053480L;
    private String tokenKey;
    private String tokenType;
    private String refreshToken;
    private long expiresIn = -1L;
    private long issuedAt = -1L;
    private String issuer;
    private String encodedToken;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    protected AccessToken() {
    }

    protected AccessToken(String tokenType, String tokenKey) {
        this.tokenType = tokenType;
        this.tokenKey = tokenKey;
    }

    protected AccessToken(String tokenType, String tokenKey, long expiresIn, long issuedAt) {
        this(tokenType, tokenKey);
        this.expiresIn = expiresIn;
        this.issuedAt = issuedAt;
    }

    protected AccessToken(String tokenType, String tokenKey, long expiresIn, long issuedAt, String refreshToken, Map<String, String> parameters) {
        this(tokenType, tokenKey, expiresIn, issuedAt);
        this.refreshToken = refreshToken;
        this.parameters = parameters;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String type) {
        this.tokenType = type;
    }

    @Id
    public String getTokenKey() {
        return this.tokenKey;
    }

    public void setTokenKey(String key) {
        this.tokenKey = key;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="propName")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Transient
    public String getEncodedToken() {
        return this.encodedToken;
    }

    public void setEncodedToken(String encodedToken) {
        this.encodedToken = encodedToken;
    }
}

