/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import org.apache.wss4j.dom.message.WSSecBase;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.SignatureConfirmation;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecSignatureConfirmation
extends WSSecBase {
    private static final Logger LOG = LoggerFactory.getLogger(WSSecSignatureConfirmation.class);
    private SignatureConfirmation sc;
    private byte[] signatureValue;

    public void setSignatureValue(byte[] signatureValue) {
        this.signatureValue = signatureValue;
    }

    public void prepare(Document doc) {
        this.sc = new SignatureConfirmation(doc, this.signatureValue);
        this.sc.setID(this.getIdAllocator().createId("SC-", this.sc));
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.sc.getElement());
    }

    public Document build(Document doc, byte[] sigVal, WSSecHeader secHeader) {
        LOG.debug("Begin add signature confirmation...");
        this.signatureValue = sigVal;
        this.prepare(doc);
        this.prependToHeader(secHeader);
        return doc;
    }

    public String getId() {
        if (this.sc == null) {
            return null;
        }
        return this.sc.getID();
    }

    public Element getSignatureConfirmationElement() {
        return this.sc != null ? this.sc.getElement() : null;
    }
}

