/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.token.Reference;
import org.apache.wss4j.common.token.SecurityTokenReference;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WsuIdAllocator;
import org.apache.wss4j.dom.callback.CallbackLookup;
import org.apache.wss4j.dom.message.Encryptor;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.Serializer;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecEncrypt
extends WSSecEncryptedKey {
    private static final Logger LOG = LoggerFactory.getLogger(WSSecEncrypt.class);
    private SecurityTokenReference securityTokenReference;
    private boolean encryptSymmKey = true;
    private String customReferenceValue;
    private boolean encKeyIdDirectId;
    private boolean embedEncryptedKey;
    private List<Element> attachmentEncryptedDataElements;
    private Serializer encryptionSerializer;

    @Override
    public void prepare(Document doc, Crypto crypto) throws WSSecurityException {
        this.document = doc;
        this.attachmentEncryptedDataElements = new ArrayList<Element>();
        if (this.symmetricKey == null) {
            if (this.getEphemeralKey() != null) {
                this.symmetricKey = KeyUtils.prepareSecretKey((String)this.getSymmetricEncAlgorithm(), (byte[])this.getEphemeralKey());
            } else {
                KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)this.getSymmetricEncAlgorithm());
                this.symmetricKey = keyGen.generateKey();
            }
        }
        if (this.encryptSymmKey && this.encryptedEphemeralKey == null) {
            if (this.getUseThisPublicKey() != null) {
                this.prepareInternal(this.symmetricKey, this.getUseThisPublicKey(), crypto);
            } else {
                X509Certificate remoteCert = this.getUseThisCert();
                if (remoteCert == null) {
                    if (crypto == null) {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "encryptionCryptoFailure");
                    }
                    CryptoType cryptoType = null;
                    if (this.keyIdentifierType == 14) {
                        cryptoType = new CryptoType(CryptoType.TYPE.ENDPOINT);
                        cryptoType.setEndpoint(this.user);
                    } else {
                        cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
                        cryptoType.setAlias(this.user);
                    }
                    X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
                    if (certs == null || certs.length <= 0) {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noUserCertsFound", new Object[]{this.user, "encryption"});
                    }
                    remoteCert = certs[0];
                }
                this.prepareInternal(this.symmetricKey, remoteCert, crypto);
            }
        } else if (this.encryptedEphemeralKey != null) {
            this.prepareInternal(this.symmetricKey);
        } else {
            this.encryptedEphemeralKey = this.symmetricKey.getEncoded();
        }
    }

    public Document build(Document doc, Crypto crypto, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = LOG.isDebugEnabled();
        this.prepare(doc, crypto);
        if (this.doDebug) {
            LOG.debug("Beginning Encryption...");
        }
        Element refs = this.encrypt(secHeader);
        this.addAttachmentEncryptedDataElements(secHeader);
        if (this.getEncryptedKeyElement() != null) {
            this.addInternalRefElement(refs);
            this.prependToHeader(secHeader);
        } else {
            this.addExternalRefElement(refs, secHeader);
        }
        this.prependBSTElementToHeader(secHeader);
        this.clean();
        LOG.debug("Encryption complete.");
        return doc;
    }

    public Element encrypt() throws WSSecurityException {
        return this.encrypt(null);
    }

    public Element encrypt(WSSecHeader secHeader) throws WSSecurityException {
        if (this.getParts().isEmpty()) {
            this.getParts().add(WSSecurityUtil.getDefaultEncryptionPart(this.document));
        }
        return this.encryptForRef(null, this.getParts(), secHeader);
    }

    public Element encryptForRef(Element dataRef, List<WSEncryptionPart> references) throws WSSecurityException {
        return this.encryptForRef(dataRef, references, null);
    }

    public Element encryptForRef(Element dataRef, List<WSEncryptionPart> references, WSSecHeader secHeader) throws WSSecurityException {
        KeyInfo keyInfo = this.createKeyInfo();
        String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)this.getSymmetricEncAlgorithm());
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.symmetricKey.getEncoded(), keyAlgorithm);
        Encryptor encryptor = new Encryptor();
        encryptor.setDoc(this.document);
        encryptor.setSecurityHeader(secHeader);
        encryptor.setIdAllocator(this.getIdAllocator());
        encryptor.setCallbackLookup(this.callbackLookup);
        encryptor.setAttachmentCallbackHandler(this.attachmentCallbackHandler);
        encryptor.setStoreBytesInAttachment(this.storeBytesInAttachment);
        encryptor.setEncryptionSerializer(this.getEncryptionSerializer());
        List<String> encDataRefs = encryptor.doEncryption(keyInfo, secretKeySpec, this.getSymmetricEncAlgorithm(), references, this.attachmentEncryptedDataElements);
        if (encDataRefs.isEmpty()) {
            return null;
        }
        if (dataRef == null) {
            dataRef = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
            if (!this.encryptSymmKey) {
                XMLUtils.setNamespace((Element)dataRef, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"xenc");
            }
        }
        return WSSecEncrypt.createDataRefList(this.document, dataRef, encDataRefs);
    }

    public void addInternalRefElement(Element dataRef) {
        if (dataRef != null) {
            this.getEncryptedKeyElement().appendChild(dataRef);
        }
    }

    public void addExternalRefElement(Element dataRef, WSSecHeader secHeader) {
        if (dataRef != null) {
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), dataRef);
        }
    }

    public void addAttachmentEncryptedDataElements(WSSecHeader secHeader) {
        if (this.attachmentEncryptedDataElements != null) {
            for (int i = 0; i < this.attachmentEncryptedDataElements.size(); ++i) {
                Element encryptedData = this.attachmentEncryptedDataElements.get(i);
                WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), encryptedData);
            }
        }
    }

    public static List<String> doEncryption(Document doc, WSSecHeader securityHeader, WsuIdAllocator idAllocator, KeyInfo keyInfo, SecretKey secretKey, String encryptionAlgorithm, List<WSEncryptionPart> references, CallbackLookup callbackLookup) throws WSSecurityException {
        return WSSecEncrypt.doEncryption(doc, securityHeader, idAllocator, keyInfo, secretKey, encryptionAlgorithm, references, callbackLookup, null, null, false);
    }

    public static List<String> doEncryption(Document doc, WSSecHeader securityHeader, WsuIdAllocator idAllocator, KeyInfo keyInfo, SecretKey secretKey, String encryptionAlgorithm, List<WSEncryptionPart> references, CallbackLookup callbackLookup, CallbackHandler attachmentCallbackHandler, List<Element> attachmentEncryptedDataElements, boolean storeBytesInAttachment) throws WSSecurityException {
        return WSSecEncrypt.doEncryption(doc, securityHeader, idAllocator, keyInfo, secretKey, encryptionAlgorithm, references, callbackLookup, attachmentCallbackHandler, attachmentEncryptedDataElements, storeBytesInAttachment, null);
    }

    public static List<String> doEncryption(Document doc, WSSecHeader securityHeader, WsuIdAllocator idAllocator, KeyInfo keyInfo, SecretKey secretKey, String encryptionAlgorithm, List<WSEncryptionPart> references, CallbackLookup callbackLookup, CallbackHandler attachmentCallbackHandler, List<Element> attachmentEncryptedDataElements, boolean storeBytesInAttachment, Serializer encryptionSerializer) throws WSSecurityException {
        Encryptor encryptor = new Encryptor();
        encryptor.setDoc(doc);
        encryptor.setSecurityHeader(securityHeader);
        encryptor.setIdAllocator(idAllocator);
        encryptor.setCallbackLookup(callbackLookup);
        encryptor.setAttachmentCallbackHandler(attachmentCallbackHandler);
        encryptor.setStoreBytesInAttachment(storeBytesInAttachment);
        encryptor.setEncryptionSerializer(encryptionSerializer);
        return encryptor.doEncryption(keyInfo, secretKey, encryptionAlgorithm, references, attachmentEncryptedDataElements);
    }

    private KeyInfo createKeyInfo() throws WSSecurityException {
        SecurityTokenReference secToken;
        KeyInfo keyInfo = new KeyInfo(this.document);
        if (this.embedEncryptedKey) {
            keyInfo.addUnknownElement(this.getEncryptedKeyElement());
        } else if (this.keyIdentifierType == 10) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            if (this.customReferenceValue != null) {
                secToken.setKeyIdentifierEncKeySHA1(this.customReferenceValue);
            } else {
                byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.encryptedEphemeralKey);
                secToken.setKeyIdentifierEncKeySHA1(Base64.encode((byte[])encodedBytes));
            }
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            keyInfo.addUnknownElement(secToken.getElement());
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customReferenceValue)) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            secToken.setKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", this.getId());
            keyInfo.addUnknownElement(secToken.getElement());
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customReferenceValue)) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            secToken.setKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", this.getId());
            keyInfo.addUnknownElement(secToken.getElement());
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(this.customReferenceValue)) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
            secToken.setKeyIdentifier(this.customReferenceValue, this.getId(), true);
            keyInfo.addUnknownElement(secToken.getElement());
        } else if (this.securityTokenReference != null) {
            Element tmpE = this.securityTokenReference.getElement();
            tmpE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + tmpE.getPrefix(), tmpE.getNamespaceURI());
            keyInfo.addUnknownElement(this.securityTokenReference.getElement());
        } else if (this.getId() != null) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            Reference ref = new Reference(this.document);
            if (this.encKeyIdDirectId) {
                ref.setURI(this.getId());
            } else {
                ref.setURI("#" + this.getId());
            }
            if (this.customReferenceValue != null) {
                ref.setValueType(this.customReferenceValue);
            }
            secToken.setReference(ref);
            if (KerberosSecurity.isKerberosToken(this.customReferenceValue)) {
                secToken.addTokenType(this.customReferenceValue);
            } else if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken".equals(this.customReferenceValue)) {
                secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            }
            keyInfo.addUnknownElement(secToken.getElement());
        } else if (!this.encryptSymmKey && this.keyIdentifierType == 2) {
            secToken = new SecurityTokenReference(this.document);
            secToken.addWSSENamespace();
            if (this.customReferenceValue != null) {
                secToken.setKeyIdentifierEncKeySHA1(this.customReferenceValue);
            } else {
                byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.encryptedEphemeralKey);
                secToken.setKeyIdentifierEncKeySHA1(Base64.encode((byte[])encodedBytes));
            }
            secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            keyInfo.addUnknownElement(secToken.getElement());
        }
        Element keyInfoElement = keyInfo.getElement();
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        return keyInfo;
    }

    public static Element createDataRefList(Document doc, Element referenceList, List<String> encDataRefs) {
        for (String dataReferenceUri : encDataRefs) {
            Element dataReference = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:DataReference");
            dataReference.setAttributeNS(null, "URI", dataReferenceUri);
            referenceList.appendChild(dataReference);
        }
        return referenceList;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference reference) {
        this.securityTokenReference = reference;
    }

    public boolean isEncryptSymmKey() {
        return this.encryptSymmKey;
    }

    public void setEncryptSymmKey(boolean encryptSymmKey) {
        this.encryptSymmKey = encryptSymmKey;
    }

    public void setCustomReferenceValue(String customReferenceValue) {
        this.customReferenceValue = customReferenceValue;
    }

    public void setEncKeyIdDirectId(boolean b) {
        this.encKeyIdDirectId = b;
    }

    public void setEmbedEncryptedKey(boolean embedEncryptedKey) {
        this.embedEncryptedKey = embedEncryptedKey;
    }

    public boolean isEmbedEncryptedKey() {
        return this.embedEncryptedKey;
    }

    public List<Element> getAttachmentEncryptedDataElements() {
        return this.attachmentEncryptedDataElements;
    }

    public Serializer getEncryptionSerializer() {
        return this.encryptionSerializer;
    }

    public void setEncryptionSerializer(Serializer encryptionSerializer) {
        this.encryptionSerializer = encryptionSerializer;
    }
}

